/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.negocio.infraestrutura;

import br.com.bb.plugins.negocio.infraestrutura.RegistroRemessa;
import br.com.bb.plugins.persistencia.infraestrutura.ArquivoRemessaBD;
import br.com.bb.plugins.utilitarios.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;

public class ArquivoRemessa {
    private String codigoArquivo;
    private Vector tiposRegistro;
    private Vector registros;
    private int contador;
    private FileOutputStream arquivoSaida;
    private PrintWriter printWriter;
    private Reader reader;
    private BufferedReader bufferedReader;
    private boolean analisavel;
    private String nomeAnalisador;
    private String nomeClasseAnalisador;
    private String nomeBD;

    public void abrirArquivoEntrada(File arquivoEntrada) throws IOException {
        this.reader = new FileReader(arquivoEntrada);
        this.bufferedReader = new BufferedReader(this.reader);
    }

    public void abrirArquivoSaida(File arquivo) throws IOException {
        this.arquivoSaida = new FileOutputStream(arquivo);
        this.printWriter = new PrintWriter(this.arquivoSaida);
    }

    public void addRegistro(RegistroRemessa r) throws Throwable {
        ++this.contador;
        r.setArquivoRemessa(this);
        this.printWriter.println(r.gerarLinha());
    }

    public void addTipoRegistro(RegistroRemessa r) {
        if (this.registros == null) {
            this.registros = new Vector();
        }
        this.registros.addElement(r);
    }

    public RegistroRemessa criarRegistro(String nomeRegistro) throws Throwable {
        RegistroRemessa r = null;
        int i = 0;
        while (i < this.registros.size()) {
            if (((RegistroRemessa)this.registros.elementAt(i)).getNome().equalsIgnoreCase(nomeRegistro)) {
                r = ((RegistroRemessa)this.registros.elementAt(i)).copia();
                return r;
            }
            ++i;
        }
        throw new Throwable("Tipo de registro '" + nomeRegistro + "' n\u00e3o encontrado no arquivo!");
    }

    public void fecharArquivoEntrada() throws IOException {
        this.bufferedReader.close();
        this.reader.close();
        this.bufferedReader = null;
        this.reader = null;
    }

    public void fecharArquivoSaida() throws IOException {
        this.printWriter.close();
        this.arquivoSaida.close();
        this.printWriter = null;
        this.arquivoSaida = null;
    }

    public String getCodigoArquivo() {
        return this.codigoArquivo;
    }

    public int getContador() {
        return this.contador;
    }

    public String getNomeAnalisador() {
        return this.nomeAnalisador;
    }

    public String getNomeBD() {
        return this.nomeBD;
    }

    public String getNomeClasseAnalisador() {
        return this.nomeClasseAnalisador;
    }

    public int getQtRegistros() {
        return this.registros.size();
    }

    public boolean isAnalisavel() {
        return this.analisavel;
    }

    public RegistroRemessa lerRegistro() throws Throwable {
        return this.lerRegistro(false);
    }

    public RegistroRemessa lerRegistro(boolean verificarTamanhoRegistro) throws Throwable {
        String texto = this.bufferedReader.readLine();
        if (texto == null || texto.trim().length() == 0) {
            return null;
        }
        this.setContador(this.getContador() + 1);
        int i = 0;
        while (i < this.registros.size()) {
            RegistroRemessa r = (RegistroRemessa)this.registros.elementAt(i);
            r.setVerificarTamanhoRegistro(verificarTamanhoRegistro);
            if (r.isRegistroTipo(texto)) {
                RegistroRemessa r1;
                try {
                    r1 = this.criarRegistro(r.getNome());
                    r1.setVerificarTamanhoRegistro(verificarTamanhoRegistro);
                    r1.setArquivoRemessa(this);
                    r1.lerLinha(texto);
                }
                catch (Throwable t) {
                    throw new Throwable("Linha: " + this.contador + " - " + t.getMessage());
                }
                return r1;
            }
            ++i;
        }
        throw new Throwable("Linha: " + this.contador + " - Tipo de registro n\u00e3o identificado!");
    }

    public RegistroRemessa lerRegistro(boolean verificarTamanhoRegistro, boolean substituiCaracteresEspeciais) throws Throwable {
        String texto = this.bufferedReader.readLine();
        if (texto == null || texto.trim().length() == 0) {
            return null;
        }
        if (substituiCaracteresEspeciais) {
            texto = Util.substituirCaracteresEspeciais(texto);
        }
        this.setContador(this.getContador() + 1);
        int i = 0;
        while (i < this.registros.size()) {
            RegistroRemessa r = (RegistroRemessa)this.registros.elementAt(i);
            r.setVerificarTamanhoRegistro(verificarTamanhoRegistro);
            if (r.isRegistroTipo(texto)) {
                RegistroRemessa r1;
                try {
                    r1 = this.criarRegistro(r.getNome());
                    r1.setVerificarTamanhoRegistro(verificarTamanhoRegistro);
                    r1.setArquivoRemessa(this);
                    r1.lerLinha(texto);
                }
                catch (Throwable t) {
                    throw new Throwable("Linha: " + this.contador + " - " + t.getMessage());
                }
                return r1;
            }
            ++i;
        }
        throw new Throwable("Linha: " + this.contador + " - Tipo de registro n\u00e3o identificado!");
    }

    public RegistroRemessa lerString(String texto) throws Throwable {
        if (texto == null || texto.trim().length() == 0) {
            return null;
        }
        this.setContador(this.getContador() + 1);
        int i = 0;
        while (i < this.registros.size()) {
            RegistroRemessa r = (RegistroRemessa)this.registros.elementAt(i);
            if (r.isRegistroTipo(texto)) {
                RegistroRemessa r1;
                try {
                    r1 = this.criarRegistro(r.getNome());
                    r1.setArquivoRemessa(this);
                    r1.lerLinha(texto);
                }
                catch (Throwable t) {
                    throw new Throwable("Linha: " + this.contador + " - " + t.getMessage());
                }
                return r1;
            }
            ++i;
        }
        throw new Throwable("Tipo de registro n\u00e3o identificado!");
    }

    public static void main(String[] args) {
        ArquivoRemessa ar = null;
        try {
            ar = ArquivoRemessaBD.obterArquivoRemessa("ART300");
            ar.abrirArquivoEntrada(new File(String.valueOf(System.getProperty("file.separator")) + "lixo.txt"));
        }
        catch (Throwable e) {
            System.out.println(e);
            System.exit(0);
        }
        try {
            RegistroRemessa linha;
            while ((linha = ar.lerRegistro()) != null) {
                if (linha.getNome().equalsIgnoreCase("H")) {
                    System.out.println(linha.getValorNumerico("CGC"));
                    System.out.println(linha.getValorData("DataRemessa"));
                    System.out.println(linha.getValorString("OrigemRemessa"));
                    System.out.println(linha.getValorNumerico("NumeroRemessa"));
                }
                if (linha.getNome().equalsIgnoreCase("D")) {
                    System.out.println((long)linha.getValorNumerico("CPFCGC"));
                    System.out.println(linha.getValorData("DataArrec"));
                    System.out.println(linha.getValorString("NomeContrib"));
                    System.out.println(linha.getValorData("DataPag"));
                }
                linha.getNome().equalsIgnoreCase("T");
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        try {
            ar.fecharArquivoEntrada();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public void setAnalisavel(boolean newAnalisavel) {
        this.analisavel = newAnalisavel;
    }

    public void setCodigoArquivo(String newCodigoArquivo) {
        this.codigoArquivo = newCodigoArquivo;
    }

    public void setContador(int newContador) {
        this.contador = newContador;
    }

    public void setNomeAnalisador(String newNomeAnalisador) {
        this.nomeAnalisador = newNomeAnalisador;
    }

    public void setNomeBD(String newNomeBD) {
        this.nomeBD = newNomeBD;
    }

    public void setNomeClasseAnalisador(String newNomeClasseAnalisador) {
        this.nomeClasseAnalisador = newNomeClasseAnalisador;
    }
}

