/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.negocio.infraestrutura;

import br.com.bb.plugins.negocio.infraestrutura.ArquivoRemessa;
import br.com.bb.plugins.negocio.infraestrutura.CampoRemessa;
import br.com.bb.plugins.utilitarios.Util;
import java.util.Date;
import java.util.Vector;

public class RegistroRemessa {
    private int tamanho;
    private Vector campos;
    private boolean indicadorObrigatorio;
    private String nome;
    private Vector identificadores;
    private ArquivoRemessa arquivoRemessa;
    private int tamanhoAtual = 0;
    private boolean verificarTamanhoRegistro;

    public void add(CampoRemessa campo) throws Throwable {
        if (this.campos == null) {
            this.campos = new Vector();
        }
        this.campos.addElement(campo);
        campo.setRegistroPai(this);
        campo.setInicio(this.getTamanhoAtual());
        campo.setFim(campo.getInicio() + campo.getTamanho());
        this.setTamanhoAtual(this.getTamanhoAtual() + campo.getTamanho());
        if (this.getTamanhoAtual() > this.getTamanho()) {
            throw new Throwable("Soma dos campos excede o tamanho do registro!");
        }
    }

    public RegistroRemessa copia() throws Throwable {
        RegistroRemessa r = new RegistroRemessa();
        r.setIdentificadores(this.getIdentificadores());
        r.setNome(this.getNome());
        r.setTamanho(this.getTamanho());
        int i = 0;
        while (i < this.campos.size()) {
            r.add(((CampoRemessa)this.campos.elementAt(i)).copia());
            ++i;
        }
        return r;
    }

    public String gerarLinha() throws Throwable {
        String linha = "";
        int i = 0;
        while (i < this.campos.size()) {
            CampoRemessa c = (CampoRemessa)this.campos.elementAt(i);
            linha = String.valueOf(linha) + c.gerarTexto();
            ++i;
        }
        if (linha.length() < this.getTamanho()) {
            linha = Util.padL(linha, this.getTamanho());
        }
        return linha;
    }

    public ArquivoRemessa getArquivoRemessa() {
        return this.arquivoRemessa;
    }

    public Vector getIdentificadores() {
        return this.identificadores;
    }

    public String getNome() {
        return this.nome;
    }

    private int getPosicaoCampo(String nomeCampo) {
        int i = 0;
        while (i < this.campos.size()) {
            if (((CampoRemessa)this.campos.elementAt(i)).getNome().equalsIgnoreCase(nomeCampo)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getQuantidadeCampos() {
        return this.campos.size();
    }

    public int getTamanho() {
        return this.tamanho;
    }

    public int getTamanhoAtual() {
        return this.tamanhoAtual;
    }

    public Date getValorData(String nomeCampo) throws Throwable {
        return this.obterCampo(nomeCampo).getValorData();
    }

    public double getValorDouble(String nomeCampo) throws Throwable {
        return this.obterCampo(nomeCampo).getValorDouble();
    }

    public int getValorInt(String nomeCampo) throws Throwable {
        return this.obterCampo(nomeCampo).getValorInt();
    }

    public long getValorLong(String nomeCampo) throws Throwable {
        return this.obterCampo(nomeCampo).getValorLong();
    }

    public double getValorNumerico(String nomeCampo) throws Throwable {
        return this.obterCampo(nomeCampo).getValorNumerico();
    }

    public String getValorString(String nomeCampo) throws Throwable {
        return this.obterCampo(nomeCampo).getValorString();
    }

    public boolean isRegistroTipo(String texto) throws Throwable {
        if (this.getIdentificadores() == null || this.getIdentificadores().size() == 0) {
            return true;
        }
        boolean retorno = true;
        int i = 0;
        while (i < this.getIdentificadores().size()) {
            CampoRemessa campoid = this.obterCampo((String)this.getIdentificadores().elementAt(i));
            if (!texto.substring(campoid.getInicio(), campoid.getFim()).equalsIgnoreCase(campoid.getValorString())) {
                retorno = false;
            }
            ++i;
        }
        return retorno;
    }

    public boolean isVerificarTamanhoRegistro() {
        return this.verificarTamanhoRegistro;
    }

    public void lerLinha(String texto) throws Throwable {
        if (texto.length() != this.getTamanho() && this.isVerificarTamanhoRegistro()) {
            throw new Throwable("Registro com tamanho inv\u00e1lido!");
        }
        int i = 0;
        while (i < this.campos.size()) {
            CampoRemessa campo = (CampoRemessa)this.campos.elementAt(i);
            campo.lerTexto(texto.substring(campo.getInicio(), campo.getFim()));
            ++i;
        }
    }

    public CampoRemessa obterCampo(int indiceCampo) throws Throwable {
        if (indiceCampo < 0) {
            throw new Throwable("Campo \u00edndice" + indiceCampo + " n\u00e3o existe neste registro!");
        }
        return (CampoRemessa)this.campos.elementAt(indiceCampo);
    }

    public CampoRemessa obterCampo(String nomeCampo) throws Throwable {
        int i = this.getPosicaoCampo(nomeCampo);
        if (i < 0) {
            throw new Throwable("Campo " + nomeCampo + " n\u00e3o existe neste registro!");
        }
        return (CampoRemessa)this.campos.elementAt(i);
    }

    public void setArquivoRemessa(ArquivoRemessa newArquivoRemessa) {
        this.arquivoRemessa = newArquivoRemessa;
    }

    public void setIdentificadores(Vector newIdentificadores) {
        this.identificadores = newIdentificadores;
    }

    public void setNome(String newNome) {
        this.nome = newNome;
    }

    public void setTamanho(int newTamanho) {
        this.tamanho = newTamanho;
    }

    public void setTamanhoAtual(int newTamanhoAtual) {
        this.tamanhoAtual = newTamanhoAtual;
    }

    public void setValorCampo(String nomeCampo, double valor) throws Throwable {
        this.obterCampo(nomeCampo).setValor(valor);
    }

    public void setValorCampo(String nomeCampo, String valor) throws Throwable {
        this.obterCampo(nomeCampo).setValor(valor);
    }

    public void setValorCampo(String nomeCampo, Date valor) throws Throwable {
        this.obterCampo(nomeCampo).setValor(valor);
    }

    public void setVerificarTamanhoRegistro(boolean newVerificarTamanhoRegistro) {
        this.verificarTamanhoRegistro = newVerificarTamanhoRegistro;
    }
}

