/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.comum;

import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.utilitarios.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public abstract class Persistencia {
    public Connection con = null;
    private Vector resultsets;
    private Vector statements;

    public abstract int abrirLista() throws SQLException;

    public abstract void adicionar(Object var1) throws SQLException;

    protected int adicionarLista(String query) throws SQLException {
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (this.resultsets == null) {
            this.resultsets = new Vector();
        }
        if (this.statements == null) {
            this.statements = new Vector();
        }
        this.resultsets.addElement(rs);
        this.statements.addElement(stmt);
        return this.resultsets.size() - 1;
    }

    public abstract void alterar(Object var1) throws SQLException;

    public void conectar() throws SQLException {
        this.con = ConexaoBancoDados.getConexao();
    }

    protected String dataSql(Date data) {
        if (data == null) {
            return " null ";
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(data);
        return "#" + (c.get(2) + 1) + "/" + c.get(5) + "/" + c.get(1) + "#";
    }

    protected int executar(String query) throws SQLException {
        this.conectar();
        Statement stmt = this.con.createStatement();
        int alterados = stmt.executeUpdate(query);
        stmt.close();
        return alterados;
    }

    public boolean executarCommit() throws Throwable {
        this.con.commit();
        return true;
    }

    public boolean executarRollback() throws Throwable {
        this.con.rollback();
        return true;
    }

    public void fecharLista(int idLista) {
        if (idLista >= this.resultsets.size()) {
            return;
        }
        ResultSet rs = (ResultSet)this.resultsets.elementAt(idLista);
        Statement stmt = (Statement)this.statements.elementAt(idLista);
        if (rs == null) {
            return;
        }
        try {
            rs.close();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.resultsets.setElementAt(null, idLista);
        this.statements.setElementAt(null, idLista);
    }

    protected Vector gerarVetor(String query) throws SQLException {
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        Vector<Object> vetor = new Vector<Object>();
        while (rs.next()) {
            vetor.addElement(this.lerRegistro(rs));
        }
        rs.close();
        stmt.close();
        return vetor;
    }

    protected Vector gerarVetorString(String query) throws SQLException {
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        int i = rs.getMetaData().getColumnCount();
        Vector<String[]> vetor = new Vector<String[]>();
        while (rs.next()) {
            String[] s = new String[i];
            int j = 0;
            while (j < i) {
                switch (rs.getMetaData().getColumnType(j + 1)) {
                    case 8: {
                        s[j] = String.valueOf(rs.getDouble(j + 1));
                        break;
                    }
                    case 4: {
                        s[j] = String.valueOf(rs.getInt(j + 1));
                        break;
                    }
                    case -5: {
                        s[j] = String.valueOf(rs.getLong(j + 1));
                        break;
                    }
                    case 12: {
                        s[j] = rs.getString(j + 1);
                        break;
                    }
                    case 93: {
                        try {
                            s[j] = Util.formatarData(rs.getDate(j + 1));
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    case 91: {
                        try {
                            s[j] = Util.formatarData(rs.getDate(j + 1));
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    case 5: {
                        s[j] = String.valueOf(rs.getInt(j + 1));
                    }
                }
                ++j;
            }
            vetor.addElement(s);
        }
        rs.close();
        stmt.close();
        return vetor;
    }

    public boolean getSetarautoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    public boolean isConsultaVazia(String query) throws SQLException {
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            rs.close();
            stmt.close();
            return false;
        }
        rs.close();
        stmt.close();
        return true;
    }

    public abstract void lerRegistro(Object var1, ResultSet var2) throws SQLException;

    public abstract Object lerRegistro(ResultSet var1) throws SQLException;

    public abstract boolean localizado(Object var1) throws SQLException;

    public boolean localizado(PreparedStatement preparedStatement) throws SQLException {
        ResultSet rs = null;
        boolean retorno = false;
        try {
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                retorno = true;
            }
            rs.close();
        }
        catch (SQLException s) {
            rs.close();
            throw s;
        }
        return retorno;
    }

    protected String nuloSeVazio(String texto) {
        if (texto == null || texto.length() == 0) {
            return "null";
        }
        return "'" + texto + "'";
    }

    public String nuloSeZero(double valor) {
        if (valor == 0.0) {
            return "null";
        }
        return String.valueOf(valor);
    }

    public abstract void obter(Object var1) throws SQLException;

    public abstract Vector obterLista() throws SQLException;

    public Object obterProximoLista(int idResultSet) {
        if (idResultSet >= this.resultsets.size()) {
            return null;
        }
        ResultSet rs = (ResultSet)this.resultsets.elementAt(idResultSet);
        if (rs == null) {
            return null;
        }
        try {
            if (rs.next()) {
                Object objetoNegocio = this.lerRegistro(rs);
                return objetoNegocio;
            }
            rs.close();
            ((Statement)this.statements.elementAt(idResultSet)).close();
            this.statements.setElementAt(null, idResultSet);
            this.resultsets.setElementAt(null, idResultSet);
            return null;
        }
        catch (SQLException ex) {
            System.out.println(ex);
            return null;
        }
    }

    public boolean obterProximoLista(int idResultSet, Object objetoNegocio) {
        if (idResultSet >= this.resultsets.size()) {
            return false;
        }
        ResultSet rs = (ResultSet)this.resultsets.elementAt(idResultSet);
        if (rs == null) {
            return false;
        }
        try {
            if (rs.next()) {
                this.lerRegistro(objetoNegocio, rs);
                return true;
            }
            return false;
        }
        catch (SQLException ex) {
            return false;
        }
    }

    public Vector obterProximosLista(int idResultSet, int quantidadeRegistros) {
        if (idResultSet >= this.resultsets.size()) {
            return null;
        }
        ResultSet rs = (ResultSet)this.resultsets.elementAt(idResultSet);
        if (rs == null) {
            return null;
        }
        Vector<Object> vetor = new Vector<Object>();
        int i = 0;
        while (i < quantidadeRegistros) {
            try {
                if (!rs.next()) break;
                vetor.addElement(this.lerRegistro(rs));
            }
            catch (SQLException ex) {
                break;
            }
            ++i;
        }
        return vetor;
    }

    public java.sql.Date obterValorData(String query) throws SQLException {
        java.sql.Date retorno = null;
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            retorno = rs.getDate(1);
        }
        rs.close();
        stmt.close();
        return retorno;
    }

    public double obterValorDouble(String query) throws SQLException {
        double retorno = 0.0;
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            retorno = rs.getDouble(1);
        }
        rs.close();
        stmt.close();
        return retorno;
    }

    public long obterValorLong(String query) throws SQLException {
        long retorno = 0L;
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            retorno = rs.getLong(1);
        }
        rs.close();
        stmt.close();
        return retorno;
    }

    public String obterValorString(String query) throws SQLException {
        String retorno = null;
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            retorno = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return retorno;
    }

    protected boolean popularObjeto(Object objetoNegocio, String query) throws SQLException {
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            this.lerRegistro(objetoNegocio, rs);
            rs.close();
            stmt.close();
            return true;
        }
        rs.close();
        stmt.close();
        return false;
    }

    protected boolean popularObjeto(Object objetoNegocio, PreparedStatement preparedStatement) throws SQLException {
        this.conectar();
        ResultSet rs = preparedStatement.executeQuery();
        if (rs.next()) {
            this.lerRegistro(objetoNegocio, rs);
            rs.close();
            return true;
        }
        rs.close();
        return false;
    }

    public abstract void remover(Object var1) throws SQLException;

    public abstract void salvar(Object var1) throws SQLException;

    public boolean setarAutoCommit(boolean arg) throws Throwable {
        if (this.con.getAutoCommit()) {
            if (!arg) {
                this.con.setAutoCommit(false);
            }
        } else if (arg) {
            this.con.setAutoCommit(true);
        }
        return true;
    }

    protected String vazioSeNulo(String texto) {
        if (texto == null || texto.length() == 0) {
            return "";
        }
        return texto;
    }
}

