/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.comum;

import br.com.bb.plugins.negocio.comum.Identificacao;
import br.com.bb.plugins.negocio.comum.Pessoa;
import br.com.bb.plugins.persistencia.comum.Persistencia;
import br.com.bb.plugins.utilitarios.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class PessoaBD
extends Persistencia {
    private static PessoaBD pessoaBD;

    public int abrirLista() throws SQLException {
        String query = "SELECT * FROM Pessoa order by textoNome";
        return this.adicionarLista(query);
    }

    public int abrirLista(String nomeInicial, String nomeFinal) throws SQLException {
        String query = "SELECT * FROM Pessoa WHERE textoNome >= '" + nomeInicial + "' and textoNome <= '" + nomeFinal + "'";
        return this.adicionarLista(query);
    }

    public void adicionar(Object objetoNegocio) throws SQLException {
        Pessoa pessoa = (Pessoa)objetoNegocio;
        if (pessoa.getCodigoPessoa() == null || pessoa.getCodigoPessoa().trim().length() == 0) {
            String novoCodigo = this.calculaNovoCodigo();
            pessoa.setCodigoPessoa(novoCodigo);
        }
        String query = "INSERT INTO Pessoa ( textoNome, textoEndereco, textoBairro,  codigoCep, textoCidade, textoSiglaUFFK, codigoPessoa, codigoTipoPessoaFK ) VALUES('" + pessoa.getNomePessoa() + "', " + this.nuloSeVazio(pessoa.getTextoEndereco()) + ", " + this.nuloSeVazio(pessoa.getTextoBairro()) + ", " + this.nuloSeVazio(pessoa.getCodigoCep()) + ", " + this.nuloSeVazio(pessoa.getTextoCidade()) + ", " + this.nuloSeVazio(pessoa.getCodigoUFRel()) + ", '" + pessoa.getCodigoPessoa() + "', " + pessoa.getTipoPessoa().getCodigoTipoPessoa() + ")";
        this.executar(query);
    }

    public void alterar(Object objetoNegocio) throws SQLException {
        Pessoa pessoa = (Pessoa)objetoNegocio;
        String query = "UPDATE Pessoa SET textoNome = '" + pessoa.getNomePessoa() + "', textoEndereco = " + this.nuloSeVazio(pessoa.getTextoEndereco()) + ", textoBairro = " + this.nuloSeVazio(pessoa.getTextoBairro()) + ", codigoCep = " + this.nuloSeVazio(pessoa.getCodigoCep()) + ", textoCidade = " + this.nuloSeVazio(pessoa.getTextoCidade()) + ", textoSiglaUFFK = " + this.nuloSeVazio(pessoa.getCodigoUFRel()) + ", codigoTipoPessoaFK = '" + pessoa.getTipoPessoa().getCodigoTipoPessoa() + "'" + " WHERE codigoPessoa = '" + pessoa.getCodigoPessoa() + "'";
        this.executar(query);
    }

    public String calculaNovoCodigo() throws SQLException {
        String query = "SELECT max(codigoPessoa) FROM Pessoa";
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            String ultimoCodigo = rs.getString(1);
            long novoCodigo = Long.valueOf(ultimoCodigo);
            ++novoCodigo;
            rs.close();
            stmt.close();
            try {
                return Util.padR(String.valueOf(novoCodigo), 7, "0");
            }
            catch (Throwable throwable) {
                return "0000000";
            }
        }
        rs.close();
        stmt.close();
        throw new SQLException("PessoaDB_CalculaNovoCodigo: ultimo registro n\u00e3o localizado");
    }

    public static PessoaBD getPessoaBD() {
        if (pessoaBD == null) {
            pessoaBD = new PessoaBD();
        }
        return pessoaBD;
    }

    public void lerRegistro(Object objetoNegocio, ResultSet rs) throws SQLException {
        Pessoa pessoa = (Pessoa)objetoNegocio;
        pessoa.setTextoEndereco(this.vazioSeNulo(rs.getString("textoEndereco")));
        pessoa.setNomePessoa(rs.getString("textoNome"));
        pessoa.setTextoBairro(this.vazioSeNulo(rs.getString("textoBairro")));
        pessoa.setCodigoCep(this.vazioSeNulo(rs.getString("codigoCep")));
        pessoa.setTextoCidade(this.vazioSeNulo(rs.getString("textoCidade")));
        pessoa.setCodigoUFRel(this.vazioSeNulo(rs.getString("textoSiglaUFFK")));
        pessoa.setCodigoPessoa(rs.getString("codigoPessoa"));
        pessoa.getTipoPessoa().setCodigoTipoPessoa(rs.getInt("codigoTipoPessoaFK"));
    }

    public Object lerRegistro(ResultSet rs) throws SQLException {
        Pessoa pessoa = new Pessoa();
        this.lerRegistro(pessoa, rs);
        return pessoa;
    }

    public boolean localizado(Object objetoNegocio) throws SQLException {
        Pessoa pessoa = (Pessoa)objetoNegocio;
        String query = "select * from Pessoa where codigoPessoa ='" + pessoa.getCodigoPessoa() + "'";
        return !this.isConsultaVazia(query);
    }

    public void obter(Object objetoNegocio) throws SQLException {
        Pessoa pessoa = (Pessoa)objetoNegocio;
        String query = "";
        if (pessoa.getCodigoPessoa() == null || Long.parseLong(pessoa.getCodigoPessoa()) <= 0L) {
            if (pessoa.getNomePessoa() == null || pessoa.getNomePessoa().trim().length() == 0) {
                return;
            }
            query = "SELECT * FROM Pessoa WHERE textoNome = '" + pessoa.getNomePessoa() + "'";
        } else {
            query = "SELECT * FROM Pessoa WHERE codigoPessoa = '" + pessoa.getCodigoPessoa() + "'";
        }
        this.popularObjeto((Object)pessoa, query);
    }

    public String obterCodigoPessoa(String nomePessoa) throws SQLException {
        String query = "SELECT  Pessoa.codigoPessoa FROM Pessoa where textoNome = '" + nomePessoa + "'";
        String codigoPessoa = "";
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            codigoPessoa = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return codigoPessoa;
    }

    public Vector obterLista() throws SQLException {
        String query = "SELECT * FROM Pessoa order by textoNome";
        return this.gerarVetor(query);
    }

    public String obterNomePessoa(String codigoPessoa) throws SQLException {
        String query = "SELECT  Pessoa.textoNome FROM Pessoa where codigoPessoa = '" + codigoPessoa + "'";
        String nomePessoa = "";
        this.conectar();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            nomePessoa = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return nomePessoa;
    }

    public void obterPorIdentificaco(Pessoa pessoa, Identificacao identificacao) throws SQLException {
        if (identificacao.getNumeroIdentificador() != null && identificacao.getNumeroIdentificador().trim().compareTo("") != 0) {
            String query = "SELECT * FROM Pessoa LEFT JOIN Identificacao ON Pessoa.codigoPessoa = Identificacao.codigoPessoaFK WHERE Identificacao.NumeroIdentificador = '" + identificacao.getNumeroIdentificador() + "'";
            this.popularObjeto((Object)pessoa, query);
        }
    }

    public void remover(Object objetoNegocio) throws SQLException {
        Pessoa pessoa = (Pessoa)objetoNegocio;
        String query = "delete * from Pessoa where codigoPessoa='" + pessoa.getCodigoPessoa() + "'";
        this.executar(query);
    }

    public void salvar(Object objetoNegocio) throws SQLException {
        Pessoa pessoa = (Pessoa)objetoNegocio;
        if (pessoa.getCodigoPessoa() == null || pessoa.getCodigoPessoa().length() == 0) {
            this.adicionar(pessoa);
        } else {
            this.alterar(pessoa);
        }
    }

    private void setPessoaBD(PessoaBD newPessoaBD) {
        pessoaBD = newPessoaBD;
    }
}

