/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.infraestrutura;

import br.com.bb.plugins.negocio.infraestrutura.ArquivoRemessa;
import br.com.bb.plugins.negocio.infraestrutura.CampoLeiaute;
import br.com.bb.plugins.negocio.infraestrutura.CampoRemessa;
import br.com.bb.plugins.negocio.infraestrutura.Leiaute;
import br.com.bb.plugins.negocio.infraestrutura.RegistroRemessa;
import br.com.bb.plugins.persistencia.infraestrutura.XmlBD;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.File;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArquivoRemessaBD {
    private ArquivoRemessaBD() {
    }

    public static ArquivoRemessa obterArquivoImportacao(Leiaute leiaute) throws Throwable {
        ArquivoRemessa arqRem = new ArquivoRemessa();
        arqRem.setCodigoArquivo(leiaute.getCodigoLeiaute());
        RegistroRemessa reg = new RegistroRemessa();
        reg.setNome(leiaute.getCodigoLeiaute());
        reg.setTamanho(leiaute.getTamanhoRegistro());
        reg.setIdentificadores(null);
        int i = 0;
        int j = 0;
        while (j < leiaute.getCampos().size()) {
            CampoRemessa c = new CampoRemessa();
            CampoLeiaute campoLeiaute = (CampoLeiaute)leiaute.getCampos().elementAt(j);
            c.setNome(campoLeiaute.getNome());
            c.setNatureza('S');
            c.setValor("");
            c.setTamanho(campoLeiaute.getTamanhoCampo());
            c.setInicio(campoLeiaute.getPosicaoInicio() - 1);
            c.setFim(campoLeiaute.getPosicaoInicio() + campoLeiaute.getTamanhoCampo() - 2);
            if (c.getInicio() > i) {
                CampoRemessa filler = new CampoRemessa();
                filler.setNome("filler" + String.valueOf(i).trim());
                filler.setNatureza('S');
                filler.setValor("");
                filler.setTamanho(c.getInicio() - i);
                reg.add(filler);
            }
            reg.add(c);
            i = c.getFim();
            ++j;
        }
        arqRem.addTipoRegistro(reg);
        return arqRem;
    }

    public static ArquivoRemessa obterArquivoRemessa(String codigoArquivo) throws Throwable {
        return ArquivoRemessaBD.obterArquivoRemessa(null, codigoArquivo);
    }

    public static ArquivoRemessa obterArquivoRemessa(String codigoPlugin, String codigoArquivo) throws Throwable {
        return ArquivoRemessaBD.obterArquivoRemessa(codigoPlugin, codigoArquivo, null, null);
    }

    public static ArquivoRemessa obterArquivoRemessa(String codigoPlugin, String codigoArquivo, ZipFile zf, ZipEntry ze) throws Throwable {
        ArquivoRemessa arqRem = new ArquivoRemessa();
        arqRem.setCodigoArquivo(codigoArquivo);
        File arquivoXML = new File(String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "classes" + System.getProperty("file.separator") + "arquivo_" + codigoArquivo + ".xml");
        XmlDocumentBuilder builder = zf == null ? (codigoPlugin == null ? XmlBD.obter("Arquivo_" + codigoArquivo + ".xml") : XmlBD.obter(codigoPlugin, "Arquivo_" + codigoArquivo + ".xml")) : XmlBD.obter(zf, ze);
        Element elemento = builder.getDocument().getDocumentElement();
        if (elemento != null) {
            if (elemento.getAttribute("Analisavel") != null && elemento.getAttribute("Analisavel").trim().equalsIgnoreCase("S")) {
                arqRem.setAnalisavel(true);
                if (elemento.getAttribute("NomeAnalisador") != null && elemento.getAttribute("NomeAnalisador").trim().length() > 0) {
                    arqRem.setNomeAnalisador(elemento.getAttribute("NomeAnalisador"));
                }
                if (elemento.getAttribute("NomeClasseAnalisador") != null && elemento.getAttribute("NomeClasseAnalisador").trim().length() > 0) {
                    arqRem.setNomeClasseAnalisador(elemento.getAttribute("NomeClasseAnalisador"));
                }
                if (elemento.getAttribute("NomeBD") != null && elemento.getAttribute("NomeBD").trim().length() > 0) {
                    arqRem.setNomeBD(elemento.getAttribute("NomeBD"));
                }
            } else {
                arqRem.setAnalisavel(false);
            }
            NodeList list = elemento.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                String nome = n.getNodeName();
                if (nome.equalsIgnoreCase("Registro")) {
                    RegistroRemessa reg = new RegistroRemessa();
                    Element e = (Element)n;
                    reg.setNome(e.getAttribute("Nome"));
                    reg.setTamanho(Integer.parseInt(e.getAttribute("Tamanho")));
                    if (e.getAttribute("Identificador") != null) {
                        reg.setIdentificadores(new Vector());
                        reg.getIdentificadores().addElement(e.getAttribute("Identificador"));
                    }
                    char idIdentificador = '1';
                    while (idIdentificador < '9') {
                        if (e.getAttribute("Identificador" + idIdentificador) == null || e.getAttribute("Identificador" + idIdentificador).trim().length() == 0) break;
                        reg.getIdentificadores().addElement(e.getAttribute("Identificador" + idIdentificador));
                        idIdentificador = (char)(idIdentificador + '\u0001');
                    }
                    NodeList campos = n.getChildNodes();
                    int j = 0;
                    while (j < campos.getLength()) {
                        if (campos.item(j).getNodeName().equalsIgnoreCase("Campo")) {
                            CampoRemessa c = new CampoRemessa();
                            Element e1 = (Element)campos.item(j);
                            c.setNome(e1.getAttribute("Nome"));
                            c.setNatureza(e1.getAttribute("Tipo").charAt(0));
                            String valor = e1.getAttribute("Valor");
                            c.setObrigatorio(e1.getAttribute("Obrigatorio").equalsIgnoreCase("S"));
                            c.setDescricao(e1.getAttribute("Descricao"));
                            NodeList conteudo = campos.item(j).getChildNodes();
                            Vector<String> conteudoCampoRemessa = new Vector<String>();
                            int l = 0;
                            while (l < conteudo.getLength()) {
                                if (conteudo.item(l).getNodeName().equalsIgnoreCase("ConteudoCampo")) {
                                    Element et = (Element)conteudo.item(l);
                                    conteudoCampoRemessa.addElement(new String(et.getChildNodes().item(0).toString()));
                                }
                                ++l;
                            }
                            c.setConteudoCampoRemessa(conteudoCampoRemessa);
                            switch (c.getNatureza()) {
                                case 'N': {
                                    c.setNumeroDecimais(Integer.parseInt(e1.getAttribute("Decimais")));
                                    c.setTamanho(Integer.parseInt(e1.getAttribute("Tamanho")));
                                    if (valor.length() <= 0) break;
                                    c.setValor((double)Integer.parseInt(valor) / Math.pow(10.0, c.getNumeroDecimais()));
                                    break;
                                }
                                case 'R': {
                                    c.setNumeroDecimais(0);
                                    c.setTamanho(Integer.parseInt(e1.getAttribute("Tamanho")));
                                    break;
                                }
                                case 'S': {
                                    c.setTamanho(Integer.parseInt(e1.getAttribute("Tamanho")));
                                    c.setValor(valor);
                                    break;
                                }
                                case 'D': {
                                    c.setFormato(e1.getAttribute("Formato"));
                                }
                            }
                            reg.add(c);
                        }
                        ++j;
                    }
                    arqRem.addTipoRegistro(reg);
                }
                ++i;
            }
        }
        return arqRem;
    }
}

