/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.negocio.comum.Plugin;
import br.com.bb.plugins.negocio.infraestrutura.CampoTabela;
import br.com.bb.plugins.negocio.infraestrutura.IndiceTabela;
import br.com.bb.plugins.negocio.infraestrutura.Tabela;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.Persistencia;
import br.com.bb.plugins.persistencia.comum.PluginBD;
import br.com.bb.plugins.persistencia.infraestrutura.GeradorTabelasListener;
import br.com.bb.plugins.persistencia.infraestrutura.XmlBD;
import br.com.bb.plugins.utilitarios.Util;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeradorTabelas
extends Persistencia {
    private Vector vGeradorTabelasListener = null;
    private Plugin plugin = null;
    private DatabaseMetaData metaData = null;
    private String catalog = null;

    public int abrirLista() throws SQLException {
        return 0;
    }

    public void addGeradorTabelasListener(GeradorTabelasListener newListener) {
        this.getVGeradorTabelasListener().addElement(newListener);
    }

    public void adicionar(Object objetoNegocio) throws SQLException {
    }

    public void adicionarTabela(Tabela tabela) throws SQLException {
        String query = null;
        Object tipoConstraint = null;
        boolean indPK = false;
        this.conectar();
        try {
            String nomeTabela = tabela.getNome();
            query = "CREATE TABLE " + tabela.getNome() + " ( ";
            int i = 0;
            while (i < tabela.getVCampos().size()) {
                query = String.valueOf(query) + ((CampoTabela)tabela.getVCampos().elementAt(i)).getNome() + " " + ((CampoTabela)tabela.getVCampos().elementAt(i)).getTipo();
                if (i + 1 < tabela.getVCampos().size()) {
                    query = String.valueOf(query) + ",";
                }
                ++i;
            }
            query = String.valueOf(query) + ")";
            this.executarUpdate(query);
            this.criarChavePrimaria(tabela);
            this.criarIndices(tabela);
        }
        catch (SQLException e) {
            System.out.println("Erro na adi\u00e7\u00e3o da tabela " + tabela.getNome());
            throw e;
        }
    }

    public void alterar(Object objetoNegocio) throws SQLException {
    }

    public void atualizarEstruturaTabela(Tabela tabela) throws SQLException {
        String prefQuery = null;
        String query = null;
        Tabela tabelaDestino = this.obterTabela(tabela.getNome());
        if (tabelaDestino == null) {
            this.adicionarTabela(tabela);
            return;
        }
        this.excluirChavePrimaria(tabela);
        this.excluirIndices(tabela);
        prefQuery = ConexaoBancoDados.getPadraoSQL().equals("ANSI") ? "ALTER TABLE " + tabela.getNome() + " ADD COLUMN " : "ALTER TABLE " + tabela.getNome() + " ADD ";
        boolean indCampoEncontrado = false;
        int i = 0;
        while (i < tabela.getVCampos().size()) {
            CampoTabela campoOrigem = (CampoTabela)tabela.getVCampos().elementAt(i);
            indCampoEncontrado = false;
            int j = 0;
            while (j < tabelaDestino.getVCampos().size()) {
                CampoTabela campoDestino = (CampoTabela)tabelaDestino.getVCampos().elementAt(j);
                if (campoOrigem.getNome().equalsIgnoreCase(campoDestino.getNome())) {
                    indCampoEncontrado = true;
                    if (campoOrigem.getTipo().equalsIgnoreCase(campoDestino.getTipo()) || campoOrigem.getTipo().equalsIgnoreCase("INTEGER") && campoDestino.getTipo().equalsIgnoreCase("LONG")) break;
                    query = String.valueOf(prefQuery) + campoOrigem.getNome() + "_NEW  " + campoOrigem.getTipo();
                    this.executarUpdate(query);
                    query = "update " + tabela.getNome() + " set " + campoOrigem.getNome() + "_NEW = " + campoOrigem.getNome();
                    this.executarUpdate(query);
                    query = "alter table " + tabela.getNome() + " drop column " + campoOrigem.getNome();
                    this.executarUpdate(query);
                    query = String.valueOf(prefQuery) + campoOrigem.getNome() + " " + campoOrigem.getTipo();
                    this.executarUpdate(query);
                    query = "update " + tabela.getNome() + " set " + campoOrigem.getNome() + " = " + campoOrigem.getNome() + "_NEW";
                    this.executarUpdate(query);
                    query = "alter table " + tabela.getNome() + " drop column " + campoOrigem.getNome() + "_NEW";
                    this.executarUpdate(query);
                    break;
                }
                ++j;
            }
            if (!indCampoEncontrado) {
                query = String.valueOf(prefQuery) + campoOrigem.getNome() + " " + campoOrigem.getTipo();
                this.executarUpdate(query);
            }
            ++i;
        }
        this.criarChavePrimaria(tabela);
        this.criarIndices(tabela);
    }

    public void atualizarTabelas(XmlDocumentBuilder builder) throws Throwable {
        Vector vTabelas = this.montarVetorTabelas(builder);
        int i = 0;
        while (i < vTabelas.size()) {
            Tabela tabela = (Tabela)vTabelas.elementAt(i);
            this.atualizarEstruturaTabela(tabela);
            System.out.println(tabela.getNome());
            if (tabela.getBasica().equals("S")) {
                this.popularTabelaBasica(tabela);
            }
            this.firePercentualConcluido((int)((double)i / (double)vTabelas.size() * 100.0));
            ++i;
        }
        this.firePercentualConcluido(100);
    }

    public void criarArquivoPropriedades() throws Throwable {
        if (ConexaoBancoDados.getNomeBancoDados().indexOf("prp") > 0) {
            File f = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + this.getPlugin().getCodigoPlugin().toLowerCase() + ".prp");
            if (f.exists()) {
                File f2 = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + this.getPlugin().getCodigoPlugin() + ".bkp");
                f2.delete();
                f.renameTo(f2);
            }
            String linha = "";
            String dir = "";
            String dirClasses = System.getProperty("user.dir").toLowerCase();
            dirClasses = dirClasses.replace('\\', '/');
            int x = dirClasses.indexOf("classes");
            String dirDados = "";
            String so = System.getProperty("os.name");
            if (x > 0) {
                dirDados = String.valueOf(dirClasses.substring(0, x)) + "dados/" + this.getPlugin().getNomePlugin().toLowerCase();
            } else {
                if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                    dir = System.getProperty("user.dir").substring(0, 2);
                }
                dirDados = String.valueOf(dir) + "/bancobrasil/aplicativos/dados" + this.getPlugin().getNomePlugin().toLowerCase();
            }
            File diretorio = null;
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                diretorio = new File(dirDados.replace('/', '\\'));
                Util.deletarArqsEm(dirDados.replace('/', '\\'));
            } else {
                diretorio = new File(dirDados);
                Util.deletarArqsEm(dirDados);
            }
            diretorio.mkdirs();
            FileOutputStream meuBat = new FileOutputStream(String.valueOf(ControleAplicacao.getDiretorioClasses()) + this.getPlugin().getCodigoPlugin().toLowerCase() + ".prp", true);
            PrintWriter registro = new PrintWriter(meuBat);
            registro.println("indexPath=" + dirDados + "/indexes");
            registro.println("systemPath=" + dirDados + "/system");
            registro.println("tablePath=" + dirDados + "/tables");
            registro.println("tmpPath=" + dirDados + "/tmp");
            registro.println("relativeToProperties=0");
            registro.println("cacheAmount=512");
            registro.println("cacheCondition=CACHE_ROWS");
            registro.println("cacheResetPercent=10");
            registro.println("fastUpdate=0");
            registro.println("indexLoad=5");
            registro.println("missesInCacheStats=100");
            registro.println("resultsOnDisk=0");
            registro.println("resultsSetCache=CACHE_ROWS");
            registro.println("resultsSetCacheAmount=100");
            registro.println("rowCacheSize=128");
            registro.println("searchDeletes=0");
            registro.println("exportSQL=0");
            registro.println("traceConsole=1");
            registro.println("traceFile=" + dirDados + "/trace.log");
            registro.println("traceLevel=2");
            registro.println("recoveryPolicy=1");
            registro.println("transLevel=1");
            registro.println("transImports=100");
            registro.println("currencyDecimal=2");
            registro.println("currencySymbol=$");
            registro.println("dateFormat=yyyy-mm-dd");
            registro.println("nowMeansTime=0");
            registro.println("altStringHashing=0");
            registro.println("likeIgnoreCase=0");
            registro.println("strictLiterals=0");
            registro.println("readOnly=0");
            registro.close();
            meuBat.close();
        }
    }

    public void criarChavePrimaria(Tabela tabela) throws SQLException {
        String query = null;
        boolean indFK = false;
        query = ConexaoBancoDados.getPadraoSQL().equals("ANSI") ? "ALTER TABLE " + tabela.getNome() + " ADD CONSTRAINT PrimaryKey PRIMARY KEY (" : "ALTER TABLE " + tabela.getNome() + " ADD PRIMARY KEY (";
        int i = 0;
        while (i < tabela.getVCampos().size()) {
            if (((CampoTabela)tabela.getVCampos().elementAt(i)).isChave()) {
                if (indFK) {
                    query = String.valueOf(query) + ",";
                }
                query = String.valueOf(query) + ((CampoTabela)tabela.getVCampos().elementAt(i)).getNome();
                indFK = true;
            }
            ++i;
        }
        if (indFK) {
            query = String.valueOf(query) + ")";
            this.executarUpdate(query);
        }
    }

    public void criarIndice(IndiceTabela indice, Tabela tabela) throws SQLException {
        String query = null;
        String unico = "";
        unico = indice.isUnico() ? "UNIQUE" : "";
        query = "CREATE " + unico + " INDEX " + indice.getNome() + " ON " + tabela.getNome() + " (" + indice.getChave() + ")";
        this.executarUpdate(query);
    }

    public void criarIndices(Tabela tabela) throws SQLException {
        int j = 0;
        while (j < tabela.getVConstraint().size()) {
            this.criarIndice((IndiceTabela)tabela.getVConstraint().elementAt(j), tabela);
            ++j;
        }
    }

    public void excluirChavePrimaria(Tabela tabela) throws SQLException {
        String query = null;
        query = ConexaoBancoDados.getPadraoSQL().equals("ANSI") ? "ALTER TABLE " + tabela.getNome() + " DROP CONSTRAINT PrimaryKey" : "ALTER TABLE " + tabela.getNome() + " DROP PRIMARY KEY";
        try {
            this.executarUpdate(query);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void excluirIndices(Tabela tabela) throws SQLException {
        String query = null;
        int i = 0;
        while (i < tabela.getVConstraint().size()) {
            try {
                query = "ALTER TABLE " + tabela.getNome() + " DROP CONSTRAINT " + ((IndiceTabela)tabela.getVConstraint().elementAt(i)).getNome();
                this.executarUpdate(query);
            }
            catch (Throwable t) {
                try {
                    query = "ALTER TABLE " + tabela.getNome() + " DROP INDEX " + ((IndiceTabela)tabela.getVConstraint().elementAt(i)).getNome();
                    this.executarUpdate(query);
                }
                catch (Throwable t1) {
                    System.out.println("Query=" + query + " - " + t1);
                }
            }
            ++i;
        }
    }

    public ResultSet executarQuery(String query) throws SQLException {
        Statement stmt = ConexaoBancoDados.getConexao().createStatement();
        ResultSet rs = stmt.executeQuery(query);
        stmt.close();
        return rs;
    }

    public void executarUpdate(String query) throws SQLException {
        Statement stmt = ConexaoBancoDados.getConexao().createStatement();
        stmt.executeUpdate(query);
        stmt.close();
    }

    private void fireGeracaoCancelada(Throwable exception) {
        int tam = this.getVGeradorTabelasListener().size();
        int i = 0;
        while (i < tam) {
            ((GeradorTabelasListener)this.getVGeradorTabelasListener().elementAt(i)).geracaoCancelada(exception);
            ++i;
        }
    }

    private void fireGeracaoIniciada() {
        int tam = this.getVGeradorTabelasListener().size();
        int i = 0;
        while (i < tam) {
            ((GeradorTabelasListener)this.getVGeradorTabelasListener().elementAt(i)).geracaoIniciada();
            ++i;
        }
    }

    private void fireGeracaoTerminada() {
        int tam = this.getVGeradorTabelasListener().size();
        int i = 0;
        while (i < tam) {
            ((GeradorTabelasListener)this.getVGeradorTabelasListener().elementAt(i)).geracaoTerminada();
            ++i;
        }
    }

    private void fireInicializandoGeracao() {
        int tam = this.getVGeradorTabelasListener().size();
        int i = 0;
        while (i < tam) {
            ((GeradorTabelasListener)this.getVGeradorTabelasListener().elementAt(i)).inicializandoGeracao();
            ++i;
        }
    }

    private void firePercentualConcluido(int percentual) {
        int tam = this.getVGeradorTabelasListener().size();
        int i = 0;
        while (i < tam) {
            ((GeradorTabelasListener)this.getVGeradorTabelasListener().elementAt(i)).percentualConcluido(percentual);
            ++i;
        }
    }

    private String getCatalog() {
        return this.catalog;
    }

    public String getDiretorioDados() {
        String diretorioClasses = System.getProperty("user.dir").toLowerCase();
        int ix = diretorioClasses.indexOf("classes");
        return String.valueOf(diretorioClasses.substring(0, ix)) + "dados";
    }

    private DatabaseMetaData getMetaData() {
        if (this.metaData == null) {
            try {
                ConexaoBancoDados.conectar();
                this.setMetaData(ConexaoBancoDados.getConexao().getMetaData());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.metaData;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Vector getVGeradorTabelasListener() {
        if (this.vGeradorTabelasListener == null) {
            this.vGeradorTabelasListener = new Vector();
        }
        return this.vGeradorTabelasListener;
    }

    public void lerRegistro(Object objetoNegocio, ResultSet rs) throws SQLException {
    }

    public Object lerRegistro(ResultSet rs) throws SQLException {
        return null;
    }

    public boolean localizado(Object objetoNegocio) throws SQLException {
        return false;
    }

    public Vector montarVetorTabelas(XmlDocumentBuilder builder) throws Throwable {
        Element elemento = builder.getDocument().getDocumentElement();
        Vector<Tabela> vTab = new Vector<Tabela>();
        if (elemento != null) {
            NodeList list = elemento.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                String nome = n.getNodeName();
                if (nome.equalsIgnoreCase("Tabela")) {
                    Tabela tabela = new Tabela(((Element)n).getAttribute("Nome").trim());
                    tabela.setVersao(((Element)n).getAttribute("Versao").trim());
                    tabela.setBasica(((Element)n).getAttribute("Basica").trim());
                    tabela.setSobreescrever(((Element)n).getAttribute("Sobreescrever"));
                    NodeList listTabela = n.getChildNodes();
                    int j = 0;
                    while (j < listTabela.getLength()) {
                        Node nTabela = listTabela.item(j);
                        nome = nTabela.getNodeName();
                        if (nome.equalsIgnoreCase("Campos")) {
                            CampoTabela campoTabela = new CampoTabela(((Element)nTabela).getAttribute("Nome").trim());
                            campoTabela.setTipo(((Element)nTabela).getAttribute("Tipo").trim());
                            if (((Element)nTabela).getAttribute("ChavePrimaria").trim().equalsIgnoreCase("S")) {
                                campoTabela.setChave(true);
                            }
                            tabela.getVCampos().addElement(campoTabela);
                        }
                        if (nome.equalsIgnoreCase("Indice")) {
                            IndiceTabela indice = new IndiceTabela();
                            indice.setNome(((Element)nTabela).getAttribute("Nome").trim());
                            if (((Element)nTabela).getAttribute("Unico").trim().equalsIgnoreCase("S")) {
                                indice.setUnico(true);
                            }
                            indice.setChave(((Element)nTabela).getAttribute("Chave").trim());
                            tabela.getVConstraint().addElement(indice);
                        }
                        ++j;
                    }
                    vTab.addElement(tabela);
                }
                ++i;
            }
        }
        return vTab;
    }

    public void obter(Object objetoNegocio) throws SQLException {
    }

    public Vector obterLista() throws SQLException {
        return null;
    }

    public Tabela obterTabela(String nomeTabela) throws SQLException {
        ResultSetMetaData rsmt;
        ResultSet rsTab;
        Tabela tabela = new Tabela();
        tabela.setNome(nomeTabela);
        Statement stmt = null;
        try {
            stmt = ConexaoBancoDados.getConexao().createStatement();
            rsTab = stmt.executeQuery("select * from " + nomeTabela);
            rsmt = rsTab.getMetaData();
        }
        catch (SQLException t) {
            stmt.close();
            return null;
        }
        int i = 1;
        while (i <= rsmt.getColumnCount()) {
            CampoTabela campo = new CampoTabela();
            campo.setNome(rsmt.getColumnName(i));
            campo.setTipo(rsmt.getColumnTypeName(i));
            int tamanho = rsmt.getColumnDisplaySize(i);
            if (campo.getTipo().equalsIgnoreCase("VARCHAR")) {
                campo.setTipo(String.valueOf(campo.getTipo()) + "(" + tamanho + ")");
            } else if (campo.getTipo().equalsIgnoreCase("DATETIME")) {
                campo.setTipo("DATE");
            } else if (campo.getTipo().equalsIgnoreCase("INTEGER")) {
                campo.setTipo("LONG");
            } else if (campo.getTipo().equalsIgnoreCase("SMALLINT")) {
                campo.setTipo("INTEGER");
            }
            tabela.getVCampos().addElement(campo);
            ++i;
        }
        rsTab.close();
        stmt.close();
        rsTab = this.metaData.getIndexInfo(this.getCatalog(), null, nomeTabela, false, false);
        IndiceTabela indice = new IndiceTabela();
        indice.setNome("");
        while (rsTab.next()) {
            String nomeIndice = rsTab.getString("INDEX_NAME");
            if (nomeIndice == null) continue;
            if (!nomeIndice.equalsIgnoreCase(indice.getNome())) {
                if (indice.getNome() != "") {
                    indice.setChave(indice.getChave().substring(1));
                    tabela.getVConstraint().addElement(indice);
                    indice = new IndiceTabela();
                    indice.setNome(nomeIndice);
                    indice.setUnico(!rsTab.getBoolean("NON_UNIQUE"));
                    indice.setChave("");
                }
                indice.setNome(nomeIndice);
                indice.setChave("");
            }
            indice.setChave(String.valueOf(indice.getChave()) + "," + rsTab.getString("COLUMN_NAME"));
        }
        if (indice.getNome() != "") {
            indice.setChave(indice.getChave().substring(1));
            tabela.getVConstraint().addElement(indice);
        }
        return tabela;
    }

    public void popularTabelaBasica(Tabela tabela) throws SQLException {
        Element elemento;
        XmlDocumentBuilder builder = XmlBD.obter("tab_" + tabela.getNome() + ".xml");
        if (builder == null) {
            ControleAplicacao.getRoteadorPlugins().exibirMensagem("Arquivo tab_" + tabela.getNome() + ".xml n\u00e3o localizado!");
            System.exit(0);
        }
        if ((elemento = builder.getDocument().getDocumentElement()) != null) {
            NodeList list = elemento.getChildNodes();
            try {
                int i = 0;
                while (i < list.getLength()) {
                    Node n = list.item(i);
                    String nome = n.getNodeName();
                    if (nome.equalsIgnoreCase(tabela.getNome())) {
                        int b = 0;
                        while (b < tabela.getVCampos().size()) {
                            String campo = ((CampoTabela)tabela.getVCampos().elementAt(b)).getNome();
                            ((CampoTabela)tabela.getVCampos().elementAt(b)).setValor(((Element)n).getAttribute(campo.trim()));
                            ++b;
                        }
                        this.populaTab_insert(tabela);
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                throw new SQLException(t.getMessage());
            }
        }
    }

    public void populaTab_insert(Tabela tabela) throws SQLException {
        block13: {
            String query = null;
            String values = null;
            Statement stmt = null;
            String nomeTabela = tabela.getNome();
            query = "INSERT INTO " + tabela.getNome() + " (";
            values = ") values (";
            int a = 0;
            while (a < tabela.getVCampos().size()) {
                query = String.valueOf(query) + ((CampoTabela)tabela.getVCampos().elementAt(a)).getNome();
                if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("VAR")) {
                    values = String.valueOf(values) + "'" + ((CampoTabela)tabela.getVCampos().elementAt(a)).getValor() + "'";
                } else if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("INT")) {
                    values = String.valueOf(values) + Integer.parseInt(((CampoTabela)tabela.getVCampos().elementAt(a)).getValor());
                } else if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("LON")) {
                    values = String.valueOf(values) + Integer.parseInt(((CampoTabela)tabela.getVCampos().elementAt(a)).getValor());
                } else if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("DAT")) {
                    String data = ((CampoTabela)tabela.getVCampos().elementAt(a)).getValor();
                    values = data == null || data.trim().length() == 0 ? String.valueOf(values) + this.dataSql(new Date(80, 0, 1)) : String.valueOf(values) + this.dataSql(Date.valueOf(((CampoTabela)tabela.getVCampos().elementAt(a)).getValor()));
                } else if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("DOU")) {
                    values = String.valueOf(values) + Double.valueOf(((CampoTabela)tabela.getVCampos().elementAt(a)).getValor());
                }
                if (a + 1 < tabela.getVCampos().size()) {
                    query = String.valueOf(query) + ", ";
                    values = String.valueOf(values) + ", ";
                }
                ++a;
            }
            values = String.valueOf(values) + ")";
            query = String.valueOf(query) + values;
            try {
                stmt = this.con.createStatement();
                stmt.executeUpdate(query);
                stmt.close();
            }
            catch (SQLException e) {
                stmt.close();
                if (!tabela.getSobreescrever().equals("S")) break block13;
                this.populaTab_update(tabela);
            }
        }
    }

    public void populaTab_update(Tabela tabela) throws SQLException {
        String queryUpdate = null;
        String campo = null;
        String where = null;
        Statement stm = null;
        Vector vRegistros = new Vector();
        String nomeTabela = tabela.getNome();
        try {
            queryUpdate = "UPDATE " + tabela.getNome() + " SET ";
            int a = 0;
            while (a < tabela.getVCampos().size()) {
                queryUpdate = String.valueOf(queryUpdate) + ((CampoTabela)tabela.getVCampos().elementAt(a)).getNome() + " = ";
                if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("VAR")) {
                    queryUpdate = String.valueOf(queryUpdate) + "'" + ((CampoTabela)tabela.getVCampos().elementAt(a)).getValor() + "'";
                } else if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("INT")) {
                    queryUpdate = String.valueOf(queryUpdate) + Integer.parseInt(((CampoTabela)tabela.getVCampos().elementAt(a)).getValor());
                } else if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("LON")) {
                    queryUpdate = String.valueOf(queryUpdate) + Integer.parseInt(((CampoTabela)tabela.getVCampos().elementAt(a)).getValor());
                } else if (((CampoTabela)tabela.getVCampos().elementAt(a)).getTipo().substring(0, 3).equalsIgnoreCase("DAT")) {
                    queryUpdate = String.valueOf(queryUpdate) + this.dataSql(Date.valueOf(((CampoTabela)tabela.getVCampos().elementAt(a)).getValor()));
                }
                if (a + 1 < tabela.getVCampos().size()) {
                    queryUpdate = String.valueOf(queryUpdate) + ", ";
                }
                ++a;
            }
            where = " WHERE ";
            int b = 0;
            while (b < tabela.getVCampos().size()) {
                if (((CampoTabela)tabela.getVCampos().elementAt(b)).isChave()) {
                    campo = ((CampoTabela)tabela.getVCampos().elementAt(b)).getNome();
                    if (where.length() > 7) {
                        where = String.valueOf(where) + " AND ";
                    }
                    where = ((CampoTabela)tabela.getVCampos().elementAt(b)).getTipo().substring(0, 3).equalsIgnoreCase("VAR") ? String.valueOf(where) + campo + " = '" + ((CampoTabela)tabela.getVCampos().elementAt(b)).getValor() + "'" : String.valueOf(where) + campo + " = " + ((CampoTabela)tabela.getVCampos().elementAt(b)).getValor();
                }
                ++b;
            }
            queryUpdate = String.valueOf(queryUpdate) + where;
            stm = this.con.createStatement();
            stm.executeUpdate(queryUpdate);
            stm.close();
        }
        catch (SQLException e) {
            System.out.println("Erro ao adicionar registros na tabela " + tabela.getNome());
            stm.close();
            throw e;
        }
    }

    public void populaTabelasInstalacao() throws Throwable {
        this.conectar();
        String query = null;
        XmlDocumentBuilder builder = XmlBD.obter("tab_instalacao.xml");
        if (builder == null) {
            return;
        }
        Element elemento = builder.getDocument().getDocumentElement();
        if (elemento != null) {
            NodeList list = elemento.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                String nome = n.getNodeName();
                if (nome.equalsIgnoreCase("Query")) {
                    query = ((Element)n).getAttribute("Texto");
                    try {
                        this.executarUpdate(query);
                    }
                    catch (SQLException e) {
                        System.out.println("Erro na criacao de tabelas de instalacao.");
                        throw e;
                    }
                }
                ++i;
            }
        }
    }

    public void remover(Object objetoNegocio) throws SQLException {
    }

    public void salvar(Object objetoNegocio) throws SQLException {
    }

    private void setCatalog(String newCatalog) {
        this.catalog = newCatalog;
    }

    private void setMetaData(DatabaseMetaData newMetaData) {
        this.metaData = newMetaData;
    }

    public void setPlugin(Plugin newPlugin) {
        this.plugin = newPlugin;
    }

    public void setVGeradorTabelasListener(Vector newVGeradorTabelasListener) {
        this.vGeradorTabelasListener = newVGeradorTabelasListener;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verSeAtualizouTabelas(Plugin plugin) throws Throwable {
        try {
            if (plugin.getTextoVersaoBancoDados() == null) {
                return;
            }
            this.setPlugin(plugin);
            ConexaoBancoDados.conectar();
            this.conectar();
            boolean indPluginOK = false;
            this.metaData = ConexaoBancoDados.getConexao().getMetaData();
            ResultSet rs = this.metaData.getCatalogs();
            rs.next();
            this.catalog = rs.getString(1);
            rs.close();
            Statement stmt = ConexaoBancoDados.getConexao().createStatement();
            try {
                try {
                    rs = stmt.executeQuery("select * from Plugin");
                    ResultSetMetaData rsmt = rs.getMetaData();
                    int i = 1;
                    while (i <= rsmt.getColumnCount()) {
                        if (rsmt.getColumnName(i).equalsIgnoreCase("textoVersaoBancoDados")) {
                            indPluginOK = true;
                            break;
                        }
                        ++i;
                    }
                    if (rs.next()) {
                        this.getPlugin().setDataInstalacao(rs.getDate("DataInstalacao"));
                    }
                }
                catch (SQLException rsmt) {}
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                stmt.close();
                throw throwable;
            }
            {
                Object var7_13 = null;
            }
            stmt.close();
            if (indPluginOK) {
                Plugin p = new Plugin();
                p.setCodigoPlugin(this.getPlugin().getCodigoPlugin());
                PluginBD.getPluginBD().obter(p);
                int comparacao = p.getTextoVersaoBancoDados() == null ? 1 : plugin.getTextoVersaoBancoDados().compareTo(p.getTextoVersaoBancoDados());
                if (comparacao < 0) {
                    if (ControleAplicacao.getRoteadorPlugins().exibirMensagemConfirmacao("Vers\u00e3o incorreta", "A vers\u00e3o do aplicativo n\u00e3o confere com a vers\u00e3o da base de dados. Deseja continuar?")) {
                        return;
                    }
                    System.exit(0);
                } else if (comparacao == 0) {
                    return;
                }
            }
            this.fireInicializandoGeracao();
            NodeList list = null;
            Node n = null;
            String nome = null;
            String versao = null;
            Element elemento = null;
            String nomeArqXML = "tabelas_" + this.getPlugin().getCodigoPlugin().toLowerCase().trim() + ".xml";
            XmlDocumentBuilder builder = XmlBD.obter(nomeArqXML);
            elemento = builder.getDocument().getDocumentElement();
            if (elemento != null) {
                list = elemento.getChildNodes();
                int l = 0;
                while (l < list.getLength()) {
                    n = list.item(l);
                    nome = n.getNodeName();
                    if (nome.equalsIgnoreCase("Versao")) {
                        versao = ((Element)n).getAttribute("Vrs");
                        break;
                    }
                    ++l;
                }
            }
            if (!this.getPlugin().getTextoVersaoBancoDados().equals(versao)) {
                ControleAplicacao.getRoteadorPlugins().exibirMensagem("Vers\u00e3o do XML da base de dados difere da vers\u00e3o exigida pelo sistema. Reinstale a aplica\u00e7\u00e3o!");
                System.exit(0);
            }
            this.fireGeracaoIniciada();
            ConexaoBancoDados.getConexao().setAutoCommit(false);
            this.atualizarTabelas(builder);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            this.fireGeracaoTerminada();
            if (this.getPlugin().getDataInstalacao() == null) {
                this.getPlugin().setDataInstalacao(new java.util.Date());
            }
            PluginBD.getPluginBD().salvar(this.getPlugin());
            return;
        }
        catch (Throwable e) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            this.fireGeracaoCancelada(e);
        }
    }
}

