/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ImagemBD {
    private static String diretorioImagens = ControleAplicacao.getDiretorioClasses();

    public static boolean adicionar(String nomeArquivo) throws IOException {
        return ImagemBD.adicionar(nomeArquivo, "infra");
    }

    public static boolean adicionar(String siglaPlugin, String nomeArquivo) throws IOException {
        File f = new File(String.valueOf(ImagemBD.getDiretorioImagens()) + System.getProperty("file.separator") + "img" + siglaPlugin + ".bbz");
        File f1 = new File(String.valueOf(ImagemBD.getDiretorioImagens()) + System.getProperty("file.separator") + "img" + siglaPlugin + ".new");
        File f2 = new File(nomeArquivo);
        if (!f2.exists()) {
            return false;
        }
        ZipFile zipExistente = null;
        ZipOutputStream novoArquivo = null;
        FileOutputStream out = null;
        boolean indRenomear = false;
        if (f.exists()) {
            indRenomear = true;
            zipExistente = new ZipFile(f);
            out = new FileOutputStream(f1);
            novoArquivo = new ZipOutputStream(out);
            Enumeration<? extends ZipEntry> entries = zipExistente.entries();
            while (true) {
                int lidos;
                ZipEntry ze;
                try {
                    ze = entries.nextElement();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                if (ze.getName().equalsIgnoreCase(f2.getName())) continue;
                InputStream zin = zipExistente.getInputStream(ze);
                byte[] b = new byte[(int)ze.getSize()];
                novoArquivo.putNextEntry(new ZipEntry(ze.getName()));
                int totalLidos = 0;
                while ((lidos = zin.read(b, totalLidos, b.length - totalLidos)) > 0) {
                    totalLidos += lidos;
                }
                novoArquivo.write(b);
                zin.close();
                novoArquivo.closeEntry();
            }
            zipExistente.close();
        } else {
            out = new FileOutputStream(f);
            novoArquivo = new ZipOutputStream(out);
        }
        FileInputStream fi = new FileInputStream(f2);
        byte[] b = new byte[fi.available()];
        fi.read(b);
        fi.close();
        ZipEntry ze = new ZipEntry(f2.getName());
        novoArquivo.putNextEntry(ze);
        novoArquivo.write(b);
        novoArquivo.closeEntry();
        novoArquivo.close();
        out.close();
        if (indRenomear) {
            if (!f.delete()) {
                return false;
            }
            if (!f1.renameTo(f)) {
                return false;
            }
        }
        return true;
    }

    public static String getDiretorioImagens() {
        File f = new File(String.valueOf(diretorioImagens) + "imginfra.bbz");
        if (!f.exists()) {
            diretorioImagens = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator");
        }
        return diretorioImagens;
    }

    public static Image obter(String nome) {
        return ImagemBD.obter(ControleAplicacao.getPlugin().getCodigoPlugin(), nome);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image obter(String siglaPlugin, String nome) {
        try {
            File fz;
            File f = new File(String.valueOf(ImagemBD.getDiretorioImagens()) + nome);
            ZipFile zf = null;
            if (f.exists()) {
                ImagemBD.adicionar(siglaPlugin, String.valueOf(ImagemBD.getDiretorioImagens()) + nome);
            }
            if (!(fz = new File(String.valueOf(ImagemBD.getDiretorioImagens()) + "img" + siglaPlugin.toLowerCase() + ".bbz")).exists()) {
                if (siglaPlugin.equalsIgnoreCase("infra")) {
                    return null;
                }
                return ImagemBD.obter("infra", nome);
            }
            zf = new ZipFile(fz);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            ZipEntry ze = null;
            while (entries.hasMoreElements() && !(ze = entries.nextElement()).getName().equalsIgnoreCase(nome)) {
            }
            if (!ze.getName().equalsIgnoreCase(nome)) {
                if (!siglaPlugin.equalsIgnoreCase("infra")) {
                    return ImagemBD.obter("infra", nome);
                }
                return null;
            }
            InputStream i = zf.getInputStream(ze);
            byte[] b = new byte[(int)ze.getSize()];
            int totalLidos = 0;
            while (true) {
                int lidos;
                if ((lidos = i.read(b, totalLidos, b.length - totalLidos)) <= 0) {
                    Image im = Toolkit.getDefaultToolkit().createImage(b);
                    i.close();
                    zf.close();
                    return im;
                }
                totalLidos += lidos;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }
}

