/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.utilitarios;

import br.com.bb.plugins.utilitarios.Util;
import javax.swing.JOptionPane;

public class DigitoVerificador {
    public static int tipo;
    public static final int CNPJ = 1;
    public static final int CPF = 2;
    public static final int CEI = 3;
    public static final int NIT_PIS_PA = 4;
    public static final int NB = 5;
    public static final int COBRANCA = 6;
    public static final int DEBCAD = 7;
    public static final int REFERENCIA = 8;
    public static final int MOD10 = 9;
    public static final int MOD11 = 10;

    public static String calcula(String numero, int param) {
        String ret = "";
        switch (param) {
            case 1: {
                ret = DigitoVerificador.calculaCNPJ(numero);
                break;
            }
            case 2: {
                ret = DigitoVerificador.calculaCPF(numero);
                break;
            }
            case 3: {
                ret = DigitoVerificador.calculaCEI(numero);
                break;
            }
            case 4: {
                ret = DigitoVerificador.calculaNIT_PIS_PASEP(numero);
                break;
            }
            case 5: {
                ret = DigitoVerificador.calculaNB(numero);
                break;
            }
            case 6: {
                ret = DigitoVerificador.calculaNUMERO_TITULO_COBRANCA(numero);
                break;
            }
            case 7: {
                ret = DigitoVerificador.calculaDEBCAD(numero);
                break;
            }
            case 8: {
                ret = DigitoVerificador.calculaREFERENCIA(numero);
                break;
            }
            case 9: {
                ret = DigitoVerificador.calculaMOD10(numero);
                break;
            }
            case 10: {
                ret = DigitoVerificador.calculaMOD11(numero);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Op\u00e7\u00e3o inv\u00e1lida");
            }
        }
        return ret;
    }

    private static String calculaCEI(String numero) {
        try {
            numero = Util.padR(numero, 11, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String primeiroDV = "";
        int[] vetor1 = new int[]{7, 4, 1, 8, 5, 2, 1, 6, 3, 7, 4};
        int tamanho = numero.length();
        int[] numeros = new int[tamanho];
        int acumulador = 0;
        int i = 0;
        while (i < tamanho) {
            numeros[i] = Integer.parseInt(numero.substring(i, i + 1));
            acumulador += numeros[i] * vetor1[i];
            ++i;
        }
        String total = "" + acumulador;
        String dezena = "";
        String unidade = "";
        total = total.substring(total.length() - 2);
        dezena = total.substring(0, 1);
        unidade = total.substring(1, 2);
        int soma = Integer.parseInt(dezena) + Integer.parseInt(unidade);
        unidade = "" + soma;
        if ((unidade = unidade.substring(unidade.length() - 1)).equalsIgnoreCase("0")) {
            primeiroDV = "0";
        } else {
            soma = 10 - Integer.parseInt(unidade);
            primeiroDV = "" + soma;
        }
        return primeiroDV;
    }

    private static String calculaCNPJ(String numero) {
        try {
            numero = Util.padR(numero, 12, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String primeiroDV = "";
        String segundoDV = "";
        int[] vetor1 = new int[]{5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int[] vetor2 = new int[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int tamanho = numero.length();
        int[] numeros = new int[tamanho];
        double acumulador = 0.0;
        int i = 0;
        while (i < tamanho) {
            numeros[i] = Integer.parseInt(numero.substring(i, i + 1));
            acumulador += (double)(numeros[i] * vetor1[i]);
            ++i;
        }
        int resto = (int)acumulador % 11;
        primeiroDV = (resto = 11 - resto) < 10 ? "" + resto : "0";
        String numeroCalculoSegundoDV = String.valueOf(numero) + primeiroDV;
        int tamanhoSegundoCalculo = numeroCalculoSegundoDV.length();
        double acumuladorSegundoCalculo = 0.0;
        int[] numeros2 = new int[tamanhoSegundoCalculo];
        int y = 0;
        while (y < tamanhoSegundoCalculo) {
            numeros2[y] = Integer.parseInt(numeroCalculoSegundoDV.substring(y, y + 1));
            acumuladorSegundoCalculo += (double)(numeros2[y] * vetor2[y]);
            ++y;
        }
        int restoSegundoCalculo = (int)acumuladorSegundoCalculo % 11;
        segundoDV = (restoSegundoCalculo = 11 - restoSegundoCalculo) < 10 ? "" + restoSegundoCalculo : "0";
        return String.valueOf(primeiroDV) + segundoDV;
    }

    private static String calculaCPF(String numero) {
        try {
            numero = Util.padR(numero, 9, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String primeiroDV = "";
        String segundoDV = "";
        int[] vetor1 = new int[]{10, 9, 8, 7, 6, 5, 4, 3, 2};
        int[] vetor2 = new int[]{11, 10, 9, 8, 7, 6, 5, 4, 3, 2};
        int tamanho = numero.length();
        int[] numeros = new int[tamanho];
        double acumulador = 0.0;
        int i = 0;
        while (i < tamanho) {
            numeros[i] = Integer.parseInt(numero.substring(i, i + 1));
            acumulador += (double)(numeros[i] * vetor1[i]);
            ++i;
        }
        int resto = (int)acumulador % 11;
        primeiroDV = (resto = 11 - resto) < 10 ? "" + resto : "0";
        String numeroCalculoSegundoDV = String.valueOf(numero) + primeiroDV;
        int tamanhoSegundoCalculo = numeroCalculoSegundoDV.length();
        double acumuladorSegundoCalculo = 0.0;
        int[] numeros2 = new int[tamanhoSegundoCalculo];
        int y = 0;
        while (y < tamanhoSegundoCalculo) {
            numeros2[y] = Integer.parseInt(numeroCalculoSegundoDV.substring(y, y + 1));
            acumuladorSegundoCalculo += (double)(numeros2[y] * vetor2[y]);
            ++y;
        }
        int restoSegundoCalculo = (int)acumuladorSegundoCalculo % 11;
        segundoDV = (restoSegundoCalculo = 11 - restoSegundoCalculo) < 10 ? "" + restoSegundoCalculo : "0";
        return String.valueOf(primeiroDV) + segundoDV;
    }

    private static String calculaDEBCAD(String numero) {
        try {
            numero = Util.padR(numero, 8, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String DV2 = "";
        DV2 = DigitoVerificador.calculaMOD11(numero);
        return DV2;
    }

    private static String calculaMOD10(String numero) {
        String moduloDv = "";
        int soma = 0;
        int somaParcial = 0;
        int multiplicador = 2;
        if (numero != null) {
            numero.trim();
            int i = numero.length();
            while (i > 0) {
                somaParcial = Integer.parseInt(numero.substring(i - 1, i)) * multiplicador;
                if (somaParcial > 9) {
                    somaParcial -= 9;
                }
                multiplicador = multiplicador == 2 ? 1 : 2;
                soma += somaParcial;
                --i;
            }
            int guardaSoma = soma;
            while (soma % 10 != 0) {
                ++soma;
            }
            moduloDv = Integer.toString(soma - guardaSoma);
            if (moduloDv.equals("10")) {
                moduloDv = "0";
            }
        }
        return moduloDv.substring(0, 1);
    }

    private static String calculaMOD11(String numero) {
        int tamanho = numero.length();
        int multiplicador = 9;
        double acumulador = 0.0;
        int i = tamanho - 1;
        while (i >= 0) {
            int valor = Integer.parseInt(numero.substring(i, i + 1));
            acumulador += (double)(valor * multiplicador);
            if (--multiplicador == 1) {
                multiplicador = 9;
            }
            --i;
        }
        int resto = (int)acumulador % 11;
        if (resto == 10) {
            return "X";
        }
        return String.valueOf(resto).substring(0, 1);
    }

    private static String calculaNB(String numero) {
        try {
            numero = Util.padR(numero, 9, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String primeiroDV = "";
        int[] vetor1 = new int[]{2, 9, 8, 7, 6, 5, 4, 3, 2};
        int tamanho = numero.length();
        int[] numeros = new int[tamanho];
        int acumulador = 0;
        int i = 0;
        while (i < tamanho) {
            numeros[i] = Integer.parseInt(numero.substring(i, i + 1));
            acumulador += numeros[i] * vetor1[i];
            ++i;
        }
        int total = acumulador % 11;
        if (total == 0 || total == 1) {
            primeiroDV = "0";
        } else {
            total = 11 - total;
            primeiroDV = "" + total;
        }
        return primeiroDV;
    }

    private static String calculaNIT_PIS_PASEP(String numero) {
        try {
            numero = Util.padR(numero, 10, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String primeiroDV = "";
        int[] vetor1 = new int[]{3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int tamanho = numero.length();
        int[] numeros = new int[tamanho];
        int acumulador = 0;
        int i = 0;
        while (i < tamanho) {
            numeros[i] = Integer.parseInt(numero.substring(i, i + 1));
            acumulador += numeros[i] * vetor1[i];
            ++i;
        }
        int total = acumulador % 11;
        if (total == 0 || total == 1) {
            primeiroDV = "0";
        } else {
            total = 11 - total;
            primeiroDV = "" + total;
        }
        return primeiroDV;
    }

    private static String calculaNUMERO_TITULO_COBRANCA(String numero) {
        try {
            numero = Util.padR(numero, 13, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String DV2 = "";
        DV2 = DigitoVerificador.calculaMOD11(numero);
        return DV2;
    }

    private static String calculaREFERENCIA(String numero) {
        try {
            numero = Util.padR(numero, 13, "0");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String DV2 = "";
        DV2 = DigitoVerificador.calculaMOD11(numero);
        return DV2;
    }

    public static boolean verifica(String numero, int param) {
        boolean ret = false;
        String DV2 = "";
        String retornoCalcular = "";
        String numeroSemDV = "";
        switch (param) {
            case 1: {
                DV2 = numero.substring(numero.length() - 2);
                numeroSemDV = numero.substring(0, numero.length() - 2);
                retornoCalcular = DigitoVerificador.calculaCNPJ(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 2: {
                DV2 = numero.substring(numero.length() - 2);
                numeroSemDV = numero.substring(0, numero.length() - 2);
                retornoCalcular = DigitoVerificador.calculaCPF(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 3: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaCEI(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 4: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaNIT_PIS_PASEP(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 5: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaNB(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 6: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaNUMERO_TITULO_COBRANCA(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 7: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaDEBCAD(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 8: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaREFERENCIA(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 9: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaMOD10(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            case 10: {
                DV2 = numero.substring(numero.length() - 1);
                numeroSemDV = numero.substring(0, numero.length() - 1);
                retornoCalcular = DigitoVerificador.calculaMOD11(numeroSemDV);
                if (!retornoCalcular.equalsIgnoreCase(DV2)) break;
                ret = true;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Op\u00e7\u00e3o inv\u00e1lida");
            }
        }
        return ret;
    }

    public static boolean verifica(String numero, String param) {
        boolean ret = false;
        try {
            if (param.trim().equalsIgnoreCase("CEI")) {
                tipo = 3;
            } else if (param.trim().equalsIgnoreCase("CNPJ")) {
                tipo = 1;
            } else if (param.trim().equalsIgnoreCase("COBRANCA")) {
                tipo = 6;
            } else if (param.trim().equalsIgnoreCase("CPF")) {
                tipo = 2;
            } else if (param.trim().equalsIgnoreCase("DEBCAD")) {
                tipo = 7;
            } else if (param.trim().equalsIgnoreCase("NB")) {
                tipo = 5;
            } else if (param.trim().equalsIgnoreCase("NIT_PIS_PA")) {
                tipo = 4;
            } else if (param.trim().equalsIgnoreCase("REFERENCIA")) {
                tipo = 8;
            }
            String DV2 = "";
            String retornoCalcular = "";
            String numeroSemDV = "";
            switch (tipo) {
                case 1: {
                    DV2 = numero.substring(numero.length() - 2);
                    numeroSemDV = numero.substring(0, numero.length() - 2);
                    retornoCalcular = DigitoVerificador.calculaCNPJ(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 2: {
                    DV2 = numero.substring(numero.length() - 2);
                    numeroSemDV = numero.substring(0, numero.length() - 2);
                    retornoCalcular = DigitoVerificador.calculaCPF(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 3: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaCEI(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 4: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaNIT_PIS_PASEP(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 5: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaNB(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 6: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaNUMERO_TITULO_COBRANCA(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 7: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaDEBCAD(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 8: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaREFERENCIA(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 9: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaMOD10(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                case 10: {
                    DV2 = numero.substring(numero.length() - 1);
                    numeroSemDV = numero.substring(0, numero.length() - 1);
                    retornoCalcular = DigitoVerificador.calculaMOD11(numeroSemDV);
                    if (retornoCalcular.equalsIgnoreCase(DV2)) {
                        ret = true;
                    }
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Op\u00e7\u00e3o inv\u00e1lida");
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.getMessage();
        }
        return ret;
    }
}

