/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.utilitarios;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class JDBCAppl
extends Applet {
    Connection con;
    Label urlLabel;
    public TextField urlText;
    Button connectButton;
    Label sqlLabel;
    public TextField sqlText;
    Button submitButton;
    Label tableLabel;
    Label outputLabel;
    List tableList;
    public List rowList;
    Label statusLabel;
    Button disconnectButton;
    Button browseButton;
    FileDialog urlBrowse;
    public TextArea displayText;

    public boolean action(Event evt, Object what) {
        block11: {
            block10: {
                if (evt.target != this.submitButton && evt.target != this.sqlText) break block10;
                this.statusLabel.setText("Executing...");
                Statement stmt = this.con.createStatement();
                if (stmt.execute(this.sqlText.getText())) {
                    ResultSet rs = stmt.getResultSet();
                    String colNames = this.addResultstoList(rs, this.rowList, null);
                    this.outputLabel.setText(colNames);
                    rs.close();
                    this.statusLabel.setText("SQL Executed");
                }
                stmt.close();
                return true;
            }
            if (evt.target != this.connectButton && evt.target != this.urlText) break block11;
            this.statusLabel.setText("Connecting...");
            System.out.println("Connecting to " + this.urlText.getText());
            this.con = DriverManager.getConnection(this.urlText.getText());
            DatabaseMetaData dbmd = this.con.getMetaData();
            this.statusLabel.setText("Connected to " + dbmd.getDatabaseProductName() + " " + dbmd.getDatabaseProductVersion());
            ResultSet rs = dbmd.getTables(null, null, "%", null);
            this.addResultstoList(rs, this.tableList, "TABLE_NAME");
            rs.close();
            return true;
        }
        try {
            if (evt.target == this.disconnectButton) {
                if (this.con != null) {
                    this.con.close();
                }
                this.con = null;
                this.statusLabel.setText("Disconnected");
            } else if (evt.target == this.browseButton) {
                if (this.urlBrowse == null) {
                    this.urlBrowse = new FileDialog((Frame)this.getParent(), "Select a database", 0);
                }
                this.urlBrowse.show();
                this.urlText.setText("jdbc:idb:" + this.urlBrowse.getDirectory() + this.urlBrowse.getFile());
            }
        }
        catch (Exception e) {
            this.statusLabel.setText(e.toString());
            e.printStackTrace();
        }
        return false;
    }

    private String addResultstoList(ResultSet rs, List ls, String colName) {
        StringBuffer curRow = new StringBuffer(500);
        try {
            int i;
            ls.removeAll();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            while (rs.next()) {
                curRow.setLength(0);
                i = 1;
                while (i <= numCols) {
                    if (colName == null || rsmd.getColumnLabel(i).equalsIgnoreCase(colName)) {
                        if (curRow.length() > 0) {
                            curRow.append(",");
                        }
                        curRow.append(rs.getString(i));
                    }
                    ++i;
                }
                ls.add(curRow.toString());
            }
            curRow.setLength(0);
            i = 1;
            while (i <= numCols) {
                if (curRow.length() > 0) {
                    curRow.append(",");
                }
                curRow.append(rsmd.getColumnLabel(i));
                ++i;
            }
        }
        catch (Exception e) {
            this.statusLabel.setText(e.toString());
            e.printStackTrace();
        }
        return curRow.toString();
    }

    public void destroy() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception e) {
            this.statusLabel.setText(e.toString());
            e.printStackTrace();
        }
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.tableList && evt.id == 701) {
            this.sqlText.setText("SELECT * FROM " + this.tableList.getSelectedItem());
            return true;
        }
        if (evt.target == this.rowList && evt.id == 701) {
            this.displayText.append("\n" + this.rowList.getSelectedItem());
            return true;
        }
        return super.handleEvent(evt);
    }

    public void init() {
        try {
            DriverManager.setLogStream(System.out);
            this.loadDrivers();
            this.urlLabel = new Label("URL:");
            this.urlText = new TextField("jdbc:idb:idb.prp");
            this.connectButton = new Button("Connect");
            this.sqlLabel = new Label("SQL:");
            this.sqlText = new TextField("");
            this.submitButton = new Button("Submit");
            this.tableLabel = new Label("Tables");
            this.outputLabel = new Label("Results");
            this.tableList = new List();
            this.rowList = new List();
            this.statusLabel = new Label("Enter a URL and click on Connect");
            this.disconnectButton = new Button("Disconnect");
            this.browseButton = new Button("Browse");
            this.displayText = new TextArea(4, 40);
            Panel top = new Panel();
            Panel center = new Panel();
            this.setLayout(new BorderLayout(5, 5));
            this.add("North", top);
            this.add("Center", center);
            this.add("South", this.displayText);
            top.setLayout(new BorderLayout(5, 5));
            Panel topLeft = new Panel();
            Panel topCenter = new Panel();
            Panel topRight = new Panel();
            top.add("West", topLeft);
            top.add("Center", topCenter);
            top.add("East", topRight);
            topLeft.setLayout(new GridLayout(2, 1, 5, 5));
            topCenter.setLayout(new GridLayout(2, 1, 5, 5));
            topRight.setLayout(new GridLayout(2, 2, 5, 5));
            topLeft.add(this.urlLabel);
            topLeft.add(this.sqlLabel);
            topCenter.add(this.urlText);
            topCenter.add(this.sqlText);
            topRight.add(this.connectButton);
            topRight.add(this.browseButton);
            topRight.add(this.submitButton);
            topRight.add(this.disconnectButton);
            center.setLayout(new BorderLayout(5, 5));
            Panel centerLeft = new Panel();
            Panel centerCenter = new Panel();
            center.add("West", centerLeft);
            center.add("Center", centerCenter);
            centerLeft.setLayout(new BorderLayout(5, 5));
            centerCenter.setLayout(new BorderLayout(5, 5));
            centerLeft.add("North", this.tableLabel);
            centerCenter.add("North", this.outputLabel);
            centerLeft.add("Center", this.tableList);
            centerCenter.add("Center", this.rowList);
            centerCenter.add("South", this.statusLabel);
            StringBuffer rowEntry = new StringBuffer(500);
            Properties sysProps = System.getProperties();
            Enumeration<?> propNames = sysProps.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                rowEntry.setLength(0);
                rowEntry.append(propName);
                rowEntry.append('=');
                try {
                    rowEntry.append(System.getProperty(propName));
                }
                catch (Exception e) {
                    rowEntry.append(e.toString());
                }
                this.rowList.add(rowEntry.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void loadDrivers() {
        String[] drivers = new String[]{"org.enhydra.instantdb.jdbc.idbDriver", "RmiJdbc.RJDriver", "sun.jdbc.odbc.JdbcOdbcDriver"};
        int i = 0;
        while (i < drivers.length) {
            try {
                System.out.print("Loading driver: " + drivers[i] + "...");
                Class.forName(drivers[i]).newInstance();
                System.out.println("success");
            }
            catch (Exception e) {
                System.out.println("failed. Error=" + e);
            }
            ++i;
        }
    }

    void setUrl(String s) {
        this.urlText.setText(s);
    }
}

