/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.utilitarios;

import br.com.bb.plugins.interfaces.infraestrutura.DialogMensagens;
import br.com.bb.plugins.interfaces.infraestrutura.FrameBB;
import br.com.bb.plugins.utilitarios.Format;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Util {
    static Calendar cal = new GregorianCalendar();

    public static String calculaDigitoMod10(String modulo) throws Throwable {
        String moduloDv = "";
        int soma = 0;
        int somaParcial = 0;
        int multiplicador = 2;
        if (modulo != null) {
            modulo.trim();
            int i = modulo.length();
            while (i > 0) {
                somaParcial = Integer.parseInt(modulo.substring(i - 1, i)) * multiplicador;
                if (somaParcial > 9) {
                    somaParcial -= 9;
                }
                multiplicador = multiplicador == 2 ? 1 : 2;
                soma += somaParcial;
                --i;
            }
            int guardaSoma = soma;
            while (soma % 10 != 0) {
                ++soma;
            }
            moduloDv = Integer.toString(soma - guardaSoma);
            if (moduloDv.equals("10")) {
                moduloDv = "0";
            }
        }
        return moduloDv;
    }

    public static String calculaDigitoMod11(String modulo) throws Throwable {
        String moduloDv = "";
        int soma = 0;
        int somaParcial = 0;
        int multiplicador = 9;
        if (modulo != null) {
            modulo.trim();
            int i = modulo.length();
            while (i > 0) {
                somaParcial = Integer.parseInt(modulo.substring(i - 1, i)) * multiplicador;
                if (--multiplicador < 2) {
                    multiplicador = 9;
                }
                soma += somaParcial;
                --i;
            }
            moduloDv = Integer.toString(soma % 11);
            if (moduloDv.equals("10")) {
                moduloDv = "X";
            }
        }
        return moduloDv;
    }

    public static String calculaDigitoMod11Guia(String modulo) throws Throwable {
        String moduloDv = "";
        int soma = 0;
        int somaParcial = 0;
        int multiplicador = 2;
        int contador = 1;
        if (modulo != null) {
            modulo.trim();
            if (modulo.length() != 11) {
                int j = 3;
                while (j > 0) {
                    somaParcial = Integer.parseInt(modulo.substring(j - 1, j)) * multiplicador;
                    ++multiplicador;
                    soma += somaParcial;
                    --j;
                }
            }
            multiplicador = 2;
            int i = modulo.length();
            while (i > 0) {
                somaParcial = Integer.parseInt(modulo.substring(i - 1, i)) * multiplicador;
                ++multiplicador;
                soma += somaParcial;
                if (modulo.length() == 11 ? contador == 12 : ++contador == 40) break;
                if (multiplicador > 9) {
                    multiplicador = 2;
                }
                --i;
            }
            if ((moduloDv = Integer.toString(soma % 11)).equals("1")) {
                moduloDv = "0";
            }
            if (moduloDv.equals("10")) {
                moduloDv = "1";
            }
            if (!moduloDv.equalsIgnoreCase("0") && !moduloDv.equalsIgnoreCase("1")) {
                moduloDv = Integer.toString(11 - Integer.valueOf(moduloDv));
            }
        }
        return moduloDv;
    }

    public static String calcularDV(String cNum) {
        int nSoma = 0;
        int fator = 2;
        int dv = 0;
        String dvs = "";
        String cNumCalc = String.valueOf(cNum.substring(0, 4)) + cNum.substring(5, cNum.length());
        String cNumParte = "";
        int i = 1;
        while (i <= cNumCalc.length()) {
            cNumParte = cNumCalc.substring(cNumCalc.length() - i, cNumCalc.length() - i + 1);
            nSoma += Integer.parseInt(cNumCalc.substring(cNumCalc.length() - i, cNumCalc.length() - i + 1)) * fator;
            if (++fator > 9) {
                fator = 2;
            }
            ++i;
        }
        dv = 11 - nSoma % 11;
        if (dv == 11 || dv == 10) {
            dv = 1;
        }
        dvs = String.valueOf(dv);
        return dvs;
    }

    public static void centralizarJanela(Window win) {
        try {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            if (screenDim.width < win.getSize().width) {
                ((Component)win).setSize(screenDim.width, win.getSize().height);
            }
            if (screenDim.height < win.getSize().height) {
                ((Component)win).setSize(win.getSize().width, screenDim.height);
            }
            int x = (screenDim.width - win.getSize().width) / 2;
            int y = (screenDim.height - win.getSize().height) / 2;
            ((Component)win).setLocation(x, y);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String construirLinhaDigitavel(String linha) {
        String retorno = "";
        try {
            if (!Util.verificaDVLinhaDigitavel(linha)) {
                return retorno;
            }
            String campo1 = String.valueOf(linha.substring(0, 4)) + linha.substring(19, 24) + Util.calculaDigitoMod10(String.valueOf(linha.substring(0, 4)) + linha.substring(19, 24));
            String campo2 = String.valueOf(linha.substring(24, 34)) + Util.calculaDigitoMod10(linha.substring(24, 34));
            String campo3 = String.valueOf(linha.substring(34, 44)) + Util.calculaDigitoMod10(linha.substring(34, 44));
            String campo4 = linha.substring(4, 5);
            String campo5 = linha.substring(5, 19);
            retorno = String.valueOf(campo1.substring(0, 5)) + "." + campo1.substring(5, 10) + " " + campo2.substring(0, 5) + "." + campo2.substring(5, 11) + " " + campo3.substring(0, 5) + "." + campo3.substring(5, 11) + " " + campo4 + " " + campo5;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return retorno;
    }

    public static String construirLinhaDigitavel(String linha, String tipo) {
        String retorno = "";
        try {
            String campo1 = "";
            String campo2 = "";
            String campo3 = "";
            String campo4 = "";
            String campo5 = "";
            retorno = "";
            if (!Util.verificaDVLinhaDigitavel(linha, tipo)) {
                return retorno;
            }
            if (tipo.equalsIgnoreCase("guia")) {
                if (linha.substring(2, 3).equalsIgnoreCase("6") || linha.substring(2, 3).equalsIgnoreCase("7")) {
                    campo1 = String.valueOf(linha.substring(0, 11)) + Util.calculaDigitoMod10(linha.substring(0, 11));
                    campo2 = String.valueOf(linha.substring(11, 22)) + Util.calculaDigitoMod10(linha.substring(11, 22));
                    campo3 = String.valueOf(linha.substring(22, 33)) + Util.calculaDigitoMod10(linha.substring(22, 33));
                    campo4 = String.valueOf(linha.substring(33, 44)) + Util.calculaDigitoMod10(linha.substring(33, 44));
                } else if (linha.substring(2, 3).equalsIgnoreCase("8") || linha.substring(2, 3).equalsIgnoreCase("9")) {
                    campo1 = String.valueOf(linha.substring(0, 11)) + Util.calculaDigitoMod11Guia(linha.substring(0, 11));
                    campo2 = String.valueOf(linha.substring(11, 22)) + Util.calculaDigitoMod11Guia(linha.substring(11, 22));
                    campo3 = String.valueOf(linha.substring(22, 33)) + Util.calculaDigitoMod11Guia(linha.substring(22, 33));
                    campo4 = String.valueOf(linha.substring(33, 44)) + Util.calculaDigitoMod11Guia(linha.substring(33, 44));
                }
                retorno = String.valueOf(campo1.substring(0, campo1.length() - 1)) + "-" + campo1.substring(11, campo1.length()) + " " + campo2.substring(0, campo2.length() - 1) + "-" + campo2.substring(11, campo2.length()) + " " + campo3.substring(0, campo3.length() - 1) + "-" + campo3.substring(11, campo3.length()) + " " + campo4.substring(0, campo4.length() - 1) + "-" + campo4.substring(11, campo4.length());
            } else {
                campo1 = String.valueOf(linha.substring(0, 4)) + linha.substring(19, 24) + Util.calculaDigitoMod10(String.valueOf(linha.substring(0, 4)) + linha.substring(19, 24));
                campo2 = String.valueOf(linha.substring(24, 34)) + Util.calculaDigitoMod10(linha.substring(24, 34));
                campo3 = String.valueOf(linha.substring(34, 44)) + Util.calculaDigitoMod10(linha.substring(34, 44));
                campo4 = linha.substring(4, 5);
                campo5 = linha.substring(5, 19);
                retorno = String.valueOf(campo1.substring(0, 5)) + "." + campo1.substring(5, 10) + " " + campo2.substring(0, 5) + "." + campo2.substring(5, 11) + " " + campo3.substring(0, 5) + "." + campo3.substring(5, 11) + " " + campo4 + " " + campo5;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return retorno;
    }

    public static void copiar(File origem, File destino) throws IOException {
        Util.garantirPath(destino);
        FileInputStream in = new FileInputStream(origem);
        FileOutputStream out = new FileOutputStream(destino);
        Util.copiar(in, out);
        ((OutputStream)out).close();
    }

    public static void copiar(InputStream in, OutputStream out) throws IOException {
        int lidos;
        byte[] buffer = new byte[4096];
        while ((lidos = in.read(buffer)) != -1) {
            out.write(buffer, 0, lidos);
        }
        in.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(String origem, String destino) throws Throwable {
        String newLine2 = System.getProperty("line.separator");
        FileWriter fw = null;
        FileReader fr = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File source = null;
        try {
            try {
                fr = new FileReader(origem);
                fw = new FileWriter(destino);
                br = new BufferedReader(fr);
                bw = new BufferedWriter(fw);
                source = new File(origem);
                int fileLength = (int)source.length();
                char[] charBuff = new char[fileLength];
                while (br.read(charBuff, 0, fileLength) != -1) {
                    bw.write(charBuff, 0, fileLength);
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new Exception(String.valueOf(origem) + " nao existe!");
            }
            catch (IOException ioe) {
                throw new Exception("Copia de arquivo - Erro de i/o");
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (br != null) {
                    br.close();
                }
                if (bw == null) throw throwable;
                bw.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (br != null) {
            br.close();
        }
        if (bw == null) return;
        bw.close();
    }

    public static boolean criarDiretorio(String Diretorio) throws Throwable {
        File nomeDir;
        block3: {
            try {
                nomeDir = new File(Diretorio);
                if (!nomeDir.isDirectory()) break block3;
                return true;
            }
            catch (Throwable e) {
                throw new Throwable(e.getMessage());
            }
        }
        return nomeDir.mkdirs();
    }

    public static java.util.Date dataSql(java.util.Date data) throws Throwable {
        if (data == null) {
            return null;
        }
        Date datasql = new Date(data.getTime());
        return datasql;
    }

    public static GregorianCalendar dataUtil(java.util.Date data) throws SQLException, Throwable {
        Vector<String> feriados = new Vector<String>();
        feriados.addElement("01/01");
        feriados.addElement("21/04");
        feriados.addElement("01/05");
        feriados.addElement("07/09");
        feriados.addElement("12/10");
        feriados.addElement("02/11");
        feriados.addElement("15/11");
        feriados.addElement("25/12");
        GregorianCalendar dataTemp = new GregorianCalendar();
        GregorianCalendar dataRetorno = new GregorianCalendar();
        dataRetorno.setTime(data);
        try {
            dataTemp.setTime(data);
            int i = 0;
            while (i < feriados.size()) {
                if (dataTemp.get(5) == Integer.parseInt(feriados.elementAt(i).toString().substring(0, 2)) && dataTemp.get(2) + 1 == Integer.parseInt(feriados.elementAt(i).toString().substring(3, 5))) {
                    dataRetorno.add(5, 1);
                    dataTemp = dataRetorno;
                    Util.dataSql(dataRetorno.getTime());
                }
                ++i;
            }
            if (dataTemp.get(7) == 7) {
                dataRetorno.add(5, 2);
                Util.dataSql(dataRetorno.getTime());
            } else if (dataTemp.get(7) == 1) {
                dataRetorno.add(5, 1);
                Util.dataSql(dataRetorno.getTime());
            }
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
        }
        return dataRetorno;
    }

    public static void deletarArqsEm(String strBaseDir) {
        if (!strBaseDir.endsWith(System.getProperty("file.separator"))) {
            strBaseDir = String.valueOf(strBaseDir) + System.getProperty("file.separator");
        }
        File BaseDir = new File(strBaseDir);
        Vector result = new Vector();
        String[] arrayOfNames = BaseDir.list();
        if (arrayOfNames == null || arrayOfNames.length == 0) {
            return;
        }
        String elemento = null;
        String SubDir = null;
        int index = 0;
        while (index < arrayOfNames.length) {
            elemento = arrayOfNames[index];
            SubDir = String.valueOf(strBaseDir) + elemento;
            File SubDirFile = new File(SubDir);
            if (SubDirFile.isDirectory()) {
                Util.deletarArqsEm(SubDir);
            } else {
                SubDirFile.delete();
            }
            ++index;
        }
    }

    public static String desFormatarConta(String strtexto) throws Throwable {
        String str = strtexto.trim();
        int tamstr = str.trim().length();
        String textoDesformatado = "";
        String strInvalidos = ".,-";
        if (str != null && tamstr > 0) {
            int i = 0;
            while (i < tamstr) {
                if (strInvalidos.indexOf(str.substring(i, i + 1)) == -1) {
                    textoDesformatado = String.valueOf(textoDesformatado) + str.substring(i, i + 1);
                }
                ++i;
            }
        } else {
            textoDesformatado = str;
        }
        return textoDesformatado;
    }

    public static String desformatarCPFCGC(String inscricao) throws Throwable {
        inscricao = inscricao.trim();
        String inscricaoDesformatada = "";
        int i = 0;
        while (i < inscricao.length()) {
            if (!(inscricao.substring(i, i + 1).equals(".") | inscricao.substring(i, i + 1).equals("/") | inscricao.substring(i, i + 1).equals("-"))) {
                inscricaoDesformatada = String.valueOf(inscricaoDesformatada) + inscricao.substring(i, i + 1);
            }
            ++i;
        }
        return inscricaoDesformatada;
    }

    public static String desformatarString(String dado, String mascara) {
        String dadoDesformatado = new String();
        int i = 0;
        while (i < mascara.length()) {
            if (mascara.substring(i, i + 1).equalsIgnoreCase("9") || mascara.substring(i, i + 1).equalsIgnoreCase("A") || mascara.substring(i, i + 1).equalsIgnoreCase("@") || mascara.substring(i, i + 1).equalsIgnoreCase("#")) {
                dadoDesformatado = String.valueOf(dadoDesformatado) + dado.substring(i, i + 1);
            }
            ++i;
        }
        return dadoDesformatado;
    }

    public static String desformatarValor(String sValor) {
        String retorno = sValor;
        int pos = -1;
        pos = retorno.indexOf(".");
        while (pos > -1 && pos < retorno.length()) {
            retorno = String.valueOf(retorno.substring(0, pos)) + retorno.substring(pos + 1, retorno.length());
            pos = retorno.indexOf(".");
        }
        pos = -1;
        pos = retorno.indexOf(",");
        while (pos > -1 && pos < retorno.length()) {
            retorno = String.valueOf(retorno.substring(0, pos)) + retorno.substring(pos + 1, retorno.length());
            pos = retorno.indexOf(",");
        }
        return retorno;
    }

    public static void displayURL(String url) throws Throwable {
        String cmd = null;
        if (!url.substring(0, 7).equals("http://") && !url.substring(0, 7).equals("file://")) {
            throw new Exception("URL inv\u00e1lida. Deve iniciar por 'http://' ou 'file://'.");
        }
        cmd = "rundll32 url.dll,FileProtocolHandler " + url;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException x) {
            throw new Exception("Erro na carga do browser. " + x);
        }
    }

    public static String doubleToString(double valor, int nroDecimais) throws Throwable {
        double valorTruncado = valor * Math.pow(10.0, nroDecimais) + 1.0 / Math.pow(10.0, nroDecimais + 4);
        StringBuffer textoB = new StringBuffer(String.valueOf((long)valorTruncado));
        int i = textoB.length();
        if (valor < 1.0 && valor > 0.0) {
            ++i;
            textoB.insert(0, "0");
        }
        if (i <= nroDecimais) {
            String texto = Util.padR(textoB.toString(), nroDecimais + 1, "0");
            textoB = new StringBuffer(texto);
            i = textoB.length();
        }
        if (nroDecimais > 0) {
            textoB.insert(i - nroDecimais, ',');
        }
        return String.valueOf(textoB);
    }

    public static void exibirMensagemErro(Throwable ex) {
        try {
            while (ex != null) {
                DialogMensagens msg;
                if (ex.getMessage() == null || ex.getMessage().trim().length() == 0) {
                    ex.printStackTrace();
                    msg = new DialogMensagens((Frame)new FrameBB(), "Mensagem da Aplica\u00e7\u00e3o", "Erro indeterminado. \u00c9 recomend\u00e1vel sair e reiniciar a aplica\u00e7\u00e3o.", 0);
                    msg.show();
                    break;
                }
                if (ex instanceof SQLException) {
                    if (((SQLException)ex).getSQLState().length() > 0) {
                        ex.printStackTrace();
                        msg = new DialogMensagens((Frame)new FrameBB(), "Mensagem da Aplica\u00e7\u00e3o", "Erro de acesso a dados. (cod " + ((SQLException)ex).getSQLState() + ")", 0);
                        msg.show();
                        System.out.println("Erro de acesso a dados. " + ((SQLException)ex).getMessage());
                    }
                } else {
                    msg = new DialogMensagens((Frame)new FrameBB(), "Mensagem da Aplica\u00e7\u00e3o", ex.getMessage(), 0);
                    msg.show();
                }
                ex = ex instanceof SQLException ? ((SQLException)ex).getNextException() : null;
            }
        }
        catch (Throwable t) {
            System.out.println("Problema na rotina de exibi\u00e7\u00e3o de mensagens. Contate suporte - BB");
        }
    }

    public static double exponenciacao(double base, int expoente) throws Throwable {
        double aux = base;
        int limite = expoente;
        int i = 1;
        while (i < limite) {
            aux *= base;
            ++i;
        }
        return aux;
    }

    public static String formataDataAAAAMMDD(String AAAAMMDD) throws Throwable {
        String strYEAR = AAAAMMDD.substring(0, 4);
        String strMONTH = AAAAMMDD.substring(5, 7);
        String strDATE = AAAAMMDD.substring(8, 10);
        String strDATAFORMATADA = String.valueOf(strDATE) + "/" + strMONTH + "/" + strYEAR;
        return strDATAFORMATADA;
    }

    public static String formatarCEP(String strCep) throws Throwable {
        if (strCep == null) {
            return " ";
        }
        strCep = !Util.isZeros(strCep = Util.padR(strCep, 8)) ? String.valueOf(strCep.substring(0, 2)) + "." + strCep.substring(2, 5) + "-" + strCep.substring(5, 8) : " ";
        return strCep;
    }

    public static String formatarCGC(String inscricao) throws Throwable {
        int tamanho = (inscricao = inscricao.trim()).length();
        if (tamanho == 14) {
            inscricao = String.valueOf(inscricao.substring(0, 2)) + "." + inscricao.substring(2, 5) + "." + inscricao.substring(5, 8) + "/" + inscricao.substring(8, 12) + "-" + inscricao.substring(12);
        }
        return inscricao;
    }

    public static String formatarConta(String string) throws Throwable {
        String str = string.trim();
        int tamstr = str.trim().length();
        String dv = str.substring(tamstr - 1, tamstr);
        String strSemdv = str.substring(0, tamstr - 1);
        int tamstrSemdv = tamstr - 1;
        String strFormatado = "";
        int j = 0;
        int i = tamstrSemdv;
        while (i > 0) {
            if (j == 3) {
                strFormatado = "." + strFormatado;
                j = 0;
            }
            strFormatado = String.valueOf(strSemdv.substring(i - 1, i)) + strFormatado;
            ++j;
            --i;
        }
        strFormatado = String.valueOf(strFormatado) + "-" + dv;
        return strFormatado;
    }

    public static String formatarCPF(String inscricao) throws Throwable {
        int tamanho = (inscricao = inscricao.trim()).length();
        if (tamanho == 11) {
            inscricao = String.valueOf(inscricao.substring(0, 3)) + "." + inscricao.substring(3, 6) + "." + inscricao.substring(6, 9) + "-" + inscricao.substring(9);
        }
        return inscricao;
    }

    public static String formatarCPFouCNPJ(String inscricao) throws Throwable {
        if (inscricao.trim().length() == 14) {
            return Util.formatarCGC(inscricao);
        }
        return Util.formatarCPF(inscricao);
    }

    public static String formatarData(java.util.Date d) throws Throwable {
        if (d == null) {
            return " ";
        }
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(d);
        int ano = calendario.get(1);
        int mes = calendario.get(2) + 1;
        int dia = calendario.get(5);
        String dataFormatada = String.valueOf(Util.strZero(String.valueOf(dia), 2)) + "/" + Util.strZero(String.valueOf(mes), 2) + "/" + Util.strZero(String.valueOf(ano), 4);
        return dataFormatada;
    }

    public static String formatarData(java.util.Date d, String formato) throws Throwable {
        if (d == null) {
            return " ";
        }
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(d);
        int ano = calendario.get(1);
        int mes = calendario.get(2) + 1;
        int dia = calendario.get(5);
        String dataFormatada = "";
        if (formato.equalsIgnoreCase("DD/MM/AAAA")) {
            dataFormatada = String.valueOf(Util.strZero(String.valueOf(dia), 2)) + "/" + Util.strZero(String.valueOf(mes), 2) + "/" + Util.strZero(String.valueOf(ano), 4);
        } else if (formato.equalsIgnoreCase("MM/DD/AAAA")) {
            dataFormatada = String.valueOf(Util.strZero(String.valueOf(mes), 2)) + "/" + Util.strZero(String.valueOf(dia), 2) + "/" + Util.strZero(String.valueOf(ano), 4);
        } else if (formato.equalsIgnoreCase("DDMMAAAA")) {
            dataFormatada = String.valueOf(Util.strZero(String.valueOf(dia), 2)) + Util.strZero(String.valueOf(mes), 2) + Util.strZero(String.valueOf(ano), 4);
        } else if (formato.equalsIgnoreCase("AAAAMMDD")) {
            dataFormatada = String.valueOf(Util.strZero(String.valueOf(ano), 4)) + Util.strZero(String.valueOf(mes), 2) + Util.strZero(String.valueOf(dia), 2);
        } else if (formato.equalsIgnoreCase("AAMMDD")) {
            dataFormatada = String.valueOf(Util.strZero(String.valueOf(ano - ano / 100 * 100), 2)) + Util.strZero(String.valueOf(mes), 2) + Util.strZero(String.valueOf(dia), 2);
        } else if (formato.equalsIgnoreCase("DDMMAA")) {
            dataFormatada = String.valueOf(Util.strZero(String.valueOf(dia), 2)) + Util.strZero(String.valueOf(mes), 2) + Util.strZero(String.valueOf(ano - ano / 100 * 100), 4);
        }
        return dataFormatada;
    }

    public static String formatarDataDDMMAAAA(String strData) throws Throwable {
        if (strData == null) {
            return " ";
        }
        strData = Util.padR(strData, 8);
        strData = String.valueOf(strData.substring(0, 2)) + "/" + strData.substring(2, 4) + "/" + strData.substring(4, 8);
        return strData;
    }

    public static String formatarHora(java.util.Date d) throws Throwable {
        if (d == null) {
            return " ";
        }
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(d);
        int hora = calendario.get(11);
        int minuto = calendario.get(12);
        int segundo = calendario.get(13);
        String horaFormatada = String.valueOf(Util.strZero(String.valueOf(hora), 2)) + ":" + Util.strZero(String.valueOf(minuto), 2) + ":" + Util.strZero(String.valueOf(segundo), 2);
        return horaFormatada;
    }

    public static String formatarPASEP(String inscricao) throws Throwable {
        int tamanho = (inscricao = inscricao.trim()).length();
        if (tamanho == 11) {
            inscricao = String.valueOf(inscricao.substring(0, 1)) + "." + inscricao.substring(1, 4) + "." + inscricao.substring(4, 7) + "." + inscricao.substring(7, 10) + "-" + inscricao.substring(10);
        }
        return inscricao;
    }

    public static String formatarString(String dado, String mascara) {
        String dadoFormatado = new String();
        int j = 0;
        int i = 0;
        while (i < mascara.length()) {
            if (mascara.substring(i, i + 1).equalsIgnoreCase("9") || mascara.substring(i, i + 1).equalsIgnoreCase("A") || mascara.substring(i, i + 1).equalsIgnoreCase("@") || mascara.substring(i, i + 1).equalsIgnoreCase("#")) {
                if (j < dado.length()) {
                    dadoFormatado = String.valueOf(dadoFormatado) + dado.substring(j, j + 1);
                    ++j;
                }
            } else {
                dadoFormatado = String.valueOf(dadoFormatado) + mascara.substring(i, i + 1);
            }
            ++i;
        }
        return dadoFormatado;
    }

    public static String formatarValor(double valor, int nroDecimais) throws Throwable {
        double valorTruncado = valor * Math.pow(10.0, nroDecimais) + 1.0 / Math.pow(10.0, nroDecimais + 4);
        StringBuffer textoB = new StringBuffer(String.valueOf((long)valorTruncado));
        while (textoB.length() < nroDecimais + 1) {
            textoB.insert(0, '0');
        }
        int i = textoB.length();
        if (nroDecimais > 0) {
            textoB.insert(i - nroDecimais, ',');
        }
        int k = i - nroDecimais - 3;
        while (k > 0) {
            textoB.insert(k, '.');
            k -= 3;
        }
        return textoB.toString();
    }

    public static String formatarValor(String sValor, int nroDecimais) throws Throwable {
        double valor = Double.valueOf(sValor);
        return Util.formatarValor(valor, nroDecimais);
    }

    public static void garantirPath(File arq) throws IOException {
        String pai = arq.getParent();
        if (pai == null || pai.length() == 0) {
            return;
        }
        new File(pai).mkdirs();
    }

    public static String gerarNomeArquivoNovo(String Diretorio) throws Throwable {
        try {
            int cont = 1;
            String dia = new Format("%02d").form(cal.get(5));
            String mes = new Format("/%02d").form(cal.get(2) + 1);
            String ano = new Format("/%04d").form(cal.get(1));
            String nomeRetornoNovo = String.valueOf(dia) + mes.substring(1, 3) + ano.substring(1, 5) + "." + Util.strZero(Integer.toString(cont), 3);
            File verificaNomeRemessa = new File(String.valueOf(Diretorio) + nomeRetornoNovo);
            if (verificaNomeRemessa.exists()) {
                File novoNomeRemessa = new File(String.valueOf(Diretorio) + nomeRetornoNovo);
                while (novoNomeRemessa.exists()) {
                    File newNomeRemessa;
                    nomeRetornoNovo = String.valueOf(dia) + mes.substring(1, 3) + ano.substring(1, 5) + "." + Util.strZero(Integer.toString(++cont), 3);
                    novoNomeRemessa = newNomeRemessa = new File(String.valueOf(Diretorio) + nomeRetornoNovo);
                }
            }
            return nomeRetornoNovo;
        }
        catch (Throwable e) {
            throw new Throwable(e.getMessage());
        }
    }

    public static String gerarNomeArquivoNovo(String diretorio, String aplicativo, String extensao) throws Throwable {
        try {
            boolean cont = true;
            String dia = new Format("%02d").form(cal.get(5));
            String mes = new Format("/%02d").form(cal.get(2) + 1);
            String nomeArquivoNovo = String.valueOf(aplicativo) + dia + mes.substring(1, 3) + "." + extensao;
            File verificaNomeRemessa = new File(String.valueOf(diretorio) + nomeArquivoNovo);
            if (verificaNomeRemessa.exists()) {
                throw new Exception("J\u00e1 existe um arquivo " + diretorio + nomeArquivoNovo + " Contate o suporte.");
            }
            return nomeArquivoNovo;
        }
        catch (Throwable e) {
            throw new Throwable(e.getMessage());
        }
    }

    public static String gerarValorPorExtenso(long valor) throws Throwable {
        String textoPorExtenso = "";
        String[] baixosValores = new String[]{"", " um", " dois", " tr\u00eas", " quatro", " cinco", " seis", " sete", " oito", " nove", " dez", " onze", " doze", " treze", " catorze", " quinze", " dezesseis", " dezessete", " dezoito", " dezenove"};
        String[] grupoDezena = new String[]{"", "", " vinte", " trinta", " quarenta", " cinq\u00fcenta", " sessenta", " setenta", " oitenta", " noventa"};
        String[] grupoCentena = new String[]{"", " cento", " duzentos", " trezentos", " quatrocentos", " quinhentos", " seiscentos", " setecentos", " oitocentos", " novecentos"};
        String[] altosValoresPlural = new String[]{"", " mil", " milh\u00f5es", " bilh\u00f5es", " trilh\u00f5es", " quatrilh\u00f5es", " quintilh\u00f5es", " sextilh\u00f5es"};
        String[] altosValoresSingular = new String[]{"", " mil", " milh\u00e3o", " bilh\u00e3o", " trilh\u00e3o", " quatrilh\u00e3o", " quintilh\u00e3o", " sextilh\u00e3o"};
        if (valor == 0L) {
            textoPorExtenso = "";
        }
        int i = 0;
        while (valor > 0L) {
            int restoDivisao = (int)(valor % 1000L);
            valor /= 1000L;
            if (restoDivisao != 0) {
                String textoAuxiliar;
                if (restoDivisao < 1000) {
                    int dezenas;
                    int unidades = restoDivisao % 100;
                    if (unidades < 20) {
                        dezenas = 0;
                    } else {
                        unidades = restoDivisao % 10;
                        dezenas = restoDivisao % 100 / 10;
                    }
                    int centenas = restoDivisao / 100;
                    if (centenas == 1 && dezenas == 0 && unidades == 0) {
                        textoAuxiliar = " cem";
                    } else {
                        textoAuxiliar = grupoCentena[centenas];
                        if (dezenas != 0) {
                            textoAuxiliar = dezenas != 1 ? String.valueOf(textoAuxiliar) + " e" + grupoDezena[dezenas] : String.valueOf(textoAuxiliar) + " e" + baixosValores[unidades];
                        }
                        if (unidades != 0) {
                            textoAuxiliar = String.valueOf(textoAuxiliar) + " e" + baixosValores[unidades];
                        }
                    }
                } else {
                    textoAuxiliar = Util.gerarValorPorExtenso(restoDivisao);
                }
                textoPorExtenso = restoDivisao == 1 ? String.valueOf(textoAuxiliar) + altosValoresSingular[i] + "," + textoPorExtenso : String.valueOf(textoAuxiliar) + altosValoresPlural[i] + "," + textoPorExtenso;
            }
            ++i;
        }
        if (!(textoPorExtenso = textoPorExtenso.trim()).equals("") || textoPorExtenso == null) {
            if (textoPorExtenso.charAt(0) == 'e') {
                textoPorExtenso = textoPorExtenso.substring(2).trim();
            }
            textoPorExtenso = textoPorExtenso.substring(0, textoPorExtenso.length() - 1).trim();
            textoPorExtenso = String.valueOf(Character.toUpperCase(textoPorExtenso.charAt(0))) + textoPorExtenso.substring(1).trim();
            int j = textoPorExtenso.length() - 1;
            while (j > -1) {
                if (textoPorExtenso.charAt(j) == ',') {
                    if (textoPorExtenso.charAt(j + 2) == 'e') {
                        textoPorExtenso = String.valueOf(textoPorExtenso.substring(0, j)) + textoPorExtenso.substring(j + 1, textoPorExtenso.length());
                        break;
                    }
                    textoPorExtenso = String.valueOf(textoPorExtenso.substring(0, j)) + " e" + textoPorExtenso.substring(j + 1, textoPorExtenso.length());
                    break;
                }
                --j;
            }
            j = 0;
            while (j < textoPorExtenso.length() - 1) {
                if (textoPorExtenso.charAt(j) == ',' && textoPorExtenso.charAt(j + 2) == 'e') {
                    textoPorExtenso = String.valueOf(textoPorExtenso.substring(0, j + 1)) + textoPorExtenso.substring(j + 3, textoPorExtenso.length());
                }
                ++j;
            }
            return textoPorExtenso;
        }
        return null;
    }

    public static String[] gerarValorPorExtenso(String valor, int quantidadeDecimal) throws Throwable {
        String valorInteiro = valor.substring(0, valor.length() - quantidadeDecimal);
        String valorFracionario = valor.substring(valor.length() - quantidadeDecimal, valor.length());
        String[] textosPorExtenso = new String[4];
        long valorLongInteiro = Long.parseLong(valorInteiro);
        long valorLongFracionario = Long.parseLong(valorFracionario);
        if (valorLongInteiro < 1L) {
            textosPorExtenso[2] = "0";
        } else if (valorLongInteiro == 1L) {
            textosPorExtenso[0] = "Um";
            textosPorExtenso[2] = "1";
        } else if (valorLongInteiro > 1L) {
            textosPorExtenso[0] = Util.gerarValorPorExtenso(valorLongInteiro);
            textosPorExtenso[2] = "2";
        }
        if (valorLongFracionario < 1L) {
            textosPorExtenso[3] = "0";
        } else if (valorLongFracionario == 1L) {
            textosPorExtenso[1] = "um";
            textosPorExtenso[3] = "1";
        } else if (valorLongFracionario > 1L) {
            textosPorExtenso[1] = String.valueOf(Character.toLowerCase(Util.gerarValorPorExtenso(valorLongFracionario).charAt(0))) + Util.gerarValorPorExtenso(valorLongFracionario).substring(1).trim();
            textosPorExtenso[3] = "2";
        }
        return textosPorExtenso;
    }

    public static String gerarValorPorExtensoEmReal(double valor) throws Throwable {
        String[] num = Util.gerarValorPorExtenso(Util.tirarPontoValor(valor, 2), 2);
        String real = "";
        String centavo = "";
        String textoPorExtenso = "";
        if (num[2].equals("0")) {
            real = "";
        } else if (num[2].equals("1")) {
            real = String.valueOf(num[0]) + " real";
        } else if (num[2].equals("2")) {
            real = String.valueOf(num[0]) + " reais";
        }
        if (num[3].equals("0")) {
            centavo = "";
        } else if (num[3].equals("1")) {
            centavo = String.valueOf(num[1]) + " centavo";
        } else if (num[3].equals("2")) {
            centavo = String.valueOf(num[1]) + " centavos";
        }
        textoPorExtenso = real.equals("") ? centavo.trim() : (centavo.equals("") ? real : String.valueOf(real) + " e " + centavo);
        return textoPorExtenso;
    }

    public static void gravarArquivo(File arquivo, Vector linhas) throws Throwable {
        FileOutputStream fos = new FileOutputStream(arquivo);
        int i = 0;
        while (i < linhas.size()) {
            fos.write((String.valueOf((String)linhas.elementAt(i)) + '\r' + '\n').getBytes());
            ++i;
        }
        fos.flush();
        fos.close();
    }

    public static void apagarLinhas(File arquivo) throws Throwable {
        if (!arquivo.exists()) {
            throw new Throwable("Arquivo " + arquivo.getName() + " n\u00e3o existe.");
        }
        FileOutputStream fos = new FileOutputStream(arquivo);
        fos.write("".getBytes());
        fos.flush();
        fos.close();
    }

    public static String insereBrancos(String texto, int quantTotal) {
        String resultado = texto;
        int iQuant = texto.length();
        int i = 0;
        while (i < quantTotal - iQuant) {
            resultado = String.valueOf(resultado) + " ";
            ++i;
        }
        return resultado;
    }

    public static boolean isZeros(String campo) {
        if (campo == null || campo.trim().length() == 0) {
            return false;
        }
        int i = 0;
        while (i < campo.trim().length()) {
            if (campo.charAt(i) != '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Vector lerArquivo(File arquivo) {
        return Util.lerArquivo(arquivo, true);
    }

    public static Vector lerArquivo(File arquivo, boolean pararNaPrimeiraLinhaBranco) {
        if (!arquivo.exists()) {
            return null;
        }
        Vector<String> vLinhas = new Vector<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(arquivo));
            String linha = in.readLine();
            while (!(linha == null || linha.length() <= 0 && pararNaPrimeiraLinhaBranco)) {
                vLinhas.addElement(linha);
                linha = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException fnf) {
            Util.exibirMensagemErro(new Exception("Problemas na abertura do arquivo " + arquivo));
        }
        catch (IOException io) {
            Util.exibirMensagemErro(new Exception("Problemas na leitura do arquivo " + arquivo));
        }
        return vLinhas;
    }

    public static String localizarDiretorioArquivo(String titulo) {
        FileDialog d = new FileDialog(new Frame());
        d.setName("FileDialogLeituraConfiguracao");
        d.setLayout(null);
        d.setMode(0);
        ((Dialog)d).setTitle(titulo);
        d.show();
        return d.getDirectory();
    }

    public static void mensagem(Frame frame, String mensagem) {
        DialogMensagens msg = new DialogMensagens(frame, "Mensagem da Aplica\u00e7\u00e3o", mensagem, 1);
        msg.show();
    }

    public static Vector ordenaVetor(Vector elementosOrdenacao, String[] camposOrdenacao) throws Throwable {
        Vector<String[]> vAux = new Vector<String[]>();
        try {
            if (elementosOrdenacao == null) {
                elementosOrdenacao = new Vector();
            }
            int ultimoIndice = 0;
            while (elementosOrdenacao.size() > 0) {
                String[] oAux = (String[])elementosOrdenacao.elementAt(0);
                int j = 0;
                while (j < elementosOrdenacao.size()) {
                    int i = 0;
                    if (((String[])elementosOrdenacao.elementAt(j))[Integer.parseInt(camposOrdenacao[i])].compareTo(oAux[Integer.parseInt(camposOrdenacao[i])]) == 0) {
                        if (((String[])elementosOrdenacao.elementAt(j))[Integer.parseInt(camposOrdenacao[++i])].compareTo(oAux[Integer.parseInt(camposOrdenacao[i])]) == 0) {
                            if (((String[])elementosOrdenacao.elementAt(j))[Integer.parseInt(camposOrdenacao[++i])].compareTo(oAux[Integer.parseInt(camposOrdenacao[i])]) < 0) {
                                oAux = (String[])elementosOrdenacao.elementAt(j);
                                ultimoIndice = j;
                            }
                        } else if (((String[])elementosOrdenacao.elementAt(j))[Integer.parseInt(camposOrdenacao[i])].compareTo(oAux[Integer.parseInt(camposOrdenacao[i])]) < 0) {
                            oAux = (String[])elementosOrdenacao.elementAt(j);
                            ultimoIndice = j;
                        }
                    } else if (((String[])elementosOrdenacao.elementAt(j))[Integer.parseInt(camposOrdenacao[i])].compareTo(oAux[Integer.parseInt(camposOrdenacao[i])]) < 0) {
                        oAux = (String[])elementosOrdenacao.elementAt(j);
                        ultimoIndice = j;
                    }
                    ++j;
                }
                vAux.addElement(oAux);
                elementosOrdenacao.removeElementAt(ultimoIndice);
                ultimoIndice = 0;
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
        }
        return vAux;
    }

    public static String padL(String strOrigem, int comprimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem.trim();
                int i = 0;
                while (i < comprimento - tamString) {
                    lRet = String.valueOf(lRet) + " ";
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(0, comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = String.valueOf(lRet) + " ";
                ++i;
            }
        }
        return lRet;
    }

    public static String padL(String strOrigem, int comprimento, String caractereDePreenchimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem.trim();
                int i = 0;
                while (i < comprimento - tamString) {
                    lRet = String.valueOf(lRet) + caractereDePreenchimento;
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(0, comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = String.valueOf(lRet) + caractereDePreenchimento;
                ++i;
            }
        }
        return lRet;
    }

    public static String padR(String strOrigem, int comprimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem;
                int i = 0;
                while (i < comprimento - strOrigem.length()) {
                    lRet = " " + lRet;
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(tamString - comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = " " + lRet;
                ++i;
            }
        }
        return lRet;
    }

    public static String padR(String strOrigem, int comprimento, String caractereDePreenchimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem;
                int i = 0;
                while (i < comprimento - strOrigem.length()) {
                    lRet = String.valueOf(caractereDePreenchimento) + lRet;
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(tamString - comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = String.valueOf(caractereDePreenchimento) + lRet;
                ++i;
            }
        }
        return lRet;
    }

    public static void removeFile(String dirOrigem) throws Throwable {
        File nomeArquivo = new File(dirOrigem);
        if (nomeArquivo.exists()) {
            nomeArquivo.delete();
        }
    }

    public static String renomear(String arqOrigem, String arqDestino, String dirOrigem, String dirDestino) throws Throwable {
        try {
            String nomeArquivoDestino = "";
            nomeArquivoDestino = arqDestino.trim().length() == 0 ? Util.gerarNomeArquivoNovo(dirDestino) : arqDestino;
            File origem = new File(String.valueOf(dirOrigem) + arqOrigem.trim());
            File destino = new File(String.valueOf(dirDestino) + nomeArquivoDestino.trim());
            origem.renameTo(destino);
            return nomeArquivoDestino;
        }
        catch (Throwable e) {
            throw new Throwable("ProcessarRetornoException:" + e.getMessage());
        }
    }

    public static String renomear(String arqOrigem, String arqDestino, String dirOrigem, String dirDestino, String aplicativo, String extensao) throws Throwable {
        try {
            String nomeArquivoDestino = "";
            nomeArquivoDestino = arqDestino.trim().length() == 0 ? Util.gerarNomeArquivoNovo(dirDestino, aplicativo, extensao) : arqDestino;
            File origem = new File(String.valueOf(dirOrigem) + arqOrigem.trim());
            File destino = new File(String.valueOf(dirDestino) + nomeArquivoDestino.trim());
            origem.renameTo(destino);
            return nomeArquivoDestino;
        }
        catch (Throwable e) {
            throw new Throwable("ProcessarRetornoException:" + e.getMessage());
        }
    }

    public static double round(double value, int decimals) throws Throwable {
        double rounded = value;
        int expoente = decimals + 1;
        rounded = Util.truncate(rounded, expoente);
        double retExpo = Util.exponenciacao(10.0, expoente);
        rounded += 5.0 / retExpo;
        rounded = Util.truncate(rounded, decimals);
        return rounded;
    }

    public static java.util.Date strdataInvToDate(String strDataInvertida) throws Throwable {
        strDataInvertida = Util.padR(strDataInvertida, 8, "0");
        int ano = Integer.parseInt(strDataInvertida.substring(0, 4).trim());
        int mes = Integer.parseInt(strDataInvertida.substring(4, 6).trim());
        int dia = Integer.parseInt(strDataInvertida.substring(6, 8).trim());
        GregorianCalendar gc = new GregorianCalendar(ano, mes - 1, dia);
        int diaRet = gc.get(5);
        int mesRet = gc.get(2) + 1;
        int anoRet = gc.get(1);
        if (dia != diaRet || mes != mesRet || ano != anoRet) {
            throw new Throwable("Data inv\u00e1lida " + strDataInvertida.substring(6, 8).trim() + "/" + strDataInvertida.substring(4, 6).trim() + "/" + strDataInvertida.substring(0, 4).trim());
        }
        return gc.getTime();
    }

    public static java.util.Date strdataToDate(String strdata) throws Throwable {
        int i = strdata.indexOf("/");
        while (i != -1) {
            strdata = String.valueOf(strdata.substring(0, i)) + strdata.substring(i + 1, strdata.length());
            i = strdata.indexOf("/");
        }
        strdata = Util.padR(strdata.trim(), 8, "0");
        int dia = Integer.parseInt(strdata.substring(0, 2).trim());
        int mes = Integer.parseInt(strdata.substring(2, 4).trim());
        int ano = Integer.parseInt(strdata.substring(4, 8).trim());
        GregorianCalendar gc = new GregorianCalendar(ano, mes - 1, dia, 12, 0);
        int diaRet = gc.get(5);
        int mesRet = gc.get(2) + 1;
        int anoRet = gc.get(1);
        if (dia != diaRet || mes != mesRet || ano != anoRet) {
            throw new Throwable("Data inv\u00e1lida " + strdata.substring(0, 2).trim() + "/" + strdata.substring(2, 4).trim() + "/" + strdata.substring(4, 8).trim());
        }
        return gc.getTime();
    }

    public static java.util.Date strdataToDate00(String strdata) throws Throwable {
        int i = strdata.indexOf("/");
        while (i != -1) {
            strdata = String.valueOf(strdata.substring(0, i)) + strdata.substring(i + 1, strdata.length());
            i = strdata.indexOf("/");
        }
        strdata = Util.padR(strdata.trim(), 8, "0");
        int dia = Integer.parseInt(strdata.substring(0, 2).trim());
        int mes = Integer.parseInt(strdata.substring(2, 4).trim());
        int ano = Integer.parseInt(strdata.substring(4, 8).trim());
        GregorianCalendar gc = new GregorianCalendar(ano, mes - 1, dia, 0, 0);
        int diaRet = gc.get(5);
        int mesRet = gc.get(2) + 1;
        int anoRet = gc.get(1);
        if (dia != diaRet || mes != mesRet || ano != anoRet) {
            throw new Throwable("Data inv\u00e1lida " + strdata.substring(0, 2).trim() + "/" + strdata.substring(2, 4).trim() + "/" + strdata.substring(4, 8).trim());
        }
        return gc.getTime();
    }

    public static String strEspaco(String texto, int comprimento) throws Throwable {
        String retorno = " ";
        if ((texto = texto.trim()) != null && texto.length() <= comprimento) {
            retorno = texto;
            int i = 0;
            while (i < comprimento - texto.length()) {
                retorno = " " + retorno;
                ++i;
            }
        }
        return retorno;
    }

    public static String strZero(String valor, int comprimento) throws Throwable {
        String retorno = "0";
        if ((valor = valor.trim()) != null && valor.length() <= comprimento) {
            retorno = valor;
            int i = 0;
            while (i < comprimento - valor.length()) {
                retorno = "0" + retorno;
                ++i;
            }
        }
        return retorno;
    }

    public static String substituirCaracteresEspeciais(String strVar) throws Throwable {
        int indice = 0;
        String strTexto = strVar.toUpperCase();
        String strValidos = "0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,-,., ,/";
        String strEspeciais = "\u00c1,\u00c0,\u00c3,\u00c2,\u00c4,\u00c9,\u00c8,\u00ca,\u00cb,\u00cd,\u00ce,\u00cf,\u00d3,\u00d2,\u00d4,\u00d5,\u00da,\u00d9,\u00dc,\u00c7,\u00d1,|";
        String strSubstitutos = "A,A,A,A,A,E,E,E,E,I,I,I,O,O,O,O,U,U,U,C,N,-";
        String strRetorno = "";
        int tamVar = strTexto.length();
        int i = 0;
        while (i < tamVar) {
            strRetorno = strValidos.indexOf(strTexto.substring(i, i + 1)) != -1 ? String.valueOf(strRetorno) + strTexto.substring(i, i + 1) : ((indice = strEspeciais.indexOf(strTexto.substring(i, i + 1))) == -1 ? String.valueOf(strRetorno) + " " : String.valueOf(strRetorno) + strSubstitutos.substring(indice, indice + 1));
            ++i;
        }
        return strRetorno;
    }

    public static String tirarBarraData(String sData) throws Throwable {
        if (sData == null) {
            sData = "";
        }
        int tam = sData.length();
        int i = 0;
        while (i < tam) {
            int posBarra = sData.indexOf("/");
            if (posBarra < 0) break;
            sData = String.valueOf(sData.substring(0, posBarra)) + sData.substring(posBarra + 1, sData.length());
            ++i;
        }
        return sData;
    }

    public static String tirarPontos(String valor) throws Throwable {
        if (valor == null) {
            valor = "";
        }
        int tam = valor.length();
        int i = 0;
        while (i < tam) {
            int posPonto = valor.indexOf(".");
            if (posPonto < 0) break;
            valor = String.valueOf(valor.substring(0, posPonto)) + valor.substring(posPonto + 1, valor.length());
            ++i;
        }
        return valor;
    }

    public static String tirarPontoValor(double valor, int nroDecimais) throws Throwable {
        double valorTruncado = valor * Math.pow(10.0, nroDecimais) + 1.0 / Math.pow(10.0, nroDecimais + 4);
        StringBuffer textoB = new StringBuffer(String.valueOf((long)valorTruncado));
        while (textoB.length() < nroDecimais + 1) {
            textoB.insert(0, '0');
        }
        return textoB.toString();
    }

    public static String tirarPontoValor(String valor) throws Throwable {
        int tamValor = valor.length();
        int posPonto = 0;
        String vlrSemPonto = "";
        int i = 0;
        while (i < tamValor) {
            if (valor.substring(i, i + 1).trim().equalsIgnoreCase(".")) {
                posPonto = i;
            }
            ++i;
        }
        vlrSemPonto = tamValor - posPonto == 3 ? String.valueOf(valor.substring(0, posPonto)) + valor.substring(posPonto + 1, tamValor) : String.valueOf(valor.substring(0, posPonto)) + valor.substring(posPonto + 1, tamValor) + "0";
        return vlrSemPonto;
    }

    public static String tirarPontoValor(String valor, int qtddecimais) throws Throwable {
        int tamValor = valor.length();
        int posPonto = 0;
        int tamStringPosPonto = 0;
        String strZeros = "000000000";
        String vlrSemPonto = "";
        String strPosPonto = "";
        if (valor.indexOf(".") < 0) {
            return valor;
        }
        int i = 0;
        while (i < tamValor) {
            if (valor.substring(i, i + 1).trim().equalsIgnoreCase(".")) {
                posPonto = i;
            }
            ++i;
        }
        strPosPonto = valor.substring(posPonto + 1, tamValor);
        tamStringPosPonto = strPosPonto.trim().length();
        vlrSemPonto = tamStringPosPonto == qtddecimais ? String.valueOf(valor.substring(0, posPonto)) + strPosPonto : (tamStringPosPonto > qtddecimais ? String.valueOf(valor.substring(0, posPonto)) + strPosPonto.substring(0, qtddecimais) : String.valueOf(valor.substring(0, posPonto)) + strPosPonto + strZeros.substring(0, qtddecimais - tamStringPosPonto));
        return vlrSemPonto;
    }

    public static String trocaVirgulaPorPonto(String strMsg) throws Throwable {
        if (strMsg == null) {
            strMsg = "";
        }
        return strMsg.replace(',', '.');
    }

    public static double truncate(double valor, int decimais) throws Throwable {
        double valorTruncado = valor * Math.pow(10.0, decimais) + 1.0 / Math.pow(10.0, decimais + 4);
        long truncado = (long)valorTruncado;
        return (double)truncado / Math.pow(10.0, decimais);
    }

    public static boolean validarData(int dia, int mes, int ano) throws Throwable {
        if (ano < 1900 || mes < 1 || mes > 12 || dia < 1) {
            return false;
        }
        int maximo = 31;
        switch (mes) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                maximo = 30;
                break;
            }
            case 2: {
                maximo = ano % 4 == 0 && ano % 100 != 0 || ano % 400 == 0 ? 29 : 28;
            }
        }
        return dia <= maximo;
    }

    public static boolean validarData6(String ddmmaa) throws Throwable {
        boolean dataValida = false;
        try {
            int dia = Integer.parseInt(ddmmaa.substring(0, 2));
            int mes = Integer.parseInt(ddmmaa.substring(2, 4));
            int ano = Integer.parseInt(ddmmaa.substring(4, 6));
            ano = ano > 70 ? (ano += 1900) : (ano += 2000);
            dataValida = Util.validarData(dia, mes, ano);
            return dataValida;
        }
        catch (Throwable e) {
            return dataValida;
        }
    }

    public static boolean validarData8(String ddmmaaaa) throws Throwable {
        boolean dataValida = false;
        try {
            int dia = Integer.parseInt(ddmmaaaa.substring(0, 2));
            int mes = Integer.parseInt(ddmmaaaa.substring(2, 4)) - 1;
            int ano = Integer.parseInt(ddmmaaaa.substring(4, 8));
            dataValida = Util.validarData(dia, mes, ano);
            return dataValida;
        }
        catch (Throwable e) {
            return dataValida;
        }
    }

    public static boolean verificaDVLinhaDigitavel(String parametro) throws Throwable {
        boolean retorno = true;
        if (!parametro.substring(4, 5).equalsIgnoreCase(Util.calcularDV(parametro))) {
            retorno = false;
        }
        return retorno;
    }

    public static boolean verificaDVLinhaDigitavel(String parametro, String tipo) throws Throwable {
        boolean retorno = true;
        if (tipo.equalsIgnoreCase("titulo") && !parametro.substring(4, 5).equalsIgnoreCase(Util.calcularDV(parametro))) {
            retorno = false;
        }
        if (tipo.equalsIgnoreCase("guia")) {
            if (parametro.substring(2, 3).equalsIgnoreCase("6") || parametro.substring(2, 3).equalsIgnoreCase("7")) {
                if (!Util.calculaDigitoMod10(String.valueOf(parametro.substring(0, 3)) + parametro.substring(4, parametro.length())).equalsIgnoreCase(parametro.substring(3, 4))) {
                    retorno = false;
                }
            } else if ((parametro.substring(2, 3).equalsIgnoreCase("8") || parametro.substring(2, 3).equalsIgnoreCase("9")) && !Util.calculaDigitoMod11Guia(String.valueOf(parametro.substring(0, 3)) + parametro.substring(4, parametro.length())).equalsIgnoreCase(parametro.substring(3, 4))) {
                retorno = false;
            }
        }
        return retorno;
    }
}

