/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.utilitarios;

import br.com.bb.data.Data;
import br.com.bb.plugins.utilitarios.Format;
import com.ibm.webrunner.widget.MaskedTextField;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Container;
import java.awt.TextField;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Util2 {
    private BufferedReader in;
    static String strParam = "";
    static int intPont = 0;
    static Calendar cal = new GregorianCalendar();
    static java.util.Date data = new java.util.Date();

    public static String calculaDigitoMod10(String modulo) throws Throwable {
        String moduloDv = "";
        int soma = 0;
        int somaParcial = 0;
        int multiplicador = 2;
        if (modulo != null) {
            modulo.trim();
            int i = modulo.length();
            while (i > 0) {
                somaParcial = Integer.parseInt(modulo.substring(i - 1, i)) * multiplicador;
                if (somaParcial > 9) {
                    somaParcial -= 9;
                }
                multiplicador = multiplicador == 2 ? 1 : 2;
                soma += somaParcial;
                --i;
            }
            int guardaSoma = soma;
            while (soma % 10 != 0) {
                ++soma;
            }
            moduloDv = Integer.toString(soma - guardaSoma);
            if (moduloDv.equals("10")) {
                moduloDv = "0";
            }
        }
        return moduloDv;
    }

    public static String calculaDigitoMod11(String modulo) throws Throwable {
        String moduloDv = "";
        int soma = 0;
        int somaParcial = 0;
        int multiplicador = 9;
        if (modulo != null) {
            modulo.trim();
            int i = modulo.length();
            while (i > 0) {
                somaParcial = Integer.parseInt(modulo.substring(i - 1, i)) * multiplicador;
                if (--multiplicador < 2) {
                    multiplicador = 9;
                }
                soma += somaParcial;
                --i;
            }
            moduloDv = Integer.toString(soma % 11);
            if (moduloDv.equals("10")) {
                moduloDv = "X";
            }
        }
        return moduloDv;
    }

    public static String calculaNumeroCal(String tipoLeilao, int edital, int bolsa, int sequencial) throws Throwable {
        String numeroCal = "0";
        String numeroTipoLeilao = "0";
        numeroTipoLeilao = Util2.getNumeroTipoLeilao(tipoLeilao);
        numeroCal = "00";
        numeroCal = numeroCal.concat(numeroTipoLeilao);
        numeroCal = numeroCal.concat(Util2.strZero(Integer.toString(edital), 5));
        numeroCal = numeroCal.concat(Util2.strZero(Integer.toString(bolsa), 2));
        numeroCal = numeroCal.concat(Util2.strZero(Integer.toString(sequencial), 3));
        numeroCal = numeroCal.concat(Util2.calculaDigitoMod10(numeroCal));
        return numeroCal;
    }

    public static String calcularDigitoCGC(String cgc) throws Throwable {
        String cgcDv = "";
        int[] cgcParte = new int[14];
        if (cgc != null && cgc.length() == 12) {
            cgcParte[0] = Integer.parseInt(cgc.substring(0, 1));
            cgcParte[1] = Integer.parseInt(cgc.substring(1, 2));
            cgcParte[2] = Integer.parseInt(cgc.substring(2, 3));
            cgcParte[3] = Integer.parseInt(cgc.substring(3, 4));
            cgcParte[4] = Integer.parseInt(cgc.substring(4, 5));
            cgcParte[5] = Integer.parseInt(cgc.substring(5, 6));
            cgcParte[6] = Integer.parseInt(cgc.substring(6, 7));
            cgcParte[7] = Integer.parseInt(cgc.substring(7, 8));
            cgcParte[8] = Integer.parseInt(cgc.substring(8, 9));
            cgcParte[9] = Integer.parseInt(cgc.substring(9, 10));
            cgcParte[10] = Integer.parseInt(cgc.substring(10, 11));
            cgcParte[11] = Integer.parseInt(cgc.substring(11, 12));
            int soma = 5 * cgcParte[0] + 4 * cgcParte[1] + 3 * cgcParte[2] + 2 * cgcParte[3] + 9 * cgcParte[4] + 8 * cgcParte[5] + 7 * cgcParte[6] + 6 * cgcParte[7] + 5 * cgcParte[8] + 4 * cgcParte[9] + 3 * cgcParte[10] + 2 * cgcParte[11];
            String resultadoDivisao = Double.toString(soma / 11);
            int parteInteira = Integer.parseInt(resultadoDivisao.substring(0, resultadoDivisao.indexOf(".")));
            cgcParte[12] = soma - (parteInteira *= 11);
            if (cgcParte[12] == 1) {
                cgcParte[12] = 0;
            }
            if (cgcParte[12] != 0) {
                cgcParte[12] = 11 - cgcParte[12];
            }
            soma = 6 * cgcParte[0] + 5 * cgcParte[1] + 4 * cgcParte[2] + 3 * cgcParte[3] + 2 * cgcParte[4] + 9 * cgcParte[5] + 8 * cgcParte[6] + 7 * cgcParte[7] + 6 * cgcParte[8] + 5 * cgcParte[9] + 4 * cgcParte[10] + 3 * cgcParte[11] + 2 * cgcParte[12];
            resultadoDivisao = Double.toString(soma / 11);
            parteInteira = Integer.parseInt(resultadoDivisao.substring(0, resultadoDivisao.indexOf("."))) * 11;
            cgcParte[13] = soma - parteInteira;
            if (cgcParte[13] == 1) {
                cgcParte[13] = 0;
            }
            if (cgcParte[13] != 0) {
                cgcParte[13] = 11 - cgcParte[13];
            }
            cgcDv = cgcDv.concat(Integer.toString(cgcParte[12]));
            cgcDv = cgcDv.concat(Integer.toString(cgcParte[13]));
        }
        return cgcDv;
    }

    public static String calcularDigitoCPF(String cpf) throws Throwable {
        String cpfDv = "";
        int[] cpfParte = new int[11];
        int soma = 0;
        if (cpf != null && cpf.length() == 9) {
            cpfParte[0] = Integer.parseInt(cpf.substring(0, 1));
            cpfParte[1] = Integer.parseInt(cpf.substring(1, 2));
            cpfParte[2] = Integer.parseInt(cpf.substring(2, 3));
            cpfParte[3] = Integer.parseInt(cpf.substring(3, 4));
            cpfParte[4] = Integer.parseInt(cpf.substring(4, 5));
            cpfParte[5] = Integer.parseInt(cpf.substring(5, 6));
            cpfParte[6] = Integer.parseInt(cpf.substring(6, 7));
            cpfParte[7] = Integer.parseInt(cpf.substring(7, 8));
            cpfParte[8] = Integer.parseInt(cpf.substring(8, 9));
            int i = 0;
            while (i < 9) {
                soma += cpfParte[i] * (11 - (i + 1));
                ++i;
            }
            int Dv = 11 - soma % 11;
            if (Dv == 10 || Dv == 11) {
                Dv = 0;
            }
            cpfParte[9] = Dv;
            soma = 0;
            i = 0;
            while (i < 10) {
                soma += cpfParte[i] * (12 - (i + 1));
                ++i;
            }
            Dv = 11 - soma % 11;
            if (Dv == 10 || Dv == 11) {
                Dv = 0;
            }
            cpfParte[10] = Dv;
            cpfDv = cpfDv.concat(Integer.toString(cpfParte[9]));
            cpfDv = cpfDv.concat(Integer.toString(cpfParte[10]));
        }
        return cpfDv;
    }

    public static void comprimir(File origem, File destino) throws IOException {
        Util2.garantirPath(destino);
        FileInputStream in = new FileInputStream(origem);
        DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)new FileOutputStream(destino), new Deflater(9));
        Util2.copiar(in, out);
        ((OutputStream)out).close();
    }

    public static boolean conferirData(String dataDigitada) throws Throwable {
        if (dataDigitada.trim().length() < 8) {
            throw new Throwable("Data Inv\u00e1lida!");
        }
        int dia = Integer.parseInt(dataDigitada.substring(0, 2).trim());
        int mes = Integer.parseInt(dataDigitada.substring(2, 4).trim());
        int ano = Integer.parseInt(dataDigitada.substring(4, 8).trim());
        Data data = new Data(dia, mes, ano);
        return true;
    }

    public static void copiar(File origem, File destino) throws IOException {
        Util2.garantirPath(destino);
        FileInputStream in = new FileInputStream(origem);
        FileOutputStream out = new FileOutputStream(destino);
        Util2.copiar(in, out);
        ((OutputStream)out).close();
    }

    public static void copiar(InputStream in, OutputStream out) throws IOException {
        int lidos;
        byte[] buffer = new byte[4096];
        while ((lidos = in.read(buffer)) != -1) {
            out.write(buffer, 0, lidos);
        }
        in.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(String origem, String destino) throws Throwable {
        String newLine2 = System.getProperty("line.separator");
        FileWriter fw = null;
        FileReader fr = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File source = null;
        try {
            try {
                fr = new FileReader(origem);
                fw = new FileWriter(destino);
                br = new BufferedReader(fr);
                bw = new BufferedWriter(fw);
                source = new File(origem);
                int fileLength = (int)source.length();
                char[] charBuff = new char[fileLength];
                while (br.read(charBuff, 0, fileLength) != -1) {
                    bw.write(charBuff, 0, fileLength);
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new Exception(String.valueOf(origem) + " nao existe!");
            }
            catch (IOException ioe) {
                throw new Exception("Copia de arquivo - Erro de i/o");
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (br != null) {
                    br.close();
                }
                if (bw == null) throw throwable;
                bw.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (br != null) {
            br.close();
        }
        if (bw == null) return;
        bw.close();
    }

    public static String cpNumerico(String strMsg, TextField strNomeCampo) throws Throwable {
        String strRetorno = "";
        String strMatrizNumero = "0#1#2#3#4#5#6#7#8#9#,";
        int intI = strMsg.length();
        if (intI <= 0) {
            return null;
        }
        if (strMatrizNumero.indexOf(strMsg.substring(intI - 1)) == -1) {
            strNomeCampo.requestFocus();
            strNomeCampo.setSelectionStart(intI - 1);
            strNomeCampo.setSelectionEnd(intI);
        } else {
            strRetorno = null;
        }
        return strRetorno;
    }

    public static boolean criarDiretorio(String Diretorio) throws Throwable {
        File nomeDir;
        block3: {
            try {
                nomeDir = new File(Diretorio);
                if (!nomeDir.isDirectory()) break block3;
                return true;
            }
            catch (Throwable e) {
                throw new Throwable(e.getMessage());
            }
        }
        return nomeDir.mkdirs();
    }

    public static String dataSql() throws Throwable {
        String datasql = "xx";
        return datasql;
    }

    public static java.util.Date dataSql(java.util.Date data) throws Throwable {
        if (data == null) {
            return null;
        }
        Date datasql = new Date(data.getTime());
        return datasql;
    }

    public static File descomprimir(File origem) throws IOException {
        File destino = new File(String.valueOf(origem.getName()) + ".tmp");
        Util2.garantirPath(destino);
        FileInputStream inZip = new FileInputStream(origem);
        InflaterInputStream in = new InflaterInputStream(inZip);
        FileOutputStream out = new FileOutputStream(destino);
        Util2.copiar(in, out);
        ((OutputStream)out).close();
        return destino;
    }

    public static void descomprimir(File origem, File destino) throws IOException {
        Util2.garantirPath(destino);
        FileInputStream inZip = new FileInputStream(origem);
        InflaterInputStream in = new InflaterInputStream(inZip);
        FileOutputStream out = new FileOutputStream(destino);
        Util2.copiar(in, out);
        ((OutputStream)out).close();
    }

    public static String desformatarCPFCGC(String inscricao) throws Throwable {
        inscricao = inscricao.trim();
        String inscricaoDesformatada = "";
        int i = 0;
        while (i < inscricao.length()) {
            if (!(inscricao.substring(i, i + 1).equals(".") | inscricao.substring(i, i + 1).equals("/") | inscricao.substring(i, i + 1).equals("-"))) {
                inscricaoDesformatada = String.valueOf(inscricaoDesformatada) + inscricao.substring(i, i + 1);
            }
            ++i;
        }
        return inscricaoDesformatada;
    }

    public static String desformatarData(String strData) throws Throwable {
        strData = Util2.padR(strData, 10);
        strData = String.valueOf(strData.substring(8, 10)) + strData.substring(5, 7) + strData.substring(0, 4);
        return strData;
    }

    public static String digitoVerifCodigoBarraCBR(String modulo) throws Throwable {
        String moduloDv = "";
        int resto = 0;
        int soma = 0;
        int somaParcial = 0;
        int multiplicador = 2;
        int tamModulo = modulo.trim().length();
        if (modulo != null) {
            int i = tamModulo;
            while (i > 0) {
                somaParcial = Integer.parseInt(modulo.substring(i - 1, i)) * multiplicador;
                soma += somaParcial;
                if (++multiplicador > 9) {
                    multiplicador = 2;
                }
                --i;
            }
            resto = soma % 11;
            moduloDv = Integer.toString(11 - resto);
            if (moduloDv.equals("10") || moduloDv.equals("11")) {
                moduloDv = "1";
            }
        }
        return moduloDv;
    }

    public static void displayURL(String url) throws Throwable {
        String cmd = null;
        if (!url.substring(0, 7).equals("http://") && !url.substring(0, 7).equals("file://")) {
            throw new Exception("URL inv\u00e1lida. Deve iniciar por 'http://' ou 'file://'.");
        }
        cmd = "rundll32 url.dll,FileProtocolHandler " + url;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException x) {
            throw new Exception("Erro na carga do browser. " + x);
        }
    }

    public static double exponenciacao(double base, int expoente) throws Throwable {
        double aux = base;
        int limite = expoente;
        int i = 1;
        while (i < limite) {
            aux *= base;
            ++i;
        }
        return aux;
    }

    public static String formatadaData(String AAAAMMDD) throws Throwable {
        String strYEAR = AAAAMMDD.substring(0, 4);
        String strMONTH = AAAAMMDD.substring(5, 7);
        String strDATE = AAAAMMDD.substring(8, 10);
        String strDATAFORMATADA = String.valueOf(strDATE) + "/" + strMONTH + "/" + strYEAR;
        return strDATAFORMATADA;
    }

    public static String formatarCGC(String inscricao) throws Throwable {
        int tamanho = (inscricao = inscricao.trim()).length();
        if (tamanho == 14) {
            inscricao = String.valueOf(inscricao.substring(0, 2)) + "." + inscricao.substring(2, 5) + "." + inscricao.substring(5, 8) + "." + inscricao.substring(8, 12) + "/" + inscricao.substring(12);
        }
        return inscricao;
    }

    public static String formatarCPF(String inscricao) throws Throwable {
        int tamanho = (inscricao = inscricao.trim()).length();
        if (tamanho == 11) {
            inscricao = String.valueOf(inscricao.substring(0, 3)) + "." + inscricao.substring(3, 6) + "." + inscricao.substring(6, 9) + "-" + inscricao.substring(9);
        }
        return inscricao;
    }

    public static String formatarData(String strData) throws Throwable {
        if (strData == null) {
            return " ";
        }
        strData = Util2.padR(strData, 8);
        strData = String.valueOf(strData.substring(0, 2)) + "/" + strData.substring(2, 4) + "/" + strData.substring(4, 8);
        return strData;
    }

    public static String formatarData(java.util.Date d) throws Throwable {
        if (d == null) {
            return " ";
        }
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(d);
        int ano = calendario.get(1);
        int mes = calendario.get(2) + 1;
        int dia = calendario.get(5);
        String dataFormatada = String.valueOf(Util2.strZero(String.valueOf(dia), 2)) + "/" + Util2.strZero(String.valueOf(mes), 2) + "/" + Util2.strZero(String.valueOf(ano), 4);
        return dataFormatada;
    }

    public static String formatarValor(String valor, int decimal) throws Throwable {
        int tamValor = valor.length();
        int cont = 3;
        int complementoTam = 0;
        String vlrFormatado = "";
        vlrFormatado = decimal != 0 ? String.valueOf(valor.substring(0, tamValor - decimal)) + "," + valor.substring(tamValor - decimal, tamValor) : String.valueOf(valor) + " ";
        int i = tamValor - decimal;
        while (i > 0) {
            if (i == tamValor - decimal - cont) {
                cont += 3;
                vlrFormatado = String.valueOf(vlrFormatado.substring(0, i)) + "." + vlrFormatado.substring(i, tamValor + ++complementoTam);
            }
            --i;
        }
        return vlrFormatado;
    }

    public static String formatarValor1(double Valor, int decimal) throws Throwable {
        int i;
        String valor = String.valueOf(String.valueOf(Valor)) + " ";
        int tamValor = valor.length();
        int cont = 3;
        int complementoTam = 0;
        int tamDecimal = 0;
        String vlrFormatado = "";
        String valorAux1 = "";
        String valorAux2 = "";
        int posPonto = 0;
        int i2 = 0;
        while (i2 < tamValor - 1) {
            if (valor.charAt(i2) == 'E') {
                posPonto = Integer.parseInt(valor.substring(i2 + 1, i2 + 3).trim());
            }
            ++i2;
        }
        valor = valor.trim();
        if (posPonto != 0) {
            valor = Util2.tirarPontoValor(valor);
            int tamValorSemPonto = valor.length();
            String restoString = "";
            i = 0;
            while (i < tamValorSemPonto) {
                if (i == posPonto) {
                    valorAux1 = String.valueOf(valor.substring(0, posPonto + 1)) + "." + valor.substring(posPonto + 1, tamValorSemPonto);
                }
                valorAux2 = String.valueOf(valor.substring(0, posPonto + 1)) + ".";
                ++i;
            }
        }
        int tamValorAux = valorAux1.length();
        int cont1 = 0;
        if (valorAux1.trim() != "") {
            i = posPonto + 2;
            while (i < posPonto + 4) {
                if (valorAux1.charAt(i) != 'E') {
                    ++cont1;
                }
                ++i;
            }
            valor = cont1 == 1 ? String.valueOf(valorAux2) + valorAux1.substring(posPonto + 2, tamValorAux - 3) + "0" : String.valueOf(valorAux2) + valorAux1.substring(posPonto + 2, tamValorAux - 3);
        }
        i = 0;
        while (i < valor.length()) {
            if (valor.charAt(i) == 'E') {
                valor = String.valueOf(valor.substring(0, i)) + "0" + valor.substring(i + 1, valor.length());
            }
            ++i;
        }
        tamValor = valor.length();
        i = 0;
        while (i < tamValor) {
            if (valor.charAt(i) == '.') {
                vlrFormatado = String.valueOf(valor.substring(0, i)) + "," + valor.substring(i + 1, tamValor);
                tamDecimal = tamValor - 1 - i;
            }
            ++i;
        }
        if (tamDecimal < decimal) {
            i = 0;
            while (i < decimal - tamDecimal) {
                vlrFormatado = String.valueOf(vlrFormatado) + "0";
                ++i;
            }
        } else if (tamDecimal > decimal) {
            vlrFormatado = vlrFormatado.substring(0, tamValor - tamDecimal + decimal);
        } else if (tamDecimal == decimal) {
            vlrFormatado = vlrFormatado.substring(0, tamValor);
        }
        int tamValorFormatado = vlrFormatado.length();
        int j = 0;
        while (j < tamValorFormatado - 1) {
            if (vlrFormatado.charAt(j) == ',') {
                vlrFormatado = String.valueOf(vlrFormatado.substring(0, j)) + vlrFormatado.substring(j + 1, tamValorFormatado);
            }
            ++j;
        }
        int tamValorFormatadoSemVirgula = vlrFormatado.length();
        vlrFormatado = decimal != 0 ? String.valueOf(vlrFormatado.substring(0, tamValorFormatadoSemVirgula - decimal)) + "," + vlrFormatado.substring(tamValorFormatadoSemVirgula - decimal, tamValorFormatadoSemVirgula) : String.valueOf(vlrFormatado.substring(0, tamValorFormatadoSemVirgula - decimal)) + vlrFormatado.substring(tamValorFormatadoSemVirgula - decimal, tamValorFormatadoSemVirgula) + " ";
        int j2 = tamValorFormatadoSemVirgula - decimal;
        while (j2 > 0) {
            if (j2 == tamValorFormatadoSemVirgula - decimal - cont) {
                cont += 3;
                vlrFormatado = String.valueOf(vlrFormatado.substring(0, j2)) + "." + vlrFormatado.substring(j2, tamValorFormatadoSemVirgula + ++complementoTam);
            }
            --j2;
        }
        return vlrFormatado;
    }

    public static String formatarValor1(float Valor, int decimal) throws Throwable {
        int i;
        String valor = String.valueOf(String.valueOf(Valor)) + " ";
        int tamValor = valor.length();
        int cont = 3;
        int complementoTam = 0;
        int tamDecimal = 0;
        String vlrFormatado = "";
        String valorAux1 = "";
        String valorAux2 = "";
        int posPonto = 0;
        int i2 = 0;
        while (i2 < tamValor - 1) {
            if (valor.charAt(i2) == 'E') {
                posPonto = Integer.parseInt(valor.substring(i2 + 1, i2 + 3).trim());
            }
            ++i2;
        }
        long numeroConv = Math.abs((long)Valor - 1L);
        valor = String.valueOf(numeroConv);
        valor = valor.trim();
        if (posPonto != 0) {
            int tamValorSemPonto = valor.length();
            String restoString = "";
            i = 0;
            while (i < tamValorSemPonto) {
                if (i == posPonto) {
                    valorAux1 = String.valueOf(valor.substring(0, posPonto + 1)) + "." + valor.substring(posPonto + 1, tamValorSemPonto);
                }
                ++i;
            }
            valorAux2 = String.valueOf(valor.substring(0, posPonto + 1)) + ".";
            if (tamDecimal == 0) {
                int j = 0;
                while (j < decimal) {
                    valorAux1 = String.valueOf(valorAux1) + "0";
                    ++j;
                }
            }
        } else {
            valorAux1 = String.valueOf(valor) + ".";
            valorAux2 = String.valueOf(valor) + ".";
            if (tamDecimal == 0) {
                int j = 0;
                while (j < decimal) {
                    valorAux1 = String.valueOf(valorAux1) + "0";
                    ++j;
                }
            }
        }
        int tamValorAux = valorAux2.length();
        int cont1 = 0;
        if (valorAux1.trim() != "") {
            i = posPonto + 2;
            while (i < posPonto + 4) {
                if (valorAux1.charAt(i) != 'E') {
                    ++cont1;
                }
                ++i;
            }
            valor = cont1 == 1 ? String.valueOf(valorAux1) + "0" : valorAux1;
        }
        i = 0;
        while (i < valor.length()) {
            if (valor.charAt(i) == 'E') {
                valor = String.valueOf(valor.substring(0, i)) + "0" + valor.substring(i + 1, valor.length());
            }
            ++i;
        }
        tamValor = valor.length();
        i = 0;
        while (i < tamValor) {
            if (valor.charAt(i) == '.') {
                vlrFormatado = String.valueOf(valor.substring(0, i)) + "," + valor.substring(i + 1, tamValor);
                tamDecimal = tamValor - 1 - i;
            }
            ++i;
        }
        if (tamDecimal < decimal) {
            i = 0;
            while (i < decimal - tamDecimal) {
                vlrFormatado = String.valueOf(vlrFormatado) + "0";
                ++i;
            }
        } else if (tamDecimal > decimal) {
            vlrFormatado = vlrFormatado.substring(0, tamValor - tamDecimal + decimal);
        } else if (tamDecimal == decimal) {
            vlrFormatado = vlrFormatado.substring(0, tamValor);
        }
        int tamValorFormatado = vlrFormatado.length();
        int j = 0;
        while (j < tamValorFormatado - 1) {
            if (vlrFormatado.charAt(j) == ',') {
                vlrFormatado = String.valueOf(vlrFormatado.substring(0, j)) + vlrFormatado.substring(j + 1, tamValorFormatado);
            }
            ++j;
        }
        int tamValorFormatadoSemVirgula = vlrFormatado.length();
        vlrFormatado = decimal != 0 ? String.valueOf(vlrFormatado.substring(0, tamValorFormatadoSemVirgula - decimal)) + "," + vlrFormatado.substring(tamValorFormatadoSemVirgula - decimal, tamValorFormatadoSemVirgula) : String.valueOf(vlrFormatado.substring(0, tamValorFormatadoSemVirgula - decimal)) + vlrFormatado.substring(tamValorFormatadoSemVirgula - decimal, tamValorFormatadoSemVirgula) + " ";
        int j2 = tamValorFormatadoSemVirgula - decimal;
        while (j2 > 0) {
            if (j2 == tamValorFormatadoSemVirgula - decimal - cont) {
                cont += 3;
                vlrFormatado = String.valueOf(vlrFormatado.substring(0, j2)) + "." + vlrFormatado.substring(j2, tamValorFormatadoSemVirgula + ++complementoTam);
            }
            --j2;
        }
        return vlrFormatado;
    }

    public static String formatarValor1(String Valor, int decimal) throws Throwable {
        int i;
        String valor = String.valueOf(Valor.toString()) + " ";
        int tamValor = valor.length();
        int cont = 3;
        int complementoTam = 0;
        int tamDecimal = 0;
        String vlrFormatado = "";
        String valorAux1 = "";
        String valorAux2 = "";
        int posPonto = 0;
        int i2 = 0;
        while (i2 < tamValor - 1) {
            if (valor.charAt(i2) == 'E') {
                posPonto = Integer.parseInt(valor.substring(i2 + 1, i2 + 3).trim());
            } else if (valor.charAt(i2) == '.') {
                posPonto = i2 - 1;
            }
            ++i2;
        }
        valor = valor.trim();
        if (posPonto != 0) {
            valor = Util2.tirarPontoValor(valor);
            int tamValorSemPonto = valor.length();
            String restoString = "";
            i = 0;
            while (i < tamValorSemPonto) {
                if (i == posPonto) {
                    valorAux1 = String.valueOf(valor.substring(0, posPonto + 1)) + "." + valor.substring(posPonto + 1, tamValorSemPonto);
                }
                valorAux2 = String.valueOf(valor.substring(0, posPonto + 1)) + ".";
                ++i;
            }
        } else {
            valorAux1 = String.valueOf(valor) + ".";
            int j = 0;
            while (j < decimal) {
                valorAux1 = String.valueOf(valorAux1) + "0";
                ++j;
            }
            valorAux2 = String.valueOf(valor) + ".";
        }
        int tamValorAux = valorAux1.length();
        int cont1 = 0;
        if (valorAux1.trim() != "") {
            i = posPonto + 2;
            while (i < posPonto + 4) {
                if (valorAux1.charAt(i) != 'E') {
                    ++cont1;
                }
                ++i;
            }
            valor = cont1 == 1 ? String.valueOf(valorAux2) + valorAux1.substring(posPonto + 2, tamValorAux - 3) + "0" : (posPonto != 0 ? String.valueOf(valorAux2) + valorAux1.substring(posPonto + 2, tamValorAux) : String.valueOf(valorAux2) + valorAux1.substring(tamValorAux - (posPonto + 1), tamValorAux));
        }
        tamValor = valor.length();
        i = 0;
        while (i < tamValor) {
            if (valor.charAt(i) == '.') {
                vlrFormatado = String.valueOf(valor.substring(0, i)) + "," + valor.substring(i + 1, tamValor);
                tamDecimal = tamValor - 1 - i;
            }
            ++i;
        }
        if (tamDecimal < decimal) {
            i = 0;
            while (i < decimal - tamDecimal) {
                vlrFormatado = String.valueOf(vlrFormatado) + "0";
                ++i;
            }
        } else if (tamDecimal > decimal) {
            vlrFormatado = vlrFormatado.substring(0, tamValor - tamDecimal + decimal);
        } else if (tamDecimal == decimal) {
            vlrFormatado = vlrFormatado.substring(0, tamValor);
        }
        int tamValorFormatado = vlrFormatado.length();
        int j = 0;
        while (j < tamValorFormatado - 1) {
            if (vlrFormatado.charAt(j) == ',') {
                vlrFormatado = String.valueOf(vlrFormatado.substring(0, j)) + vlrFormatado.substring(j + 1, tamValorFormatado);
            }
            ++j;
        }
        int tamValorFormatadoSemVirgula = vlrFormatado.length();
        vlrFormatado = decimal != 0 ? String.valueOf(vlrFormatado.substring(0, tamValorFormatadoSemVirgula - decimal)) + "," + vlrFormatado.substring(tamValorFormatadoSemVirgula - decimal, tamValorFormatadoSemVirgula) : String.valueOf(vlrFormatado.substring(0, tamValorFormatadoSemVirgula - decimal)) + vlrFormatado.substring(tamValorFormatadoSemVirgula - decimal, tamValorFormatadoSemVirgula) + " ";
        int j2 = tamValorFormatadoSemVirgula - decimal;
        while (j2 > 0) {
            if (j2 == tamValorFormatadoSemVirgula - decimal - cont) {
                cont += 3;
                vlrFormatado = String.valueOf(vlrFormatado.substring(0, j2)) + "." + vlrFormatado.substring(j2, tamValorFormatadoSemVirgula + ++complementoTam);
            }
            --j2;
        }
        return vlrFormatado;
    }

    public static void garantirPath(File arq) throws IOException {
        String pai = arq.getParent();
        if (pai == null || pai.length() == 0) {
            return;
        }
        new File(pai).mkdirs();
    }

    public static String gerarNomeArquivoNovo(String Diretorio) throws Throwable {
        try {
            int cont = 1;
            String dia = new Format("%02d").form(cal.get(5));
            String mes = new Format("/%02d").form(cal.get(2) + 1);
            String ano = new Format("/%04d").form(cal.get(1));
            String nomeRetornoNovo = String.valueOf(dia) + mes.substring(1, 3) + ano.substring(1, 5) + "." + Util2.strZero(Integer.toString(cont), 3);
            File verificaNomeRemessa = new File(String.valueOf(Diretorio) + nomeRetornoNovo);
            if (verificaNomeRemessa.exists()) {
                File novoNomeRemessa = new File(String.valueOf(Diretorio) + nomeRetornoNovo);
                while (novoNomeRemessa.exists()) {
                    File newNomeRemessa;
                    nomeRetornoNovo = String.valueOf(dia) + mes.substring(1, 3) + ano.substring(1, 5) + "." + Util2.strZero(Integer.toString(++cont), 3);
                    novoNomeRemessa = newNomeRemessa = new File(String.valueOf(Diretorio) + nomeRetornoNovo);
                }
            }
            return nomeRetornoNovo;
        }
        catch (Throwable e) {
            throw new Throwable(e.getMessage());
        }
    }

    public static String getNextField() throws Throwable {
        String ProximoCampo;
        int Delimitador = 9;
        int Fim = strParam.indexOf(Delimitador, intPont);
        if (Fim == -1) {
            Fim = strParam.length();
        }
        try {
            ProximoCampo = strParam.substring(intPont, Fim);
            intPont = Fim + 1;
        }
        catch (StringIndexOutOfBoundsException e) {
            ProximoCampo = "";
        }
        return ProximoCampo;
    }

    public static String getNextField(String ParmIn) throws Throwable {
        String PrimeiroCampo;
        int Delimitador = 9;
        strParam = ParmIn;
        intPont = 0;
        int Fim = strParam.indexOf(Delimitador, intPont);
        try {
            if (Fim == -1) {
                PrimeiroCampo = strParam;
                Fim = strParam.length();
            } else {
                PrimeiroCampo = strParam.substring(intPont, Fim);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            PrimeiroCampo = "";
        }
        intPont = Fim + 1;
        return PrimeiroCampo;
    }

    public static String getNumeroTipoLeilao(String tipoLeilao) throws Throwable {
        String numeroTipoLeilao = "0";
        if (tipoLeilao.equalsIgnoreCase("BB-VENDA       ") || tipoLeilao.equalsIgnoreCase("BB-PREMIO      ") || tipoLeilao.equalsIgnoreCase("BB-PREMIO/TRIGO") || tipoLeilao.equalsIgnoreCase("BB-PREMIO/ALG  ") || tipoLeilao.equalsIgnoreCase("BB-CPR         ") || tipoLeilao.equalsIgnoreCase("BB-FINAN       ") || tipoLeilao.equalsIgnoreCase("BB-FINAN/PL    ") || tipoLeilao.equalsIgnoreCase("BB-OUTROS      ")) {
            numeroTipoLeilao = "1";
        } else if (tipoLeilao.equalsIgnoreCase("CONAB-VENDA    ") || tipoLeilao.equalsIgnoreCase("CONAB-FINAN/PL ") || tipoLeilao.equalsIgnoreCase("CONAB-AGF      ") || tipoLeilao.equalsIgnoreCase("CONAB-ERG      ") || tipoLeilao.equalsIgnoreCase("               ") || tipoLeilao.equalsIgnoreCase("               ") || tipoLeilao.equalsIgnoreCase("CONAB-PROPRIOS ")) {
            numeroTipoLeilao = "2";
        } else if (tipoLeilao.equalsIgnoreCase("MICT-1         ") || tipoLeilao.equalsIgnoreCase("MICT-2         ") || tipoLeilao.equalsIgnoreCase("MICT-3         ") || tipoLeilao.equalsIgnoreCase("MICT-4         ") || tipoLeilao.equalsIgnoreCase("MICT-VENDA     ") || tipoLeilao.equalsIgnoreCase("MICT-FUNCAFE   ") || tipoLeilao.equalsIgnoreCase("MICT-TESOURO   ")) {
            numeroTipoLeilao = "3";
        } else if (tipoLeilao.equalsIgnoreCase("TERCEIROS-VENDA")) {
            numeroTipoLeilao = "4";
        }
        return numeroTipoLeilao;
    }

    public static void limparCampos(Container container) throws Throwable {
        int i = 0;
        while (i < container.getComponentCount()) {
            if (container.getComponent(i) instanceof TextField && !((TextField)container.getComponent(i)).getName().equals("TextFieldAvisoMsg")) {
                ((TextField)container.getComponent(i)).setText("");
            }
            if (container.getComponent(i) instanceof Choice && ((Choice)container.getComponent(i)).getItemCount() > 0) {
                ((Choice)container.getComponent(i)).select(0);
            }
            if (container.getComponent(i) instanceof MaskedTextField) {
                ((MaskedTextField)container.getComponent(i)).setText("");
            }
            if (container.getComponent(i) instanceof Checkbox) {
                ((Checkbox)container.getComponent(i)).setState(false);
            }
            ++i;
        }
        container.validate();
    }

    public String montarNomeRemessaCBR() throws Throwable {
        String s;
        int cont = 1;
        String dia = new Format("%02d").form(cal.get(5));
        String mes = new Format("/%02d").form(cal.get(2) + 1);
        String ano = new Format("/%04d").form(cal.get(1));
        String NomeRemessa = "d:CBR641" + dia + mes.substring(1, 3) + "." + ano.substring(3, 5) + cont;
        try {
            File verificaNomeRemessa = new File(NomeRemessa);
            if (verificaNomeRemessa.exists()) {
                this.in = new BufferedReader(new FileReader(verificaNomeRemessa));
                s = this.in.readLine();
                if (s.length() == 0) {
                    verificaNomeRemessa.delete();
                }
            }
        }
        catch (IOException verificaNomeRemessa) {
            // empty catch block
        }
        File novoNomeRemessa = new File(NomeRemessa);
        while (novoNomeRemessa.exists()) {
            File newNomeRemessa;
            NomeRemessa = "d:CBR641" + dia + mes.substring(1, 3) + "." + ano.substring(3, 5) + ++cont;
            novoNomeRemessa = newNomeRemessa = new File(NomeRemessa);
            try {
                File verificaNomeRemessa = new File(NomeRemessa);
                if (!verificaNomeRemessa.exists()) continue;
                this.in = new BufferedReader(new FileReader(verificaNomeRemessa));
                s = this.in.readLine();
                if (s.length() != 0) continue;
                verificaNomeRemessa.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return NomeRemessa;
    }

    public static String padL(String strOrigem, int comprimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem.trim();
                int i = 0;
                while (i < comprimento - tamString) {
                    lRet = String.valueOf(lRet) + " ";
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(0, comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = String.valueOf(lRet) + " ";
                ++i;
            }
        }
        return lRet;
    }

    public static String padL(String strOrigem, int comprimento, String caractereDePreenchimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem.trim();
                int i = 0;
                while (i < comprimento - tamString) {
                    lRet = String.valueOf(lRet) + caractereDePreenchimento;
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(0, comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = String.valueOf(lRet) + caractereDePreenchimento;
                ++i;
            }
        }
        return lRet;
    }

    public static String padR(String strOrigem, int comprimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem;
                int i = 0;
                while (i < comprimento - strOrigem.length()) {
                    lRet = " " + lRet;
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(0, comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = " " + lRet;
                ++i;
            }
        }
        return lRet;
    }

    public static String padR(String strOrigem, int comprimento, String caractereDePreenchimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (strOrigem != null) {
            if (tamString < comprimento) {
                lRet = strOrigem;
                int i = 0;
                while (i < comprimento - strOrigem.length()) {
                    lRet = String.valueOf(caractereDePreenchimento) + lRet;
                    ++i;
                }
            } else {
                lRet = strOrigem.substring(0, comprimento);
            }
        } else {
            lRet = "";
            int i = 0;
            while (i < comprimento) {
                lRet = String.valueOf(caractereDePreenchimento) + lRet;
                ++i;
            }
        }
        return lRet;
    }

    public Object quebraLinha(String mensagem) throws Throwable {
        int posParada = 0;
        int multiplicador = 1;
        int contador = mensagem.length() / 65;
        int cont = 0;
        int j = 0;
        String[] novoTexto = new String[contador + 1];
        String textoGravado = "";
        String[] textoFormatado = novoTexto;
        Object[][] novoTextoFormatado = new Object[][]{{""}};
        if (mensagem.length() < 65) {
            novoTexto[j] = mensagem.substring(0, mensagem.length());
        } else {
            int i = 0;
            while (i < mensagem.length()) {
                if (mensagem.charAt(i) == ' ') {
                    textoGravado = String.valueOf(textoGravado) + mensagem.substring(posParada, i + 1);
                    posParada = i + 1;
                    if (posParada > 65 * multiplicador) {
                        novoTexto[j] = textoGravado;
                        ++multiplicador;
                        textoGravado = "";
                        ++cont;
                        ++j;
                    }
                    if (contador == cont) {
                        novoTexto[j] = textoGravado = String.valueOf(textoGravado) + mensagem.substring(posParada, mensagem.length());
                        break;
                    }
                }
                ++i;
            }
        }
        return textoFormatado;
    }

    public static void removeFile(String dirOrigem) throws Throwable {
        File nomeArquivo = new File(dirOrigem);
        if (nomeArquivo.exists()) {
            nomeArquivo.delete();
        }
    }

    public static String renomear(String arqOrigem, String arqDestino, String dirOrigem, String dirDestino) throws Throwable {
        try {
            String nomeArquivoDestino = "";
            nomeArquivoDestino = arqDestino.trim().length() == 0 ? Util2.gerarNomeArquivoNovo(dirDestino) : arqDestino;
            File origem = new File(String.valueOf(dirOrigem) + arqOrigem.trim());
            File destino = new File(String.valueOf(dirDestino) + nomeArquivoDestino.trim());
            origem.renameTo(destino);
            return nomeArquivoDestino;
        }
        catch (Throwable e) {
            throw new Throwable("ProcessarRetornoException:" + e.getMessage());
        }
    }

    public static double round(double value, int decimals) throws Throwable {
        double rounded = value;
        int expoente = decimals + 1;
        rounded = Util2.truncate(rounded, expoente);
        double retExpo = Util2.exponenciacao(10.0, expoente);
        rounded += 5.0 / retExpo;
        rounded = Util2.truncate(rounded, decimals);
        return rounded;
    }

    public static java.util.Date strdataToDate(String strdata) throws Throwable {
        int dia = Integer.parseInt(strdata.substring(0, 2).trim());
        int mes = Integer.parseInt(strdata.substring(2, 4).trim());
        int ano = Integer.parseInt(strdata.substring(4, 8).trim());
        GregorianCalendar xxx = new GregorianCalendar(ano, mes - 1, dia);
        return xxx.getTime();
    }

    public static String strZero(String valor, int comprimento) throws Throwable {
        String retorno = "0";
        if ((valor = valor.trim()) != null && valor.length() <= comprimento) {
            retorno = valor;
            int i = 0;
            while (i < comprimento - valor.length()) {
                retorno = "0" + retorno;
                ++i;
            }
        }
        return retorno;
    }

    public static String strZero(String valor, long comprimento) throws Throwable {
        String retorno = "0";
        if ((valor = valor.trim()) != null && (long)valor.length() <= comprimento) {
            retorno = valor;
            int i = 0;
            while ((long)i < comprimento - (long)valor.length()) {
                retorno = "0" + retorno;
                ++i;
            }
        }
        return retorno;
    }

    public static String substituirCaracteresAspas(String texto) throws Throwable {
        String textoAlterado = " ";
        if (texto != null) {
            textoAlterado = texto.replace('\'', ' ');
            textoAlterado = textoAlterado.replace('\"', ' ');
        }
        return textoAlterado;
    }

    public static String tirarPontoValor(String valor) throws Throwable {
        int tamValor = valor.length();
        int posPonto = 0;
        String vlrSemPonto = "";
        int i = 0;
        while (i < tamValor) {
            if (valor.substring(i, i + 1).trim().equalsIgnoreCase(".")) {
                posPonto = i;
            }
            ++i;
        }
        vlrSemPonto = tamValor - posPonto == 3 ? String.valueOf(valor.substring(0, posPonto)) + valor.substring(posPonto + 1, tamValor) : String.valueOf(valor.substring(0, posPonto)) + valor.substring(posPonto + 1, tamValor) + "0";
        return vlrSemPonto;
    }

    public static String tirarZerosEsquerda(String strVar) throws Throwable {
        String varSemZero = "";
        if (Integer.parseInt(strVar) == 0) {
            varSemZero = "0";
            return varSemZero;
        }
        int tamVar = strVar.length();
        int i = 0;
        while (i < tamVar) {
            if (!strVar.substring(i, i + 1).trim().equalsIgnoreCase("0")) {
                varSemZero = String.valueOf(varSemZero) + strVar.substring(i, i + 1);
            }
            ++i;
        }
        return varSemZero;
    }

    public static String trocaPontoPorVirgula(String strMsg) throws Throwable {
        return strMsg.replace('.', ',');
    }

    public static String trocaVirgulaPorPonto(String strMsg) throws Throwable {
        return strMsg.replace(',', '.');
    }

    public static double truncate(double valor, int decimais) throws Throwable {
        String Buff = "";
        Buff = Double.toString(valor);
        int posicaoDecimal = Buff.indexOf(".");
        if (posicaoDecimal > -1) {
            if (Buff.length() > posicaoDecimal + decimais) {
                Buff = Buff.substring(0, posicaoDecimal + 1 + decimais);
            }
        } else {
            Buff = "0";
        }
        double lRet = Double.valueOf(Buff);
        return lRet;
    }

    public static boolean validarData(int dia, int mes, int ano) throws Throwable {
        if (ano < 1900 || mes < 1 || mes > 12 || dia < 1) {
            return false;
        }
        int maximo = 31;
        switch (mes) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                maximo = 30;
                break;
            }
            case 2: {
                maximo = ano % 4 == 0 && ano % 100 != 0 || ano % 400 == 0 ? 29 : 28;
            }
        }
        return dia <= maximo;
    }

    public static boolean verificaMod10(String modulo) throws Throwable {
        boolean retorno = false;
        if (modulo != null) {
            modulo.trim();
            String moduloSemDv = modulo.substring(0, modulo.length() - 1);
            String dv = Util2.calculaDigitoMod10(moduloSemDv);
            if (modulo.substring(modulo.length() - 1, modulo.length()).compareTo(dv) == 0) {
                retorno = true;
            }
        }
        return retorno;
    }

    public static boolean verificarCGC(String cgc) throws Throwable {
        boolean retorno = false;
        if (cgc != null && cgc.length() == 14) {
            String cgcSemDv = cgc.substring(0, 12);
            String dv = Util2.calcularDigitoCGC(cgcSemDv);
            if (cgc.substring(12, 14).compareTo(dv) == 0) {
                retorno = true;
            }
        }
        return retorno;
    }

    public static boolean verificarCPF(String cpf) throws Throwable {
        boolean retorno = false;
        if (cpf != null && cpf.length() == 11) {
            String cpfSemDv = cpf.substring(0, 9);
            String dv = Util2.calcularDigitoCPF(cpfSemDv);
            if (cpf.substring(9, 11).compareTo(dv) == 0) {
                retorno = true;
            }
        }
        return retorno;
    }

    public static boolean verificaUF(String strUF) throws Throwable {
        boolean blnRetorno = true;
        String strMatrizUF = "RS#SC#PR#SP#RJ#MG#ES#MS#MT#GO#TO#DF#BA#AL#SE#RN#PE#CE#MA#PI#PB#FN#AM#AC#PA#RO#RR#AP";
        if (strMatrizUF.indexOf(strUF.toUpperCase()) == -1) {
            blnRetorno = false;
        }
        return blnRetorno;
    }
}

