/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.instalacao;

import br.com.bb.hob.utilitario.FileLoader;
import br.com.bb.hob.utilitario.FileLoaderListener;
import br.com.bb.instalacao.CachedObjectInputStream;
import br.com.bb.instalacao.InfoArquivo;
import br.com.bb.instalacao.ProvedorInstalacao;
import br.com.bb.instalacao.TabelaInfoDiretorio;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.InflaterInputStream;

public class CriptoCachedFileLoader
extends FileLoader {
    private ProvedorInstalacao provedorBB_;
    private TabelaInfoDiretorio tabelaCodigoHash_;
    private static final String DIR_CACHE = "cache";
    private ClassLoader classLoader_;

    public CriptoCachedFileLoader(ClassLoader classLoader, ProvedorInstalacao provedorInstalacao) throws IOException {
        if (provedorInstalacao == null) {
            throw new RuntimeException("O ProvedorInstalacao passado n\u00e3o pode ser nulo.");
        }
        this.provedorBB_ = provedorInstalacao;
        this.provedorBB_.verificar();
        if (!this.provedorBB_.isOk()) {
            throw new RuntimeException("Erro ao procurar info instala\u00e7\u00e3o no site do Banco do Brasil: " + this.provedorBB_.getStatusAsString());
        }
        this.tabelaCodigoHash_ = this.provedorBB_.getInfoAssinado();
        this.classLoader_ = classLoader;
    }

    private String getHashedFilename(String string) throws IOException, MalformedURLException {
        int n = string.indexOf(FileLoader.getPathBB());
        if (n != -1 && (string = string.substring(FileLoader.getPathBB().length())).charAt(0) == File.separator.charAt(0)) {
            string = string.substring(1);
        }
        if (this.isEmbaralhado(string)) {
            return String.valueOf(FileLoader.getSubDir()) + File.separator + DIR_CACHE + File.separator + Integer.toHexString(TabelaInfoDiretorio.calcularHash(string.getBytes()));
        }
        return string;
    }

    private InfoArquivo getInfo(String string) {
        if (FileLoader.isLinux()) {
            string = string.replace('/', '\\');
            return this.tabelaCodigoHash_.getInfo(string);
        }
        return this.tabelaCodigoHash_.getInfo(FileLoader.corrigeParaBarraPath(string));
    }

    protected InputStream getInputStreamImpl(String string) throws IOException {
        return new ByteArrayInputStream(this.loadImpl(string, null, true));
    }

    public static ProvedorInstalacao getProvedor() {
        FileLoader fileLoader = FileLoader.getFileLoader();
        if (fileLoader instanceof CriptoCachedFileLoader) {
            return ((CriptoCachedFileLoader)fileLoader).provedorBB_;
        }
        return null;
    }

    public static TabelaInfoDiretorio getTabelaArquivos() {
        FileLoader fileLoader = FileLoader.getFileLoader();
        if (fileLoader instanceof CriptoCachedFileLoader) {
            return ((CriptoCachedFileLoader)fileLoader).tabelaCodigoHash_;
        }
        return null;
    }

    private boolean isEmbaralhado(String string) throws IOException {
        int n = string.indexOf(FileLoader.getPathBB());
        if (n != -1 && (string = string.substring(FileLoader.getPathBB().length())).charAt(0) == File.separator.charAt(0)) {
            string = string.substring(1);
        }
        return !this.provedorBB_.isArquivoNucleo(string) && this.provedorBB_.getInfoAssinado().getInfo(string) != null;
    }

    public boolean isSincronizado(String string) {
        InfoArquivo infoArquivo = this.getInfo(string);
        if (infoArquivo == null) {
            return false;
        }
        return infoArquivo.isSincronizado();
    }

    public byte[] loadFileImpl(String string, FileLoaderListener fileLoaderListener, boolean bl) throws IOException {
        return super.loadFileImpl(string, fileLoaderListener, bl || this.isEmbaralhado(string));
    }

    protected byte[] loadImpl(String string, FileLoaderListener fileLoaderListener, boolean bl) throws IOException {
        Object object;
        if (bl) {
            object = new StringBuffer(FileLoader.getSubDir());
            if (!string.startsWith(File.separator)) {
                ((StringBuffer)object).append(File.separator);
            }
            string = ((StringBuffer)object).append(string).toString();
        }
        if ((object = this.getInfo(string)) == null) {
            throw new FileNotFoundException("Arquivo " + string + " inexistente na tabela de hash.");
        }
        byte[] byArray = null;
        try {
            byArray = this.loadFileImpl(((InfoArquivo)object).getNome(), null, false);
            if (((InfoArquivo)object).isSincronizado(byArray)) {
                return byArray;
            }
        }
        catch (IOException iOException) {}
        URL uRL = this.provedorBB_.getURLArquivoComprimido(((InfoArquivo)object).getNome());
        byArray = FileLoader.load(uRL, fileLoaderListener, true);
        this.saveFileImpl(((InfoArquivo)object).getNome(), byArray, false);
        return byArray;
    }

    protected Object loadObjetoImpl(String string, FileLoaderListener fileLoaderListener, boolean bl) throws IOException, ClassNotFoundException {
        InflaterInputStream inflaterInputStream = new InflaterInputStream(FileLoader.getInputStream(string));
        ObjectInputStream objectInputStream = this.classLoader_ == null ? new ObjectInputStream(inflaterInputStream) : new CachedObjectInputStream(this.classLoader_, inflaterInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static void resetTabelaHash() {
        FileLoader fileLoader = FileLoader.getFileLoader();
        if (fileLoader instanceof CriptoCachedFileLoader) {
            CriptoCachedFileLoader criptoCachedFileLoader = (CriptoCachedFileLoader)fileLoader;
            criptoCachedFileLoader.tabelaCodigoHash_.reset();
        }
    }

    public File resolveFileImpl(String string) {
        try {
            return new File(String.valueOf(FileLoader.getPathBB()) + File.separatorChar + FileLoader.corrigeParaBarraPath(this.getHashedFilename(string)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new File(string);
        }
    }

    public void saveFileImpl(String string, byte[] byArray, boolean bl) throws IOException {
        InfoArquivo infoArquivo = this.getInfo(string);
        String string2 = string;
        if (infoArquivo != null) {
            if (TabelaInfoDiretorio.calcularHash(byArray) != infoArquivo.getHash()) {
                throw new IOException("O arquivo de download " + infoArquivo.getNome() + " nao confere com o codigo de hash: " + TabelaInfoDiretorio.calcularHash(byArray) + "(arq) != " + infoArquivo.getHash() + "(lista)");
            }
            string2 = infoArquivo.getNome();
        }
        File file = FileLoader.resolveFile(string2);
        FileLoader.save(file, byArray, this.isEmbaralhado(string2));
        if (infoArquivo != null) {
            infoArquivo.setSincronizado(true);
        }
    }
}

