/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.instalacao;

import br.com.bb.hob.utilitario.FileLoader;
import br.com.bb.instalacao.TabelaInfoDiretorio;
import java.io.IOException;

public class InfoArquivo {
    public final String nome_;
    public final int tamanho_;
    public final int hash_;
    private static final byte DESCONHECIDO = 0;
    private static final byte ATUALIZADO = 1;
    private static final byte DESATUALIZADO = 0;
    private byte status_ = 0;

    public InfoArquivo(String string, int n, int n2) {
        this.nome_ = InfoArquivo.normalizaNome(string);
        this.hash_ = n;
        this.tamanho_ = n2;
    }

    public int getHash() {
        return this.hash_;
    }

    public String getNome() {
        return this.nome_;
    }

    public int getTamanho() {
        return this.tamanho_;
    }

    public boolean isSincronizado() {
        if (this.status_ == 0) {
            try {
                boolean bl = false;
                if (FileLoader.resolveFile(this.nome_).exists()) {
                    byte[] byArray = FileLoader.loadFile(this.nome_);
                    bl = TabelaInfoDiretorio.calcularHash(byArray) == this.hash_;
                }
                this.status_ = bl ? (byte)1 : 0;
            }
            catch (IOException iOException) {
                this.status_ = 0;
            }
        }
        return this.status_ == 1;
    }

    public boolean isSincronizado(byte[] byArray) {
        if (this.status_ == 0) {
            return TabelaInfoDiretorio.calcularHash(byArray) == this.hash_;
        }
        return this.status_ == 1;
    }

    public static String normalizaNome(String string) {
        return string.replace('/', '\\');
    }

    public void reset() {
        this.status_ = 0;
    }

    public void setSincronizado(boolean bl) {
        this.status_ = bl ? (byte)1 : 0;
    }
}

