/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.instalacao;

import br.com.bb.hob.utilitario.FileLoader;
import br.com.bb.hob.utilitario.FileLoaderListener;
import br.com.bb.hob.visual.BBBarraProgresso;
import br.com.bb.instalacao.InfoArquivo;
import br.com.bb.instalacao.ProvedorInstalacao;
import br.com.bb.instalacao.TabelaInfoDiretorio;
import br.com.bb.util.Conversor;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class PanelCopiarArquivo
extends Panel
implements FileLoaderListener,
Runnable {
    private static final long serialVersionUID = 1993560452949236465L;
    private Label lblMsg_ = new Label();
    private final BBBarraProgresso progressTudo_ = new BBBarraProgresso();
    private final Label lblProgressTudo_ = new Label();
    private final Label lblTempoTudo_ = new Label();
    private final BBBarraProgresso progressArquivo_ = new BBBarraProgresso();
    private final Label lblProgressArquivo_ = new Label();
    private final Label lblTempoArquivo_ = new Label();
    private final Label lblProvedor_ = new Label("", 1);
    private int qtdArquivo_;
    private int qtdArquivoLidos_;
    private int totalCopiar_;
    private int totalCopiado_;
    private long tempoAtual_;
    private long ultimaExibicao_;
    private long tempoInicioTotal_;
    private long tempoLatenciaTotal_;
    private int bytesLatenciaTotal_;
    private long tempoInicioArquivo_;
    private long tempoLatenciaArquivo_;
    private int bytesLatenciaArquivo_;
    private int bytesLidosArquivo_;
    private int tamanhoArquivo_;
    private int maiorBytesLatencia_;
    private String nomeArquivo_ = "";
    private String origemArquivo_ = "";

    public PanelCopiarArquivo() {
        this.progressTudo_.setValorFinal(100000000);
        this.progressTudo_.setForeground(Color.blue);
        this.progressArquivo_.setForeground(Color.blue);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.lblProvedor_, gridBagConstraints);
        this.add(this.lblProvedor_);
        gridBagConstraints.gridwidth = 1;
        Label label = new Label("Total:");
        label.setFont(new Font("sansserif", 0, 12));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        label = new Label("Arquivo:");
        label.setFont(new Font("sansserif", 0, 12));
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.progressTudo_, gridBagConstraints);
        this.add(this.progressTudo_);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lblProgressTudo_, gridBagConstraints);
        this.add(this.lblProgressTudo_);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lblTempoTudo_, gridBagConstraints);
        this.add(this.lblTempoTudo_);
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.progressArquivo_, gridBagConstraints);
        this.add(this.progressArquivo_);
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.lblProgressArquivo_, gridBagConstraints);
        this.add(this.lblProgressArquivo_);
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.lblTempoArquivo_, gridBagConstraints);
        this.add(this.lblTempoArquivo_);
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.lblMsg_, gridBagConstraints);
        this.add(this.lblMsg_);
    }

    public synchronized void bytesArrived(FileLoader.InfoLeitura infoLeitura) {
        this.tempoAtual_ = System.currentTimeMillis();
        if (this.tempoLatenciaArquivo_ == -1L) {
            this.origemArquivo_ = infoLeitura.getOrigem().toString();
            this.tempoLatenciaArquivo_ = infoLeitura.getTempoLatencia();
            this.tempoLatenciaTotal_ += this.tempoLatenciaArquivo_;
            if (infoLeitura.getBytesLatencia() > this.maiorBytesLatencia_) {
                this.maiorBytesLatencia_ = infoLeitura.getBytesLatencia();
            }
        }
        this.totalCopiado_ += infoLeitura.getBytesLidos();
        this.bytesLidosArquivo_ = infoLeitura.getBytesTotalLidos();
    }

    private long calcularTempo(long l, long l2, int n, int n2, int n3, int n4, int n5) {
        long l3;
        long l4 = l3 = l * (long)n5 / (long)(n4 + 1);
        if (n != 0) {
            if (n == n2) {
                l4 += l2 * (long)n3 / (long)n;
            } else {
                int n6 = n3 - n2 - this.maiorBytesLatencia_ * (n5 - n4) / (n4 + 1);
                l4 += (long)n6 * (l2 - l) / (long)(n - n2);
            }
        }
        return l4 - l2;
    }

    private void copiarArquivo(ProvedorInstalacao provedorInstalacao, InfoArquivo infoArquivo) throws IOException {
        this.setMsg("Copiando Arquivo " + infoArquivo.getNome());
        URL uRL = provedorInstalacao.getURLArquivoComprimido(infoArquivo.getNome());
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            inputStream = new InflaterInputStream(FileLoader.getInputStream(uRL));
            byArray = FileLoader.readAllBytes(inputStream, uRL, infoArquivo.getTamanho(), this);
        }
        catch (ZipException zipException) {
            if (infoArquivo.getNome().indexOf("index.html") != -1) {
                inputStream = uRL.openStream();
                byArray = FileLoader.readAllBytes(inputStream, uRL, infoArquivo.getTamanho(), this);
                Conversor.converte(byArray, 0);
                inputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
            } else {
                System.out.println("Erro ao descompactar arquivo:" + infoArquivo.getNome());
            }
            byArray = FileLoader.readAllBytes(inputStream, uRL, infoArquivo.getTamanho(), this);
        }
        FileLoader.saveBB(infoArquivo.getNome(), byArray);
        FileLoader.getTrace().trace("PanelCopiarArquivo.copiarArquivo: O seguinte arquivo foi salvo com sucesso: \r\n\t\t\t   " + infoArquivo.getNome());
        infoArquivo.setSincronizado(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copiarLista(ProvedorInstalacao provedorInstalacao, InfoArquivo[] infoArquivoArray) throws IOException {
        this.qtdArquivo_ = infoArquivoArray.length;
        this.totalCopiar_ = 0;
        int n = 0;
        while (true) {
            if (n >= infoArquivoArray.length) {
                this.progressTudo_.setValorFinal(this.totalCopiar_);
            }
            this.totalCopiar_ += infoArquivoArray[n].getTamanho();
            ++n;
        }
        String string = ProvedorInstalacao.getIndicadorAtualizacao() ? "Atualiza\u00e7\u00e3o" : "Instala\u00e7\u00e3o";
        PanelCopiarArquivo.mostrarSituacaoLeitura(this.lblProgressTudo_, this.lblTempoTudo_, string, this.totalCopiado_, this.totalCopiar_, 0L, 0L);
        this.tempoInicioTotal_ = System.currentTimeMillis();
        Thread thread = new Thread(this);
        thread.start();
        URL[] uRLArray = new URL[1];
        try {
            if (!ProvedorInstalacao.getIndicadorAtualizacao()) {
                if (infoArquivoArray.length <= 0) {
                    Object var7_7 = null;
                    thread.stop();
                    return;
                }
                uRLArray[0] = provedorInstalacao.getURLArquivoComprimido("toda_instalacao.zbb");
                this.lerBloco(uRLArray[0], provedorInstalacao, infoArquivoArray);
            }
            int n2 = 0;
            while (n2 < infoArquivoArray.length) {
                if (!infoArquivoArray[n2].isSincronizado()) {
                    this.nomeArquivo_ = infoArquivoArray[n2].getNome();
                    this.tempoInicioArquivo_ = System.currentTimeMillis();
                    this.tempoLatenciaArquivo_ = -1L;
                    this.bytesLidosArquivo_ = 0;
                    this.tamanhoArquivo_ = infoArquivoArray[n2].getTamanho();
                    FileLoader.getTrace().trace("PanelCopiarArquivo.CopiarLista: Vou copiar o arquivo:\r\n\t\t\t   " + infoArquivoArray[n2].getNome());
                    this.copiarArquivo(provedorInstalacao, infoArquivoArray[n2]);
                    ++this.qtdArquivoLidos_;
                    this.mostrarSituacao();
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            thread.stop();
            throw throwable;
        }
        {
            Object var7_9 = null;
            thread.stop();
        }
        long l = System.currentTimeMillis() - this.tempoInicioTotal_;
        System.out.println("Bytes Total=" + this.totalCopiar_);
        System.out.println("Tempo Total=" + l);
        if (this.qtdArquivo_ > 0) {
            System.out.println("Latencia Total=" + this.tempoLatenciaTotal_);
            System.out.println("Tempo    Medio=" + l / (long)this.qtdArquivo_);
            System.out.println("Latencia Medio=" + this.tempoLatenciaTotal_ / (long)this.qtdArquivo_);
            System.out.println("Diferenca     =" + (l - this.tempoLatenciaTotal_) / (long)this.qtdArquivo_);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copiarAtualizacaoZbb(ProvedorInstalacao provedorInstalacao, InfoArquivo[] infoArquivoArray) throws IOException {
        this.qtdArquivo_ = infoArquivoArray.length;
        this.totalCopiar_ = 0;
        FileLoader.getTrace().trace("PanelCopiarArquivo.copiarAtualizacaoZbb: Total de arquivos a copiar: " + infoArquivoArray.length);
        if (infoArquivoArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < infoArquivoArray.length) {
            this.totalCopiar_ += infoArquivoArray[n].getTamanho();
            ++n;
        }
        this.progressTudo_.setValorFinal(this.totalCopiar_);
        PanelCopiarArquivo.mostrarSituacaoLeitura(this.lblProgressTudo_, this.lblTempoTudo_, "Atualiza\u00e7\u00e3o", this.totalCopiado_, this.totalCopiar_, 0L, 0L);
        this.tempoInicioTotal_ = System.currentTimeMillis();
        Thread thread = new Thread(this);
        thread.start();
        URL[] uRLArray = new URL[1];
        try {
            uRLArray[0] = provedorInstalacao.getURLArquivoComprimido("atualizacao.zbb");
            FileLoader.getTrace().trace("PanelCopiarArquivo.copiarAtualizacaoZbb: URL do arquivo a ser copiado: \r\n\t\t\t   " + provedorInstalacao.getURLArquivoComprimido("atualizacao.zbb"));
            FileLoader.getTrace().trace("PanelCopiarArquivo.copiarAtualizacaoZbb: Copiando arquivos...");
            this.lerBlocoAtualizacao(uRLArray[0], provedorInstalacao, infoArquivoArray);
            FileLoader.getTrace().trace("PanelCopiarArquivo.copiarAtualizacaoZbb: Checando se h\u00e1 arquivo que n\u00e3o foram atualizados com sucesso...");
            int n2 = 0;
            while (n2 < infoArquivoArray.length) {
                if (!infoArquivoArray[n2].isSincronizado()) {
                    this.nomeArquivo_ = infoArquivoArray[n2].getNome();
                    this.tempoInicioArquivo_ = System.currentTimeMillis();
                    this.tempoLatenciaArquivo_ = -1L;
                    this.bytesLidosArquivo_ = 0;
                    this.tamanhoArquivo_ = infoArquivoArray[n2].getTamanho();
                    FileLoader.getTrace().trace("PanelCopiarArquivo.copiarAtualizacaoZbb: Vou copiar novamente o arquivo: \r\n\t\t\t   " + infoArquivoArray[n2].getNome());
                    this.copiarArquivo(provedorInstalacao, infoArquivoArray[n2]);
                    ++this.qtdArquivoLidos_;
                    this.mostrarSituacao();
                }
                ++n2;
            }
            Object var6_10 = null;
            thread.stop();
            FileLoader.getTrace().trace("PanelCopiarArquivo.copiarAtualizacaoZbb: Final do processamento do atualizacao.zbb");
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            thread.stop();
            throw throwable;
        }
        long l = System.currentTimeMillis() - this.tempoInicioTotal_;
        System.out.println("Bytes Total=" + this.totalCopiar_);
        System.out.println("Tempo Total=" + l);
        if (this.qtdArquivo_ > 0) {
            System.out.println("Latencia Total=" + this.tempoLatenciaTotal_);
            System.out.println("Tempo    Medio=" + l / (long)this.qtdArquivo_);
            System.out.println("Latencia Medio=" + this.tempoLatenciaTotal_ / (long)this.qtdArquivo_);
            System.out.println("Diferenca     =" + (l - this.tempoLatenciaTotal_) / (long)this.qtdArquivo_);
        }
    }

    public URL[] decidirEstrategiaDownload(ProvedorInstalacao provedorInstalacao, InfoArquivo[] infoArquivoArray) throws MalformedURLException, IOException {
        InfoArquivo infoArquivo;
        TabelaInfoDiretorio tabelaInfoDiretorio = provedorInstalacao.getInfoZip();
        FileLoader.InfoLeitura infoLeitura = provedorInstalacao.getInfoLeitura();
        URL[] uRLArray = new URL[]{};
        long l = 0L;
        int n = 0;
        int n2 = 0;
        while (n2 < infoArquivoArray.length) {
            infoArquivo = tabelaInfoDiretorio.getInfo(infoArquivoArray[n2].getNome());
            if (infoArquivo == null) {
                throw new RuntimeException("Informa\u00e7\u00e3o sobre o arquivo compactado n\u00e3o encontrada.");
            }
            l += infoLeitura.estimarTempoLeitura(infoArquivo.getTamanho());
            n += infoArquivo.getTamanho();
            ++n2;
        }
        System.out.println("%%% Estimativa varios arquivo=" + l + "  tamanho=" + n);
        if (!ProvedorInstalacao.getIndicadorAtualizacao()) {
            infoArquivo = tabelaInfoDiretorio.getInfo("toda_instalacao.zbb");
            if (infoArquivo == null) {
                throw new RuntimeException("N\u00e3o foi localizado a informa\u00e7\u00e3o sobre o arquivo com tudo zipado");
            }
            long l2 = infoLeitura.estimarTempoLeitura(infoArquivo.getTamanho());
            System.out.println("%%% Estimativa um zip=" + l2 + "  tamanho=" + infoArquivo.getTamanho());
            if (l2 < l) {
                l = l2;
                uRLArray = new URL[]{provedorInstalacao.getURLArquivoComprimido("toda_instalacao.zbb")};
            }
        }
        return uRLArray;
    }

    public InfoArquivo[] desatualizados(ProvedorInstalacao provedorInstalacao) throws IOException {
        this.lblProvedor_.setText("Provedor: " + provedorInstalacao.getNome() + " (" + provedorInstalacao.getURL() + ")");
        this.lblProvedor_.setFont(new Font("sansserif", 0, 12));
        TabelaInfoDiretorio tabelaInfoDiretorio = provedorInstalacao.getInfoAssinado();
        String[] stringArray = provedorInstalacao.getArquivosToCopy();
        return tabelaInfoDiretorio.desatualizados(stringArray);
    }

    private static void formatarTamanho(StringBuffer stringBuffer, int n) {
        double d = n;
        if (n > 0x100000) {
            d = Math.floor(d * 10.0 / 1048576.0) / 10.0;
            stringBuffer.append(d).append("Mbytes");
        } else if (n > 1024) {
            d = Math.floor(d * 10.0 / 1024.0) / 10.0;
            stringBuffer.append(d).append("Kbytes");
        } else {
            stringBuffer.append(n).append("bytes");
        }
    }

    private static void formatarTempo(StringBuffer stringBuffer, long l) {
        long l2 = l / 3600000L;
        l -= l2 * 3600000L;
        if (l2 > 0L) {
            stringBuffer.append(l2).append('h');
        }
        l2 = l / 60000L;
        l -= l2 * 60000L;
        if (l2 > 0L) {
            stringBuffer.append(l2).append('m');
        }
        if ((l2 = (l + 999L) / 1000L) > 0L) {
            stringBuffer.append(l2).append('s');
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lerBloco(URL uRL, ProvedorInstalacao provedorInstalacao, InfoArquivo[] infoArquivoArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(new BufferedInputStream(FileLoader.getInputStream(uRL), 5120)));
            int n = 1;
            try {
                try {
                    this.setMsg("Copiando Arquivo " + uRL);
                    while (true) {
                        String string = dataInputStream.readUTF();
                        int n2 = dataInputStream.readInt();
                        InfoArquivo infoArquivo = this.procurarInfo(infoArquivoArray, string);
                        if (infoArquivo == null) {
                            ++this.qtdArquivo_;
                            this.totalCopiar_ += n2;
                            infoArquivo = provedorInstalacao.getInfoAssinado().getInfo(string);
                        }
                        if (infoArquivo.getTamanho() != n2) {
                            throw new RuntimeException("O tamanho do arquivo sendo lido (" + n2 + ") \u00e9 diferente do tamanho esperado (" + infoArquivo.getTamanho() + ')');
                        }
                        this.nomeArquivo_ = string;
                        this.tempoInicioArquivo_ = System.currentTimeMillis();
                        this.tempoLatenciaArquivo_ = 0L;
                        this.bytesLidosArquivo_ = 0;
                        this.tamanhoArquivo_ = n2;
                        FileLoader.InfoLeitura infoLeitura = new FileLoader.InfoLeitura(string, n2);
                        long l = System.currentTimeMillis();
                        byte[] byArray = new byte[n2];
                        int n3 = 0;
                        FileLoader.getTrace().trace("-----------------------------------------------------------------------------------------------");
                        FileLoader.getTrace().trace("PanelCopiarArquivo.lerBloco(URL, ProvedorInstalacao, InfoArquivo[]): Copiando arquivo " + n + ":\r\n\t\t\t   " + string);
                        while (true) {
                            if (n3 >= n2) {
                                ++n;
                                this.mostrarSituacao();
                                if (TabelaInfoDiretorio.calcularHash(byArray) == infoArquivo.getHash()) break;
                                throw new RuntimeException("O hash do arquivo '" + string + "' (" + TabelaInfoDiretorio.calcularHash(byArray) + ") \u00e9 diferente do esperado (" + infoArquivo.getHash() + ")");
                            }
                            int n4 = dataInputStream.read(byArray, n3, Math.min(n2 - infoLeitura.getBytesTotalLidos(), 10240));
                            if (n4 == -1) {
                                throw new RuntimeException("Fim de arquivo n\u00e3o esperado ao ler bloco.");
                            }
                            infoLeitura.addBloco(n4, l, System.currentTimeMillis());
                            this.bytesArrived(infoLeitura);
                            FileLoader.getTrace().trace("PanelCopiarArquivo.LerBloco: Lido | A ler: [" + (n3 += n4) + " | " + n2 + "]");
                        }
                        if (infoArquivo.isSincronizado()) continue;
                        FileLoader.saveBB(string, byArray);
                        infoArquivo.setSincronizado(true);
                    }
                }
                catch (EOFException eOFException) {
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                dataInputStream.close();
                throw throwable;
            }
            {
                Object var15_16 = null;
                dataInputStream.close();
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lerBlocoAtualizacao(URL uRL, ProvedorInstalacao provedorInstalacao, InfoArquivo[] infoArquivoArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(new BufferedInputStream(FileLoader.getInputStream(uRL), 5120)));
            dataInputStream.readInt();
            int n = 0;
            try {
                try {
                    this.setMsg("Copiando Arquivo " + uRL);
                    while (true) {
                        String string = dataInputStream.readUTF();
                        int n2 = dataInputStream.readInt();
                        FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Copiado " + n + " de " + infoArquivoArray.length + " arquivos.");
                        InfoArquivo infoArquivo = this.procurarInfo(infoArquivoArray, string);
                        if (infoArquivo == null) {
                            ++this.qtdArquivo_;
                            this.totalCopiar_ += n2;
                            infoArquivo = provedorInstalacao.getInfoAssinado().getInfo(string);
                            FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Copiando um arquivo que n\u00e3o estava na relac\u00e3o atualiza.info:\r\n\t\t\t   " + infoArquivo);
                        }
                        if (infoArquivo.getTamanho() != n2) {
                            FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Tamanho do arquivo sendo (" + n2 + ") " + "lido \u00e9 diferente do esperado (" + infoArquivo.getTamanho());
                            throw new RuntimeException("O tamanho do arquivo sendo lido (" + n2 + ") \u00e9 diferente do tamanho esperado (" + infoArquivo.getTamanho() + ')');
                        }
                        this.nomeArquivo_ = string;
                        this.tempoInicioArquivo_ = System.currentTimeMillis();
                        this.tempoLatenciaArquivo_ = 0L;
                        this.bytesLidosArquivo_ = 0;
                        this.tamanhoArquivo_ = n2;
                        FileLoader.InfoLeitura infoLeitura = new FileLoader.InfoLeitura(string, n2);
                        long l = System.currentTimeMillis();
                        byte[] byArray = new byte[n2];
                        int n3 = 0;
                        FileLoader.getTrace().trace("--------------------------------------------------------------------------------------------------------");
                        FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Copiando arquivo:\r\n\t\t\t   " + string);
                        while (true) {
                            if (n3 >= n2) {
                                this.mostrarSituacao();
                                if (TabelaInfoDiretorio.calcularHash(byArray) == infoArquivo.getHash()) break;
                                FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao:O hash do arquivo '" + string + "' (" + TabelaInfoDiretorio.calcularHash(byArray) + ") \u00e9 diferente do esperado (" + infoArquivo.getHash() + ")");
                                throw new RuntimeException("O hash do arquivo '" + string + "' (" + TabelaInfoDiretorio.calcularHash(byArray) + ") \u00e9 diferente do esperado (" + infoArquivo.getHash() + ")");
                            }
                            int n4 = dataInputStream.read(byArray, n3, Math.min(n2 - infoLeitura.getBytesTotalLidos(), 10240));
                            if (n4 == -1) {
                                FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Fim de arquivo n\u00e3o esperado ao ler bloco.");
                                throw new RuntimeException("Fim de arquivo n\u00e3o esperado ao ler bloco.");
                            }
                            infoLeitura.addBloco(n4, l, System.currentTimeMillis());
                            this.bytesArrived(infoLeitura);
                            FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Lido | A ler: [" + (n3 += n4) + " | " + n2 + "]");
                        }
                        if (!infoArquivo.isSincronizado()) {
                            FileLoader.saveBB(string, byArray);
                            FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Salvando arquivo:\r\n\t\t\t   " + string);
                            infoArquivo.setSincronizado(true);
                        }
                        ++n;
                    }
                }
                catch (EOFException eOFException) {
                    FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Fim da atualiza\u00e7\u00e3o");
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Fechando DataInputStream...");
                dataInputStream.close();
                throw throwable;
            }
            {
                Object var15_17 = null;
                FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Fechando DataInputStream...");
                dataInputStream.close();
                return;
            }
        }
        catch (IOException iOException) {
            FileLoader.getTrace().trace("PanelCopiarArquivo.lerBlocoAtualizacao: Ocorreu o seguinte erro: " + iOException.getMessage());
            return;
        }
    }

    private synchronized void mostrarSituacao() {
        this.ultimaExibicao_ = this.tempoAtual_;
        String string = ProvedorInstalacao.getIndicadorAtualizacao() ? "Atualiza\u00e7\u00e3o" : "Instala\u00e7\u00e3o";
        long l = this.calcularTempo(this.tempoLatenciaTotal_, this.tempoAtual_ - this.tempoInicioTotal_, this.totalCopiado_, this.bytesLatenciaTotal_, this.totalCopiar_, this.qtdArquivoLidos_, this.qtdArquivo_);
        PanelCopiarArquivo.mostrarSituacaoLeitura(this.lblProgressTudo_, this.lblTempoTudo_, string, this.totalCopiado_, this.totalCopiar_, this.tempoAtual_ - this.tempoInicioTotal_, l);
        l = this.calcularTempo(this.tempoLatenciaArquivo_, this.tempoAtual_ - this.tempoInicioArquivo_, this.bytesLidosArquivo_, this.bytesLatenciaArquivo_, this.tamanhoArquivo_, 0, 1);
        PanelCopiarArquivo.mostrarSituacaoLeitura(this.lblProgressArquivo_, this.lblTempoArquivo_, this.nomeArquivo_, this.bytesLidosArquivo_, this.tamanhoArquivo_, this.tempoAtual_ - this.tempoInicioArquivo_, l);
        this.lblMsg_.setText("Copiando " + this.origemArquivo_ + ".");
        this.progressTudo_.setValorFinal(this.totalCopiar_);
        this.progressTudo_.setValorAtual(this.totalCopiado_);
        this.progressArquivo_.setValorFinal(this.tamanhoArquivo_);
        this.progressArquivo_.setValorAtual(this.bytesLidosArquivo_);
    }

    private static void mostrarSituacaoLeitura(Label label, Label label2, String string, int n, int n2, long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0) {
            stringBuffer.append(": ");
        }
        if (n == 0) {
            stringBuffer.append("tamanho ");
            PanelCopiarArquivo.formatarTamanho(stringBuffer, n2);
        } else {
            PanelCopiarArquivo.formatarTamanho(stringBuffer, n);
            stringBuffer.append(" de ");
            PanelCopiarArquivo.formatarTamanho(stringBuffer, n2);
        }
        if (l > 999L) {
            stringBuffer.append(" (");
            PanelCopiarArquivo.formatarTamanho(stringBuffer, (int)((long)n * 1000L / l));
            stringBuffer.append("/seg)");
            StringBuffer stringBuffer2 = new StringBuffer();
            PanelCopiarArquivo.formatarTempo(stringBuffer2, l);
            stringBuffer2.append(" decorrido");
            if (l2 > 0L) {
                stringBuffer2.append("; ");
                PanelCopiarArquivo.formatarTempo(stringBuffer2, l2);
                stringBuffer2.append(" termino; ");
                PanelCopiarArquivo.formatarTempo(stringBuffer2, l + l2);
                stringBuffer2.append(" total");
            }
            label2.setText(stringBuffer2.toString());
            label2.setFont(new Font("sansserif", 0, 12));
        } else {
            label2.setText("");
        }
        label.setText(stringBuffer.toString());
        label.setFont(new Font("sanserif", 0, 12));
    }

    private InfoArquivo procurarInfo(InfoArquivo[] infoArquivoArray, String string) {
        string = FileLoader.corrigeParaBarraPath(string);
        int n = infoArquivoArray.length - 1;
        while (n != -1) {
            if (infoArquivoArray[n].getNome().equalsIgnoreCase(string)) {
                return infoArquivoArray[n];
            }
            --n;
        }
        return null;
    }

    public void run() {
        while (this.totalCopiar_ != this.totalCopiado_) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {}
            long l = System.currentTimeMillis();
            if (l - this.ultimaExibicao_ <= 800L) continue;
            this.tempoAtual_ = l;
            this.mostrarSituacao();
        }
    }

    public void setLabelMsg(Label label) {
        this.lblMsg_ = label;
    }

    private void setMsg(String string) {
        if (this.lblMsg_ != null) {
            this.lblMsg_.setText(string);
        }
    }
}

