/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.data;

import br.com.bb.data.DataInvalidaException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class Data {
    private Calendar calendario = new GregorianCalendar();

    public Data() {
    }

    public Data(int n, int n2, int n3) throws DataInvalidaException {
        this();
        this.set(n, n2, n3);
    }

    public int compararCom(Data data) {
        long l = this.getTime() / 86400000L;
        long l2 = data.getTime() / 86400000L;
        Long l3 = new Long(l - l2);
        return l3.intValue();
    }

    public static String formatar(String string) throws DataInvalidaException {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 != 8) {
            throw new DataInvalidaException("Tamanho da data invalido");
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!Character.isDigit(string.charAt(n4))) {
                throw new DataInvalidaException("Data contem caracteres invalidos");
            }
            ++n4;
        }
        int n5 = Integer.parseInt(string.substring(0, 2));
        if (!Data.validar(n5, n2 = Integer.parseInt(string.substring(2, 4)), n = Integer.parseInt(string.substring(4)))) {
            throw new DataInvalidaException();
        }
        String string2 = string.substring(0, 2);
        string2 = String.valueOf(string2) + "/";
        string2 = String.valueOf(string2) + string.substring(2, 4);
        string2 = String.valueOf(string2) + "/";
        string2 = String.valueOf(string2) + string.substring(4);
        return string2;
    }

    public String get() {
        String string = "";
        int n = this.calendario.get(5);
        int n2 = this.calendario.get(2) + 1;
        int n3 = this.calendario.get(1);
        if (n < 10) {
            string = String.valueOf(string) + "0";
        }
        string = String.valueOf(string) + n;
        if (n2 < 10) {
            string = String.valueOf(string) + "0";
        }
        string = String.valueOf(string) + n2;
        string = String.valueOf(string) + n3;
        return string;
    }

    public String getFormatada() {
        String string;
        try {
            string = Data.formatar(this.get());
        }
        catch (DataInvalidaException dataInvalidaException) {
            string = "";
        }
        return string;
    }

    private static Data getPascoa(int n) {
        Data data;
        int n2;
        int n3;
        int n4 = n % 19 + 1;
        int n5 = n / 100 + 1;
        int n6 = 3 * n5 / 4 - 12;
        int n7 = (8 * n5 + 5) / 25 - 5;
        int n8 = 5 * n / 4 - n6 - 10;
        int n9 = (11 * n4 + 20 + n7 - n6) % 30;
        if (n9 == 25 && n4 > 11 || n9 == 24) {
            ++n9;
        }
        if ((n3 = 44 - n9) < 21) {
            n3 += 30;
        }
        if ((n3 = n3 + 7 - (n8 + n3) % 7) > 31) {
            n3 -= 31;
            n2 = 4;
        } else {
            n2 = 3;
        }
        try {
            data = new Data(n3, n2, n);
        }
        catch (DataInvalidaException dataInvalidaException) {
            return null;
        }
        return data;
    }

    public Data getProximaDataUtil() {
        String string = this.get();
        int n = Integer.parseInt(string.substring(0, 2));
        int n2 = Integer.parseInt(string.substring(2, 4));
        int n3 = Integer.parseInt(string.substring(4));
        Data data = new Data();
        try {
            data.set(n, n2, n3);
        }
        catch (DataInvalidaException dataInvalidaException) {}
        data.somarDiaUtil(1);
        return data;
    }

    private long getTime() {
        return this.calendario.getTime().getTime();
    }

    public boolean isDiaUtil() {
        int n = this.calendario.get(7);
        boolean bl = true;
        if (Data.isFeriadoNacional(this) || n == 1 || n == 7) {
            bl = false;
        }
        return bl;
    }

    private static boolean isFeriadoNacional(Data data) {
        String string = data.get().substring(0, 4);
        String string2 = data.get().substring(4);
        boolean bl = false;
        if (string.compareTo("0101") == 0 || string.compareTo("2104") == 0 || string.compareTo("0105") == 0 || string.compareTo("0709") == 0 || string.compareTo("1210") == 0 || string.compareTo("0211") == 0 || string.compareTo("1511") == 0 || string.compareTo("2512") == 0) {
            bl = true;
        } else {
            switch (data.compararCom(Data.getPascoa(Integer.parseInt(string2)))) {
                case -48: 
                case -47: 
                case -2: 
                case 60: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void set(int n, int n2, int n3) throws DataInvalidaException {
        if (!Data.validar(n, n2, n3)) {
            throw new DataInvalidaException();
        }
        this.calendario.set(n3, n2 - 1, n);
    }

    public void somarDia(int n) {
        this.calendario.add(5, n);
    }

    public void somarDiaUtil(int n) {
        int n2 = Math.abs(n);
        int n3 = n < 0 ? -1 : 1;
        int n4 = 0;
        while (n4 < n2) {
            do {
                this.somarDia(n3);
            } while (!this.isDiaUtil());
            ++n4;
        }
    }

    private static boolean validar(int n, int n2, int n3) {
        if (n3 < 1900 || n2 < 1 || n2 > 12 || n < 1) {
            return false;
        }
        int n4 = 31;
        switch (n2) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n4 = 30;
                break;
            }
            case 2: {
                if (n3 % 4 == 0 && n3 % 100 != 0 || n3 % 400 == 0) {
                    n4 = 29;
                    break;
                }
                n4 = 28;
                break;
            }
        }
        return n <= n4;
    }
}

