/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.pessoa;

import br.com.bb.pessoa.CGCInvalidoException;
import br.com.bb.pessoa.CGCNaoInformadoException;

public class CGC {
    private String valor;
    private boolean obrigatorio;

    public CGC() {
        this.obrigatorio = false;
    }

    public CGC(String string) throws CGCNaoInformadoException, CGCInvalidoException {
        this(string, false);
    }

    public CGC(String string, boolean bl) throws CGCNaoInformadoException, CGCInvalidoException {
        this.obrigatorio = bl;
        this.setValor(string);
    }

    public String getValor() throws CGCNaoInformadoException {
        String string = this.valor;
        if (string == null) {
            if (this.obrigatorio) {
                throw new CGCNaoInformadoException();
            }
            string = "";
        }
        return string;
    }

    public String getValorFormatado() throws CGCNaoInformadoException {
        String string = "";
        if (this.valor == null) {
            if (this.obrigatorio) {
                throw new CGCNaoInformadoException();
            }
        } else {
            string = String.valueOf(string) + this.valor.substring(0, 2) + ".";
            string = String.valueOf(string) + this.valor.substring(2, 5) + ".";
            string = String.valueOf(string) + this.valor.substring(5, 8) + "/";
            string = String.valueOf(string) + this.valor.substring(8, 12) + "-";
            string = String.valueOf(string) + this.valor.substring(12);
        }
        return string;
    }

    public boolean isValido() {
        boolean bl = true;
        try {
            CGC.validar(this.valor, this.obrigatorio);
        }
        catch (CGCNaoInformadoException cGCNaoInformadoException) {
            bl = false;
        }
        catch (CGCInvalidoException cGCInvalidoException) {
            bl = false;
        }
        return bl;
    }

    public void setValor(String string) throws CGCNaoInformadoException, CGCInvalidoException {
        CGC.validar(string, this.obrigatorio);
        this.valor = string;
    }

    private static boolean validar(String string, boolean bl) throws CGCNaoInformadoException, CGCInvalidoException {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        String string2 = "";
        if (string == null || string.compareTo("") == 0) {
            if (bl) {
                throw new CGCNaoInformadoException();
            }
            return true;
        }
        if (string.length() != 14) {
            throw new CGCInvalidoException("Tamanho do CGC invalido");
        }
        int n = 0;
        while (n < 14) {
            if (!Character.isDigit(string.charAt(n))) {
                throw new CGCInvalidoException("CGC contem caracteres invalidos");
            }
            ++n;
        }
        nArray[0] = Integer.parseInt(string.substring(0, 1));
        nArray[1] = Integer.parseInt(string.substring(1, 2));
        nArray[2] = Integer.parseInt(string.substring(2, 3));
        nArray[3] = Integer.parseInt(string.substring(3, 4));
        nArray[4] = Integer.parseInt(string.substring(4, 5));
        nArray[5] = Integer.parseInt(string.substring(5, 6));
        nArray[6] = Integer.parseInt(string.substring(6, 7));
        nArray[7] = Integer.parseInt(string.substring(7, 8));
        nArray[8] = Integer.parseInt(string.substring(8, 9));
        nArray[9] = Integer.parseInt(string.substring(9, 10));
        nArray[10] = Integer.parseInt(string.substring(10, 11));
        nArray[11] = Integer.parseInt(string.substring(11, 12));
        int n2 = 0;
        int n3 = 2;
        n = 11;
        while (n >= 0) {
            n2 += nArray[n] * n3++;
            if (n3 > 9) {
                n3 = 2;
            }
            --n;
        }
        int n4 = n2 % 11;
        nArray[12] = n4 == 0 || n4 == 1 ? 0 : 11 - n4;
        n2 = 0;
        n3 = 2;
        n = 12;
        while (n >= 0) {
            n2 += nArray[n] * n3++;
            if (n3 > 9) {
                n3 = 2;
            }
            --n;
        }
        n4 = n2 % 11;
        nArray[13] = n4 == 0 || n4 == 1 ? 0 : 11 - n4;
        string2 = string2.concat(Integer.toString(nArray[12]));
        string2 = string2.concat(Integer.toString(nArray[13]));
        if (string.substring(12).compareTo(string2) != 0) {
            throw new CGCInvalidoException("DV do CGC invalido");
        }
        return true;
    }
}

