/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.pessoa;

import br.com.bb.pessoa.CPFInvalidoException;
import br.com.bb.pessoa.CPFNaoInformadoException;

public class CPF {
    private String valor;
    private boolean obrigatorio;

    public CPF() {
        this.obrigatorio = false;
    }

    public CPF(String string) throws CPFNaoInformadoException, CPFInvalidoException {
        this(string, false);
    }

    public CPF(String string, boolean bl) throws CPFNaoInformadoException, CPFInvalidoException {
        this.obrigatorio = bl;
        this.setValor(string);
    }

    public String getValor() throws CPFNaoInformadoException {
        String string = this.valor;
        if (string == null) {
            if (this.obrigatorio) {
                throw new CPFNaoInformadoException();
            }
            string = "";
        }
        return string;
    }

    public String getValorFormatado() throws CPFNaoInformadoException {
        String string = "";
        if (this.valor == null) {
            if (this.obrigatorio) {
                throw new CPFNaoInformadoException();
            }
        } else {
            string = String.valueOf(string) + this.valor.substring(0, 3) + ".";
            string = String.valueOf(string) + this.valor.substring(3, 6) + ".";
            string = String.valueOf(string) + this.valor.substring(6, 9) + "-";
            string = String.valueOf(string) + this.valor.substring(9);
        }
        return string;
    }

    public boolean isValido() {
        boolean bl = true;
        try {
            CPF.validar(this.valor, this.obrigatorio);
        }
        catch (CPFNaoInformadoException cPFNaoInformadoException) {
            bl = false;
        }
        catch (CPFInvalidoException cPFInvalidoException) {
            bl = false;
        }
        return bl;
    }

    public void setValor(String string) throws CPFNaoInformadoException, CPFInvalidoException {
        CPF.validar(string, this.obrigatorio);
        this.valor = string;
    }

    public static boolean validar(String string, boolean bl) throws CPFNaoInformadoException, CPFInvalidoException {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int n = 0;
        String string2 = "";
        if (string == null || string.compareTo("") == 0) {
            if (bl) {
                throw new CPFNaoInformadoException();
            }
            return true;
        }
        if (string.length() != 11) {
            throw new CPFInvalidoException("Tamanho do CPF invalido");
        }
        int n2 = 0;
        while (n2 < 11) {
            if (!Character.isDigit(string.charAt(n2))) {
                throw new CPFInvalidoException("CPF contem caracteres invalidos");
            }
            ++n2;
        }
        nArray[0] = Integer.parseInt(string.substring(0, 1));
        nArray[1] = Integer.parseInt(string.substring(1, 2));
        nArray[2] = Integer.parseInt(string.substring(2, 3));
        nArray[3] = Integer.parseInt(string.substring(3, 4));
        nArray[4] = Integer.parseInt(string.substring(4, 5));
        nArray[5] = Integer.parseInt(string.substring(5, 6));
        nArray[6] = Integer.parseInt(string.substring(6, 7));
        nArray[7] = Integer.parseInt(string.substring(7, 8));
        nArray[8] = Integer.parseInt(string.substring(8, 9));
        n2 = 0;
        while (n2 < 9) {
            n += nArray[n2] * (11 - (n2 + 1));
            ++n2;
        }
        int n3 = 11 - n % 11;
        if (n3 == 10 || n3 == 11) {
            n3 = 0;
        }
        nArray[9] = n3;
        n = 0;
        n2 = 0;
        while (n2 < 10) {
            n += nArray[n2] * (12 - (n2 + 1));
            ++n2;
        }
        n3 = 11 - n % 11;
        if (n3 == 10 || n3 == 11) {
            n3 = 0;
        }
        nArray[10] = n3;
        string2 = string2.concat(Integer.toString(nArray[9]));
        string2 = string2.concat(Integer.toString(nArray[10]));
        if (string.substring(9).compareTo(string2) != 0) {
            throw new CPFInvalidoException("DV do CPF invalido");
        }
        return true;
    }
}

