/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.util;

public class MathUtils {
    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1996).\n\n";
    }

    private MathUtils() {
    }

    public static int getHighestCommonFactor(int n, int n2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n < n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        n3 = n % n2;
        while (n3 > 0) {
            int n4 = n2;
            n2 = n % n2;
            n = n4;
            n3 = n % n2;
        }
        return n2;
    }

    public static long getHighestCommonFactor(long l, long l2) {
        long l3;
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l < l2) {
            l3 = l;
            l = l2;
            l2 = l3;
        }
        l3 = l % l2;
        while (l3 > 0L) {
            long l4 = l2;
            l2 = l % l2;
            l = l4;
            l3 = l % l2;
        }
        return l2;
    }

    public static int getNumberOfBits(int n) {
        int n2 = 0;
        while (n != 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    public static int getNumberOfDigits(int n, int n2) {
        int n3 = 0;
        while (n > 0) {
            n /= n2;
            ++n3;
        }
        return n3;
    }

    public static int roundUpToNextMultiple(int n, int n2) {
        if (n2 < 0) {
            n2 = -n2;
        } else if (n2 == 0) {
            throw new IllegalArgumentException("multiple is zero");
        }
        return n + ((n2 - n) % n2 + n2) % n2;
    }

    public static int roundDownToNextMultiple(int n, int n2) {
        if (n2 < 0) {
            n2 = -n2;
        } else if (n2 == 0) {
            throw new IllegalArgumentException("multiple is zero");
        }
        return n - (n % n2 + n2) % n2;
    }

    public static int pow(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("exponent must be positive");
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < n2 - 1) {
            n3 *= n;
            ++n4;
        }
        return n3;
    }
}

