/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.util;

import com.ibm.eou.toolkit.util.ArrayUtils;
import java.text.BreakIterator;
import java.util.Locale;

public class TextUtils {
    public static final char LEADING = 'l';
    public static final char TRAILING = 't';
    public static final char BOTH = 'b';
    public static final int UPPER_CASE = 1;
    public static final int LOWER_CASE = 2;
    public static final int TITLE_CASE_STRICT = 3;
    public static final int TITLE_CASE_LENIENT = 4;

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1996).\n\n";
    }

    private TextUtils() {
    }

    public static char[] getDistinctChars(String string) {
        return TextUtils.getDistinctChars(string, 0);
    }

    public static char[] getDistinctChars(String string, int n) {
        String string2 = "";
        int n2 = n;
        while (n2 < string.length()) {
            if (string2.indexOf(String.valueOf(string.charAt(n2)), n) == -1) {
                string2 = String.valueOf(string2) + "" + string.charAt(n2);
            }
            ++n2;
        }
        return string2.toCharArray();
    }

    public static int indexOf(String string, char[] cArray) {
        return TextUtils.indexOf(string, 0, cArray);
    }

    public static int indexOf(String string, int n, char[] cArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < cArray.length) {
            int n4 = string.indexOf(cArray[n3], n);
            if (n4 != -1) {
                n2 = Math.min(n2, n4);
            }
            ++n3;
        }
        if (n2 == Integer.MAX_VALUE) {
            return -1;
        }
        return n2;
    }

    public static int lastIndexOf(String string, char[] cArray) {
        return TextUtils.lastIndexOf(string, string.length() - 1, cArray);
    }

    public static int lastIndexOf(String string, int n, char[] cArray) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < cArray.length) {
            int n4 = string.lastIndexOf(cArray[n3], n);
            if (n4 != -1) {
                n2 = Math.max(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    public static int indexOfNonMatching(String string, char[] cArray) {
        return TextUtils.indexOfNonMatching(string, 0, cArray);
    }

    public static int indexOfNonMatching(String string, int n, char[] cArray) {
        boolean bl = false;
        int n2 = n;
        boolean bl2 = false;
        while (!bl && n2 < string.length()) {
            bl2 = false;
            int n3 = 0;
            while (n3 < cArray.length) {
                if (string.charAt(n2) == cArray[n3]) {
                    bl2 = true;
                }
                ++n3;
            }
            if (!bl2) {
                bl = true;
                continue;
            }
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public static int lastIndexOfNonMatching(String string, char[] cArray) {
        return TextUtils.lastIndexOfNonMatching(string, string.length() - 1, cArray);
    }

    public static int lastIndexOfNonMatching(String string, int n, char[] cArray) {
        if (n >= string.length()) {
            n = string.length() - 1;
        }
        boolean bl = false;
        int n2 = n;
        while (!bl && n2 >= 0) {
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < cArray.length) {
                if (string.charAt(n2) == cArray[n3]) {
                    bl2 = true;
                }
                ++n3;
            }
            if (!bl2) {
                bl = true;
                continue;
            }
            --n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public static int indexOfNonWhitespace(String string) {
        return TextUtils.indexOfNonWhitespace(string, 0);
    }

    public static int indexOfNonWhitespace(String string, int n) {
        boolean bl = false;
        int n2 = n;
        while (!bl && n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                bl = true;
                continue;
            }
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public static int lastIndexOfNonWhitespace(String string) {
        return TextUtils.lastIndexOfNonWhitespace(string, string.length() - 1);
    }

    public static int lastIndexOfNonWhitespace(String string, int n) {
        if (n >= string.length() - 1) {
            n = string.length() - 1;
        }
        boolean bl = false;
        int n2 = n;
        while (!bl && n2 >= 0) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                bl = true;
                continue;
            }
            --n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public static int indexOfNonZero(String string) {
        return TextUtils.indexOfNonZero(string, 0);
    }

    public static int indexOfNonZero(String string, int n) {
        boolean bl = false;
        int n2 = n;
        while (!bl && n2 < string.length()) {
            if (Character.digit(string.charAt(n2), 10) != 0) {
                bl = true;
                continue;
            }
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public static int lastIndexOfNonZero(String string) {
        return TextUtils.lastIndexOfNonZero(string, string.length() - 1);
    }

    public static int lastIndexOfNonZero(String string, int n) {
        if (n >= string.length() - 1) {
            n = string.length() - 1;
        }
        boolean bl = false;
        int n2 = n;
        while (!bl && n2 >= 0) {
            if (Character.digit(string.charAt(n2), 10) != 0) {
                bl = true;
                continue;
            }
            --n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public static String createGroupedString(String string, int n, char c, boolean bl) {
        String string2 = "";
        int n2 = string.length();
        int n3 = string.length() % n;
        if (bl) {
            if (n3 != 0) {
                string2 = string.substring(0, n3);
                if (n2 > n) {
                    string2 = String.valueOf(string2) + c;
                }
            }
            int n4 = Math.max(0, n2 - n);
            int n5 = n3;
            while (n5 < n4) {
                string2 = String.valueOf(string2) + string.substring(n5, n5 + n) + c;
                n5 += n;
            }
            if (n2 >= n) {
                string2 = String.valueOf(string2) + string.substring(n2 - n);
            }
        } else {
            int n6 = Math.max(0, n2 - n3);
            if (n2 > n) {
                int n7 = 0;
                while (n7 < n6) {
                    string2 = String.valueOf(string2) + string.substring(n7, n7 + n) + c;
                    n7 += n;
                }
            } else {
                string2 = string;
            }
            if (n2 > n) {
                string2 = String.valueOf(string2) + string.substring(n6);
            }
        }
        return string2;
    }

    public static String createPaddedString(String string, int n) {
        return TextUtils.createPaddedString(string, n, ' ', 't', string.length());
    }

    public static String createPaddedString(String string, int n, char c) {
        return TextUtils.createPaddedString(string, n, c, 't', string.length());
    }

    public static String createPaddedString(String string, int n, char c, char c2) {
        return TextUtils.createPaddedString(string, n, c, c2, string.length());
    }

    public static String createPaddedString(String string, int n, char c, char c2, int n2) {
        int n3 = string.length();
        String string2 = string;
        if (n3 > n2) {
            if (c2 == 't') {
                string2 = string.substring(0, n2);
            } else if (c2 == 'l') {
                string2 = string.substring(n3 - n2);
            } else if (c2 == 'b') {
                int n4 = (1 + n3 - n2) / 2;
                string2 = string.substring(n4, n2 + n4);
            }
        } else if (n3 < n) {
            if (c2 == 't') {
                string2 = String.valueOf(string) + TextUtils.createRepeatedString(c, n - n3);
            } else if (c2 == 'l') {
                string2 = String.valueOf(TextUtils.createRepeatedString(c, n - n3)) + string;
            } else if (c2 == 'b') {
                int n5 = (1 + n - n3) / 2;
                string2 = String.valueOf(TextUtils.createRepeatedString(c, n5)) + string + TextUtils.createRepeatedString(c, n - n3 - n5);
            }
        }
        return string2;
    }

    public static String createRepeatedString(char c, int n) {
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return String.valueOf(c);
        }
        boolean bl = n % 2 == 1;
        String string = TextUtils.createRepeatedString(c, n / 2);
        if (bl) {
            return String.valueOf(c) + string + string;
        }
        return String.valueOf(string) + string;
    }

    public static String createRepeatedString(String string, int n) {
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return string;
        }
        boolean bl = n % 2 == 1;
        String string2 = TextUtils.createRepeatedString(string, n / 2);
        if (bl) {
            return String.valueOf(string) + string2 + string2;
        }
        return String.valueOf(string2) + string2;
    }

    public static String createFilteredString(String string, int n, boolean bl, boolean bl2, char[] cArray) {
        String string2 = "";
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (n > 0 && Character.digit(c, n) >= 0 || bl && Character.isLetter(c) || bl2 && Character.isWhitespace(c) || cArray != null && ArrayUtils.indexOf(cArray, c, 0) != -1) {
                string2 = String.valueOf(string2) + c;
            }
            ++n2;
        }
        return string2;
    }

    public static String createFilteredOutString(String string, char[] cArray) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (ArrayUtils.indexOf(cArray, c, 0) == -1) {
                string2 = String.valueOf(string2) + c;
            }
            ++n;
        }
        return string2;
    }

    public static String toTitleCase(String string) {
        return TextUtils.toCase(string, 4, null);
    }

    public static String toTitleCase(String string, Locale locale) {
        return TextUtils.toCase(string, 4, locale);
    }

    public static String toCase(String string, int n) {
        return TextUtils.toCase(string, n, null);
    }

    public static String toCase(String string, int n, Locale locale) {
        BreakIterator breakIterator = locale != null ? BreakIterator.getWordInstance(locale) : BreakIterator.getWordInstance();
        breakIterator.setText(string);
        String string2 = "";
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        while (n3 != -1) {
            switch (n) {
                case 1: {
                    string2 = String.valueOf(string2) + string.substring(n2, n3).toUpperCase();
                    break;
                }
                case 2: {
                    string2 = String.valueOf(string2) + string.substring(n2, n3).toLowerCase();
                    break;
                }
                case 3: {
                    string2 = String.valueOf(string2) + Character.toTitleCase(string.charAt(n2)) + string.substring(n2 + 1, n3).toLowerCase();
                    break;
                }
                case 4: {
                    string2 = String.valueOf(string2) + Character.toTitleCase(string.charAt(n2)) + string.substring(n2 + 1, n3);
                }
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        return string2;
    }
}

