/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.image;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class MaskedImageFilter
extends RGBImageFilter {
    public static final int DEFAULT_THRESHOLD = 128;
    public static final Color DEFAULT_FOREGROUND = Color.gray;
    public static final Color DEFAULT_BACKGROUND = Color.lightGray;
    private int fThreshold = 128;
    private int fFR;
    private int fFG;
    private int fFB;
    private int fBR;
    private int fBG;
    private int fBB;
    private Color fForeground;
    private Color fBackground;

    public MaskedImageFilter() {
        this.setForeground(DEFAULT_FOREGROUND);
        this.setBackground(DEFAULT_BACKGROUND);
    }

    public MaskedImageFilter(int n) {
        this();
        this.setThreshold(n);
    }

    public MaskedImageFilter(Color color, Color color2) {
        this.setForeground(color);
        this.setBackground(color2);
    }

    public MaskedImageFilter(int n, Color color, Color color2) {
        this.setThreshold(n);
        this.setForeground(color);
        this.setBackground(color2);
    }

    public synchronized void setThreshold(int n) {
        if (n >= 0 && n <= 255) {
            this.fThreshold = n;
            return;
        }
        this.fThreshold = 128;
    }

    public int getThreshold() {
        return this.fThreshold;
    }

    public synchronized void setForeground(Color color) {
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        this.fFR = color.getRed();
        this.fFG = color.getGreen();
        this.fFB = color.getBlue();
        this.fForeground = color;
    }

    public Color getForeground() {
        return this.fForeground;
    }

    public synchronized void setBackground(Color color) {
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        this.fBR = color.getRed();
        this.fBG = color.getGreen();
        this.fBB = color.getBlue();
        this.fBackground = color;
    }

    public Color getBackground() {
        return this.fBackground;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = (n3 & 0xFF000000) >> 24;
        int n5 = (n3 & 0xFF0000) >> 16;
        int n6 = (n3 & 0xFF00) >> 8;
        int n7 = n3 & 0xFF;
        int n8 = (n5 + n6 + n7) / 3;
        if (n8 < this.fThreshold) {
            return n4 << 24 | this.fFR << 16 | this.fFG << 8 | this.fFB;
        }
        return n4 << 24 | this.fBR << 16 | this.fBG << 8 | this.fBB;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("threshold=" + this.fThreshold);
        stringBuffer.append(",foreground=" + this.fForeground);
        stringBuffer.append(",background=" + this.fBackground);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

