/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;

public class AWT {
    public static void waitForImage(Image image) throws InterruptedException {
        if (image == null) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(null);
        mediaTracker.addImage(image, 0);
        mediaTracker.waitForID(0);
    }

    public static void waitForImages(Image[] imageArray) throws InterruptedException {
        if (imageArray == null) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(null);
        int n = 0;
        while (n < imageArray.length) {
            mediaTracker.addImage(imageArray[n], n);
            ++n;
        }
        mediaTracker.waitForAll();
    }

    public static Frame getFrame(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof Frame) {
                return (Frame)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    public static Point getAbsoluteLocation(Component component) {
        Point point = component.getLocation();
        Container container = component.getParent();
        if (container != null) {
            Point point2 = AWT.getAbsoluteLocation(container);
            point.x += point2.x;
            point.y += point2.y;
        }
        return point;
    }

    public static String eventName(Event event) {
        switch (event.id) {
            case 1001: {
                return "ACTION_EVENT";
            }
            case 403: {
                return "KEY_ACTION";
            }
            case 401: {
                return "KEY_PRESS";
            }
            case 402: {
                return "KEY_RELEASE";
            }
            case 1004: {
                return "GOT_FOCUS";
            }
            case 1005: {
                return "LOST_FOCUS";
            }
            case 501: {
                return "MOUSE_DOWN";
            }
            case 506: {
                return "MOUSE_DRAG";
            }
            case 502: {
                return "MOUSE_UP";
            }
            case 503: {
                return "MOUSE_MOVE";
            }
            case 504: {
                return "MOUSE_ENTER";
            }
            case 505: {
                return "MOUSE_EXIT";
            }
            case 701: {
                return "LIST_SELECT";
            }
            case 702: {
                return "LIST_DESELECT";
            }
            case 601: {
                return "SCROLL_LINE_UP";
            }
            case 602: {
                return "SCROLL_LINE_DOWN";
            }
            case 603: {
                return "SCROLL_PAGE_UP";
            }
            case 604: {
                return "SCROLL_PAGE_DOWN";
            }
            case 605: {
                return "SCROLL_ABSOLUTE";
            }
            case 201: {
                return "WINDOW_DESTROY";
            }
            case 203: {
                return "WINDOW_ICONIFY";
            }
            case 204: {
                return "WINDOW_DEICONIFY";
            }
            case 205: {
                return "WINDOW_MOVED";
            }
        }
        return "Unknown ID (" + event.id + ")";
    }
}

