/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.util;

import com.ibm.webrunner.util.TableModel;
import com.ibm.webrunner.util.event.TableEvent;
import com.ibm.webrunner.util.event.TableListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileTable
extends TableModel {
    public static final int TEXT = 0;
    public static final int BINARY = 1;
    public static final int DEFAULT_MODE = 0;
    public static final String DEFAULT_FILENAME = "table.txt";
    public static final char DEFAULT_SEPARATOR = ',';
    private transient Vector fColumnInfo;
    private transient Vector fRowInfo;
    private transient Vector fColumns;
    private transient Vector fTableListeners;
    private boolean fOpened = false;
    private String fFilename = "table.txt";
    private int fMode = 0;
    private boolean fFirstLine = true;
    private char fSeparator = (char)44;
    private transient IOException fLastError;
    private transient PropertyChangeSupport fChanges;

    public FileTable() {
        this(DEFAULT_FILENAME, 0);
    }

    public FileTable(String string) {
        this(string, 0);
    }

    public FileTable(String string, int n) {
        this.setFilename(string);
        this.setMode(n);
        this.init();
    }

    private void init() {
        this.fColumnInfo = new Vector(5, 5);
        this.fRowInfo = new Vector(50, 50);
        this.fColumns = new Vector(5, 5);
        this.fTableListeners = new Vector();
        this.fChanges = new PropertyChangeSupport(this);
        if (this.fOpened) {
            this.readTable();
        }
    }

    public void readTable() {
        Serializable serializable = this;
        synchronized (serializable) {
            block23: {
                this.fColumnInfo.removeAllElements();
                this.fColumns.removeAllElements();
                this.fRowInfo.removeAllElements();
                try {
                    if (this.fMode == 0) {
                        Tokenizer tokenizer;
                        String string;
                        FileReader fileReader = new FileReader(this.fFilename);
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        int n = 0;
                        int n2 = 0;
                        if (this.fFirstLine && (string = bufferedReader.readLine()) != null) {
                            tokenizer = new Tokenizer(string, this.fSeparator);
                            while (tokenizer.hasMoreTokens()) {
                                this.fColumnInfo.addElement(tokenizer.nextToken());
                                this.fColumns.addElement(new Vector(50, 50));
                                ++n;
                            }
                        }
                        while ((string = bufferedReader.readLine()) != null) {
                            tokenizer = new Tokenizer(string, this.fSeparator);
                            int n3 = 0;
                            while (tokenizer.hasMoreTokens()) {
                                Vector<String> vector;
                                if (n3 >= n) {
                                    this.fColumnInfo.addElement(null);
                                    vector = new Vector<String>(50, 50);
                                    this.fColumns.addElement(vector);
                                    int n4 = 0;
                                    while (n4 < n2) {
                                        vector.addElement(null);
                                        ++n4;
                                    }
                                    ++n;
                                }
                                vector = (Vector<String>)this.fColumns.elementAt(n3);
                                vector.addElement(tokenizer.nextToken());
                                ++n3;
                            }
                            this.fRowInfo.addElement(null);
                            ++n2;
                        }
                        bufferedReader.close();
                        break block23;
                    }
                    if (this.fMode != 1) break block23;
                    FileInputStream fileInputStream = new FileInputStream(this.fFilename);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    int n = objectInputStream.readInt();
                    int n5 = objectInputStream.readInt();
                    int n6 = 0;
                    while (n6 < n5) {
                        try {
                            this.fColumnInfo.addElement(objectInputStream.readObject());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.fColumnInfo.addElement(null);
                        }
                        ++n6;
                    }
                    int n7 = 0;
                    while (n7 < n) {
                        try {
                            this.fRowInfo.addElement(objectInputStream.readObject());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.fRowInfo.addElement(null);
                        }
                        ++n7;
                    }
                    int n8 = 0;
                    while (n8 < n5) {
                        Vector<Object> vector = new Vector<Object>(n, 50);
                        this.fColumns.addElement(vector);
                        int n9 = 0;
                        while (n9 < n) {
                            try {
                                vector.addElement(objectInputStream.readObject());
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                vector.addElement(null);
                            }
                            ++n;
                        }
                        ++n8;
                    }
                    objectInputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.fLastError = fileNotFoundException;
                    this.fOpened = false;
                }
                catch (IOException iOException) {
                    this.fLastError = iOException;
                }
            }
        }
        serializable = new TableEvent(this, 1, -1, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public synchronized void writeTable() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fFilename);
            if (this.fMode == 0) {
                int n;
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                int n2 = this.fRowInfo.size();
                int n3 = this.fColumnInfo.size();
                if (this.fFirstLine) {
                    n = 0;
                    while (n < n3) {
                        printWriter.print('\"');
                        StringTokenizer stringTokenizer = new StringTokenizer(this.fColumnInfo.elementAt(n).toString(), "\"");
                        while (stringTokenizer.hasMoreElements()) {
                            printWriter.print(stringTokenizer.nextElement());
                            if (!stringTokenizer.hasMoreElements()) continue;
                            printWriter.print("\"\"");
                        }
                        printWriter.print('\"');
                        printWriter.print(this.fSeparator);
                        ++n;
                    }
                }
                n = 0;
                while (n < n2) {
                    int n4 = 0;
                    while (n4 < n3) {
                        Vector vector = (Vector)this.fColumns.elementAt(n4);
                        printWriter.print('\"');
                        StringTokenizer stringTokenizer = new StringTokenizer(vector.elementAt(n).toString(), "\"");
                        while (stringTokenizer.hasMoreElements()) {
                            printWriter.print(stringTokenizer.nextElement());
                            if (!stringTokenizer.hasMoreElements()) continue;
                            printWriter.print("\"\"");
                        }
                        printWriter.print('\"');
                        printWriter.print(this.fSeparator);
                        ++n4;
                    }
                    printWriter.println();
                    ++n;
                }
            } else if (this.fMode == 1) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                int n = this.fRowInfo.size();
                int n5 = this.fColumnInfo.size();
                objectOutputStream.writeInt(n);
                objectOutputStream.writeInt(n5);
                int n6 = 0;
                while (n6 < n5) {
                    objectOutputStream.writeObject(this.fColumnInfo.elementAt(n6));
                    ++n6;
                }
                int n7 = 0;
                while (n7 < n) {
                    objectOutputStream.writeObject(this.fRowInfo.elementAt(n7));
                    ++n7;
                }
                int n8 = 0;
                while (n8 < n5) {
                    Vector vector = (Vector)this.fColumns.elementAt(n8);
                    int n9 = 0;
                    while (n9 < n) {
                        objectOutputStream.writeObject(vector.elementAt(n9));
                        ++n9;
                    }
                    ++n8;
                }
            }
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.fLastError = iOException;
            return;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public IOException getLastError() {
        return this.fLastError;
    }

    public synchronized void setOpened(boolean bl) {
        Boolean bl2;
        Boolean bl3 = this.fOpened ? Boolean.TRUE : Boolean.FALSE;
        this.fOpened = bl;
        if (this.fOpened) {
            this.readTable();
        }
        Boolean bl4 = bl2 = this.fOpened ? Boolean.TRUE : Boolean.FALSE;
        if (!bl3.equals(bl2)) {
            this.fChanges.firePropertyChange("opened", bl3, bl2);
        }
    }

    public boolean isOpened() {
        return this.fOpened;
    }

    public synchronized void setFilename(String string) {
        if (string == null) {
            string = DEFAULT_FILENAME;
        }
        this.fFilename = string;
        this.setOpened(false);
    }

    public String getFilename() {
        return this.fFilename;
    }

    public synchronized void setMode(int n) {
        if (n != 0 && n != 1) {
            n = 0;
        }
        this.fMode = n;
        this.setOpened(false);
    }

    public int getMode() {
        return this.fMode;
    }

    public synchronized void setFirstLineColumnNames(boolean bl) {
        if (this.fFirstLine != bl) {
            this.fFirstLine = bl;
        }
        this.setOpened(false);
    }

    public boolean isFirstLineColumnNames() {
        return this.fFirstLine;
    }

    public synchronized void setSeparator(char c) {
        this.fSeparator = c;
        this.setOpened(false);
    }

    public char getSeparator() {
        return this.fSeparator;
    }

    public void fireTableEvent(TableEvent tableEvent) {
        Vector vector = (Vector)this.fTableListeners.clone();
        int n = vector.size();
        switch (tableEvent.getID()) {
            case 0: {
                int n2 = 0;
                while (n2 < n) {
                    ((TableListener)vector.elementAt(n2)).tableRefreshed(tableEvent);
                    ++n2;
                }
                return;
            }
            case 1: {
                int n3 = 0;
                while (n3 < n) {
                    ((TableListener)vector.elementAt(n3)).tableChanged(tableEvent);
                    ++n3;
                }
                return;
            }
            case 2: {
                int n4 = 0;
                while (n4 < n) {
                    ((TableListener)vector.elementAt(n4)).columnChanged(tableEvent);
                    ++n4;
                }
                return;
            }
            case 3: {
                int n5 = 0;
                while (n5 < n) {
                    ((TableListener)vector.elementAt(n5)).rowChanged(tableEvent);
                    ++n5;
                }
                return;
            }
            case 4: {
                int n6 = 0;
                while (n6 < n) {
                    ((TableListener)vector.elementAt(n6)).elementChanged(tableEvent);
                    ++n6;
                }
                return;
            }
            case 5: {
                int n7 = 0;
                while (n7 < n) {
                    ((TableListener)vector.elementAt(n7)).columnInfoChanged(tableEvent);
                    ++n7;
                }
                return;
            }
            case 6: {
                int n8 = 0;
                while (n8 < n) {
                    ((TableListener)vector.elementAt(n8)).columnAdded(tableEvent);
                    ++n8;
                }
                return;
            }
            case 7: {
                int n9 = 0;
                while (n9 < n) {
                    ((TableListener)vector.elementAt(n9)).columnRemoved(tableEvent);
                    ++n9;
                }
                return;
            }
            case 8: {
                int n10 = 0;
                while (n10 < n) {
                    ((TableListener)vector.elementAt(n10)).columnInserted(tableEvent);
                    ++n10;
                }
                return;
            }
            case 9: {
                int n11 = 0;
                while (n11 < n) {
                    ((TableListener)vector.elementAt(n11)).rowInfoChanged(tableEvent);
                    ++n11;
                }
                return;
            }
            case 10: {
                int n12 = 0;
                while (n12 < n) {
                    ((TableListener)vector.elementAt(n12)).rowAdded(tableEvent);
                    ++n12;
                }
                return;
            }
            case 11: {
                int n13 = 0;
                while (n13 < n) {
                    ((TableListener)vector.elementAt(n13)).rowRemoved(tableEvent);
                    ++n13;
                }
                return;
            }
            case 12: {
                int n14 = 0;
                while (n14 < n) {
                    ((TableListener)vector.elementAt(n14)).rowInserted(tableEvent);
                    ++n14;
                }
                return;
            }
        }
    }

    public void addTableListener(TableListener tableListener) {
        this.fTableListeners.addElement(tableListener);
    }

    public void removeTableListener(TableListener tableListener) {
        this.fTableListeners.removeElement(tableListener);
    }

    public void setElement(Object object, int n, int n2) {
        Serializable serializable = this;
        synchronized (serializable) {
            block7: {
                block9: {
                    block8: {
                        int n3 = this.fColumns.size();
                        if (n2 < 0) break block8;
                        if (n2 < n3) break block9;
                    }
                    Object var5_6 = null;
                    return;
                }
                int n4 = ((Vector)this.fColumns.elementAt(0)).size();
                if (n < 0) break block7;
                if (n < n4) break block10;
            }
            Object var5_7 = null;
            {
                block10: {
                    return;
                }
                ((Vector)this.fColumns.elementAt(n2)).setElementAt(object, n);
            }
        }
        serializable = new TableEvent(this, 4, n, n2);
        this.fireTableEvent((TableEvent)serializable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getElement(int n, int n2) {
        FileTable fileTable = this;
        synchronized (fileTable) {
            int n3 = this.fColumnInfo.size();
            if (n2 < 0) return null;
            if (n2 >= n3) {
                return null;
            }
            int n4 = this.fRowInfo.size();
            if (n < 0) return null;
            if (n < n4) return ((Vector)this.fColumns.elementAt(n2)).elementAt(n);
            return null;
        }
    }

    public int getColumnCount() {
        return this.fColumnInfo.size();
    }

    public void setColumnInfo(Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            block6: {
                block5: {
                    int n2 = this.fColumnInfo.size();
                    if (n < 0) break block5;
                    if (n < n2) break block6;
                }
                Object var4_5 = null;
                return;
            }
            this.fColumnInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 5, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public Object getColumnInfo(int n) {
        FileTable fileTable = this;
        synchronized (fileTable) {
            int n2 = this.fColumnInfo.size();
            if (n < 0 || n >= n2) {
                Object var2_4 = null;
                Object var4_6 = null;
                return var2_4;
            }
            Object e = this.fColumnInfo.elementAt(n);
            Object var4_7 = null;
            return e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getColumnIndex(Object object) {
        FileTable fileTable = this;
        synchronized (fileTable) {
            int n = this.fColumnInfo.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.fColumnInfo.elementAt(n2);
                if (object == null ? e == null : e != null && e.equals(object)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
    }

    public void addColumn(Object[] objectArray, Object object) {
        int n = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n = this.fColumnInfo.size();
            Vector<Object> vector = new Vector<Object>(50, 25);
            this.fColumnInfo.addElement(object);
            this.fColumns.addElement(vector);
            int n2 = this.fRowInfo.size();
            int n3 = 0;
            while (n3 < n2) {
                if (objectArray == null || n3 >= objectArray.length) {
                    vector.addElement(null);
                } else {
                    vector.addElement(objectArray[n3]);
                }
                ++n3;
            }
        }
        serializable = new TableEvent(this, 6, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeColumn(int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            block8: {
                block7: {
                    if (n < 0) break block7;
                    if (n < this.fColumnInfo.size()) break block8;
                }
                Object var3_3 = null;
                return;
            }
            this.fColumnInfo.removeElementAt(n);
            this.fColumns.removeElementAt(n);
            if (this.fColumns.size() == 0) {
                this.fRowInfo.removeAllElements();
            }
        }
        serializable = new TableEvent(this, 7, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeAllColumns() {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.fColumnInfo.size() == 0) {
                Object var2_2 = null;
                return;
            }
            this.fColumnInfo.removeAllElements();
            this.fColumns.removeAllElements();
            this.fRowInfo.removeAllElements();
        }
        serializable = new TableEvent(this, 1, -1, -2);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void insertColumn(Object[] objectArray, Object object, int n) {
        int n2 = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n2 = this.fColumnInfo.size();
            if (n < 0) {
                n = 0;
            }
            if (n < n2) {
                Vector<Object> vector = new Vector<Object>(50, 25);
                this.fColumnInfo.insertElementAt(object, n);
                this.fColumns.insertElementAt(vector, n);
                int n3 = this.fRowInfo.size();
                int n4 = 0;
                while (n4 < n3) {
                    if (objectArray == null || n4 >= objectArray.length) {
                        vector.insertElementAt(null, n4);
                    } else {
                        vector.insertElementAt(objectArray[n4], n4);
                    }
                    ++n4;
                }
            }
        }
        if (n >= n2) {
            this.addColumn(objectArray, object);
            return;
        }
        serializable = new TableEvent(this, 8, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void replaceColumn(Object[] objectArray, Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            block10: {
                block9: {
                    int n2 = this.fColumnInfo.size();
                    if (n < 0) break block9;
                    if (n < n2) break block10;
                }
                Object var5_6 = null;
                return;
            }
            Vector vector = (Vector)this.fColumns.elementAt(n);
            int n3 = this.fRowInfo.size();
            int n4 = 0;
            while (n4 < n3) {
                if (objectArray == null || n4 >= objectArray.length) {
                    vector.setElementAt(null, n4);
                } else {
                    vector.setElementAt(objectArray[n4], n4);
                }
                ++n4;
            }
        }
        serializable = new TableEvent(this, 2, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public int getRowCount() {
        FileTable fileTable = this;
        synchronized (fileTable) {
            int n = this.fColumnInfo.size();
            if (n > 0) {
                n = ((Vector)this.fColumns.elementAt(0)).size();
            }
            int n2 = n;
            Object var3_4 = null;
            return n2;
        }
    }

    public void setRowInfo(Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            block6: {
                block5: {
                    int n2 = this.fRowInfo.size();
                    if (n < 0) break block5;
                    if (n < n2) break block6;
                }
                Object var4_5 = null;
                return;
            }
            this.fRowInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 9, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public Object getRowInfo(int n) {
        FileTable fileTable = this;
        synchronized (fileTable) {
            int n2 = this.fRowInfo.size();
            if (n < 0 || n >= n2) {
                Object var2_4 = null;
                Object var4_6 = null;
                return var2_4;
            }
            Object e = this.fRowInfo.elementAt(n);
            Object var4_7 = null;
            return e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRowIndex(Object object) {
        FileTable fileTable = this;
        synchronized (fileTable) {
            int n = this.fRowInfo.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.fRowInfo.elementAt(n2);
                if (object == null ? e == null : e != null && e.equals(object)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
    }

    public void addRow(Object[] objectArray, Object object) {
        int n = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n = this.getRowCount();
            int n2 = this.fColumnInfo.size();
            if (n2 == 0) {
                Object var5_6 = null;
                return;
            }
            this.fRowInfo.addElement(object);
            int n3 = 0;
            while (n3 < n2) {
                Vector vector = (Vector)this.fColumns.elementAt(n3);
                if (objectArray == null || n3 >= objectArray.length) {
                    vector.addElement(null);
                } else {
                    vector.addElement(objectArray[n3]);
                }
                ++n3;
            }
        }
        serializable = new TableEvent(this, 10, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeRow(int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2;
            block8: {
                n2 = this.fColumnInfo.size();
                if (n2 == 0) {
                    Object var3_4 = null;
                    return;
                }
                int n3 = ((Vector)this.fColumns.elementAt(0)).size();
                if (n < 0) break block8;
                if (n < n3) break block9;
            }
            Object var3_5 = null;
            {
                block9: {
                    return;
                }
                this.fRowInfo.removeElementAt(n);
                int n4 = 0;
                while (n4 < n2) {
                    Vector vector = (Vector)this.fColumns.elementAt(n4);
                    vector.removeElementAt(n);
                    ++n4;
                }
            }
        }
        serializable = new TableEvent(this, 11, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeAllRows() {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.fRowInfo.size() == 0) {
                Object var2_2 = null;
                return;
            }
            this.fRowInfo.removeAllElements();
            int n = this.fColumns.size();
            int n2 = 0;
            while (n2 < n) {
                Vector vector = (Vector)this.fColumns.elementAt(n2);
                vector.removeAllElements();
                ++n2;
            }
        }
        serializable = new TableEvent(this, 11, -2, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void insertRow(Object[] objectArray, Object object, int n) {
        int n2 = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n2 = this.fRowInfo.size();
            if (n < 0) {
                n = 0;
            }
            if (n < n2) {
                this.fRowInfo.insertElementAt(object, n);
                int n3 = this.fColumnInfo.size();
                int n4 = 0;
                while (n4 < n3) {
                    Vector vector = (Vector)this.fColumns.elementAt(n4);
                    if (objectArray == null || n4 >= objectArray.length) {
                        vector.insertElementAt(null, n);
                    } else {
                        vector.insertElementAt(objectArray[n4], n);
                    }
                    ++n4;
                }
            }
        }
        if (n >= n2) {
            this.addRow(objectArray, object);
            return;
        }
        serializable = new TableEvent(this, 12, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void replaceRow(Object[] objectArray, Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            block10: {
                block9: {
                    int n2 = this.fRowInfo.size();
                    if (n < 0) break block9;
                    if (n < n2) break block10;
                }
                Object var5_6 = null;
                return;
            }
            int n3 = this.fColumnInfo.size();
            int n4 = 0;
            while (n4 < n3) {
                Vector vector = (Vector)this.fColumns.elementAt(n4);
                if (objectArray == null || n4 >= objectArray.length) {
                    vector.setElementAt(null, n);
                } else {
                    vector.setElementAt(objectArray[n4], n);
                }
                ++n4;
            }
            this.fRowInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 3, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    class Tokenizer {
        private String fLine;
        private char fSeparator;
        private int fLength;
        private int fPlace;

        public Tokenizer(String string, char c) {
            FileTable.this = FileTable.this;
            this.fLine = string;
            this.fSeparator = c;
            this.fLength = string.length();
            this.fPlace = 0;
        }

        public boolean hasMoreTokens() {
            return this.fPlace != this.fLength;
        }

        public String nextToken() {
            if (this.fPlace >= this.fLength) {
                return null;
            }
            char c = this.fLine.charAt(this.fPlace);
            ++this.fPlace;
            if (c == this.fSeparator) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (c == '\"') {
                bl = true;
            } else {
                stringBuffer.append(c);
            }
            while (this.fPlace < this.fLength) {
                c = this.fLine.charAt(this.fPlace);
                if (bl) {
                    int n;
                    if (c == '\"' && ((n = this.fPlace + 1) == this.fLength || this.fLine.charAt(n) != '\"')) {
                        bl = false;
                    } else {
                        stringBuffer.append(c);
                    }
                } else {
                    if (c == this.fSeparator) {
                        ++this.fPlace;
                        break;
                    }
                    stringBuffer.append(c);
                }
                ++this.fPlace;
            }
            return stringBuffer.toString();
        }
    }
}

