/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.AsIsConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;

public class AsIsLayout
implements LayoutManager2 {
    private static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    int w;
    int h;
    Hashtable contents = new Hashtable();
    static final AsIsConstraints defaultConstraints = new AsIsConstraints();

    public AsIsLayout() {
    }

    public AsIsLayout(int n, int n2) {
        this.w = n;
        this.h = n2;
    }

    public int getWidth() {
        return this.w;
    }

    public void setWidth(int n) {
        this.w = n;
    }

    public int getHeight() {
        return this.h;
    }

    public void setHeight(int n) {
        this.h = n;
    }

    public String toString() {
        return "AsIsLayout [w: " + this.w + ", h: " + this.h + "]";
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        this.contents.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSizeOfLayout(container, true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSizeOfLayout(container, false);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Rectangle rectangle = this.getTheBounds(component, true);
                component.setBounds(insets.left + rectangle.x, insets.top + rectangle.y, rectangle.width, rectangle.height);
            }
            ++n2;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof AsIsConstraints) {
            this.contents.put(component, object);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    Rectangle getTheBounds(Component component, boolean bl) {
        AsIsConstraints asIsConstraints = (AsIsConstraints)this.contents.get(component);
        if (asIsConstraints == null) {
            asIsConstraints = defaultConstraints;
        }
        Rectangle rectangle = new Rectangle(asIsConstraints.x, asIsConstraints.y, asIsConstraints.w, asIsConstraints.h);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            Dimension dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
            if (rectangle.width <= 0) {
                rectangle.width = dimension.width;
            }
            if (rectangle.height <= 0) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    Dimension getSizeOfLayout(Container container, boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        if (this.w <= 0 || this.h <= 0) {
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.isVisible()) {
                    Rectangle rectangle = this.getTheBounds(component, bl);
                    dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
                    dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
                }
                ++n2;
            }
        }
        if (this.w > 0) {
            dimension.width = this.w;
        }
        if (this.h > 0) {
            dimension.height = this.h;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

