/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.Alignment;
import com.ibm.webrunner.widget.BorderPanelStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BorderPanel
extends Panel {
    public static final int SOLID = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final BorderPanelStyle DEFAULT_STYLE = BorderPanelStyle.IN;
    public static final int DEFAULT_THICKNESS = 10;
    public static final int DEFAULT_SOLID_THICKNESS = 4;
    public static final int DEFAULT_RAISED_THICKNESS = 2;
    public static final int DEFAULT_LOWERED_THICKNESS = 2;
    public static final int DEFAULT_IN_THICKNESS = 10;
    public static final int DEFAULT_OUT_THICKNESS = 10;
    public static final int DEFAULT_GAP = 4;
    public static final Color DEFAULT_COLOR = Color.black;
    public static final Font DEFAULT_FONT = new Font("TimesRoman", 0, 14);
    public static final Alignment DEFAULT_ALIGNMENT = Alignment.LEFT;
    private BorderPanelStyle fStyle = DEFAULT_STYLE;
    private int fThickness = 10;
    private int fGap = 4;
    private Color fColor = DEFAULT_COLOR;
    private Font fFont = DEFAULT_FONT;
    private String fText;
    private Alignment fAlignment = DEFAULT_ALIGNMENT;
    private static int fNumber;
    private boolean fNameSet = false;

    public BorderPanel() {
        this.init();
        this.setText(null);
        if (!this.fNameSet) {
            int n = fNumber++;
            this.setName("borderpanel" + n);
        }
    }

    public BorderPanel(String string) {
        this(BorderPanelStyle.IN);
        this.setText(string);
    }

    public BorderPanel(Color color, int n) {
        this(BorderPanelStyle.SOLID, n);
        this.setColor(color);
    }

    public BorderPanel(BorderPanelStyle borderPanelStyle) {
        this(borderPanelStyle, BorderPanelStyle.DEFAULT_THICKNESS[borderPanelStyle.getValue()]);
    }

    public BorderPanel(BorderPanelStyle borderPanelStyle, int n) {
        this();
        this.setStyle(borderPanelStyle);
        this.setThickness(n);
    }

    public void init() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public Insets getInsets() {
        Toolkit toolkit;
        int n;
        int n2 = 0;
        if ((this.fStyle.isIn() || this.fStyle.isOut()) && this.fText != null && this.fText.length() > 0 && (n = (toolkit = Toolkit.getDefaultToolkit()).getFontMetrics(this.fFont).getHeight()) > this.fThickness) {
            n2 = n - this.fThickness;
        }
        int n3 = this.fThickness + this.fGap;
        return new Insets(n3 + n2, n3, n3, n3);
    }

    public void setStyle(BorderPanelStyle borderPanelStyle) {
        if (borderPanelStyle == null) {
            borderPanelStyle = DEFAULT_STYLE;
        }
        this.fStyle = borderPanelStyle;
        this.doLayout();
        this.repaint();
    }

    public BorderPanelStyle getStyle() {
        return this.fStyle;
    }

    public void setThickness(int n) {
        if (n > 0) {
            this.fThickness = n;
            this.doLayout();
            this.repaint();
        }
    }

    public int getThickness() {
        return this.fThickness;
    }

    public void setGap(int n) {
        if (n > -1) {
            this.fGap = n;
            this.doLayout();
            this.repaint();
        }
    }

    public int getGap() {
        return this.fGap;
    }

    public void setColor(Color color) {
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        this.fColor = color;
        if (this.fStyle.isSolid() || this.fStyle.isIn() || this.fStyle.isOut()) {
            this.repaint();
        }
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setTextFont(Font font) {
        if (font != null) {
            this.fFont = font;
            if (this.fStyle.isIn() || this.fStyle.isOut()) {
                this.doLayout();
                this.repaint();
            }
        }
    }

    public Font getTextFont() {
        return this.fFont;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.fText = string;
        if (this.fStyle.isIn() || this.fStyle.isOut()) {
            this.doLayout();
            this.repaint();
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setAlignment(Alignment alignment) {
        if (alignment == null) {
            alignment = DEFAULT_ALIGNMENT;
        }
        this.fAlignment = alignment;
        if (this.fStyle.isIn() || this.fStyle.isOut()) {
            this.doLayout();
            this.repaint();
        }
    }

    public Alignment getAlignment() {
        return this.fAlignment;
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Color color = this.getBackground().brighter().brighter().brighter();
        Color color2 = this.getBackground().darker().darker().darker();
        if (this.fStyle.isRaised() || this.fStyle.isLowered()) {
            Color color3 = null;
            Color color4 = null;
            if (this.fStyle.isRaised()) {
                color3 = color;
                color4 = color2;
            } else {
                color3 = color2;
                color4 = color;
            }
            graphics.setColor(color3);
            int n3 = 0;
            while (n3 < this.fThickness) {
                graphics.drawLine(n3, n3, n - n3 - 2, n3);
                graphics.drawLine(n3, n3 + 1, n3, n2 - n3 - 1);
                ++n3;
            }
            graphics.setColor(color4);
            int n4 = 0;
            while (n4 < this.fThickness) {
                graphics.drawLine(n4 + 1, n2 - n4 - 1, n - n4 - 1, n2 - n4 - 1);
                graphics.drawLine(n - n4 - 1, n4, n - n4 - 1, n2 - n4 - 2);
                ++n4;
            }
            return;
        }
        if (this.fStyle.isIn() || this.fStyle.isOut()) {
            int n5 = 0;
            int n6 = 0;
            Font font = graphics.getFont();
            graphics.setFont(this.fFont);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
            int n7 = fontMetrics.getAscent();
            if (this.fStyle.isIn()) {
                n5 = 1;
            } else {
                n6 = 1;
            }
            int n8 = 0;
            if (this.fText != null && this.fText.length() > 0 && n7 > this.fThickness) {
                n8 = (n7 - this.fThickness) / 2;
            }
            int n9 = this.fThickness / 2;
            int n10 = this.fThickness / 2 + n8;
            int n11 = n - this.fThickness - 1;
            int n12 = n2 - this.fThickness - 1 - n8;
            graphics.setColor(color);
            graphics.drawRect(n9 + n5, n10 + n5, n11, n12);
            graphics.setColor(color2);
            graphics.drawRect(n9 + n6, n10 + n6, n11, n12);
            if (this.fText != null && this.fText.length() > 0) {
                int n13;
                int n14 = fontMetrics.getHeight();
                int n15 = fontMetrics.stringWidth(this.fText);
                if (n15 > (n13 = n - 2 * (this.fThickness + 5))) {
                    n15 = n13;
                }
                int n16 = this.fAlignment.isCenter() ? (n - n15) / 2 : (this.fAlignment.isRight() ? n - n15 - this.fThickness - 5 : this.fThickness + 5);
                graphics.setColor(this.getBackground());
                graphics.fillRect(n16 - 5, 0, n15 + 10, n14);
                graphics.setClip(n16, 0, n15, n14);
                graphics.setColor(this.fColor);
                graphics.drawString(this.fText, n16, n7);
                graphics.setClip(0, 0, n, n2);
            }
            graphics.setFont(font);
            return;
        }
        graphics.setColor(this.fColor);
        int n17 = 0;
        while (n17 < this.fThickness) {
            graphics.drawRect(n17, n17, n - 2 * n17 - 1, n2 - 2 * n17 - 1);
            ++n17;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("style=" + this.fStyle);
        stringBuffer.append(",thickness=" + this.fThickness);
        stringBuffer.append(",gap=" + this.fGap);
        stringBuffer.append(",color=" + this.fColor);
        stringBuffer.append(",text=" + this.fText);
        stringBuffer.append(",alignment=" + this.fAlignment);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

