/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.DateChangedEvent;
import com.ibm.webrunner.widget.DateChangedListener;
import com.ibm.webrunner.widget.PaintPanel;
import com.ibm.webrunner.widget.UpdatingImageButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class DatePicker
extends Panel
implements ActionListener,
KeyListener,
Externalizable {
    static final long kLostThreshold = 300L;
    private static final int DROP_DOWN_HEIGHT = 25;
    private static final int DROP_DOWN_WIDTH = 25;
    String fDateFormatString = "";
    boolean enabled = true;
    int pivotValue;
    boolean usingPivotValue = false;
    TimeZone timeZone;
    GregorianCalendar fGC = new GregorianCalendar();
    DateFormat fSDF;
    long lostTime;
    boolean ignoreNextArrowClick = false;
    private transient Vector dateChangedListeners = new Vector();
    transient PaintPanel win;
    transient TextField dateEntryField;
    transient UpdatingImageButton dropDownButton;
    transient Window w;

    public synchronized void setEnabled(boolean bl) {
        if (this.w != null) {
            ((Component)this.w).setVisible(false);
        }
        this.enabled = bl;
        this.dateEntryField.setEnabled(this.enabled);
        this.dropDownButton.setEnabled(this.enabled);
        super.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setDateString(String string) {
        CharSequence charSequence;
        java.util.Date date = null;
        boolean bl = true;
        try {
            date = this.fSDF.parse(string);
            this.fGC.setTime(date);
            this.win.gc.setTime(date);
            charSequence = this.getDateFormatString();
            int n = this.countYearDigits((String)charSequence);
            if (n > 0 && n <= 2 && this.isUsingPivotValue()) {
                int n2 = this.fGC.get(1);
                int n3 = this.fGC.get(2);
                int n4 = this.fGC.get(5);
                int n5 = this.adjustYearUsingPivotValue(n2);
                this.fGC.set(n5, n3, n4);
                this.fGC.setTime(this.fGC.getTime());
                this.win.gc.setTime(this.fGC.getTime());
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        charSequence = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.fSDF.format(this.fGC.getTime(), (StringBuffer)charSequence, fieldPosition);
        ((TextComponent)this.dateEntryField).setText(((StringBuffer)charSequence).toString());
        if (bl) {
            this.fireDateChangedEvent();
        }
        if (this.w != null) {
            ((Component)this.w).setVisible(false);
        }
    }

    public String getDateString() {
        return this.dateEntryField.getText();
    }

    public void setDateFormatString(String string) {
        String string2 = this.fDateFormatString;
        try {
            this.fDateFormatString = string;
            this.fSDF = new SimpleDateFormat(string);
            this.fSDF.setTimeZone(this.timeZone);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
            ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
            this.dateEntryField.invalidate();
            this.dropDownButton.invalidate();
            this.invalidate();
            return;
        }
        catch (Exception exception) {
            this.fDateFormatString = string2;
            this.fSDF = new SimpleDateFormat(string2);
            this.fSDF.setTimeZone(this.timeZone);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
            ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
            return;
        }
    }

    public String getDateFormatString() {
        return this.fDateFormatString;
    }

    public void setPivotValue(int n) {
        if (n >= 0 & n < 100) {
            this.pivotValue = n;
        }
    }

    public int getPivotValue() {
        return this.pivotValue;
    }

    public void setUsingPivotValue(boolean bl) {
        this.usingPivotValue = bl;
    }

    public boolean isUsingPivotValue() {
        return this.usingPivotValue;
    }

    public void setTimeZone(String string) {
        if (this.timeZone.getID() != string) {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            if (timeZone.getID() == "GMT") {
                if (string == "GMT") {
                    this.timeZone = timeZone;
                }
            } else {
                this.timeZone = timeZone;
            }
            this.fSDF.setTimeZone(this.timeZone);
            ((Calendar)this.fGC).setTimeZone(this.timeZone);
            this.fGC.setTime(this.fGC.getTime());
            this.win.setTimeZone(this.timeZone);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
            ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
        }
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public void setDateWithOptionalEvent(java.util.Date date, boolean bl) {
        this.fGC.setTime(date);
        this.win.gc.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
        ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
        if (bl) {
            this.fireDateChangedEvent();
        }
        if (this.w != null) {
            ((Component)this.w).setVisible(false);
        }
    }

    public void setDate(java.util.Date date) {
        this.setDateWithOptionalEvent(date, true);
    }

    public java.util.Date getDate() {
        return this.fGC.getTime();
    }

    public Date getSQLDate() {
        java.util.Date date = this.fGC.getTime();
        return new Date(date.getTime());
    }

    public DatePicker() {
        this(TimeZone.getDefault());
    }

    public DatePicker(TimeZone timeZone) {
        try {
            this.timeZone = timeZone;
            this.fSDF = DateFormat.getDateInstance();
            this.fSDF.setTimeZone(this.timeZone);
            ((Calendar)this.fGC).setTimeZone(this.timeZone);
            this.fGC.setTime(this.fGC.getTime());
            this.fDateFormatString = ((SimpleDateFormat)this.fSDF).toPattern();
            this.pivotValue = 18;
            this.setBackground(Color.lightGray);
            this.setLayout(null);
            this.jbInit();
            this.setSize(new Dimension(215, 25));
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
            ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void jbInit() {
        this.win = new PaintPanel(TimeZone.getTimeZone(this.getTimeZone()));
        this.win.setDatePicker(this);
        this.dateEntryField = new TextField();
        this.dateEntryField.addKeyListener(this);
        this.add(this.dateEntryField);
        this.dropDownButton = new UpdatingImageButton(this.createDropdownImage());
        this.add(this.dropDownButton);
        this.dropDownButton.setUpdateLive(false);
        this.dropDownButton.addActionListener(this);
        this.w = null;
    }

    public Dimension getPreferredSize() {
        int n = 25;
        int n2 = 215;
        try {
            FontMetrics fontMetrics = this.dateEntryField.getFontMetrics(this.dateEntryField.getFont());
            if (fontMetrics != null) {
                n2 = 45 + fontMetrics.stringWidth(this.dateEntryField.getText());
            }
        }
        catch (Exception exception) {}
        return new Dimension(n2, n);
    }

    public Dimension getMinimumSize() {
        int n = 25;
        int n2 = 45;
        return new Dimension(n2, n);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.dateEntryField.setBounds(0, 0, n3 - 25, n4);
        this.dropDownButton.setBounds(n3 - 25, 0, 25, n4);
    }

    public void setLayout(LayoutManager layoutManager) {
        super.setLayout(null);
        this.validate();
    }

    private Image createDropdownImage() {
        byte[] byArray = new byte[101];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 19;
        byArray[8] = 17;
        byArray[10] = -77;
        byArray[16] = -128;
        byArray[20] = -128;
        byArray[22] = -128;
        byArray[23] = -128;
        byArray[27] = -128;
        byArray[28] = -128;
        byArray[30] = -128;
        byArray[32] = -128;
        byArray[33] = -128;
        byArray[34] = -128;
        byArray[35] = -128;
        byArray[36] = -128;
        byArray[37] = -64;
        byArray[38] = -64;
        byArray[39] = -64;
        byArray[40] = -1;
        byArray[44] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[54] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = 44;
        byArray[66] = 19;
        byArray[68] = 17;
        byArray[71] = 4;
        byArray[72] = 26;
        byArray[73] = 16;
        byArray[74] = -55;
        byArray[75] = 73;
        byArray[76] = -85;
        byArray[77] = -67;
        byArray[78] = 56;
        byArray[79] = -21;
        byArray[80] = -51;
        byArray[81] = -69;
        byArray[82] = -1;
        byArray[83] = 64;
        byArray[84] = 40;
        byArray[85] = 2;
        byArray[86] = -35;
        byArray[87] = 72;
        byArray[88] = 122;
        byArray[89] = -30;
        byArray[90] = 39;
        byArray[91] = -99;
        byArray[92] = 106;
        byArray[93] = -21;
        byArray[94] = -66;
        byArray[95] = 112;
        byArray[96] = 44;
        byArray[97] = 95;
        byArray[98] = 17;
        byArray[100] = 59;
        byte[] byArray2 = byArray;
        return Toolkit.getDefaultToolkit().createImage(byArray2);
    }

    public synchronized void addDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.addElement(dateChangedListener);
    }

    public synchronized void removeDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.removeElement(dateChangedListener);
    }

    public void setDateByFields(int n, int n2, int n3) {
        this.fGC.set(n, n2, n3);
        this.fGC.clear(10);
        this.fGC.clear(11);
        this.fGC.clear(12);
        this.fGC.clear(13);
        this.fGC.clear(14);
        this.fGC.set(10, 0);
        this.fGC.set(11, 0);
        this.fGC.setTime(this.fGC.getTime());
        this.win.gc.setTime(this.fGC.getTime());
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
        ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
    }

    protected void fireDateChangedEvent() {
        Vector vector;
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
        DateChangedEvent dateChangedEvent = new DateChangedEvent(this, 20000, stringBuffer.toString(), this.getDate(), this.getSQLDate());
        DatePicker datePicker = this;
        synchronized (datePicker) {
            vector = (Vector)this.dateChangedListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((DateChangedListener)vector.elementAt(n)).dateChanged(dateChangedEvent);
            ++n;
        }
    }

    synchronized void dropDownButton_actionPerformed() {
        this.dropDownButton.setMouseDown(false);
        if (this.ignoreNextArrowClick) {
            java.util.Date date = new java.util.Date();
            if (date.getTime() - this.lostTime < 300L) {
                this.ignoreNextArrowClick = false;
                return;
            }
            this.ignoreNextArrowClick = false;
        }
        if (this.w != null) {
            if (this.w.isVisible()) {
                ((Component)this.w).setVisible(false);
                return;
            }
            ((Component)this.w).setVisible(true);
        }
        boolean bl = false;
        Frame frame = null;
        Container container = this.getParent();
        while (!bl) {
            block8: {
                try {
                    frame = (Frame)container;
                    bl = true;
                }
                catch (Exception exception) {
                    if (container != null) break block8;
                    return;
                }
            }
            container = container.getParent();
        }
        if (this.w == null) {
            this.w = new Window(frame);
        }
        Insets insets = this.w.getInsets();
        ((Component)this.w).setSize(223 + insets.left + insets.right, 140 + insets.top + insets.bottom);
        ((Component)this.w).setLocation(new Point(this.dropDownButton.getLocationOnScreen().x - this.w.getSize().width + this.dropDownButton.getSize().width, this.dropDownButton.getLocationOnScreen().y + this.dropDownButton.getSize().height));
        this.win.setDatePicker(this);
        this.w.add((Component)this.win, "Center");
        this.w.pack();
        ((Component)this.w).setVisible(true);
        this.win.requestFocus();
        this.win.paint(null);
    }

    protected int countYearDigits(String string) {
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        boolean bl = false;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\'') {
                bl = !bl;
            } else if (!(c != 'y' && c != 'Y' || bl)) {
                ++n;
            }
            c = stringCharacterIterator.next();
        }
        return n;
    }

    protected int adjustYearUsingPivotValue(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.timeZone);
        int n2 = gregorianCalendar.get(1);
        int n3 = n2 / 100 * 100;
        int n4 = 0;
        int n5 = n2 % 100 < 50 ? n3 : n3 + 100;
        int n6 = n5 - n2;
        n4 = n % 100;
        this.pivotValue = this.getPivotValue();
        if (Math.abs(n6) <= this.pivotValue) {
            if (n6 > 0) {
                n4 = n4 <= this.pivotValue ? n4 + n3 + 100 : (n4 += n3);
            } else if (n6 <= 0) {
                n4 = n4 < 100 - this.pivotValue ? (n4 += n3) : n4 + n3 - 100;
            }
        } else {
            n4 += n3;
        }
        return n4;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = this.getName();
        objectOutput.writeObject(string);
        Rectangle rectangle = this.getBounds();
        objectOutput.writeInt(rectangle.x);
        objectOutput.writeInt(rectangle.y);
        objectOutput.writeInt(rectangle.width);
        objectOutput.writeInt(rectangle.height);
        objectOutput.writeBoolean(this.enabled);
        objectOutput.writeObject(this.fDateFormatString);
        objectOutput.writeInt(this.pivotValue);
        objectOutput.writeBoolean(this.usingPivotValue);
        objectOutput.writeObject(this.fGC);
        objectOutput.writeObject(this.timeZone);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        this.setName(string);
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        int n3 = objectInput.readInt();
        int n4 = objectInput.readInt();
        this.setBounds(n, n2, n3, n4);
        boolean bl = objectInput.readBoolean();
        String string2 = (String)objectInput.readObject();
        int n5 = objectInput.readInt();
        boolean bl2 = objectInput.readBoolean();
        this.fGC = (GregorianCalendar)objectInput.readObject();
        this.timeZone = (TimeZone)objectInput.readObject();
        this.setEnabled(bl);
        this.setDateFormatString(string2);
        this.setPivotValue(n5);
        this.setUsingPivotValue(bl2);
        this.setTimeZone(this.timeZone.getID());
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.win.gc.setTime(this.fGC.getTime());
        this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
        ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
    }

    void dateEntryField_keyPressed(KeyEvent keyEvent) {
        boolean bl = true;
        int n = keyEvent.getKeyCode();
        java.util.Date date = null;
        if (n == 10 || n == 9) {
            CharSequence charSequence;
            try {
                date = this.fSDF.parse(this.dateEntryField.getText());
                this.fGC.setTime(date);
                this.win.gc.setTime(date);
                charSequence = this.getDateFormatString();
                int n2 = this.countYearDigits((String)charSequence);
                if (n2 > 0 && n2 <= 2 && this.isUsingPivotValue()) {
                    int n3 = this.fGC.get(1);
                    int n4 = this.fGC.get(2);
                    int n5 = this.fGC.get(5);
                    int n6 = this.adjustYearUsingPivotValue(n3);
                    this.fGC.set(n6, n4, n5);
                    this.fGC.setTime(this.fGC.getTime());
                    this.win.gc.setTime(this.fGC.getTime());
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            charSequence = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.fSDF.format(this.fGC.getTime(), (StringBuffer)charSequence, fieldPosition);
            ((TextComponent)this.dateEntryField).setText(((StringBuffer)charSequence).toString());
            if (bl) {
                this.fireDateChangedEvent();
            }
            if (this.w != null) {
                ((Component)this.w).setVisible(false);
                return;
            }
        } else if (n == 27) {
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
            ((TextComponent)this.dateEntryField).setText(stringBuffer.toString());
            if (this.w != null) {
                ((Component)this.w).setVisible(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dropDownButton) {
            this.dropDownButton_actionPerformed();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this.dateEntryField) {
            this.dateEntryField_keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

