/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.util.Sorter;
import com.ibm.webrunner.util.TableModel;
import com.ibm.webrunner.widget.Alignment;
import com.ibm.webrunner.widget.ListboxCaption;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ListboxColumn
implements Serializable {
    public static final Alignment DEFAULT_ALIGNMENT = Alignment.LEFT;
    private Component fParent;
    private TableModel fTable;
    private int fColumn;
    private ListboxCaption fCaption;
    private Sorter fSorter;
    private Alignment fAlignment = DEFAULT_ALIGNMENT;
    private Color fBackground;
    private Color fForeground;

    public ListboxColumn() {
        this.init();
    }

    public ListboxColumn(Component component, TableModel tableModel, int n, ListboxCaption listboxCaption) {
        this();
        this.fParent = component;
        this.fTable = tableModel;
        this.fColumn = n;
        this.fCaption = listboxCaption;
    }

    private void init() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public void setLabel(Object object) {
        this.fTable.setColumnInfo(object, this.fColumn);
        this.fCaption.setLabel(object);
    }

    public Object getLabel() {
        return this.fTable.getColumnInfo(this.fColumn);
    }

    public void setResizable(boolean bl) {
        this.fCaption.setResizable(bl);
    }

    public boolean isResizable() {
        return this.fCaption.isResizable();
    }

    public void setWidth(int n) {
        this.fCaption.setLength(n);
        this.fParent.doLayout();
    }

    public int getWidth() {
        return this.fCaption.getLength();
    }

    public void setSorter(Sorter sorter) {
        boolean bl = false;
        if (sorter != null) {
            bl = true;
        }
        this.fCaption.setSortable(bl);
        this.fSorter = sorter;
    }

    public Sorter getSorter() {
        return this.fSorter;
    }

    public boolean isSortable() {
        return this.fCaption.isSortable();
    }

    protected void setState(boolean bl) {
        this.fCaption.setState(bl);
        this.fParent.repaint();
    }

    protected boolean getState() {
        return this.fCaption.getState();
    }

    public void setAlignment(Alignment alignment) {
        if (!this.fAlignment.equals(alignment)) {
            this.fAlignment = alignment;
            this.fParent.repaint();
        }
    }

    public Alignment getAlignment() {
        return this.fAlignment;
    }

    public void setVisible(boolean bl) {
        this.fCaption.setVisible(bl);
        this.fParent.repaint();
    }

    public boolean isVisible() {
        return this.fCaption.isVisible();
    }

    public boolean isSelected() {
        return this.fCaption.isSelected();
    }

    public void setBackground(Color color) {
        this.fBackground = color;
        this.fParent.repaint();
    }

    public Color getBackground() {
        return this.fBackground;
    }

    public void setForeground(Color color) {
        this.fForeground = color;
        this.fParent.repaint();
    }

    public Color getForeground() {
        return this.fForeground;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append(",label=" + this.fTable.getColumnInfo(this.fColumn).toString());
        if (this.isSortable()) {
            stringBuffer.append(",sortable");
        }
        stringBuffer.append(",sorter=" + this.fSorter);
        stringBuffer.append(",alignment=" + this.fAlignment.toString());
        stringBuffer.append(",background=" + this.fBackground);
        stringBuffer.append(",foreground=" + this.fForeground);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

