/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import java.io.Serializable;
import java.util.Vector;

public class MaskCharacter
implements Serializable {
    public static final MaskCharacter DIGITS = new MaskCharacter('#', "0-9");
    public static final MaskCharacter LOWERCASE = new MaskCharacter('a', "a-z");
    public static final MaskCharacter UPPERCASE = new MaskCharacter('A', "A-Z");
    public static final MaskCharacter ALPHANUMERIC = new MaskCharacter('@', "0-9a-zA-Z");
    private char fMaskChar;
    private String fValidChars;
    private String fTranslation;
    private Object[] fRanges;
    private Object[] fTranslationRanges;

    public MaskCharacter(char c, String string) {
        this(c, string, null);
    }

    public MaskCharacter(char c, String string, String string2) {
        this.fMaskChar = c;
        this.fValidChars = string == null ? "" : string;
        this.fRanges = this.buildRanges(this.fValidChars);
        this.fTranslation = string2;
        this.fTranslationRanges = this.buildRanges(this.fTranslation);
    }

    private Object[] buildRanges(String string) {
        int n;
        Object[] objectArray;
        if (string == null || string.length() == 0) {
            return null;
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        int n2 = -1;
        boolean bl = false;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            switch (c) {
                case '-': {
                    if (n2 == -1) break;
                    bl = true;
                    break;
                }
                case '\\': {
                    c = string.charAt(++n4);
                }
                default: {
                    if (n2 == -1) {
                        n2 = c;
                    } else if (bl) {
                        objectArray = new char[]{(char)n2, c};
                        vector.addElement(objectArray);
                        n2 = -1;
                    } else {
                        objectArray = new char[]{(char)n2};
                        vector.addElement(objectArray);
                        n2 = c;
                    }
                    bl = false;
                }
            }
            ++n4;
        }
        if (n2 != -1) {
            char[] cArray = new char[]{(char)n2};
            vector.addElement(cArray);
        }
        if ((n = vector.size()) == 0) {
            return null;
        }
        objectArray = new Object[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Object[] getRanges() {
        return this.fRanges;
    }

    Object[] getTranslationRanges() {
        return this.fTranslationRanges;
    }

    public char getMaskCharacter() {
        return this.fMaskChar;
    }

    public String getValidCharacters() {
        return this.fValidChars;
    }

    public String getTranslation() {
        return this.fTranslation;
    }

    public synchronized int validateCharacter(char c) {
        int n = 0;
        while (n < this.fRanges.length) {
            char[] cArray = (char[])this.fRanges[n];
            if (cArray.length == 1) {
                if (c == cArray[0]) {
                    if (this.fTranslation != null) {
                        c = ((char[])this.fTranslationRanges[n])[0];
                    }
                    return c;
                }
            } else if (c >= cArray[0] && c <= cArray[1]) {
                if (this.fTranslation != null) {
                    int n2 = c - cArray[0];
                    char[] cArray2 = (char[])this.fTranslationRanges[n];
                    c = cArray2.length == 1 ? cArray2[0] : (char)(cArray2[0] + n2);
                }
                return c;
            }
            ++n;
        }
        if (this.fTranslationRanges != null) {
            int n3 = 0;
            while (n3 < this.fTranslationRanges.length) {
                char[] cArray = (char[])this.fTranslationRanges[n3];
                if (cArray.length == 1 ? c == cArray[0] : c >= cArray[0] && c <= cArray[1]) {
                    return c;
                }
                ++n3;
            }
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("maskchar=" + this.fMaskChar);
        stringBuffer.append(",validchars=" + this.fValidChars);
        if (this.fTranslation != null) {
            stringBuffer.append(",translation=" + this.fTranslation);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

