/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.InputDirection;
import com.ibm.webrunner.widget.MaskCharacter;
import com.ibm.webrunner.widget.TextClipboardComponent;
import com.ibm.webrunner.widget.event.MaskedTextFieldEvent;
import com.ibm.webrunner.widget.event.MaskedTextFieldListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class MaskedTextField
extends TextClipboardComponent
implements Runnable,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final MaskCharacter[] DEFAULT_MASK_CHARS = new MaskCharacter[]{MaskCharacter.DIGITS, MaskCharacter.LOWERCASE, MaskCharacter.UPPERCASE, MaskCharacter.ALPHANUMERIC};
    public static final char DEFAULT_BLANK_CHAR = '_';
    public static final InputDirection DEFAULT_INPUT_DIRECTION = InputDirection.RIGHT;
    public static final boolean DEFAULT_SHIFT_TEXT = true;
    public static final boolean DEFAULT_MOVE_CURSOR = true;
    public static final boolean DEFAULT_ALLOW_INVALID = false;
    public static final boolean DEFAULT_RETURN_LITERALS = true;
    public static final boolean DEFAULT_RETURN_BLANKS = false;
    private static final int OFFSET = 5;
    private static final char NOT_A_UNICODE_CHAR = '\uffff';
    private String fMask = "";
    private StringBuffer fText = new StringBuffer();
    private MaskCharacter[] fMaskChars = DEFAULT_MASK_CHARS;
    private char fBlank = (char)95;
    private MaskCharacter[] fMasks = new MaskCharacter[0];
    private boolean fReturnLiterals = true;
    private boolean fReturnBlanks = false;
    private InputDirection fDirection = DEFAULT_INPUT_DIRECTION;
    private boolean fShiftText = true;
    private boolean fMoveCursor = true;
    private boolean fAllowInvalid = false;
    private boolean fValid = true;
    private int fStart;
    private int fOffset;
    private transient int[] fOffsets;
    private transient Thread fFocusThread;
    private transient boolean fNewFocus = false;
    private transient boolean fBlink = false;
    private transient boolean fFocus = false;
    private char fEchoChar = (char)65535;
    private transient Vector fActionListeners;
    private transient Vector fTextListeners;
    private transient Vector fMaskedListeners;
    private transient Image fBuffer;
    private transient Graphics fBufferGraphics;
    private transient Dimension fBufferSize;
    private static int fNumber;
    private boolean fNameSet = false;

    public MaskedTextField() {
        this.init();
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (!this.fNameSet) {
            int n = fNumber++;
            this.setName("maskedtextfield" + n);
            this.fNameSet = true;
        }
        this.setBackground(Color.white);
    }

    public MaskedTextField(String string) {
        this();
        this.setMask(string);
    }

    public MaskedTextField(String string, MaskCharacter[] maskCharacterArray) {
        this();
        this.setMaskCharacters(maskCharacterArray);
        this.setMask(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void init() {
        this.fActionListeners = new Vector();
        this.fTextListeners = new Vector();
        this.fMaskedListeners = new Vector();
    }

    public FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics;
        block4: {
            fontMetrics = null;
            if (font == null) break block4;
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit == null) {
                    throw new Exception();
                }
                fontMetrics = toolkit.getFontMetrics(font);
                if (fontMetrics == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                Graphics graphics = this.getGraphics();
                if (graphics == null) break block4;
                fontMetrics = graphics.getFontMetrics(font);
            }
        }
        return fontMetrics;
    }

    public void run() {
        try {
            while (true) {
                this.repaint();
                Thread.sleep(500L);
                this.fBlink = !this.fBlink;
            }
        }
        catch (Exception exception) {
            this.fFocusThread = null;
            return;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.fFocusThread != null) {
            this.fFocusThread.stop();
        }
        this.fNewFocus = true;
        this.fBlink = true;
        this.fFocus = true;
        this.repaint();
        this.fFocusThread = new Thread(this);
        this.fFocusThread.start();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.fFocusThread != null) {
            this.fFocusThread.stop();
        }
        this.fNewFocus = false;
        this.fBlink = false;
        this.fFocus = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        this.fActionListeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fActionListeners.removeElement(actionListener);
    }

    public void addTextListener(TextListener textListener) {
        this.fTextListeners.addElement(textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.fTextListeners.removeElement(textListener);
    }

    public void addMaskedTextFieldListener(MaskedTextFieldListener maskedTextFieldListener) {
        this.fMaskedListeners.addElement(maskedTextFieldListener);
    }

    public void removeMaskedTextFieldListener(MaskedTextFieldListener maskedTextFieldListener) {
        this.fMaskedListeners.removeElement(maskedTextFieldListener);
    }

    private void adjustOffset() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        try {
            Dimension dimension = this.getSize();
            int n = this.fStart == this.fBegin ? this.fEnd : this.fBegin;
            String string = this.fText.toString().substring(0, n);
            int n2 = dimension.width - 10;
            if (fontMetrics.stringWidth(string) > n2) {
                int n3 = string.length();
                this.fOffset = 0;
                int n4 = 0;
                while (n4 < n3) {
                    if (fontMetrics.stringWidth(string.substring(n4)) < n2) {
                        this.fOffset = n4;
                        return;
                    }
                    ++n4;
                }
                return;
            }
        }
        catch (Exception exception) {
            this.fOffset = 0;
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        MaskedTextField maskedTextField = this;
        synchronized (maskedTextField) {
            this.adjustOffset();
            return;
        }
    }

    public synchronized void setMask(String string) {
        int n;
        this.fMask = string == null ? "" : string;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = string.charAt(n4);
            if (n == 92 && ++n4 != n2 && string.charAt(n4) == '\\') {
                ++n4;
                ++n3;
            }
            ++n4;
            ++n3;
        }
        n = n3;
        this.fMasks = new MaskCharacter[n];
        this.fText.setLength(n);
        n3 = 0;
        int n5 = 0;
        while (n5 < n2) {
            block9: {
                char c = string.charAt(n5);
                if (c == '\\') {
                    this.fText.setCharAt(n3, string.charAt(++n5));
                } else {
                    int n6 = 0;
                    while (n6 < this.fMaskChars.length) {
                        if (c == this.fMaskChars[n6].getMaskCharacter()) {
                            this.fMasks[n3] = this.fMaskChars[n6];
                            this.fText.setCharAt(n3, '\uffff');
                            break block9;
                        }
                        ++n6;
                    }
                    this.fText.setCharAt(n3, c);
                }
            }
            ++n5;
            ++n3;
        }
        if (this.fDirection.isRight()) {
            this.fBegin = 0;
            this.fEnd = 0;
            this.fStart = 0;
            this.fOffset = 0;
        } else {
            int n7;
            this.fEnd = this.fBegin = (n7 = this.fText.length());
            this.fStart = this.fBegin;
            this.adjustOffset();
        }
        this.repaint();
    }

    public String getMask() {
        return this.fMask;
    }

    public synchronized void setInputDirection(InputDirection inputDirection) {
        if (!this.fDirection.equals(inputDirection)) {
            this.fDirection = inputDirection;
            if (this.fDirection.isRight()) {
                this.fStart = 0;
                this.fEnd = 0;
                this.fBegin = 0;
            } else {
                this.fEnd = this.fStart = this.fText.length();
                this.fBegin = this.fStart;
            }
            this.repaint();
        }
    }

    public InputDirection getInputDirection() {
        return this.fDirection;
    }

    public void setShiftText(boolean bl) {
        this.fShiftText = bl;
    }

    public boolean getShiftText() {
        return this.fShiftText;
    }

    public void setMoveCursor(boolean bl) {
        this.fMoveCursor = bl;
    }

    public boolean getMoveCursor() {
        return this.fMoveCursor;
    }

    public void setAllowInvalid(boolean bl) {
        this.fAllowInvalid = bl;
    }

    public boolean getAllowInvalid() {
        return this.fAllowInvalid;
    }

    public synchronized void setMaskCharacters(MaskCharacter[] maskCharacterArray) {
        if (maskCharacterArray == null) {
            return;
        }
        this.fMaskChars = maskCharacterArray;
        this.setMask(this.fMask);
    }

    public MaskCharacter[] getMaskCharacters() {
        return this.fMaskChars;
    }

    public void setBlankChar(char c) {
        if (this.fBlank != c) {
            this.fBlank = c;
            this.repaint();
        }
    }

    public char getBlankChar() {
        return this.fBlank;
    }

    public void setReturnLiterals(boolean bl) {
        this.fReturnLiterals = bl;
    }

    public boolean getReturnLiterals() {
        return this.fReturnLiterals;
    }

    public void setReturnBlanks(boolean bl) {
        this.fReturnBlanks = bl;
    }

    public boolean getReturnBlanks() {
        return this.fReturnBlanks;
    }

    protected synchronized String getDisplayText() {
        StringBuffer stringBuffer = new StringBuffer(this.getText(true, true));
        if (this.fEchoChar != '\uffff') {
            int n = 0;
            while (n < this.fMasks.length) {
                if (this.fMasks[n] != null && this.fText.charAt(n) != '\uffff') {
                    stringBuffer.setCharAt(n, this.fEchoChar);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean validateText() {
        return this.fValid;
    }

    public boolean validateText(String string) {
        return this.validateText(string, true, 0);
    }

    public boolean validateText(String string, boolean bl) {
        return this.validateText(string, bl, 0);
    }

    public boolean validateText(String string, boolean bl, int n) {
        return this.validateText(string, bl, n, true);
    }

    private synchronized boolean validateText(String string, boolean bl, int n, boolean bl2) {
        int n2 = this.fText.length();
        int n3 = string.length();
        if (n >= n2 || n + n3 > n2) {
            return false;
        }
        if (bl) {
            int n4 = n;
            while (n4 < n3) {
                char c = string.charAt(n4);
                if (this.fMasks[n4] != null) {
                    if (c == '\uffff') {
                        if (!bl2) {
                            return false;
                        }
                    } else if (this.fMasks[n4].validateCharacter(c) == -1) {
                        return false;
                    }
                } else if (c != this.fText.charAt(n4)) {
                    return false;
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            int n6 = n;
            while (n6 < n3) {
                if (this.fMasks[n6] != null) {
                    char c = string.charAt(n5);
                    ++n5;
                    if (c == '\uffff') {
                        if (!bl2) {
                            return false;
                        }
                    } else if (this.fMasks[n6].validateCharacter(c) == -1) {
                        return false;
                    }
                }
                ++n6;
            }
        }
        return true;
    }

    public void setText(String string) {
        this.setText(string, this.fReturnLiterals);
    }

    public synchronized void setText(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.fText.toString());
        int n = stringBuffer.length();
        int n2 = string.length();
        if (this.fDirection.isRight()) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (n3 >= n2) break;
                if (this.fMasks[n4] == null) {
                    if (bl) {
                        if (this.fText.charAt(n4) != string.charAt(n3)) {
                            return;
                        }
                        ++n3;
                    }
                } else {
                    int n5 = this.fMasks[n4].validateCharacter(string.charAt(n3));
                    if (!this.fAllowInvalid && n5 == -1) {
                        return;
                    }
                    stringBuffer.setCharAt(n4, (char)n5);
                    ++n3;
                }
                ++n4;
            }
            while (n4 < n) {
                if (this.fMasks[n4] != null) {
                    stringBuffer.setCharAt(n4, '\uffff');
                }
                ++n4;
            }
        } else {
            int n6 = n2 - 1;
            int n7 = n - 1;
            while (n7 >= 0) {
                if (n6 < 0) break;
                if (this.fMasks[n7] == null) {
                    if (bl) {
                        if (this.fText.charAt(n7) != string.charAt(n6)) {
                            return;
                        }
                        --n6;
                    }
                } else {
                    int n8 = this.fMasks[n7].validateCharacter(string.charAt(n6));
                    if (!this.fAllowInvalid && n8 == -1) {
                        return;
                    }
                    stringBuffer.setCharAt(n7, (char)n8);
                    --n6;
                }
                --n7;
            }
            while (n7 >= 0) {
                if (this.fMasks[n7] != null) {
                    stringBuffer.setCharAt(n7, '\uffff');
                }
                --n7;
            }
        }
        this.fText = stringBuffer;
        this.repaint();
    }

    public String getText() {
        return this.getText(this.fReturnLiterals, this.fReturnBlanks);
    }

    public synchronized String getText(boolean bl, boolean bl2) {
        if (bl || bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.fMasks.length) {
                if (this.fMasks[n] != null) {
                    char c = this.fText.charAt(n);
                    if (c != '\uffff') {
                        stringBuffer.append(c);
                    } else if (bl2) {
                        stringBuffer.append(this.fBlank);
                    }
                } else if (bl) {
                    stringBuffer.append(this.fText.charAt(n));
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return this.fText.toString();
    }

    private synchronized String getTextMaskChars() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fMasks.length) {
            if (this.fMasks[n] != null) {
                stringBuffer.append(this.fText.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setEchoChar(char c) {
        this.fEchoChar = c;
        this.repaint();
    }

    public char getEchoChar() {
        return this.fEchoChar;
    }

    public boolean isEchoCharSet() {
        return this.fEchoChar != '\uffff';
    }

    public Dimension getPreferredSize() {
        int n = 20;
        int n2 = 20;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            n = 6 + fontMetrics.getHeight();
            n2 += fontMetrics.stringWidth(this.fText.toString());
        }
        return new Dimension(n2, n);
    }

    public Dimension getMinimumSize() {
        int n = 20;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            n = 6 + fontMetrics.getHeight();
        }
        return new Dimension(20, n);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Graphics graphics2 = this.fBufferGraphics;
        Dimension dimension = this.getSize();
        try {
            if (this.fBuffer == null || this.fBufferSize.width != dimension.width || this.fBufferSize.height != dimension.height) {
                if (this.fBuffer != null) {
                    this.fBuffer.flush();
                    this.fBuffer = null;
                    this.fBufferGraphics.dispose();
                }
                this.fBufferSize = dimension;
                this.fBuffer = this.createImage(this.fBufferSize.width, this.fBufferSize.height);
                graphics2 = this.fBufferGraphics = this.fBuffer.getGraphics();
                graphics2.setClip(0, 0, dimension.width, dimension.height);
            }
        }
        catch (Exception exception) {
            graphics2 = graphics;
        }
        Color color5 = this.getBackground();
        Color color6 = this.getForeground();
        Color color7 = color5.brighter().brighter().brighter();
        Color color8 = color5.darker();
        Color color9 = color8.darker().darker();
        Container container = this.getParent();
        if (container == null) {
            color4 = color5;
            Color color10 = color6;
            color3 = color7;
            color2 = color8;
            color = color9;
        } else {
            color4 = container.getBackground();
            Color color11 = container.getForeground();
            color3 = color4.brighter().brighter().brighter();
            color2 = color4.darker();
            color = color2.darker().darker();
        }
        graphics2.setColor(color5);
        graphics2.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
        graphics2.setColor(color2);
        graphics2.drawLine(0, 0, 0, dimension.height - 2);
        graphics2.drawLine(1, 0, dimension.width - 2, 0);
        graphics2.setColor(color);
        graphics2.drawLine(1, 1, 1, dimension.height - 3);
        graphics2.drawLine(2, 1, dimension.width - 3, 1);
        graphics2.setColor(color4);
        graphics2.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics2.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 3);
        graphics2.setColor(color3);
        graphics2.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics2.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 2);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            int n;
            fontMetrics.getHeight();
            int n2 = 5;
            int n3 = (dimension.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
            String string = this.getDisplayText();
            int n4 = fontMetrics.stringWidth(string.substring(0, this.fOffset));
            graphics2.setClip(5, 2, dimension.width - 10, dimension.height - 4);
            graphics2.setColor(color9);
            graphics2.drawString(string, n2 - n4, n3);
            if (this.fEnd - this.fBegin > 0) {
                String string2 = string.substring(this.fBegin, this.fEnd);
                n = fontMetrics.stringWidth(string.substring(0, this.fBegin));
                int n5 = fontMetrics.stringWidth(string.substring(this.fBegin, this.fEnd));
                if (this.fFocus) {
                    graphics2.setColor(this.getSelectionBackground());
                } else {
                    graphics2.setColor(color4);
                }
                graphics2.fillRect(n2 - n4 + n, 4, n5, dimension.height - 8);
                if (this.fFocus) {
                    graphics2.setColor(this.getSelectionForeground());
                } else {
                    graphics2.setColor(color7);
                }
                graphics2.drawString(string2, n2 - n4 + n, n3);
            }
            if (this.fBlink && this.fOffset <= this.fStart) {
                int n6 = this.fBegin < this.fStart ? this.fEnd : this.fBegin;
                n = fontMetrics.stringWidth(string.substring(0, n6));
                graphics2.setColor(color9);
                graphics2.drawLine(n2 - n4 + n, 3, n2 - n4 + n, dimension.height - 4);
            }
            graphics2.setClip(0, 0, dimension.width, dimension.height);
        }
        if (graphics2 == this.fBufferGraphics && this.fBuffer != null) {
            graphics.drawImage(this.fBuffer, 0, 0, this);
        }
    }

    private void checkValidity(boolean bl) {
        if (this.fValid != bl) {
            Vector vector;
            this.fValid = bl;
            int n = bl ? 2000 : 2001;
            MaskedTextFieldEvent maskedTextFieldEvent = new MaskedTextFieldEvent(this, n);
            MaskedTextField maskedTextField = this;
            synchronized (maskedTextField) {
                vector = (Vector)this.fMaskedListeners.clone();
            }
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (bl) {
                    ((MaskedTextFieldListener)vector.elementAt(n3)).textValidated(maskedTextFieldEvent);
                } else {
                    ((MaskedTextFieldListener)vector.elementAt(n3)).textInvalidated(maskedTextFieldEvent);
                }
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyTyped(KeyEvent var1_1) {
        if (this.fEditable) {
            if (this.clipboardCommand(var1_1)) {
                return;
            }
        } else if (var1_1.getKeyChar() == TextClipboardComponent.getCopyCharacter() && var1_1.getKeyCode() == TextClipboardComponent.getCopyModifier()) {
            this.copy();
        }
        var2_2 = Toolkit.getDefaultToolkit();
        var3_3 = var1_1.getKeyChar();
        switch (var3_3) {
            case '\t': {
                return;
            }
            case '\u001b': {
                var4_4 = this;
                synchronized (var4_4) {
                    if (this.fEnd - this.fBegin > 0) {
                        this.fEnd = this.fBegin = this.fStart;
                        this.adjustOffset();
                        this.repaint();
                        return;
                    }
                    var2_2.beep();
                    return;
                }
            }
            case '\n': 
            case '\r': {
                var4_5 = new ActionEvent(this, 1001, this.getText());
                var6_12 = this;
                synchronized (var6_12) {
                    var5_9 = (Vector)this.fActionListeners.clone();
                }
                var6_13 = var5_9.size();
                var7_31 = 0;
                while (true) {
                    if (var7_31 >= var6_13) {
                        return;
                    }
                    ((ActionListener)var5_9.elementAt(var7_31)).actionPerformed(var4_5);
                    ++var7_31;
                }
            }
            case '\b': {
                if (!this.fEditable) return;
                var4_6 = false;
                var5_10 /* !! */  = this;
                synchronized (var5_10 /* !! */ ) {
                    var7_32 /* !! */  = new StringBuffer(this.fText.toString());
                    var8_36 = var7_32 /* !! */ .length();
                    var9_38 = this.fBegin;
                    var10_40 = this.fEnd;
                    var11_42 = this.fStart;
                    if (!this.fDirection.isRight()) ** GOTO lbl69
                    if (!this.fShiftText) ** GOTO lbl63
                    if (var10_40 - var9_38 != 0) break block104;
                    if (var9_38 == 0) {
                        return;
                    }
                    var12_44 = false;
                    var13_52 = --var9_38;
                    if (true) ** GOTO lbl214
lbl63:
                    // 1 sources

                    if (var10_40 - var9_38 <= 0) ** GOTO lbl66
                    var12_46 = var9_38;
                    if (true) ** GOTO lbl244
lbl66:
                    // 1 sources

                    var12_47 = false;
                    var13_53 = var9_38 - 1;
                    if (true) ** GOTO lbl254
lbl69:
                    // 1 sources

                    if (!this.fShiftText) ** GOTO lbl80
                    var12_48 = var9_38;
                    if (var10_40 - var9_38 != 0) ** GOTO lbl78
                    if (var9_38 == 0) {
                        return;
                    }
                    var13_54 = false;
                    var14_59 = var9_38 - 1;
                    if (true) ** GOTO lbl265
lbl78:
                    // 1 sources

                    var12_48 = var10_40;
                    break block105;
lbl80:
                    // 1 sources

                    if (var10_40 - var9_38 <= 0) ** GOTO lbl83
                    var12_49 = var9_38;
                    if (true) ** GOTO lbl296
lbl83:
                    // 1 sources

                    var12_49 = 0;
                    var13_56 = var9_38 - 1;
                    while (var13_56 >= 0) {
                        if (this.fMasks[var13_56] != null) {
                            var12_49 = 1;
                            var7_32 /* !! */ .setCharAt(var13_56, '\uffff');
                            break;
                        }
                        --var13_56;
                    }
                    if (var12_49 == 0) {
                        var2_2.beep();
                        return;
                    }
lbl96:
                    // 3 sources

                    while (true) {
                        var9_38 = var10_40;
lbl98:
                        // 5 sources

                        while (true) {
                            var4_6 = this.validateText(var7_32 /* !! */ .toString());
                            if (!var4_6 && !this.fAllowInvalid) {
                                var2_2.beep();
                                return;
                            }
                            this.fText = var7_32 /* !! */ ;
                            this.fEnd = this.fBegin = var9_38;
                            this.fStart = this.fBegin;
                            if (this.fBegin < this.fOffset) {
                                this.fOffset = this.fBegin;
                            }
                            break;
                        }
                        break;
                    }
                }
                this.checkValidity(var4_6);
                var5_10 /* !! */  = new TextEvent(this, 900);
                var7_32 /* !! */  = this;
                synchronized (var7_32 /* !! */ ) {
                    var6_21 = (Vector)this.fTextListeners.clone();
                }
                var7_33 = var6_21.size();
                var8_36 = 0;
                while (true) {
                    if (var8_36 >= var7_33) {
                        this.repaint();
                        return;
                    }
                    ((TextListener)var6_21.elementAt(var8_36)).textValueChanged((TextEvent)var5_10 /* !! */ );
                    ++var8_36;
                }
            }
            default: {
                if (!this.fEditable) return;
                if (this.fEnd - this.fBegin > 0) {
                    this.keyTyped(new KeyEvent(this, 400, var1_1.getWhen(), var1_1.getModifiers(), 0, '\b'));
                }
                var4_7 = false;
                var5_11 /* !! */  = this;
                synchronized (var5_11 /* !! */ ) {
                    var7_34 /* !! */  = new StringBuffer(this.fText.toString());
                    var8_37 = var7_34 /* !! */ .length();
                    var9_39 = this.fBegin;
                    var10_41 = this.fEnd;
                    var11_43 = this.fStart;
                    if (!this.fDirection.isRight()) ** GOTO lbl151
                    if (var9_39 == var8_37) {
                        var2_2.beep();
                        return;
                    }
                    var12_50 = -1;
                    var13_57 = var9_39;
                    if (true) ** GOTO lbl305
lbl151:
                    // 1 sources

                    if (var9_39 == 0) {
                        var2_2.beep();
                        return;
                    }
                    var12_50 = -1;
                    var13_57 = var9_39 - 1;
                    while (var13_57 >= 0) {
                        if (this.fMasks[var13_57] != null) {
                            var12_50 = var13_57;
                            break;
                        }
                        --var13_57;
                    }
                    if (var12_50 == -1) {
                        var2_2.beep();
                        return;
                    }
                    if (this.fShiftText) {
                        var14_62 = this.getTextMaskChars();
                        var15_64 = 0;
                        var16_66 = 0;
                        while (var16_66 < var8_37) {
                            if (this.fMasks[var16_66] != null) {
                                if (var16_66 >= var9_39) break;
                                ++var15_64;
                            }
                            ++var16_66;
                        }
                        var14_62 = String.valueOf(var14_62.substring(1, var15_64)) + '\uffff' + var14_62.substring(var15_64);
                        var14_62.length();
                        var17_68 = 0;
                        var18_69 = 0;
                        while (var18_69 < var8_37) {
                            if (this.fMasks[var18_69] != null) {
                                var7_34 /* !! */ .setCharAt(var18_69, var14_62.charAt(var17_68));
                                ++var17_68;
                            }
                            ++var18_69;
                        }
                    }
                    if ((var14_61 = this.fMasks[var12_50].validateCharacter(var3_3)) == -1) {
                        if (!this.fAllowInvalid) {
                            var2_2.beep();
                            return;
                        }
                        var7_34 /* !! */ .setCharAt(var12_50, var3_3);
                    } else {
                        var7_34 /* !! */ .setCharAt(var12_50, (char)var14_61);
                    }
                    if (!this.fMoveCursor) break block106;
                    var15_64 = var9_39 - 1;
                    while (var15_64 >= 0) {
                        if (this.fMasks[var15_64] != null) {
                            var10_41 = var9_39 = var15_64;
                            var11_43 = var9_39;
                            break block106;
                        }
                        --var15_64;
                    }
                    break block106;
                }
            }
        }
        {
            block105: {
                block104: {
                    do {
                        if (this.fMasks[var13_52] != null) {
                            var12_44 = true;
                            var9_38 = var13_52;
                            break;
                        }
                        --var13_52;
lbl214:
                        // 2 sources

                    } while (var13_52 >= 0);
                    if (!var12_44) {
                        return;
                    }
                }
                var12_45 = new StringBuffer();
                var13_52 = var10_40;
                while (var13_52 < var8_36) {
                    if (this.fMasks[var13_52] != null) {
                        var12_45.append(var7_32 /* !! */ .charAt(var13_52));
                    }
                    ++var13_52;
                }
                var14_59 = var12_45.length();
                var15_63 = 0;
                var16_65 = var9_38;
                while (true) {
                    if (var16_65 >= var8_36) ** GOTO lbl98
                    if (this.fMasks[var16_65] != null) {
                        if (var15_63 < var14_59) {
                            var7_32 /* !! */ .setCharAt(var16_65, var12_45.charAt(var15_63));
                            ++var15_63;
                        } else {
                            var7_32 /* !! */ .setCharAt(var16_65, '\uffff');
                        }
                    }
                    ++var16_65;
                }
                do {
                    if (this.fMasks[var12_46] != null) {
                        var7_32 /* !! */ .setCharAt(var12_46, '\uffff');
                    }
                    ++var12_46;
lbl244:
                    // 2 sources

                } while (var12_46 < var10_40);
                ** GOTO lbl98
                do {
                    if (this.fMasks[var13_53] != null) {
                        var12_47 = true;
                        var7_32 /* !! */ .setCharAt(var13_53, '\uffff');
                        var10_40 = var9_38 = var13_53;
                        var11_42 = var9_38;
                        break;
                    }
                    --var13_53;
lbl254:
                    // 2 sources

                } while (var13_53 >= 0);
                if (var12_47) ** GOTO lbl98
                var2_2.beep();
                return;
                do {
                    if (this.fMasks[var14_59] != null) {
                        var13_54 = true;
                        var9_38 = var14_59;
                        break;
                    }
                    --var14_59;
lbl265:
                    // 2 sources

                } while (var14_59 > 0);
                if (!var13_54) {
                    return;
                }
            }
            var13_55 = new StringBuffer();
            var14_59 = 0;
            while (var14_59 < var9_38) {
                if (this.fMasks[var14_59] != null) {
                    var13_55.append(var7_32 /* !! */ .charAt(var14_59));
                }
                ++var14_59;
            }
            var15_63 = var13_55.length();
            var16_65 = 0;
            var17_67 = var10_40 - 1;
            while (var17_67 >= 0) {
                if (this.fMasks[var17_67] != null) {
                    if (var16_65 < var15_63) {
                        var7_32 /* !! */ .setCharAt(var17_67, var13_55.charAt(var15_63 - var16_65 - 1));
                        ++var16_65;
                    } else {
                        var7_32 /* !! */ .setCharAt(var17_67, '\uffff');
                    }
                }
                --var17_67;
            }
            var9_38 = var10_40;
            ** continue;
            do {
                if (this.fMasks[var12_49] != null) {
                    var7_32 /* !! */ .setCharAt(var12_49, '\uffff');
                }
                ++var12_49;
lbl296:
                // 2 sources

            } while (var12_49 < var10_40);
            ** continue;
        }
        {
            block106: {
                do {
                    if (this.fMasks[var13_57] != null) {
                        var10_41 = var9_39 = var13_57;
                        var11_43 = var9_39;
                        var12_50 = var9_39;
                        break;
                    }
                    ++var13_57;
lbl305:
                    // 2 sources

                } while (var13_57 < this.fMasks.length);
                if (var12_50 == -1) {
                    var2_2.beep();
                    return;
                }
                if (this.fShiftText) {
                    var14_60 = this.getTextMaskChars();
                    var15_64 = 0;
                    var16_66 = 0;
                    while (var16_66 < var8_37) {
                        if (this.fMasks[var16_66] != null) {
                            if (var16_66 >= var9_39) break;
                            ++var15_64;
                        }
                        ++var16_66;
                    }
                    var14_60 = String.valueOf(var14_60.substring(0, var15_64)) + '\uffff' + var14_60.substring(var15_64);
                    var17_68 = 0;
                    var18_69 = 0;
                    while (var18_69 < var8_37) {
                        if (this.fMasks[var18_69] != null) {
                            var7_34 /* !! */ .setCharAt(var18_69, var14_60.charAt(var17_68));
                            ++var17_68;
                        }
                        ++var18_69;
                    }
                }
                if ((var14_61 = this.fMasks[var9_39].validateCharacter(var3_3)) == -1) {
                    if (!this.fAllowInvalid) {
                        var2_2.beep();
                        return;
                    }
                    var7_34 /* !! */ .setCharAt(var9_39, var3_3);
                } else {
                    var7_34 /* !! */ .setCharAt(var9_39, (char)var14_61);
                }
                if (this.fMoveCursor) {
                    var11_43 = var10_41 = ++var9_39;
                    var15_64 = var9_39;
                    while (var15_64 < this.fMasks.length) {
                        if (this.fMasks[var15_64] != null) {
                            var10_41 = var9_39 = var15_64;
                            var11_43 = var9_39;
                            break;
                        }
                        ++var15_64;
                    }
                }
            }
            if (!(var4_7 = this.validateText(var7_34 /* !! */ .toString())) && !this.fAllowInvalid) {
                var2_2.beep();
                return;
            }
            this.fText = var7_34 /* !! */ ;
            this.fBegin = var9_39;
            this.fEnd = var10_41;
            this.fStart = var11_43;
            if (this.fBegin < this.fOffset) {
                this.fOffset = this.fBegin;
            } else {
                var12_51 = this.getFontMetrics(this.getFont());
                if (var12_51 == null) {
                    return;
                }
                var13_58 = this.fText.toString().substring(0, this.fBegin);
                var14_61 = this.getSize().width - 10;
                if (var12_51.stringWidth(var13_58) > var14_61) {
                    var15_64 = var13_58.length();
                    this.fOffset = 0;
                    var16_66 = 0;
                    while (var16_66 < var15_64) {
                        if (var12_51.stringWidth(var13_58.substring(var16_66)) < var14_61) {
                            this.fOffset = var16_66;
                            break;
                        }
                        ++var16_66;
                    }
                }
            }
        }
        this.checkValidity(var4_7);
        var5_11 /* !! */  = new TextEvent(this, 900);
        var7_34 /* !! */  = this;
        synchronized (var7_34 /* !! */ ) {
            var6_30 = (Vector)this.fTextListeners.clone();
        }
        var7_35 = var6_30.size();
        var8_37 = 0;
        while (var8_37 < var7_35) {
            ((TextListener)var6_30.elementAt(var8_37)).textValueChanged((TextEvent)var5_11 /* !! */ );
            ++var8_37;
        }
        this.repaint();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(KeyEvent var1_1) {
        var2_2 = var1_1.getKeyCode();
        var3_3 = var1_1.isShiftDown();
        var4_4 = Toolkit.getDefaultToolkit();
        switch (var2_2) {
            case 9: {
                return;
            }
            case 127: {
                if (!this.fEditable) return;
                if (this.fEnd - this.fBegin > 0) {
                    this.keyTyped(new KeyEvent(this, 400, var1_1.getWhen(), var1_1.getModifiers(), 0, '\b'));
                    return;
                }
                var5_5 = false;
                var6_10 /* !! */  = this;
                synchronized (var6_10 /* !! */ ) {
                    var8_17 = new StringBuffer(this.fText.toString());
                    var9_19 = var8_17.length();
                    if (this.fBegin == var9_19) {
                        var4_4.beep();
                        return;
                    }
                    var10_26 = this.fBegin;
                    var11_27 = this.fEnd;
                    if (!this.fDirection.isRight()) ** GOTO lbl66
                    if (!this.fShiftText) ** GOTO lbl-1000
                    var12_28 = this.getTextMaskChars();
                    var13_32 = 0;
                    var14_33 = 0;
                    var15_34 = 0;
                    while (var15_34 < var9_19) {
                        if (this.fMasks[var15_34] != null) {
                            if (var15_34 < var10_26) {
                                ++var13_32;
                            } else {
                                if (var15_34 >= var11_27) break;
                                ++var14_33;
                            }
                        }
                        ++var15_34;
                    }
                    var12_28 = String.valueOf(var12_28.substring(0, var13_32)) + var12_28.substring(var13_32 + var14_33 + 1);
                    var16_35 = var12_28.length();
                    var17_37 = 0;
                    var18_38 = 0;
                    while (var18_38 < var9_19) {
                        if (this.fMasks[var18_38] != null) {
                            if (var17_37 < var16_35) {
                                var8_17.setCharAt(var18_38, var12_28.charAt(var17_37));
                                ++var17_37;
                            } else {
                                var8_17.setCharAt(var18_38, '\uffff');
                            }
                        }
                        ++var18_38;
                    }
                    var5_5 = this.validateText(var8_17.toString());
                    if (var5_5 || this.fAllowInvalid) ** GOTO lbl118
                    var4_4.beep();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        var12_29 = var10_26;
                        while (var12_29 < var9_19) {
                            if (this.fMasks[var12_29] != null) {
                                var8_17.setCharAt(var12_29, '\uffff');
                                break;
                            }
                            ++var12_29;
                        }
                        var5_5 = this.validateText(var8_17.toString());
                        ** GOTO lbl118
lbl66:
                        // 1 sources

                        if (!this.fShiftText) ** GOTO lbl-1000
                        var12_30 = this.getTextMaskChars();
                        var13_32 = 0;
                        var14_33 = 0;
                        var15_34 = 0;
                        while (var15_34 < var9_19) {
                            if (this.fMasks[var15_34] != null) {
                                if (var15_34 < var10_26) {
                                    ++var13_32;
                                } else {
                                    if (var15_34 >= var11_27) break;
                                    ++var14_33;
                                }
                            }
                            ++var15_34;
                        }
                        var16_36 = new StringBuffer();
                        var16_36.append('\uffff');
                        var16_36.append(var12_30.substring(0, var13_32));
                        var16_36.append(var12_30.substring(var13_32 + var14_33 + 1));
                        var12_30 = var16_36.toString();
                        var17_37 = var12_30.length();
                        var18_38 = 0;
                        var19_39 = false;
                        var20_40 = 0;
                        while (var20_40 < var9_19) {
                            if (this.fMasks[var20_40] != null) {
                                if (var18_38 < var17_37) {
                                    var8_17.setCharAt(var20_40, var12_30.charAt(var18_38));
                                    ++var18_38;
                                } else {
                                    var8_17.setCharAt(var20_40, '\uffff');
                                }
                                if (!var19_39 && var20_40 > var10_26) {
                                    var10_26 = var20_40;
                                    var19_39 = true;
                                }
                            }
                            ++var20_40;
                        }
                        if (!var19_39) {
                            var10_26 = var9_19;
                        }
                        if ((var5_5 = this.validateText(var8_17.toString())) || this.fAllowInvalid) ** GOTO lbl118
                        var4_4.beep();
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        var12_31 = var10_26;
                        while (var12_31 < var9_19) {
                            if (this.fMasks[var12_31] != null) {
                                var8_17.setCharAt(var12_31, '\uffff');
                                break;
                            }
                            ++var12_31;
                        }
                        var5_5 = this.validateText(var8_17.toString());
lbl118:
                        // 4 sources

                        this.fText = var8_17;
                        this.fEnd = this.fStart = var10_26;
                        this.fBegin = this.fStart;
                    }
                }
                this.checkValidity(var5_5);
                var6_10 /* !! */  = new TextEvent(this, 900);
                var8_17 = this;
                synchronized (var8_17) {
                    var7_23 = (Vector)this.fTextListeners.clone();
                }
                var8_18 = var7_23.size();
                var9_19 = 0;
                while (var9_19 < var8_18) {
                    ((TextListener)var7_23.elementAt(var9_19)).textValueChanged((TextEvent)var6_10 /* !! */ );
                    ++var9_19;
                }
                this.repaint();
                return;
            }
            case 36: {
                var5_6 = this;
                synchronized (var5_6) {
                    if (this.fBegin == 0 && this.fOffset == 0) {
                        var4_4.beep();
                        return;
                    }
                    if (var3_3) {
                        if (this.fStart == -1) {
                            this.fStart = this.fBegin;
                        } else {
                            this.fEnd = this.fStart;
                        }
                        this.fBegin = 0;
                    } else {
                        this.fEnd = 0;
                        this.fBegin = 0;
                        this.fStart = 0;
                    }
                    this.fOffset = this.fBegin;
                }
                this.repaint();
                return;
            }
            case 35: {
                var5_7 = this;
                synchronized (var5_7) {
                    var7_24 = this.fText.length();
                    if (var7_24 == 0 || this.fBegin == var7_24) {
                        var4_4.beep();
                        return;
                    }
                    if (var3_3) {
                        if (this.fStart == -1) {
                            this.fStart = this.fBegin;
                        } else {
                            this.fBegin = this.fStart;
                        }
                        this.fEnd = var7_24;
                    } else {
                        this.fBegin = this.fEnd = var7_24;
                        this.fStart = this.fEnd;
                    }
                    this.adjustOffset();
                }
                this.repaint();
                return;
            }
            case 37: {
                var5_8 = this;
                synchronized (var5_8) {
                    if (!var3_3) ** GOTO lbl203
                    if (this.fEnd > this.fStart) {
                        --this.fEnd;
                    } else if (this.fBegin > 0) {
                        --this.fBegin;
                    } else {
                        var4_4.beep();
                        return;
lbl203:
                        // 1 sources

                        if (this.fEnd - this.fBegin > 0) {
                            this.fStart = this.fEnd = this.fBegin;
                        } else {
                            if (this.fBegin == 0) return;
                            this.fEnd = --this.fBegin;
                            this.fStart = this.fBegin;
                        }
                    }
                    if (this.fBegin < this.fOffset) {
                        this.fOffset = this.fBegin;
                    }
                }
                this.repaint();
                return;
            }
            case 39: {
                var5_9 = this;
                synchronized (var5_9) {
                    var7_25 = this.fText.length();
                    if (var3_3) {
                        if (this.fBegin < this.fStart) {
                            ++this.fBegin;
                        } else {
                            if (this.fEnd == var7_25) return;
                            ++this.fEnd;
                        }
                    } else if (this.fEnd - this.fBegin > 0) {
                        this.fStart = this.fBegin = this.fEnd;
                    } else {
                        if (this.fBegin == var7_25) return;
                        this.fEnd = ++this.fBegin;
                        this.fStart = this.fBegin;
                    }
                    this.adjustOffset();
                }
                this.repaint();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        if (this.fNewFocus || mouseEvent.getClickCount() > 1) {
            this.fBegin = 0;
            this.fEnd = this.fText.length();
            this.fStart = this.fDirection.isRight() ? this.fBegin : this.fEnd;
            this.fNewFocus = false;
            this.adjustOffset();
            this.repaint();
        }
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.getSize();
        int n = mouseEvent.getX() - 5;
        StringBuffer stringBuffer = new StringBuffer(this.getDisplayText());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        int n2 = stringBuffer.length();
        this.fOffsets = new int[n2];
        int n3 = n2;
        while (n3 > 0) {
            stringBuffer.setLength(n3);
            this.fOffsets[n3 - 1] = fontMetrics.stringWidth(stringBuffer.toString());
            --n3;
        }
        String string = this.fText.toString().substring(0, this.fOffset);
        int n4 = fontMetrics.stringWidth(string);
        int n5 = 0;
        while (n5 < n2) {
            if (n < this.fOffsets[n5] - n4) {
                this.fBegin = this.fEnd = n5;
                this.fStart = this.fEnd;
                this.repaint();
                return;
            }
            ++n5;
        }
        this.fBegin = this.fEnd = n2;
        this.fStart = this.fEnd;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - 5;
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        String string = this.getDisplayText().substring(0, this.fOffset);
        int n2 = fontMetrics.stringWidth(string);
        int n3 = this.fOffsets.length;
        int n4 = 0;
        while (n4 < n3) {
            if (n < this.fOffsets[n4] - n2) {
                if (n4 < this.fStart) {
                    this.fBegin = n4;
                    this.fEnd = this.fStart;
                } else {
                    this.fBegin = this.fStart;
                    this.fEnd = n4;
                }
                if (n > dimension.width + 5) {
                    ++this.fOffset;
                }
                if (this.fOffset > 0 && n < 0) {
                    --this.fOffset;
                }
                this.repaint();
                return;
            }
            ++n4;
        }
        if (this.fStart == n3) {
            this.fBegin = n3;
        }
        this.fEnd = n3;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("mask=" + this.fMask);
        stringBuffer.append(",value=" + this.fText.toString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public synchronized void cut() {
        if (this.fEnd - this.fBegin > 0) {
            this.copy();
            this.keyTyped(new KeyEvent(this, 400, System.currentTimeMillis(), 0, 0, '\b'));
        }
    }

    public synchronized void copy() {
        if (this.fEnd - this.fBegin > 0) {
            String string = this.getText(true, true).substring(this.fBegin, this.fEnd);
            this.copyToClipboard(string);
        }
    }

    public synchronized void paste() {
        String string = this.copyFromClipboard();
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.keyTyped(new KeyEvent(this, 400, System.currentTimeMillis(), 0, 0, string.charAt(n2)));
            ++n2;
        }
    }
}

