/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.BorderPanel;
import com.ibm.webrunner.widget.BorderPanelStyle;
import com.ibm.webrunner.widget.DatePicker;
import com.ibm.webrunner.widget.UpdatingImageButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.FieldPosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

class PaintPanel
extends BorderPanel
implements ActionListener,
FocusListener,
KeyListener,
MouseListener {
    DatePicker fDP;
    GregorianCalendar gc = new GregorianCalendar();
    GregorianCalendar today = new GregorianCalendar();
    TimeZone tz;
    Font fb = new Font("Dialog", 1, 12);
    Font fn = new Font("Dialog", 0, 10);
    transient UpdatingImageButton aLeft;
    transient UpdatingImageButton aRight;
    transient UpdatingImageButton aUp;
    transient UpdatingImageButton aDown;
    transient Image fOffscreen;
    int[][] valid = new int[6][7];
    String sun = "";
    String mon = "";
    String tue = "";
    String wed = "";
    String thu = "";
    String fri = "";
    String sat = "";
    int xWidth = 30;
    int halfXWidth = 15;
    int todayYear;
    int todayMonth;
    int todayDay;
    static ResourceBundle res = null;

    PaintPanel(TimeZone timeZone) {
        super(BorderPanelStyle.RAISED, 2);
        this.initialize();
        this.setTimeZone(timeZone);
        int n = 0;
        while (n < 6) {
            int n2 = 0;
            while (n2 < 7) {
                this.valid[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
        this.setLayout(null);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    private void initialize() {
        PaintPanel.loadResources();
        this.sun = res.getString("Sun");
        this.mon = res.getString("Mon");
        this.tue = res.getString("Tue");
        this.wed = res.getString("Wed");
        this.thu = res.getString("Thu");
        this.fri = res.getString("Fri");
        this.sat = res.getString("Sat");
        int n = this.getSize().width;
        this.aLeft = new UpdatingImageButton(this.createLeftImage());
        this.aLeft.setSize(new Dimension(20, 15));
        this.aLeft.addActionListener(this);
        this.aLeft.addMouseListener(this);
        this.aRight = new UpdatingImageButton(this.createRightImage());
        this.aRight.setSize(new Dimension(20, 15));
        this.aRight.addActionListener(this);
        this.aRight.addMouseListener(this);
        this.aUp = new UpdatingImageButton(this.createUpImage());
        this.aUp.setBorderThickness(1);
        this.aUp.setSize(new Dimension(15, 8));
        this.aUp.addActionListener(this);
        this.aUp.addMouseListener(this);
        this.aDown = new UpdatingImageButton(this.createDownImage());
        this.aDown.setBorderThickness(1);
        this.aDown.setSize(new Dimension(15, 8));
        this.aDown.addActionListener(this);
        this.aDown.addMouseListener(this);
        this.add(this.aLeft);
        this.aLeft.setBounds(5, 5, 20, 15);
        this.aLeft.setLocation(15, 5);
        this.add(this.aRight);
        this.aRight.setBounds(n - 5 - 20, 5, 20, 15);
        this.add(this.aUp);
        this.aUp.setBounds(100, 5, 15, 8);
        this.add(this.aDown);
        this.aDown.setBounds(100, 13, 15, 8);
        this.aUp.setLocation(170, 5);
        this.aDown.setLocation(170, 13);
        this.fOffscreen = null;
    }

    PaintPanel() {
        this(TimeZone.getDefault());
    }

    void setDatePicker(DatePicker datePicker) {
        this.fDP = datePicker;
    }

    void setTimeZone(TimeZone timeZone) {
        this.tz = timeZone;
        ((Calendar)this.gc).setTimeZone(timeZone);
        this.gc.setTime(this.gc.getTime());
        ((Calendar)this.today).setTimeZone(timeZone);
        this.today.setTime(this.today.getTime());
        this.todayYear = this.today.get(1);
        this.todayMonth = this.today.get(2);
        this.todayDay = this.today.get(5);
    }

    TimeZone getTimeZone() {
        return this.tz;
    }

    void aUp_actionPerformed() {
        this.gc.add(1, 1);
        this.gc.setTime(this.gc.getTime());
        this.gc.get(1);
        this.gc.get(2);
        this.gc.get(5);
        this.paint(null);
    }

    void aDown_actionPerformed() {
        this.gc.add(1, -1);
        this.gc.setTime(this.gc.getTime());
        this.gc.get(1);
        this.gc.get(2);
        this.gc.get(5);
        this.paint(null);
    }

    void aLeft_actionPerformed() {
        this.gc.add(2, -1);
        this.gc.setTime(this.gc.getTime());
        this.gc.get(1);
        this.gc.get(2);
        this.gc.get(5);
        try {
            this.invalidate();
        }
        catch (Exception exception) {}
        try {
            this.paint(this.getGraphics());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void aRight_actionPerformed() {
        this.gc.add(2, 1);
        this.gc.setTime(this.gc.getTime());
        this.gc.get(1);
        this.gc.get(2);
        this.gc.get(5);
        try {
            this.paint(null);
        }
        catch (Exception exception) {}
        try {
            this.paint(null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void paintPanel_mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - 10;
        int n4 = n2 - 54 + 6;
        if ((n3 /= this.xWidth) < 0 || n3 > 6 || (n4 /= 12) < 0 || n4 > 5) {
            if (n2 >= this.getSize().height - 18) {
                this.gc.setTime(this.today.getTime());
                int n5 = this.gc.get(1);
                int n6 = this.gc.get(2);
                int n7 = this.gc.get(5);
                this.fDP.setDateByFields(n5, n6, n7);
                this.fDP.dropDownButton.setMouseDown(false);
                if (this.fDP.w != null) {
                    ((Component)this.fDP.w).setVisible(false);
                }
                this.fDP.fireDateChangedEvent();
            }
            return;
        }
        int n8 = this.valid[n4][n3];
        if (n8 != 0) {
            int n9 = this.gc.get(1);
            int n10 = this.gc.get(2);
            this.gc.set(n9, n10, n8);
            this.gc.setTime(this.gc.getTime());
            this.fDP.setDateByFields(n9, n10, n8);
            this.fDP.dropDownButton.setMouseDown(false);
            if (this.fDP.w != null) {
                ((Component)this.fDP.w).setVisible(false);
            }
            this.fDP.fireDateChangedEvent();
        }
    }

    public Dimension getPreferredSize() {
        int n = 140;
        int n2 = 223;
        return new Dimension(n2, n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public synchronized void paint(Graphics graphics) {
        if (this.fOffscreen == null || this.fOffscreen.getWidth(this) != this.getSize().width - 4 || this.fOffscreen.getHeight(this) != this.getSize().height - 4) {
            this.fOffscreen = this.createImage(this.getSize().width - 4, this.getSize().height - 4);
        }
        Graphics graphics2 = this.fOffscreen.getGraphics();
        graphics2.setColor(Color.lightGray);
        graphics2.fillRect(0, 0, this.getSize().width - 4, this.getSize().height - 4);
        int n = this.gc.get(2);
        int n2 = this.gc.get(1);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.set(n2, n, 1);
        gregorianCalendar.setTime(gregorianCalendar.getTime());
        if (graphics != null) {
            super.paint(graphics);
        } else {
            graphics = this.getGraphics();
        }
        int n3 = this.getSize().width;
        this.aRight.setLocation(n3 - 5 - 20, 5);
        int n4 = n3 / 2;
        int n5 = this.fDP.fGC.get(5);
        int n6 = this.fDP.fGC.get(2);
        int n7 = this.fDP.fGC.get(1);
        String string = "";
        switch (n) {
            case 0: {
                string = res.getString("January");
                break;
            }
            case 1: {
                string = res.getString("February");
                break;
            }
            case 2: {
                string = res.getString("March");
                break;
            }
            case 3: {
                string = res.getString("April");
                break;
            }
            case 4: {
                string = res.getString("May");
                break;
            }
            case 5: {
                string = res.getString("June");
                break;
            }
            case 6: {
                string = res.getString("July");
                break;
            }
            case 7: {
                string = res.getString("August");
                break;
            }
            case 8: {
                string = res.getString("September");
                break;
            }
            case 9: {
                string = res.getString("October");
                break;
            }
            case 10: {
                string = res.getString("November");
                break;
            }
            case 11: {
                string = res.getString("December");
                break;
            }
        }
        string = String.valueOf(string) + " " + n2;
        graphics2.setColor(Color.black);
        graphics2.setFont(this.fb);
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        graphics2.drawString(string, n4 - fontMetrics.stringWidth(string) / 2, 15);
        fontMetrics.stringWidth(string);
        int n8 = 36;
        int n9 = 5;
        graphics2.setFont(this.fn);
        fontMetrics = graphics2.getFontMetrics();
        int n10 = fontMetrics.stringWidth(this.sun);
        int n11 = fontMetrics.stringWidth(this.mon);
        int n12 = fontMetrics.stringWidth(this.tue);
        int n13 = fontMetrics.stringWidth(this.wed);
        int n14 = fontMetrics.stringWidth(this.thu);
        int n15 = fontMetrics.stringWidth(this.fri);
        int n16 = fontMetrics.stringWidth(this.sat);
        graphics2.drawString(this.sun, n9 + this.halfXWidth - n10 / 2, n8);
        graphics2.drawString(this.mon, (n9 += this.xWidth) + this.halfXWidth - n11 / 2, n8);
        graphics2.drawString(this.tue, (n9 += this.xWidth) + this.halfXWidth - n12 / 2, n8);
        graphics2.drawString(this.wed, (n9 += this.xWidth) + this.halfXWidth - n13 / 2, n8);
        graphics2.drawString(this.thu, (n9 += this.xWidth) + this.halfXWidth - n14 / 2, n8);
        graphics2.drawString(this.fri, (n9 += this.xWidth) + this.halfXWidth - n15 / 2, n8);
        graphics2.drawString(this.sat, (n9 += this.xWidth) + this.halfXWidth - n16 / 2, n8);
        graphics2.setColor(Color.gray);
        graphics2.fillRect(5, 40, n9 + this.xWidth - 5, 3);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar2.set(n2, n, 1);
        gregorianCalendar2.setTime(gregorianCalendar2.getTime());
        int n17 = gregorianCalendar2.get(7) - 1;
        gregorianCalendar.set(n2, n, 1);
        int n18 = gregorianCalendar.get(5);
        int n19 = n;
        int n20 = 0;
        boolean bl = true;
        graphics2.setColor(Color.black);
        while (n19 == n) {
            if (n17 == 0 && !bl) {
                ++n20;
            }
            if (n18 > 31) break;
            bl = false;
            this.valid[n20][n17] = n18;
            string = String.valueOf(n18);
            graphics2.setColor(Color.black);
            if (n18 == this.todayDay && n == this.todayMonth && n2 == this.todayYear) {
                graphics2.setColor(Color.red);
            }
            if (n18 == n5 && n == n6 && n2 == n7) {
                graphics2.setColor(Color.yellow);
            }
            ++n18;
            n9 = n17 * this.xWidth + 10 + this.halfXWidth - fontMetrics.stringWidth(string);
            n8 = 54 + 12 * n20;
            graphics2.drawString(string, n9, n8);
            gregorianCalendar.add(5, 1);
            gregorianCalendar.setTime(gregorianCalendar.getTime());
            n19 = gregorianCalendar.get(2);
            ++n17;
            n17 %= 7;
        }
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.fDP.fSDF.format(this.today.getTime(), stringBuffer, fieldPosition);
        graphics2.setFont(this.fb);
        graphics2.setColor(Color.red);
        graphics2.drawString(res.getString("Today:"), 12, this.getSize().height - 8);
        graphics2.setColor(Color.black);
        graphics2.drawString(stringBuffer.toString(), 60, this.getSize().height - 8);
        graphics.drawImage(this.fOffscreen, 2, 2, this.getSize().width - 4, this.getSize().height - 4, this);
    }

    private static void loadResources() {
        PaintPanel.loadResources(Locale.getDefault());
    }

    private static void loadResources(Locale locale) {
        try {
            res = ResourceBundle.getBundle("com.ibm.webrunner.widget.Res");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            return;
        }
    }

    void paintPanel_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.fDP.fSDF.format(this.fDP.fGC.getTime(), stringBuffer, fieldPosition);
            ((TextComponent)this.fDP.dateEntryField).setText(stringBuffer.toString());
            if (this.fDP.w != null) {
                ((Component)this.fDP.w).setVisible(false);
            }
        }
    }

    void paintPanel_focusLost(FocusEvent focusEvent) {
        Date date = new Date();
        this.fDP.lostTime = date.getTime();
        this.fDP.ignoreNextArrowClick = true;
        if (this.fDP.w != null) {
            ((Component)this.fDP.w).setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.aDown) {
            this.aDown_actionPerformed();
            return;
        }
        if (object == this.aUp) {
            this.aUp_actionPerformed();
            return;
        }
        if (object == this.aLeft) {
            this.aLeft_actionPerformed();
            return;
        }
        if (object == this.aRight) {
            this.aRight_actionPerformed();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this) {
            this.paintPanel_focusLost(focusEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this) {
            this.paintPanel_keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.aRight || object == this.aLeft || object == this.aUp || object == this.aDown) {
            this.removeFocusListener(this);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.aRight || object == this.aLeft || object == this.aUp || object == this.aDown) {
            this.addFocusListener(this);
            this.requestFocus();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this) {
            this.paintPanel_mouseClicked(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private Image createDownImage() {
        byte[] byArray = new byte[91];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 13;
        byArray[8] = 6;
        byArray[10] = -77;
        byArray[16] = -128;
        byArray[20] = -128;
        byArray[22] = -128;
        byArray[23] = -128;
        byArray[27] = -128;
        byArray[28] = -128;
        byArray[30] = -128;
        byArray[32] = -128;
        byArray[33] = -128;
        byArray[34] = -128;
        byArray[35] = -128;
        byArray[36] = -128;
        byArray[37] = -64;
        byArray[38] = -64;
        byArray[39] = -64;
        byArray[40] = -1;
        byArray[44] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[54] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = 44;
        byArray[66] = 13;
        byArray[68] = 6;
        byArray[71] = 4;
        byArray[72] = 16;
        byArray[73] = 16;
        byArray[74] = -55;
        byArray[75] = 73;
        byArray[76] = 43;
        byArray[77] = 2;
        byArray[78] = 56;
        byArray[79] = 3;
        byArray[80] = 123;
        byArray[81] = 53;
        byArray[82] = -105;
        byArray[83] = -39;
        byArray[84] = 55;
        byArray[85] = 109;
        byArray[86] = -94;
        byArray[87] = 24;
        byArray[88] = 1;
        byArray[90] = 59;
        byte[] byArray2 = byArray;
        return Toolkit.getDefaultToolkit().createImage(byArray2);
    }

    private Image createLeftImage() {
        byte[] byArray = new byte[98];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 16;
        byArray[8] = 11;
        byArray[10] = -77;
        byArray[16] = -128;
        byArray[20] = -128;
        byArray[22] = -128;
        byArray[23] = -128;
        byArray[27] = -128;
        byArray[28] = -128;
        byArray[30] = -128;
        byArray[32] = -128;
        byArray[33] = -128;
        byArray[34] = -128;
        byArray[35] = -128;
        byArray[36] = -128;
        byArray[37] = -64;
        byArray[38] = -64;
        byArray[39] = -64;
        byArray[40] = -1;
        byArray[44] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[54] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = 44;
        byArray[66] = 16;
        byArray[68] = 11;
        byArray[71] = 4;
        byArray[72] = 23;
        byArray[73] = 16;
        byArray[74] = -55;
        byArray[75] = 73;
        byArray[76] = -85;
        byArray[77] = -67;
        byArray[78] = -72;
        byArray[79] = -126;
        byArray[80] = -84;
        byArray[81] = 55;
        byArray[82] = -105;
        byArray[83] = 64;
        byArray[84] = -8;
        byArray[85] = 33;
        byArray[86] = -95;
        byArray[87] = 56;
        byArray[88] = -106;
        byArray[89] = 35;
        byArray[90] = -24;
        byArray[91] = -91;
        byArray[92] = 107;
        byArray[93] = -22;
        byArray[94] = 98;
        byArray[95] = 17;
        byArray[97] = 59;
        byte[] byArray2 = byArray;
        return Toolkit.getDefaultToolkit().createImage(byArray2);
    }

    private Image createRightImage() {
        byte[] byArray = new byte[98];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 16;
        byArray[8] = 11;
        byArray[10] = -77;
        byArray[16] = -128;
        byArray[20] = -128;
        byArray[22] = -128;
        byArray[23] = -128;
        byArray[27] = -128;
        byArray[28] = -128;
        byArray[30] = -128;
        byArray[32] = -128;
        byArray[33] = -128;
        byArray[34] = -128;
        byArray[35] = -128;
        byArray[36] = -128;
        byArray[37] = -64;
        byArray[38] = -64;
        byArray[39] = -64;
        byArray[40] = -1;
        byArray[44] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[54] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = 44;
        byArray[66] = 16;
        byArray[68] = 11;
        byArray[71] = 4;
        byArray[72] = 23;
        byArray[73] = 16;
        byArray[74] = -55;
        byArray[75] = 73;
        byArray[76] = -85;
        byArray[77] = -67;
        byArray[78] = 88;
        byArray[79] = -126;
        byArray[80] = 108;
        byArray[81] = -63;
        byArray[82] = -26;
        byArray[83] = -109;
        byArray[84] = -9;
        byArray[85] = -127;
        byArray[86] = -30;
        byArray[87] = -104;
        byArray[88] = -119;
        byArray[89] = -96;
        byArray[90] = 102;
        byArray[91] = 114;
        byArray[92] = 107;
        byArray[93] = -22;
        byArray[94] = -126;
        byArray[95] = 17;
        byArray[97] = 59;
        byte[] byArray2 = byArray;
        return Toolkit.getDefaultToolkit().createImage(byArray2);
    }

    private Image createUpImage() {
        byte[] byArray = new byte[90];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 13;
        byArray[8] = 6;
        byArray[10] = -77;
        byArray[16] = -128;
        byArray[20] = -128;
        byArray[22] = -128;
        byArray[23] = -128;
        byArray[27] = -128;
        byArray[28] = -128;
        byArray[30] = -128;
        byArray[32] = -128;
        byArray[33] = -128;
        byArray[34] = -128;
        byArray[35] = -128;
        byArray[36] = -128;
        byArray[37] = -64;
        byArray[38] = -64;
        byArray[39] = -64;
        byArray[40] = -1;
        byArray[44] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[54] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = 44;
        byArray[66] = 13;
        byArray[68] = 6;
        byArray[71] = 4;
        byArray[72] = 15;
        byArray[73] = 16;
        byArray[74] = -55;
        byArray[75] = 73;
        byArray[76] = 43;
        byArray[77] = 5;
        byArray[78] = -74;
        byArray[79] = -126;
        byArray[80] = -99;
        byArray[81] = -27;
        byArray[82] = -2;
        byArray[83] = -39;
        byArray[84] = 39;
        byArray[85] = 118;
        byArray[86] = 93;
        byArray[87] = 4;
        byArray[89] = 59;
        byte[] byArray2 = byArray;
        return Toolkit.getDefaultToolkit().createImage(byArray2);
    }
}

