/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.Action;
import com.sun.java.swing.Icon;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    protected boolean enabled = true;
    private Hashtable keyTable = new Hashtable(5);
    protected PropertyChangeSupport changeSupport;

    public AbstractAction() {
    }

    public AbstractAction(String name) {
        this.putValue("Name", name);
    }

    public AbstractAction(String name, Icon icon) {
        this(name);
        this.putValue("SmallIcon", icon);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Object getValue(String key) {
        return this.keyTable.get(key);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void putValue(String key, Object newValue) {
        Object oldValue = null;
        if (this.keyTable.containsKey(key)) {
            oldValue = this.keyTable.get(key);
        }
        this.keyTable.put(key, newValue);
        this.firePropertyChange(key, oldValue, newValue);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", new Boolean(oldValue), new Boolean(newValue));
    }

    public abstract void actionPerformed(ActionEvent var1);
}

