/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NamespaceScoped;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWriteContext;
import com.sun.xml.util.XmlNames;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

final class AttributeNode
extends NodeBase
implements Attr,
NamespaceScoped {
    private String name;
    private String value;
    private boolean specified;
    private String defaultValue;
    private ElementNode nameScope;

    public AttributeNode(AttributeNode original) throws DOMException {
        this(original.name, original.value, original.specified, original.defaultValue);
        this.nameScope = original.nameScope;
        this.setOwnerDocument((XmlDocument)original.getOwnerDocument());
    }

    public AttributeNode(String name, String value, boolean specified, String defaultValue) throws DOMException {
        if (!XmlNames.isName(name)) {
            throw new DomEx(5);
        }
        this.name = name;
        this.value = value;
        this.specified = specified;
        this.defaultValue = defaultValue;
    }

    public Node cloneNode(boolean deep) {
        try {
            return new AttributeNode(this);
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("A-002"));
        }
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public String getLocalName() {
        int index = this.name.indexOf(58);
        if (index < 0) {
            return this.name;
        }
        return this.name.substring(index + 1);
    }

    public String getName() {
        return this.name;
    }

    ElementNode getNameScope() {
        return this.nameScope;
    }

    public String getNamespace() {
        if (this.nameScope == null) {
            throw new IllegalStateException(this.getMessage("A-001"));
        }
        int index = this.name.indexOf(58);
        if (index < 0) {
            return this.nameScope.getNamespace();
        }
        String prefix = this.name.substring(0, index);
        if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
            return null;
        }
        String value = this.nameScope.getInheritedAttribute("xmlns:" + prefix);
        if (value == null) {
            throw new IllegalStateException();
        }
        return value;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return this.name;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.value;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public String getValue() {
        return this.value;
    }

    void setNameScope(ElementNode e) {
        if (e != null && this.nameScope != null) {
            throw new IllegalStateException(this.getMessage("A-000", new Object[]{e.getTagName()}));
        }
        this.nameScope = e;
    }

    public void setNodeValue(String value) {
        this.value = value;
        this.specified = true;
    }

    void setSpecified(boolean specified) {
        this.specified = specified;
    }

    public void setValue(String value) {
        this.setNodeValue(value);
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            switch (c) {
                case '<': {
                    out.write("&lt;");
                    break;
                }
                case '>': {
                    out.write("&gt;");
                    break;
                }
                case '&': {
                    out.write("&amp;");
                    break;
                }
                case '\'': {
                    out.write("&apos;");
                    break;
                }
                case '\"': {
                    out.write("&quot;");
                    break;
                }
                default: {
                    out.write(c);
                    break;
                }
            }
            ++i;
        }
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        out.write(this.name);
        out.write("=\"");
        this.writeChildrenXml(context);
        out.write(34);
    }
}

