/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class MemoryHandler
extends Handler {
    private static final int DEFAULT_SIZE = 1000;
    private Level pushLevel;
    private int size;
    private Handler target;
    private LogRecord[] buffer;
    int start;
    int count;

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.pushLevel = logManager.getLevelProperty(string + ".push", Level.SEVERE);
        this.size = logManager.getIntProperty(string + ".size", 1000);
        if (this.size <= 0) {
            this.size = 1000;
        }
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new SimpleFormatter()));
    }

    public MemoryHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        String string = "???";
        try {
            LogManager logManager = LogManager.getLogManager();
            string = logManager.getProperty("java.util.logging.MemoryHandler.target");
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
            this.target = (Handler)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("MemoryHandler can't load handler \"" + string + "\"", exception);
        }
        this.init();
    }

    private void init() {
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public MemoryHandler(Handler handler, int n, Level level) {
        if (handler == null || level == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.target = handler;
        this.pushLevel = level;
        this.size = n;
        this.init();
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        int n = (this.start + this.count) % this.buffer.length;
        this.buffer[n] = logRecord;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
        }
        if (logRecord.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public synchronized void push() {
        for (int i = 0; i < this.count; ++i) {
            int n = (this.start + i) % this.buffer.length;
            LogRecord logRecord = this.buffer[n];
            this.target.publish(logRecord);
        }
        this.start = 0;
        this.count = 0;
    }

    public void flush() {
        this.target.flush();
    }

    public void close() throws SecurityException {
        this.target.close();
        this.setLevel(Level.OFF);
    }

    public void setPushLevel(Level level) throws SecurityException {
        if (level == null) {
            throw new NullPointerException();
        }
        LogManager logManager = LogManager.getLogManager();
        this.checkAccess();
        this.pushLevel = level;
    }

    public synchronized Level getPushLevel() {
        return this.pushLevel;
    }

    public boolean isLoggable(LogRecord logRecord) {
        return super.isLoggable(logRecord);
    }
}

