/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialJavaObject;
import javax.sql.rowset.serial.SerialStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialArray
implements Array,
Serializable,
Cloneable {
    private Object[] elements;
    private int baseType;
    private String baseTypeName;
    private int len;
    static final long serialVersionUID = -8466174297270688520L;

    public SerialArray(Array array, Map<String, Class<?>> map) throws SerialException, SQLException {
        if (array == null || map == null) {
            throw new SQLException("Cannot instantiate a SerialArray object with null parameters");
        }
        this.elements = (Object[])array.getArray();
        if (this.elements == null) {
            throw new SQLException("Invalid Array object. Calls to Array.getArray() return null value which cannot be serialized");
        }
        this.elements = (Object[])array.getArray(map);
        this.baseType = array.getBaseType();
        this.baseTypeName = array.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2002: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialStruct((Struct)this.elements[i], map);
                }
                break;
            }
            case 2003: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialArray((Array)this.elements[i], map);
                }
                break;
            }
            case 2004: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialBlob((Blob)this.elements[i]);
                }
                break;
            }
            case 2005: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialClob((Clob)this.elements[i]);
                }
                break;
            }
            case 70: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialDatalink((URL)this.elements[i]);
                }
                break;
            }
            case 2000: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialJavaObject(this.elements[i]);
                }
                break;
            }
        }
    }

    public SerialArray(Array array) throws SerialException, SQLException {
        if (array == null) {
            throw new SQLException("Cannot instantiate a SerialArray object with a null Array object");
        }
        this.elements = (Object[])array.getArray();
        if (this.elements == null) {
            throw new SQLException("Invalid Array object. Calls to Array.getArray() return null value which cannot be serialized");
        }
        this.baseType = array.getBaseType();
        this.baseTypeName = array.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2004: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialBlob((Blob)this.elements[i]);
                }
                break;
            }
            case 2005: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialClob((Clob)this.elements[i]);
                }
                break;
            }
            case 70: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialDatalink((URL)this.elements[i]);
                }
                break;
            }
            case 2000: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialJavaObject(this.elements[i]);
                }
                break;
            }
        }
    }

    @Override
    public Object getArray() throws SerialException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SerialException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    @Override
    public Object getArray(long l, int n) throws SerialException {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SerialException {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public int getBaseType() throws SerialException {
        return this.baseType;
    }

    @Override
    public String getBaseTypeName() throws SerialException {
        return this.baseTypeName;
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SerialException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SerialException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SerialException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SerialException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalResultSetImpl
    implements ResultSet {
        private InternalResultSetImpl() {
        }

        @Override
        public boolean absolute(int n) throws SQLException {
            return false;
        }

        @Override
        public void afterLast() throws SQLException {
        }

        @Override
        public void beforeFirst() throws SQLException {
        }

        @Override
        public void cancelRowUpdates() throws SQLException {
        }

        @Override
        public void clearWarnings() throws SQLException {
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public void deleteRow() throws SQLException {
        }

        @Override
        public int findColumn(String string) throws SQLException {
            return 0;
        }

        @Override
        public boolean first() throws SQLException {
            return false;
        }

        @Override
        public Array getArray(int n) throws SQLException {
            return null;
        }

        @Override
        public Array getArray(String string) throws SQLException {
            return null;
        }

        @Override
        public InputStream getAsciiStream(String string) throws SQLException {
            return null;
        }

        @Override
        public InputStream getAsciiStream(int n) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(String string) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(int n) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(String string, int n) throws SQLException {
            return null;
        }

        @Override
        public InputStream getBinaryStream(int n) throws SQLException {
            return null;
        }

        @Override
        public InputStream getBinaryStream(String string) throws SQLException {
            return null;
        }

        @Override
        public Blob getBlob(int n) throws SQLException {
            return null;
        }

        @Override
        public Blob getBlob(String string) throws SQLException {
            return null;
        }

        @Override
        public boolean getBoolean(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean getBoolean(String string) throws SQLException {
            return false;
        }

        @Override
        public byte getByte(int n) throws SQLException {
            return 0;
        }

        @Override
        public byte getByte(String string) throws SQLException {
            return 0;
        }

        @Override
        public byte[] getBytes(int n) throws SQLException {
            return null;
        }

        @Override
        public byte[] getBytes(String string) throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream(int n) throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream(String string) throws SQLException {
            return null;
        }

        @Override
        public Clob getClob(int n) throws SQLException {
            return null;
        }

        @Override
        public Clob getClob(String string) throws SQLException {
            return null;
        }

        @Override
        public int getConcurrency() throws SQLException {
            return 0;
        }

        @Override
        public String getCursorName() throws SQLException {
            return null;
        }

        @Override
        public Date getDate(int n) throws SQLException {
            return null;
        }

        @Override
        public Date getDate(String string) throws SQLException {
            return null;
        }

        @Override
        public Date getDate(int n, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Date getDate(String string, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public double getDouble(int n) throws SQLException {
            return 0.0;
        }

        @Override
        public double getDouble(String string) throws SQLException {
            return 0.0;
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return 0;
        }

        @Override
        public int getFetchSize() throws SQLException {
            return 0;
        }

        @Override
        public float getFloat(int n) throws SQLException {
            return 0.0f;
        }

        @Override
        public float getFloat(String string) throws SQLException {
            return 0.0f;
        }

        @Override
        public int getInt(String string) throws SQLException {
            return 0;
        }

        @Override
        public int getInt(int n) throws SQLException {
            return 0;
        }

        @Override
        public long getLong(int n) throws SQLException {
            return 0L;
        }

        @Override
        public long getLong(String string) throws SQLException {
            return 0L;
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return null;
        }

        @Override
        public Object getObject(int n) throws SQLException {
            return null;
        }

        @Override
        public Object getObject(String string) throws SQLException {
            return null;
        }

        @Override
        public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
            return null;
        }

        @Override
        public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
            return null;
        }

        @Override
        public Ref getRef(int n) throws SQLException {
            return null;
        }

        @Override
        public Ref getRef(String string) throws SQLException {
            return null;
        }

        @Override
        public int getRow() throws SQLException {
            return 0;
        }

        @Override
        public short getShort(String string) throws SQLException {
            return 0;
        }

        @Override
        public short getShort(int n) throws SQLException {
            return 0;
        }

        @Override
        public Statement getStatement() throws SQLException {
            return null;
        }

        @Override
        public String getString(String string) throws SQLException {
            return null;
        }

        @Override
        public String getString(int n) throws SQLException {
            return null;
        }

        @Override
        public Time getTime(String string) throws SQLException {
            return null;
        }

        @Override
        public Time getTime(int n) throws SQLException {
            return null;
        }

        @Override
        public Time getTime(String string, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Time getTime(int n, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(String string) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(int n) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public int getType() throws SQLException {
            return 0;
        }

        @Override
        public URL getURL(int n) throws SQLException {
            return null;
        }

        @Override
        public URL getURL(String string) throws SQLException {
            return null;
        }

        @Override
        public InputStream getUnicodeStream(String string) throws SQLException {
            return null;
        }

        @Override
        public InputStream getUnicodeStream(int n) throws SQLException {
            return null;
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        @Override
        public void insertRow() throws SQLException {
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            return false;
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            return false;
        }

        @Override
        public boolean isFirst() throws SQLException {
            return false;
        }

        @Override
        public boolean isLast() throws SQLException {
            return false;
        }

        @Override
        public boolean last() throws SQLException {
            return false;
        }

        @Override
        public void moveToCurrentRow() throws SQLException {
        }

        @Override
        public void moveToInsertRow() throws SQLException {
        }

        @Override
        public boolean next() throws SQLException {
            return false;
        }

        @Override
        public boolean previous() throws SQLException {
            return false;
        }

        @Override
        public void refreshRow() throws SQLException {
        }

        @Override
        public boolean relative(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean rowDeleted() throws SQLException {
            return false;
        }

        @Override
        public boolean rowInserted() throws SQLException {
            return false;
        }

        @Override
        public boolean rowUpdated() throws SQLException {
            return false;
        }

        @Override
        public void setFetchDirection(int n) throws SQLException {
        }

        @Override
        public void setFetchSize(int n) throws SQLException {
        }

        @Override
        public void updateArray(String string, Array array) throws SQLException {
        }

        @Override
        public void updateArray(int n, Array array) throws SQLException {
        }

        @Override
        public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        }

        @Override
        public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        }

        @Override
        public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        }

        @Override
        public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        }

        @Override
        public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        }

        @Override
        public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        }

        @Override
        public void updateBlob(int n, Blob blob) throws SQLException {
        }

        @Override
        public void updateBlob(String string, Blob blob) throws SQLException {
        }

        @Override
        public void updateBoolean(int n, boolean bl) throws SQLException {
        }

        @Override
        public void updateBoolean(String string, boolean bl) throws SQLException {
        }

        @Override
        public void updateByte(int n, byte by) throws SQLException {
        }

        @Override
        public void updateByte(String string, byte by) throws SQLException {
        }

        @Override
        public void updateBytes(int n, byte[] byArray) throws SQLException {
        }

        @Override
        public void updateBytes(String string, byte[] byArray) throws SQLException {
        }

        @Override
        public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        }

        @Override
        public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        }

        @Override
        public void updateClob(String string, Clob clob) throws SQLException {
        }

        @Override
        public void updateClob(int n, Clob clob) throws SQLException {
        }

        @Override
        public void updateDate(int n, Date date) throws SQLException {
        }

        @Override
        public void updateDate(String string, Date date) throws SQLException {
        }

        @Override
        public void updateDouble(int n, double d) throws SQLException {
        }

        @Override
        public void updateDouble(String string, double d) throws SQLException {
        }

        @Override
        public void updateFloat(String string, float f) throws SQLException {
        }

        @Override
        public void updateFloat(int n, float f) throws SQLException {
        }

        @Override
        public void updateInt(String string, int n) throws SQLException {
        }

        @Override
        public void updateInt(int n, int n2) throws SQLException {
        }

        @Override
        public void updateLong(int n, long l) throws SQLException {
        }

        @Override
        public void updateLong(String string, long l) throws SQLException {
        }

        @Override
        public void updateNull(String string) throws SQLException {
        }

        @Override
        public void updateNull(int n) throws SQLException {
        }

        @Override
        public void updateObject(String string, Object object) throws SQLException {
        }

        @Override
        public void updateObject(int n, Object object) throws SQLException {
        }

        @Override
        public void updateObject(int n, Object object, int n2) throws SQLException {
        }

        @Override
        public void updateObject(String string, Object object, int n) throws SQLException {
        }

        @Override
        public void updateRef(int n, Ref ref) throws SQLException {
        }

        @Override
        public void updateRef(String string, Ref ref) throws SQLException {
        }

        @Override
        public void updateRow() throws SQLException {
        }

        @Override
        public void updateShort(int n, short s) throws SQLException {
        }

        @Override
        public void updateShort(String string, short s) throws SQLException {
        }

        @Override
        public void updateString(int n, String string) throws SQLException {
        }

        @Override
        public void updateString(String string, String string2) throws SQLException {
        }

        @Override
        public void updateTime(String string, Time time) throws SQLException {
        }

        @Override
        public void updateTime(int n, Time time) throws SQLException {
        }

        @Override
        public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        }

        @Override
        public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        }

        @Override
        public boolean wasNull() throws SQLException {
            return false;
        }
    }
}

