/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class FieldView
extends PlainView {
    public FieldView(Element element) {
        super(element);
    }

    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    protected Shape adjustAllocation(Shape shape) {
        if (shape != null) {
            Container container;
            Rectangle rectangle = shape.getBounds();
            int n = (int)this.getPreferredSpan(1);
            int n2 = (int)this.getPreferredSpan(0);
            if (rectangle.height != n) {
                int n3 = rectangle.height - n;
                rectangle.y += n3 / 2;
                rectangle.height -= n3;
            }
            if ((container = this.getContainer()) instanceof JTextField) {
                int n4;
                JTextField jTextField = (JTextField)container;
                BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                int n5 = Math.max(n2, rectangle.width);
                int n6 = boundedRangeModel.getValue();
                if (n6 + (n4 = Math.min(n5, rectangle.width - 1)) > n5) {
                    n6 = n5 - n4;
                }
                boundedRangeModel.setRangeProperties(n6, n4, boundedRangeModel.getMinimum(), n5, false);
                if (n2 < rectangle.width) {
                    int n7 = rectangle.width - 1 - n2;
                    int n8 = ((JTextField)container).getHorizontalAlignment();
                    if (Utilities.isLeftToRight(container)) {
                        if (n8 == 10) {
                            n8 = 2;
                        } else if (n8 == 11) {
                            n8 = 4;
                        }
                    } else if (n8 == 10) {
                        n8 = 4;
                    } else if (n8 == 11) {
                        n8 = 2;
                    }
                    switch (n8) {
                        case 0: {
                            rectangle.x += n7 / 2;
                            rectangle.width -= n7;
                            break;
                        }
                        case 4: {
                            rectangle.x += n7;
                            rectangle.width -= n7;
                        }
                    }
                } else {
                    rectangle.width = n2;
                    rectangle.x -= boundedRangeModel.getValue();
                }
            }
            return rectangle;
        }
        return null;
    }

    void updateVisibilityModel() {
        Container container = this.getContainer();
        if (container instanceof JTextField) {
            JTextField jTextField = (JTextField)container;
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = (int)this.getPreferredSpan(0);
            int n2 = boundedRangeModel.getExtent();
            int n3 = Math.max(n, n2);
            n2 = n2 == 0 ? n3 : n2;
            int n4 = n3 - n2;
            int n5 = boundedRangeModel.getValue();
            if (n5 + n2 > n3) {
                n5 = n3 - n2;
            }
            n4 = Math.max(0, Math.min(n4, n5));
            boundedRangeModel.setRangeProperties(n4, n2, 0, n3, false);
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paint(graphics, shape);
    }

    Shape adjustPaintRegion(Shape shape) {
        return this.adjustAllocation(shape);
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                int n2;
                Segment segment = SegmentCache.getSharedSegment();
                Document document = this.getDocument();
                try {
                    FontMetrics fontMetrics = this.getFontMetrics();
                    document.getText(0, document.getLength(), segment);
                    n2 = Utilities.getTabbedTextWidth(segment, fontMetrics, 0, this, 0);
                    if (segment.count > 0) {
                        Container container = this.getContainer();
                        this.firstLineOffset = SwingUtilities2.getLeftSideBearing(container instanceof JComponent ? (JComponent)container : null, fontMetrics, segment.array[segment.offset]);
                        this.firstLineOffset = Math.max(0, -this.firstLineOffset);
                    } else {
                        this.firstLineOffset = 0;
                    }
                }
                catch (BadLocationException badLocationException) {
                    n2 = 0;
                }
                SegmentCache.releaseSharedSegment(segment);
                return n2 + this.firstLineOffset;
            }
        }
        return super.getPreferredSpan(n);
    }

    public int getResizeWeight(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return super.modelToView(n, this.adjustAllocation(shape), bias);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return super.viewToModel(f, f2, this.adjustAllocation(shape), biasArray);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateVisibilityModel();
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateVisibilityModel();
    }
}

