/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    private static final FlowStrategy STRATEGY = new FlowStrategy();
    protected int layoutSpan = Integer.MAX_VALUE;
    protected View layoutPool;
    protected FlowStrategy strategy = STRATEGY;

    public FlowView(Element element, int n) {
        super(element, n);
    }

    public int getFlowAxis() {
        if (this.getAxis() == 1) {
            return 0;
        }
        return 1;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return 0;
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
        }
        this.layoutPool.setParent(this);
        this.strategy.insertUpdate(this, null, null);
    }

    protected int getViewIndexAtPosition(int n) {
        if (n >= this.getStartOffset() && n < this.getEndOffset()) {
            for (int i = this.getViewCount() - 1; i >= 0; --i) {
                View view = this.getView(i);
                if (n < view.getStartOffset() || n >= view.getEndOffset()) continue;
                return i;
            }
        }
        return -1;
    }

    protected void layout(int n, int n2) {
        int n3 = this.getFlowAxis();
        int n4 = n3 == 0 ? n : n2;
        if (this.layoutSpan != n4) {
            this.layoutChanged(n3);
            this.layoutChanged(this.getAxis());
            this.layoutSpan = n4;
        }
        if (!this.isLayoutValid(n3)) {
            int n5 = this.getAxis();
            int n6 = n5 == 0 ? this.getWidth() : this.getHeight();
            this.strategy.layout(this);
            int n7 = (int)this.getPreferredSpan(n5);
            if (n6 != n7) {
                Container container;
                View view = this.getParent();
                if (view != null) {
                    view.preferenceChanged(this, n5 == 0, n5 == 1);
                }
                if ((container = this.getContainer()) != null) {
                    container.repaint();
                }
            }
        }
        super.layout(n, n2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        float f = this.layoutPool.getPreferredSpan(n);
        float f2 = this.layoutPool.getMinimumSpan(n);
        sizeRequirements.minimum = (int)f2;
        sizeRequirements.preferred = Math.max(sizeRequirements.minimum, (int)f);
        sizeRequirements.maximum = Integer.MAX_VALUE;
        sizeRequirements.alignment = 0.5f;
        return sizeRequirements;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.removeUpdate(documentEvent, shape, viewFactory);
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.changedUpdate(documentEvent, shape, viewFactory);
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view == null && this.layoutPool != null) {
            this.layoutPool.setParent(null);
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.preferenceChanged(null, true, true);
            }
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.preferenceChanged(null, true, true);
            }
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.preferenceChanged(null, true, true);
            }
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            View view;
            int n;
            int n2 = flowView.getStartOffset();
            int n3 = flowView.getEndOffset();
            View view2 = this.getLogicalView(flowView);
            int n4 = view2.getViewCount();
            for (n = 0; n < n4; ++n) {
                view = view2.getView(n);
                view.setParent(view2);
            }
            flowView.removeAll();
            n = 0;
            while (n2 < n3) {
                view = flowView.createRow();
                flowView.append(view);
                int n5 = this.layoutRow(flowView, n, n2);
                if (view.getViewCount() == 0) {
                    view.append(this.createView(flowView, n2, Integer.MAX_VALUE, n));
                    n5 = view.getEndOffset();
                }
                if (n5 <= n2) {
                    throw new StateInvariantError("infinite loop in formatting");
                }
                n2 = n5;
                ++n;
            }
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            View view;
            View view2 = flowView.getView(n);
            int n3 = flowView.getFlowStart(n);
            int n4 = flowView.getFlowSpan(n);
            int n5 = flowView.getEndOffset();
            TabExpander tabExpander = flowView instanceof TabExpander ? (TabExpander)((Object)flowView) : null;
            int n6 = n3;
            int n7 = n4;
            n6 = n3;
            int n8 = flowView.getFlowAxis();
            boolean bl = false;
            while (!(n2 >= n5 || n4 < 0 || (view = this.createView(flowView, n2, n4, n)) == null || n4 == 0 && view.getPreferredSpan(n8) > 0.0f)) {
                int n9 = n8 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n3, tabExpander) : (int)view.getPreferredSpan(n8);
                if (view.getBreakWeight(n8, n2, n4) >= 3000) {
                    int n10 = view2.getViewCount();
                    if (n10 > 0) {
                        n9 = (view = view.breakView(n8, n2, n3, n4)) != null ? (n8 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n3, tabExpander) : (int)view.getPreferredSpan(n8)) : 0;
                    }
                    bl = true;
                }
                n4 -= n9;
                n3 += n9;
                if (view != null) {
                    view2.append(view);
                    n2 = view.getEndOffset();
                }
                if (!bl) continue;
                break;
            }
            if (n4 < 0) {
                this.adjustRow(flowView, n, n7, n6);
            } else if (view2.getViewCount() == 0) {
                view = this.createView(flowView, n2, Integer.MAX_VALUE, n);
                view2.append(view);
            }
            return view2.getEndOffset();
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
            View view;
            int n4;
            int n5 = flowView.getFlowAxis();
            View view2 = flowView.getView(n);
            int n6 = view2.getViewCount();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = -1;
            boolean bl = false;
            for (n4 = 0; n4 < n6; ++n4) {
                int n11;
                view = view2.getView(n4);
                int n12 = view.getBreakWeight(n5, n3 + n7, n11 = n2 - n7);
                if (n12 >= n8 && n12 > 0) {
                    n8 = n12;
                    n10 = n4;
                    n9 = n7;
                    if (n12 >= 3000) break;
                }
                n7 = (int)((float)n7 + view.getPreferredSpan(n5));
            }
            if (n10 < 0) {
                return;
            }
            n4 = n2 - n9;
            view = view2.getView(n10);
            view = view.breakView(n5, view.getStartOffset(), n3 + n9, n4);
            View[] viewArray = new View[]{view};
            View view3 = this.getLogicalView(flowView);
            for (int i = n10; i < n6; ++i) {
                View view4 = view2.getView(i);
                if (this.contains(view3, view4)) {
                    view4.setParent(view3);
                    continue;
                }
                if (view4.getViewCount() <= 0) continue;
                this.recursiveReparent(view4, view3);
            }
            view2.replace(n10, n6 - n10, viewArray);
        }

        private void recursiveReparent(View view, View view2) {
            int n = view.getViewCount();
            for (int i = 0; i < n; ++i) {
                View view3 = view.getView(i);
                if (this.contains(view2, view3)) {
                    view3.setParent(view2);
                    continue;
                }
                this.recursiveReparent(view3, view2);
            }
        }

        private boolean contains(View view, View view2) {
            int n = view.getViewCount();
            for (int i = 0; i < n; ++i) {
                if (view.getView(i) != view2) continue;
                return true;
            }
            return false;
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view = this.getLogicalView(flowView);
            View view2 = view.getView(n4 = view.getViewIndex(n, Position.Bias.Forward));
            if (n == view2.getStartOffset()) {
                return view2;
            }
            view2 = view2.createFragment(n, view2.getEndOffset());
            return view2;
        }
    }

    static class LogicalView
    extends CompositeView {
        LogicalView(Element element) {
            super(element);
        }

        protected int getViewIndexAtPosition(int n) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                return 0;
            }
            return super.getViewIndexAtPosition(n);
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                LabelView labelView = new LabelView(element);
                this.append(labelView);
            } else {
                super.loadChildren(viewFactory);
            }
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        public float getPreferredSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                f2 += view.getPreferredSpan(n);
                if (view.getBreakWeight(n, 0.0f, 2.1474836E9f) < 3000) continue;
                f = Math.max(f, f2);
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = false;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                if (view.getBreakWeight(n, 0.0f, 2.1474836E9f) == 0) {
                    f2 += view.getPreferredSpan(n);
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                f = Math.max(f2, f);
                bl = false;
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
            return f;
        }

        protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            view.setParent(this);
            super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        protected boolean isBefore(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected boolean isAfter(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
            return null;
        }

        protected void childAllocation(int n, Rectangle rectangle) {
        }
    }
}

