/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.accessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.accessor.ObjectAccessorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectAccessorProvider
implements ObjectAccessorProvider {
    private final ConcurrentMap<Class<?>, ObjectAccessor> objectAccessors = new ConcurrentHashMap();

    protected AbstractObjectAccessorProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectAccessor get(Class<?> objectType) {
        Class<?> aClass = objectType;
        if (objectType.isInterface()) {
            aClass = this.getImplementor(aClass);
        }
        if (aClass == null) {
            return null;
        }
        ObjectAccessor objectAccessor = (ObjectAccessor)this.objectAccessors.get(aClass);
        if (objectAccessor == null) {
            AbstractObjectAccessorProvider abstractObjectAccessorProvider = this;
            synchronized (abstractObjectAccessorProvider) {
                objectAccessor = this.create(aClass);
                this.objectAccessors.put(aClass, objectAccessor);
            }
        }
        return objectAccessor;
    }

    protected abstract ObjectAccessor create(Class<?> var1);

    private Class<?> getImplementor(Class<?> anInterface) {
        if (List.class.isAssignableFrom(anInterface)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(anInterface)) {
            return HashSet.class;
        }
        if (Queue.class.isAssignableFrom(anInterface)) {
            return LinkedList.class;
        }
        if (Map.class.isAssignableFrom(anInterface)) {
            return HashMap.class;
        }
        return null;
    }
}

