/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.ParseException;
import java.util.Locale;
import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;

public class BigDecimalConverter
implements SimpleTypeConverter {
    private static final String[] DEFAULT_FORMAT = new String[]{"en", "#0.00"};
    private static final FieldPosition FIELD_POSITION = new FieldPosition(0);
    private final DecimalFormat decimalFormat;

    public static BigDecimalConverter create(SimpleTypeConverterConfiguration configuration) {
        return new BigDecimalConverter(configuration);
    }

    protected BigDecimalConverter(SimpleTypeConverterConfiguration configuration) {
        String[] format = this.getFormat(configuration);
        try {
            Locale locale = new Locale(format[0]);
            String pattern = format[1];
            this.decimalFormat = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
            this.decimalFormat.setParseBigDecimal(true);
        }
        catch (Exception e) {
            throw new ConversionException("Could not create a " + this.getClass().getName() + " with format " + format[0] + ", " + format[1], e);
        }
    }

    public final synchronized BigDecimal fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Object result = this.decimalFormat.parseObject(value);
            if (result instanceof BigDecimal) {
                return (BigDecimal)result;
            }
            return new BigDecimal((Double)result).setScale(this.decimalFormat.getMaximumFractionDigits(), 4);
        }
        catch (ParseException e) {
            throw new ConversionException("Wrong BigDecimal format " + value);
        }
    }

    public final synchronized String toString(Object value) {
        if (value == null) {
            return null;
        }
        return this.decimalFormat.format(value, new StringBuffer(), FIELD_POSITION).toString();
    }

    protected String[] getDefaultFormat() {
        return DEFAULT_FORMAT;
    }

    private String[] getFormat(SimpleTypeConverterConfiguration configuration) {
        if (configuration.getFormat() == null) {
            return this.getDefaultFormat();
        }
        if (configuration.getFormat().length != 2) {
            throw new ConversionException("The format for a BigDecimalConverter must be an array with 2 entries");
        }
        return configuration.getFormat();
    }
}

