/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;

public class BooleanConverter
implements SimpleTypeConverter {
    protected static final String[] FORMAT_TRUE_FALSE = new String[]{"true", "false"};
    protected static final String[] FORMAT_YES_NO = new String[]{"yes", "no"};
    protected static final String[] FORMAT_BINARY = new String[]{"1", "0"};
    private final String trueLiteral;
    private final String falseLiteral;

    public static BooleanConverter create(SimpleTypeConverterConfiguration configuration) {
        return new BooleanConverter(configuration);
    }

    protected BooleanConverter(SimpleTypeConverterConfiguration configuration) {
        String[] format = this.getFormat(configuration);
        this.trueLiteral = format[0];
        this.falseLiteral = format[1];
    }

    public final Boolean fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (this.trueLiteral.equals(value)) {
            return Boolean.TRUE;
        }
        if (this.falseLiteral.equals(value)) {
            return Boolean.FALSE;
        }
        throw new ConversionException("Unknown boolean value: " + value);
    }

    public final String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (((Boolean)value).booleanValue()) {
            return this.trueLiteral;
        }
        return this.falseLiteral;
    }

    protected String[] getDefaultFormat() {
        return FORMAT_TRUE_FALSE;
    }

    private String[] getFormat(SimpleTypeConverterConfiguration configuration) {
        if (configuration.getFormat() == null) {
            return this.getDefaultFormat();
        }
        if (configuration.getFormat().length != 2) {
            throw new ConversionException("The format for a BooleanConverter must be an array with 2 entries");
        }
        if (configuration.getFormat()[0].equals(configuration.getFormat()[1])) {
            throw new ConversionException("Invalid format for a BooleanConverter: " + configuration.getFormat()[0] + ", " + configuration.getFormat()[1]);
        }
        return configuration.getFormat();
    }
}

