/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;

public final class IntegerConverter
implements SimpleTypeConverter {
    private static final IntegerConverter INSTANCE = new IntegerConverter();

    public static IntegerConverter create() {
        return INSTANCE;
    }

    private IntegerConverter() {
    }

    public Integer fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            if (value.charAt(0) == '+') {
                return this.fromString(value.substring(1));
            }
            throw new ConversionException("Wrong Integer format: " + value);
        }
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

