/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;

public class XmlDateTimeConverter
implements SimpleTypeConverter {
    public static final String DEFAULT_FORMAT = "GMT";
    private static final Date PURE_GREGORIAN_CHANGE = new Date(Long.MIN_VALUE);
    private final DatatypeFactory factory;
    private final TimeZone timeZone;

    public static XmlDateTimeConverter create(SimpleTypeConverterConfiguration configuration) {
        return new XmlDateTimeConverter(configuration);
    }

    protected XmlDateTimeConverter(SimpleTypeConverterConfiguration configuration) {
        this.timeZone = TimeZone.getTimeZone(this.getFormat(configuration));
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new ConversionException("Could not create an " + this.getClass().getName(), e);
        }
    }

    public final Date fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return this.toGregorianCalendar(this.factory.newXMLGregorianCalendar(value)).getTime();
        }
        catch (Exception e) {
            throw new ConversionException("Wrong date format: " + value);
        }
    }

    public final String toString(Object value) {
        if (value == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(this.timeZone);
        cal.setTime((Date)value);
        return this.factory.newXMLGregorianCalendar(cal).toString();
    }

    protected String getDefaultFormat() {
        return DEFAULT_FORMAT;
    }

    private String getFormat(SimpleTypeConverterConfiguration configuration) {
        if (configuration.getFormat() == null) {
            return this.getDefaultFormat();
        }
        if (configuration.getFormat().length != 1) {
            throw new ConversionException("The format for an XmlDateTimeConverter must be a single String");
        }
        return configuration.getFormat()[0];
    }

    private GregorianCalendar toGregorianCalendar(XMLGregorianCalendar cal) {
        TimeZone tz = TimeZoneProvider.getTimeZone(cal);
        Locale locale = Locale.getDefault();
        GregorianCalendar result = new GregorianCalendar(tz, locale);
        result.clear();
        result.setGregorianChange(PURE_GREGORIAN_CHANGE);
        BigInteger year = cal.getEonAndYear();
        if (year != null) {
            if (year.signum() == -1) {
                result.set(0, 0);
            } else {
                result.set(0, 1);
            }
            result.set(1, year.abs().intValue());
        }
        if (cal.getMonth() != Integer.MIN_VALUE) {
            result.set(2, cal.getMonth() - 1);
        }
        if (cal.getDay() != Integer.MIN_VALUE) {
            result.set(5, cal.getDay());
        }
        if (cal.getHour() != Integer.MIN_VALUE) {
            result.set(11, cal.getHour());
        }
        if (cal.getMinute() != Integer.MIN_VALUE) {
            result.set(12, cal.getMinute());
        }
        if (cal.getSecond() != Integer.MIN_VALUE) {
            result.set(13, cal.getSecond());
        }
        if (cal.getFractionalSecond() != null) {
            result.set(14, cal.getMillisecond());
        }
        return result;
    }

    private static final class TimeZoneProvider {
        private static final ConcurrentMap<Integer, TimeZone> TIME_ZONES = new ConcurrentHashMap<Integer, TimeZone>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static TimeZone getTimeZone(XMLGregorianCalendar gregCal) {
            int timeZoneInt = gregCal.getTimezone();
            TimeZone timeZone = (TimeZone)TIME_ZONES.get(timeZoneInt);
            if (timeZone != null) return timeZone;
            Class<TimeZoneProvider> clazz = TimeZoneProvider.class;
            synchronized (TimeZoneProvider.class) {
                timeZone = gregCal.getTimeZone(Integer.MIN_VALUE);
                TIME_ZONES.put(timeZoneInt, timeZone);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return timeZone;
            }
        }

        private TimeZoneProvider() {
        }
    }
}

