/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter.provider;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleTypeConverterProvider {
    private final ConcurrentMap<Class<?>, Class<? extends SimpleTypeConverter>> converterTypeMap;

    public SimpleTypeConverterProvider() {
        this.converterTypeMap = new ConcurrentHashMap();
    }

    private SimpleTypeConverterProvider(SimpleTypeConverterProvider other) {
        this.converterTypeMap = new ConcurrentHashMap(other.converterTypeMap);
    }

    public SimpleTypeConverterProvider createCopy() {
        return new SimpleTypeConverterProvider(this);
    }

    public boolean hasConverterFor(Class<?> objectType) {
        return this.getConverterType(objectType) != null;
    }

    public SimpleTypeConverter getForObjectType(Class<?> objectType, String[] format) {
        if (!this.hasConverterFor(objectType)) {
            return null;
        }
        Class<? extends SimpleTypeConverter> converterType = this.getConverterType(objectType);
        return this.getForConverterType(converterType, objectType, format);
    }

    public SimpleTypeConverter getForObjectType(Class<?> objectType, String[] format, SimpleTypeConverter itemTypeConverter) {
        if (!this.hasConverterFor(objectType)) {
            return null;
        }
        Class<? extends SimpleTypeConverter> converterType = this.getConverterType(objectType);
        return this.getForConverterType(converterType, objectType, format, itemTypeConverter);
    }

    public SimpleTypeConverter getForConverterType(Class<? extends SimpleTypeConverter> converterType, Class<?> objectType, String[] format) {
        return this.getForConverterType(converterType, objectType, format, null);
    }

    public SimpleTypeConverter getForConverterType(Class<? extends SimpleTypeConverter> converterType, Class<?> objectType, String[] format, SimpleTypeConverter itemTypeConverter) {
        try {
            Method factoryMethod = ReflectionUtil.getMethod(converterType, "create", SimpleTypeConverterConfiguration.class);
            if (factoryMethod != null) {
                return (SimpleTypeConverter)ReflectionUtil.callMethod(null, factoryMethod, SimpleTypeConverterConfiguration.create(objectType, format, itemTypeConverter));
            }
            if (itemTypeConverter == null && (factoryMethod = ReflectionUtil.getMethod(converterType, "create", new Class[0])) != null) {
                return (SimpleTypeConverter)ReflectionUtil.callMethod(null, factoryMethod, null);
            }
            throw new ConversionException("No static create method found for class " + converterType);
        }
        catch (Exception e) {
            throw new ConversionException("Could not create a SimpleTypeConverter for class " + converterType, e);
        }
    }

    public void registerConverterType(Class<?> objectType, Class<? extends SimpleTypeConverter> converterType) {
        this.converterTypeMap.put(objectType, converterType);
    }

    private Class<? extends SimpleTypeConverter> getConverterType(Class<?> objectType) {
        return ReflectionUtil.getNearest(objectType, this.converterTypeMap);
    }
}

