/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsefa.IOFactoryException;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.mapping.FieldDescriptor;
import org.jsefa.common.mapping.NodeDescriptor;
import org.jsefa.common.mapping.NodeMapping;
import org.jsefa.common.mapping.NodeType;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexTypeMapping<N, D extends NodeDescriptor<?>, M extends NodeMapping<N, ?>>
extends TypeMapping<N> {
    private final Collection<M> nodeMappings;
    private final Map<D, M> nodeMappingsByNodeDescriptor;
    private final Map<String, ?> nodeMappingsByFieldNameAndType;
    private final Map<NodeType, List<String>> fieldNamesByNodeType;
    private final ObjectAccessor objectAccessor;
    private final Validator validator;

    public ComplexTypeMapping(Class<?> objectType, N dataTypeName, Collection<M> nodeMappings, ObjectAccessor objectAccessor, Validator validator) {
        super(objectType, dataTypeName);
        this.nodeMappings = new ArrayList<M>(nodeMappings);
        this.nodeMappingsByNodeDescriptor = this.createNodeMappingsByNodeDescriptorMap(nodeMappings);
        this.nodeMappingsByFieldNameAndType = this.createNodeMappingsByFieldNameAndTypeMap(nodeMappings);
        this.fieldNamesByNodeType = this.createFieldNamesByNodeTypeMap(nodeMappings);
        this.objectAccessor = objectAccessor;
        this.validator = validator;
    }

    public final Collection<M> getNodeMappings() {
        return Collections.unmodifiableCollection(this.nodeMappings);
    }

    public <T extends M> T getNodeMapping(D nodeDescriptor) {
        return (T)((NodeMapping)this.nodeMappingsByNodeDescriptor.get(nodeDescriptor));
    }

    public <T extends M> T getNodeMapping(String fieldName, Class<?> objectType) {
        Object value = this.nodeMappingsByFieldNameAndType.get(fieldName);
        if (value instanceof NodeMapping) {
            return (T)((NodeMapping)value);
        }
        if (value instanceof Map) {
            return (T)((NodeMapping)ReflectionUtil.getNearest(objectType, (Map)value));
        }
        return null;
    }

    public List<String> getFieldNames(NodeType nodeType) {
        List<String> result = this.fieldNamesByNodeType.get(nodeType);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public final ObjectAccessor getObjectAccessor() {
        return this.objectAccessor;
    }

    public final Validator getValidator() {
        return this.validator;
    }

    protected Map<D, M> createNodeMappingsByNodeDescriptorMap(Collection<M> nodeMappings) {
        HashMap result = new HashMap();
        for (NodeMapping nodeMapping : nodeMappings) {
            if (result.put(nodeMapping.getNodeDescriptor(), nodeMapping) == null) continue;
            throw new IOFactoryException("The node descriptor is ambiguous: " + nodeMapping.getNodeDescriptor());
        }
        return result;
    }

    private Map<String, ?> createNodeMappingsByFieldNameAndTypeMap(Collection<M> nodeMappings) {
        HashMap result = new HashMap();
        for (NodeMapping nodeMapping : nodeMappings) {
            FieldDescriptor fieldDescriptor = nodeMapping.getFieldDescriptor();
            HashMap map = (HashMap)result.get(fieldDescriptor.getName());
            if (map == null) {
                map = new HashMap();
                result.put(fieldDescriptor.getName(), map);
            }
            map.put(fieldDescriptor.getObjectType(), nodeMapping);
        }
        for (String fieldName : result.keySet()) {
            Map map = (Map)result.get(fieldName);
            if (map.size() != 1) continue;
            result.put(fieldName, map.values().iterator().next());
        }
        return result;
    }

    private Map<NodeType, List<String>> createFieldNamesByNodeTypeMap(Collection<M> nodeMappings) {
        HashMap<NodeType, List<String>> result = new HashMap<NodeType, List<String>>();
        for (NodeMapping nodeMapping : nodeMappings) {
            FieldDescriptor fieldDescriptor;
            Object nodeType = nodeMapping.getNodeDescriptor().getType();
            ArrayList<String> fieldNames = (ArrayList<String>)result.get(nodeType);
            if (fieldNames == null) {
                fieldNames = new ArrayList<String>();
                result.put((NodeType)nodeType, (List<String>)fieldNames);
            }
            if (fieldNames.contains((fieldDescriptor = nodeMapping.getFieldDescriptor()).getName())) continue;
            fieldNames.add(fieldDescriptor.getName());
        }
        return result;
    }
}

