/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jsefa.IOFactoryException;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.mapping.NodeDescriptor;
import org.jsefa.common.mapping.NodeMapping;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapTypeMapping<N, K extends NodeMapping<N, ?>, D extends NodeDescriptor<?>, V extends NodeMapping<N, D>>
extends TypeMapping<N> {
    private final K keyNodeMapping;
    private final Collection<V> valueNodeMappings;
    private final Map<D, V> valueNodeMappingsByNodeDescriptor;
    private final Map<Class<?>, V> valueNodeMappingsByObjectType;
    private final ObjectAccessor objectAccessor;

    public MapTypeMapping(Class<?> objectType, N dataTypeName, K keyNodeMapping, Collection<V> valueNodeMappings, ObjectAccessor objectAccessor) {
        super(objectType, dataTypeName);
        this.keyNodeMapping = keyNodeMapping;
        this.valueNodeMappings = new ArrayList<V>(valueNodeMappings);
        this.valueNodeMappingsByNodeDescriptor = this.createValueNodeMappingsByNodeDescriptorMap(valueNodeMappings);
        this.valueNodeMappingsByObjectType = this.createValueNodeMappingsByObjectTypeMap(valueNodeMappings);
        this.objectAccessor = objectAccessor;
    }

    public final K getKeyNodeMapping() {
        return this.keyNodeMapping;
    }

    public final Collection<V> getValueNodeMappings() {
        return Collections.unmodifiableCollection(this.valueNodeMappings);
    }

    public <T extends V> T getValueNodeMapping(D nodeDescriptor) {
        return (T)((NodeMapping)this.valueNodeMappingsByNodeDescriptor.get(nodeDescriptor));
    }

    public <T extends V> T getValueNodeMapping(Class<?> objectType) {
        return (T)((NodeMapping)ReflectionUtil.getNearest(objectType, this.valueNodeMappingsByObjectType));
    }

    public final ObjectAccessor getObjectAccessor() {
        return this.objectAccessor;
    }

    protected Map<D, V> createValueNodeMappingsByNodeDescriptorMap(Collection<V> nodeMappings) {
        HashMap result = new HashMap();
        for (NodeMapping nodeMapping : nodeMappings) {
            if (result.put(nodeMapping.getNodeDescriptor(), nodeMapping) == null) continue;
            throw new IOFactoryException("The node descriptor is ambiguous: " + nodeMapping.getNodeDescriptor());
        }
        return result;
    }

    private Map<Class<?>, V> createValueNodeMappingsByObjectTypeMap(Collection<V> nodeMappings) {
        HashMap result = new HashMap();
        for (NodeMapping nodeMapping : nodeMappings) {
            result.put(nodeMapping.getObjectType(), nodeMapping);
        }
        return result;
    }
}

