/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.util.ArrayList;
import java.util.Collection;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.validator.ConstraintsAccessor;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.ValidatorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionValidator
implements Validator {
    private final Integer minItems;
    private final Integer maxItems;
    private static final String MIN = "min";
    private static final String MAX = "max";

    public static CollectionValidator create(ValidatorConfiguration configuration) {
        return new CollectionValidator(configuration);
    }

    private CollectionValidator(ValidatorConfiguration configuration) {
        ConstraintsAccessor constraints = ConstraintsAccessor.create(configuration);
        this.minItems = constraints.getInteger(MIN, false);
        this.maxItems = constraints.getInteger(MAX, false);
    }

    @Override
    public ValidationResult validate(Object value) {
        Collection collection = (Collection)value;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateMinItems(collection, errors);
        this.validateMaxItems(collection, errors);
        return ValidationResult.create(errors);
    }

    private void validateMinItems(Collection<?> collection, Collection<ValidationError> errors) {
        int itemCount = collection.size();
        if (this.minItems != null && itemCount < this.minItems) {
            String errorText = "The collection must have at least " + this.minItems + " items, but has " + itemCount + " items only";
            errors.add(ValidationError.create("WRONG_QUANTITY", errorText, new ObjectPathElement[0]));
        }
    }

    private void validateMaxItems(Collection<?> collection, Collection<ValidationError> errors) {
        int itemCount = collection.size();
        if (this.maxItems != null && itemCount > this.maxItems) {
            String errorText = "The number of collection items must not exceed " + this.maxItems + ", but is " + itemCount;
            errors.add(ValidationError.create("WRONG_QUANTITY", errorText, new ObjectPathElement[0]));
        }
    }
}

