/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.util.ArrayList;
import java.util.Collection;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.validator.ConstraintsAccessor;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberValidator<T extends Number>
implements Validator {
    private static final String MIN = "min";
    private static final String MAX = "max";
    private final T min;
    private final T max;
    private final ConstraintsAccessor constraintsAccessor;

    protected NumberValidator(ConstraintsAccessor constraintsAccessor) {
        this.constraintsAccessor = constraintsAccessor;
        this.min = (Number)constraintsAccessor.get(MIN, false);
        this.max = (Number)constraintsAccessor.get(MAX, false);
    }

    @Override
    public ValidationResult validate(Object value) {
        Number number = (Number)value;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateMin(number, errors);
        this.validateMax(number, errors);
        return ValidationResult.create(errors);
    }

    protected ConstraintsAccessor getConstraintsAccessor() {
        return this.constraintsAccessor;
    }

    private void validateMin(T value, Collection<ValidationError> errors) {
        if (this.min != null && this.compare(value, this.min) < 0) {
            String errorText = "The value " + value + " falls below the minimum value " + this.min;
            errors.add(ValidationError.create("OUT_OF_RANGE", errorText, new ObjectPathElement[0]));
        }
    }

    private void validateMax(T value, Collection<ValidationError> errors) {
        if (this.max != null && this.compare(value, this.max) > 0) {
            String errorText = "The value " + value + " exceeds the maximum value " + this.max;
            errors.add(ValidationError.create("OUT_OF_RANGE", errorText, new ObjectPathElement[0]));
        }
    }

    private int compare(Object valueA, Object valueB) {
        return ((Comparable)valueA).compareTo((Number)valueB);
    }
}

