/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jsefa.common.validator.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<ValidationError> errors;
    public static final ValidationResult VALID = new ValidationResult(Collections.EMPTY_LIST);

    public static ValidationResult create(ValidationError ... errors) {
        if (errors.length == 0) {
            return VALID;
        }
        return new ValidationResult(Arrays.asList(errors));
    }

    public static ValidationResult create(Collection<ValidationError> errors) {
        if (errors == null || errors.size() == 0) {
            return VALID;
        }
        return new ValidationResult(new ArrayList<ValidationError>(errors));
    }

    private ValidationResult(Collection<ValidationError> errors) {
        this.errors = errors;
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public Collection<ValidationError> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }
}

