/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator.traversal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.mapping.FieldDescriptor;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.traversal.TraversingValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TraversingComplexValueValidator
extends TraversingValidator {
    private Validator rootValidator;
    private Map<String, ?> validatorsByFieldNameAndType;
    private List<String> fieldNames;
    private ObjectAccessor objectAccessor;
    private static final ThreadLocal<List<Object>> OBJECT_PATH = new ThreadLocal();

    TraversingComplexValueValidator() {
    }

    void init(Validator rootValidator, Map<FieldDescriptor, Validator> fieldValidators, ObjectAccessor objectAccessor) {
        if (this.checkTriviality(rootValidator, fieldValidators)) {
            return;
        }
        this.rootValidator = rootValidator;
        this.objectAccessor = objectAccessor;
        this.validatorsByFieldNameAndType = this.createValidatorsByFieldNameAndTypeMap(fieldValidators);
        this.fieldNames = this.createFieldNamesList(fieldValidators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationResult validate(Object object) {
        if (this.isTrivial()) {
            return ValidationResult.VALID;
        }
        if (this.onObjectPath(object)) {
            return ValidationResult.VALID;
        }
        this.addToObjectPath(object);
        try {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            if (this.rootValidator != null) {
                errors.addAll(this.rootValidator.validate(object).getErrors());
            }
            for (String fieldName : this.fieldNames) {
                Validator fieldValidator;
                Object fieldValue = this.objectAccessor.getValue(object, fieldName);
                if (fieldValue == null || (fieldValidator = this.getFieldValidator(fieldName, fieldValue)) == null) continue;
                for (ValidationError error : fieldValidator.validate(fieldValue).getErrors()) {
                    errors.add(this.createValidationError(error, new ObjectPathElement(object.getClass(), fieldName)));
                }
            }
            ValidationResult validationResult = ValidationResult.create(errors);
            return validationResult;
        }
        finally {
            this.removeFromObjectPath(object);
        }
    }

    private Validator getFieldValidator(String fieldName, Object fieldValue) {
        Object value = this.validatorsByFieldNameAndType.get(fieldName);
        if (value instanceof Validator) {
            return (Validator)value;
        }
        if (value instanceof Map) {
            return (Validator)ReflectionUtil.getNearest(fieldValue.getClass(), (Map)value);
        }
        return null;
    }

    private Map<String, ?> createValidatorsByFieldNameAndTypeMap(Map<FieldDescriptor, Validator> validatorsByFieldDescriptor) {
        Map map;
        HashMap result = new HashMap();
        for (FieldDescriptor fieldDescriptor : validatorsByFieldDescriptor.keySet()) {
            map = (HashMap)result.get(fieldDescriptor.getName());
            if (map == null) {
                map = new HashMap();
                result.put(fieldDescriptor.getName(), map);
            }
            map.put(fieldDescriptor.getObjectType(), validatorsByFieldDescriptor.get(fieldDescriptor));
        }
        for (String fieldName : result.keySet()) {
            map = (Map)result.get(fieldName);
            if (map.size() != 1) continue;
            result.put(fieldName, map.values().iterator().next());
        }
        return result;
    }

    private List<String> createFieldNamesList(Map<FieldDescriptor, Validator> validators) {
        ArrayList<String> result = new ArrayList<String>();
        for (FieldDescriptor fieldDescriptor : validators.keySet()) {
            if (result.contains(fieldDescriptor.getName())) continue;
            result.add(fieldDescriptor.getName());
        }
        return result;
    }

    private boolean onObjectPath(Object object) {
        List<Object> path = OBJECT_PATH.get();
        return path != null && path.contains(object);
    }

    private void addToObjectPath(Object object) {
        List<Object> path = OBJECT_PATH.get();
        if (path == null) {
            path = new ArrayList<Object>();
            OBJECT_PATH.set(path);
        }
        path.add(object);
    }

    private void removeFromObjectPath(Object object) {
        OBJECT_PATH.get().remove(object);
    }

    private ValidationError createValidationError(ValidationError validationError, ObjectPathElement prefix) {
        ArrayList<ObjectPathElement> relativeObjectPath = new ArrayList<ObjectPathElement>();
        relativeObjectPath.add(prefix);
        relativeObjectPath.addAll(validationError.getRelativeObjectPath());
        return ValidationError.create(validationError.getErrorCode(), validationError.getErrorText(), relativeObjectPath.toArray(new ObjectPathElement[0]));
    }

    private boolean checkTriviality(Validator rootValidator, Map<?, Validator> validators) {
        ArrayList<Validator> allValidators = new ArrayList<Validator>(validators.values());
        if (rootValidator != null) {
            allValidators.add(rootValidator);
        }
        return this.checkTriviality(allValidators);
    }
}

