/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv;

import java.util.Map;
import org.jsefa.common.mapping.SimpleTypeMapping;
import org.jsefa.csv.CsvDeserializer;
import org.jsefa.csv.config.CsvConfiguration;
import org.jsefa.csv.lowlevel.CsvLowLevelDeserializer;
import org.jsefa.csv.lowlevel.config.QuoteMode;
import org.jsefa.csv.mapping.CsvSimpleTypeMapping;
import org.jsefa.rbf.RbfDeserializerImpl;
import org.jsefa.rbf.mapping.RbfEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsvDeserializerImpl
extends RbfDeserializerImpl
implements CsvDeserializer {
    private final CsvLowLevelDeserializer lowLevelDeserializer;

    CsvDeserializerImpl(CsvConfiguration config, Map<String, RbfEntryPoint> entryPointsByPrefixes, CsvLowLevelDeserializer lowLevelDeserializer) {
        super(config, entryPointsByPrefixes);
        this.lowLevelDeserializer = lowLevelDeserializer;
    }

    CsvDeserializerImpl(CsvConfiguration config, RbfEntryPoint entryPoint, CsvLowLevelDeserializer lowLevelDeserializer) {
        super(config, entryPoint);
        this.lowLevelDeserializer = lowLevelDeserializer;
    }

    @Override
    protected Object readSimpleValue(SimpleTypeMapping<?> typeMapping) {
        CsvSimpleTypeMapping csvSimpleTypeMapping = (CsvSimpleTypeMapping)typeMapping;
        String stringValue = this.lowLevelDeserializer.nextField(csvSimpleTypeMapping.getQuoteMode());
        if (stringValue == null) {
            return null;
        }
        if (stringValue.equals(csvSimpleTypeMapping.getNoValueString())) {
            return null;
        }
        return typeMapping.getSimpleTypeConverter().fromString(stringValue);
    }

    @Override
    protected String readPrefix() {
        return this.lowLevelDeserializer.nextField(QuoteMode.NEVER);
    }

    @Override
    protected CsvLowLevelDeserializer getLowLevelDeserializer() {
        return this.lowLevelDeserializer;
    }
}

