/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv.annotation;

import java.util.ArrayList;
import java.util.Collection;
import org.jsefa.csv.annotation.CsvDataType;
import org.jsefa.csv.annotation.CsvTypeMappingFactory;
import org.jsefa.rbf.mapping.RbfEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsvEntryPointFactory {
    public static Collection<RbfEntryPoint> createEntryPoints(CsvTypeMappingFactory typeMappingFactory, Class<?> ... objectTypes) {
        ArrayList<RbfEntryPoint> entryPoints = new ArrayList<RbfEntryPoint>(objectTypes.length);
        for (Class<?> objectType : objectTypes) {
            Object dataTypeName = typeMappingFactory.createIfAbsent((Class)objectType);
            String prefix = CsvEntryPointFactory.getAnnotatedPrefix(objectType, objectType.getSimpleName());
            entryPoints.add(new RbfEntryPoint((String)dataTypeName, prefix, null));
        }
        return entryPoints;
    }

    private static String getAnnotatedPrefix(Class<?> objectType, String defaultName) {
        return objectType.getAnnotation(CsvDataType.class).defaultPrefix();
    }

    private CsvEntryPointFactory() {
    }
}

