/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv.annotation;

import java.lang.reflect.Field;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.provider.SimpleTypeConverterProvider;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.validator.provider.ValidatorProvider;
import org.jsefa.csv.annotation.CsvDataType;
import org.jsefa.csv.annotation.CsvField;
import org.jsefa.csv.annotation.CsvSubRecord;
import org.jsefa.csv.annotation.CsvSubRecordList;
import org.jsefa.csv.lowlevel.config.QuoteMode;
import org.jsefa.csv.mapping.CsvSimpleTypeMapping;
import org.jsefa.rbf.annotation.RbfAnnotations;
import org.jsefa.rbf.annotation.RbfTypeMappingFactory;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsvTypeMappingFactory
extends RbfTypeMappingFactory {
    private static final RbfAnnotations ANNOTATIONS = new RbfAnnotations(CsvDataType.class, CsvField.class, CsvSubRecord.class, CsvSubRecordList.class);
    private QuoteMode defaultQuoteMode;
    private String defaultNoValueString;

    public CsvTypeMappingFactory(RbfTypeMappingRegistry typeMappingRegistry, SimpleTypeConverterProvider simpleTypeConverterProvider, ValidatorProvider validatorProvider, ObjectAccessorProvider objectAccessorProvider, QuoteMode defaultQuoteMode, String defaultNoValueString) {
        super(typeMappingRegistry, simpleTypeConverterProvider, validatorProvider, objectAccessorProvider, ANNOTATIONS);
        this.defaultQuoteMode = defaultQuoteMode;
        this.defaultNoValueString = defaultNoValueString;
    }

    @Override
    protected TypeMapping<String> createSimpleTypeMapping(Class<?> objectType, String dataTypeName, SimpleTypeConverter converter, Field field) {
        String noValueString;
        CsvField fieldAnnotation = field.getAnnotation(CsvField.class);
        QuoteMode quoteMode = fieldAnnotation.quoteMode();
        if (quoteMode.equals((Object)QuoteMode.DEFAULT)) {
            quoteMode = this.defaultQuoteMode;
        }
        if ((noValueString = fieldAnnotation.noValue()).equals("DEFAULT_STRING")) {
            noValueString = this.defaultNoValueString;
        }
        return new CsvSimpleTypeMapping(objectType, dataTypeName, converter, quoteMode, noValueString);
    }
}

